/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lispmgrp.h"
#include "limclient.h"

#define	lispEntity_GetIMClientPtr(ptr)	((TLispIMClient*)((TLispEntity *)(ptr) + 1))

Boolean
lispMgr_CreateIMClient (
	register TLispManager*			pLispMgr,
	register void*					pvClient,
	register void					(*pKeyNotify)(),
	register void					(*pTextNotify)(),
	register void					(*pEndNotify)(),
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*			pEntity ;
	register TLispIMClient*	pIMClient ;
	register size_t			nSize ;

	assert (pLispMgr    != NULL) ;
	assert (pvClient    != NULL) ;
	assert (ppEntReturn != NULL) ;

	nSize	= sizeof (TLispIMClient) ;
	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, nSize, &pEntity)))
		return	False ;

	pEntity->m_iType		= LISPENTITY_IMCLIENT ;
	pEntity->m_lReferCount	= 0 ;
	pIMClient				= lispEntity_GetIMClientPtr (pEntity) ;
	pIMClient->m_pvClient		= pvClient ;
	pIMClient->m_pKeyNotify		= pKeyNotify ;
	pIMClient->m_pTextNotify	= pTextNotify ;
	pIMClient->m_pEndNotify		= pEndNotify ;
	lispMgr_RegisterMisc (pLispMgr, pEntity) ;

	*ppEntReturn	= pEntity ;
	return	True ;
}

void
lispIMClient_Destroy (
	register TLispEntity*	pEntity)
{
	return ;
}

Boolean
lispIMClient_KeyNotify (
	register TLispEntity*	pEntity,
	register TXEvent*		pEv)
{
	register TLispIMClient*	pIMClient ;

	assert (pEntity != NULL) ;

	pIMClient	= lispEntity_GetIMClientPtr (pEntity) ;
	assert (pIMClient->m_pvClient != NULL) ;
	/*	XEvent ˡˤĤƹͻʤС⤷
	 *	ǤʤΤʤ顢ФƤʤ*/
	(pIMClient->m_pKeyNotify)(pIMClient->m_pvClient, pEv) ;
	return	True ;
}

Boolean
lispIMClient_TextNotify (
	register TLispEntity*	pEntity,
	register const Char*	pText,
	register int			nText)
{
	register TLispIMClient*	pIMClient ;

	assert (pEntity != NULL) ;

	if (pText != NULL && nText > 0) {
		pIMClient	= lispEntity_GetIMClientPtr (pEntity) ;
		assert (pIMClient->m_pvClient != NULL) ;
		(pIMClient->m_pTextNotify)(pIMClient->m_pvClient, pText, nText) ;
	}
	return	True ;
}

Boolean
lispIMClient_EndNotify (
	register TLispEntity*	pEntity)
{
	register TLispIMClient*	pIMClient ;

	assert (pEntity != NULL) ;

	pIMClient	= lispEntity_GetIMClientPtr (pEntity) ;
	(pIMClient->m_pEndNotify)(pIMClient->m_pvClient) ;
	return	True ;
}




