/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (lispfunc_h)
#define	lispfunc_h

#include "lispmgr.h"
#include "Char.h"
#include "lentity.h"
#include "lbind.h"
#include "kfile.h"
#include "lispyevent.h"

struct tagTLispBind ;
struct tagTLispEntity ;
struct tagTLispManager ;

/*	Constants */
enum {
	/* ǿǤ뤳ȡ*/
	LISPMGR_SIZE_SYMBOL_HASH	= 127,
	LISPMGR_SIZE_INTEGER_HASH	= 13,
	LISPMGR_SIZE_SUBR_HASH		= 23,
	MAX_NEST_COUNT				= 128,
} ;

enum {
	LISPMGR_INDEX_NIL	= 0,
	LISPMGR_INDEX_T,
	LISPMGR_INDEX_MINUS,
	LISPMGR_INDEX_LAMBDA,
	LISPMGR_INDEX_MACRO,
	LISPMGR_INDEX_OPTIONAL,
	LISPMGR_INDEX_REST,
	LISPMGR_INDEX_KEYMAP,
	LISPMGR_INDEX_ERROR,
	LISPMGR_INDEX_EXIT,
	LISPMGR_INDEX_QUIT,
	LISPMGR_INDEX_QUIT_FLAG,
	LISPMGR_INDEX_INHIBIT_QUIT,
	LISPMGR_INDEX_FEATURES,
	LISPMGR_INDEX_INTERACTIVE,
	LISPMGR_INDEX_THIS_COMMAND,
	LISPMGR_INDEX_LAST_COMMAND,
	LISPMGR_INDEX_UNREAD_COMMAND_EVENTS,
	LISPMGR_INDEX_PRE_COMMAND_HOOK,
	LISPMGR_INDEX_POST_COMMAND_HOOK,
 	LISPMGR_INDEX_LAST_COMMAND_CHAR,
	LISPMGR_INDEX_LAST_COMMAND_EVENT,
	LISPMGR_INDEX_UNREAD_COMMAND_CHAR,
	LISPMGR_INDEX_GLOBAL_MAP,
	LISPMGR_INDEX_MINIBUFFER_LOCAL_MAP,
	LISPMGR_INDEX_MINOR_MODE_MAP_ALIST,
	LISPMGR_INDEX_WRONG_TYPE_ARGUMENT,
	LISPMGR_INDEX_BUFFER_FILE_NAME,
	LISPMGR_INDEX_MODE_LINE_FORMAT,
	LISPMGR_INDEX_LOAD_PATH,
	LISPMGR_INDEX_KILL_RING,
	LISPMGR_INDEX_KILL_REGION,
	LISPMGR_INDEX_KILL_RING_YANK_POINTER,
	LISPMGR_INDEX_YANK,

	LISPMGR_INDEX_CODING_SYSTEM_FOR_READ,
	LISPMGR_INDEX_CODING_SYSTEM_FOR_WRITE,
	LISPMGR_INDEX_EUC_JAPAN,
	LISPMGR_INDEX_EUC_JP,
	LISPMGR_INDEX_SHIFT_JIS,
	LISPMGR_INDEX_JAPANESE_SHIFT_JIS,
	LISPMGR_INDEX_SJIS,
	LISPMGR_INDEX_JUNET,
	LISPMGR_INDEX_ISO2022JP,
	LISPMGR_INDEX_ISO2022JP2,
	LISPMGR_INDEX_CTEXT,
	LISPMGR_INDEX_X_CTEXT,
	LISPMGR_INDEX_COMPOUND_TEXT,

	LISPMGR_INDEX_SKK_SERVER_HOST,
	LISPMGR_INDEX_SKK_SERVER_LIST,
	LISPMGR_INDEX_SKK_PORTNUM,
	LISPMGR_INDEX_SKK_PROCESS_OKURI_EARLY,
	LISPMGR_INDEX_J_HENKAN_KEY,
	LISPMGR_INDEX_J_SEARCH_KEY,
	LISPMGR_INDEX_J_OKURI_ARI,
	LISPMGR_INDEX_J_HENKAN_OKURIGANA,
	LISPMGR_INDEX_J_HENKAN_OKURI_STRICTLY,

	LISPMGR_INDEX_SKK_SERVERS_LIST,

	LISPMGR_SIZE_RESERVED,
} ;

/*	Structures */
/*	Фΰ̣ϼ̤ꡣ
 *		m_iMarker
 *			GC ˻Ȥޡ
 *		m_apSymbolListTop
 *			Intern Ƥ륷ܥƤ롣
 *		m_apIntegerListTop
 *			Ʊͤ Integer  eq Ǥ褦 Integer Entity 
 *			Ƥ롣
 *		m_apSubrListTop
 *			֥롼󷿤δ
 *		m_pOtherEntityListTop
 *			ƱݾڤʤƤ⤫ޤʤ Entity ϤΥꥹȤˤ
 *			ʤƤ롣
 *		m_apEntReserved
 *			ˤ˻Ȥ Symbol 򤢤餫 Cache Ƥ롣t 
 *			nil ʤɡIntern Ƥ롣
 *		m_pVoid
 *			ƤƤʤ (void) λ˳Ƥ̤
 *			͡
 *		m_vbufLocalSymbol
 *			Хåե˺줿˼ưŪѰդѿ
 *			¸ߤ硢ѿĤ SYMBOL 롣
 *			 void Ǥ롣(ǽ default-value Τޤ޻Ȥ
 *			֤Ǥ뤬ͤ)
 *			make-variable-buffer-local ɲä롣
 */
struct tagTLispManager {
	int						m_iMarker ;
	struct tagTLispEntity*	m_apSymbolListTop  [LISPMGR_SIZE_SYMBOL_HASH] ;
	struct tagTLispEntity*	m_apIntegerListTop [LISPMGR_SIZE_INTEGER_HASH] ;
	struct tagTLispEntity*	m_apSubrListTop    [LISPMGR_SIZE_SUBR_HASH] ;
	struct tagTLispEntity*	m_pEntListNamedMutex ;
	struct tagTLispEntity*	m_pEntListNoNameMutex ;
	struct tagTLispEntity*	m_pEntMiscListTop ;
	struct tagTLispEntity*	m_apEntReserved    [LISPMGR_SIZE_RESERVED] ;
	struct tagTLispEntity*	m_pEntVoid ;
	struct tagTLispEntity*	m_pEntEmpty ;
	TVarbuffer				m_vbufLocalSymbol ;
}	;

struct tagTLispNumber {
	Boolean	m_fFloatp ;
	union {
		float	m_fFloat ;
		long	m_lLong ;
	}		m_Value ;
} ;

typedef struct tagTLispNumber	TLispNumber ;

/*	lispmgr.kc */
Boolean	lispMgr_SetSymbolFunctionValue	(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispMgr_GetSymbolFunctionValue	(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMgr_SetSymbolFunctionValueWithName	(TLispManager*, const Char*, int, TLispEntity*) ;
Boolean	lispMgr_GetSymbolFunctionValueWithName	(TLispManager*, const Char*, int, TLispEntity** const) ;
Boolean	lispMgr_SetSymbolValue			(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispMgr_SetSymbolValueWithName	(TLispManager*, const Char*, int, TLispEntity*) ;
Boolean	lispMgr_GetSymbolValue			(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMgr_GetSymbolValueWithName	(TLispManager*, const Char*, int, TLispEntity** const) ;
Boolean	lispMgr_Allocate				(TLispManager*, size_t, void*) ;
void	lispMgr_Deallocate				(TLispManager*, void*) ;
Boolean	lispMgr_AllocateEntity			(TLispManager*, size_t, TLispEntity** const) ;
Boolean	lispMgr_CollectGarbage			(TLispManager*) ;
Boolean	lispMgr_RegisterMisc			(TLispManager*, TLispEntity*) ;
Boolean	lispMgr_UnregisterMisc			(TLispManager*, TLispEntity*) ;
void	lispMgr_DestroyEntity			(TLispManager*, TLispEntity*) ;

/*	lispsymbol.c */
Boolean	lispMgr_CreateSymbol			(TLispManager*, const Char*, int, TLispEntity** const) ;
Boolean	lispMgr_CreateSymbolA			(TLispManager*, const char*, int, TLispEntity** const) ;
Boolean	lispMgr_InternSymbol			(TLispManager*, const Char*, int, TLispEntity** const) ;
Boolean	lispMgr_InternSymbolA			(TLispManager*, const char*, int, TLispEntity** const) ;
Boolean	lispMgr_CollectSymbolGarbage	(TLispManager*) ;
Boolean	lispMgr_SearchSymbol			(TLispManager*, const Char*, int, TLispEntity** const) ;
Boolean	lispMgr_SearchSymbolA			(TLispManager*, const char*, int, TLispEntity** const) ;
Boolean	lispMgr_UnregisterSymbol		(TLispManager*, TLispEntity*) ;
Boolean	lispMgr_SymbolRequireEvalp		(TLispManager*, TLispEntity*) ;

/*	lentity.c */
Boolean	lispEntity_Memq					(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity**) ;
Boolean	lispEntity_Member				(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity**) ;
Boolean	lispEntity_Rassoc				(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity**) ;
Boolean	lispEntity_Nconc 				(TLispManager*, TLispEntity*, TLispEntity**) ;
Boolean	lispEntity_Equal				(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispEntity_GetNumberValueOrMarkerPosition	(TLispManager*, TLispEntity*, TLispNumber*) ;
Boolean	lispEntity_GetLength			(TLispManager*, TLispEntity*, int*) ;
Boolean	lispEntity_Format				(TLispManager*, const Char*, int, TLispEntity*, TLispEntity**) ;
Boolean	lispEntity_FormatA				(TLispManager*, const char*, int, TLispEntity*, TLispEntity**) ;
Boolean	lispEntity_PrincStr				(TLispManager*, TLispEntity*, TVarbuffer*) ;
Boolean	lispEntity_Print				(TLispManager*, TLispEntity*) ;
Boolean	lispEntity_Copy					(TLispManager*, TLispEntity*, TLispEntity**) ;

/*	lispstring.c	*/
Boolean	lispMgr_CreateString			(TLispManager*, const Char*, int, TLispEntity** const) ;
Boolean	lispMgr_StringToCharList		(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMgr_Concat					(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMgr_Substring				(TLispManager*, TLispEntity*, long, long, TLispEntity** const) ;
Boolean	lispEntity_Upcase				(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispEntity_Downcase				(TLispManager*, TLispEntity*, TLispEntity** const) ;

/*	lisplist.c	*/
Boolean	lispMgr_CreateConscell			(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMgr_CreateList				(TLispManager*, TLispEntity** const, int, TLispEntity** const) ;
Boolean	lispMgr_CreateTime				(TLispManager*, time_t, TLispEntity** const) ;
Boolean	lispEntity_PlistGet				(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity** const) ;
Boolean	lispEntity_PlistPut				(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity*, TLispEntity** const) ;
Boolean	lispEntity_CopyList				(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispEntity_Push2List			(TLispManager*, TLispConscell*, TLispEntity*) ;

/*	lnum.c	*/
Boolean	lispMgr_CreateInteger			(TLispManager*, long, TLispEntity** const) ;
Boolean	lispMgr_CreateFloat				(TLispManager*, float, TLispEntity** const) ;
Boolean	lispMgr_CollectIntegerGarbage	(TLispManager*) ;
Boolean	lispMgr_MathGreaterThan			(TLispManager*, TLispEntity*, TLispEntity*, Boolean*) ;
Boolean	lispMgr_MathGreaterEqual		(TLispManager*, TLispEntity*, TLispEntity*, Boolean*) ;
Boolean	lispMgr_MathLessThan			(TLispManager*, TLispEntity*, TLispEntity*, Boolean*) ;
Boolean	lispMgr_MathLessEqual			(TLispManager*, TLispEntity*, TLispEntity*, Boolean*) ;
Boolean	lispMgr_MathEqual				(TLispManager*, TLispEntity*, TLispEntity*, Boolean*) ;

/*	lvector.c	*/
Boolean	lispMgr_CreateVector			(TLispManager*, TLispEntity** const, int, TLispEntity** const) ;
Boolean	lispMgr_CreateVectorFill		(TLispManager*, TLispEntity*, int, TLispEntity** const) ;
void	lispMgr_DestroyVector			(TLispManager*, TLispEntity*) ;
Boolean	lispMgr_Vconcat					(TLispManager*, TLispEntity*, TLispEntity** const) ;

/*	lsubr.c */
Boolean	lispMgr_CreateSubr				(TLispManager*, struct tagLMCMDINFO const*, TLispEntity** const) ;
Boolean	lispSubr_GetName				(TLispManager*, TLispEntity*, const Char**) ;

/*	parser.kc */
TLispEntity*	lispMgr_ParseString		(TLispManager*, const Char*, int, int*) ;
TLispEntity*	lispMgr_ParseStringA	(TLispManager*, const char*, int, int*) ;
#if defined (WIN32)
TLispEntity*	lispMgr_ParseFile		(TLispManager*, LPCWSTR) ;
#else
TLispEntity*	lispMgr_ParseFile		(TLispManager*, const char*) ;
#endif

/*	lsub.kc */
Boolean	lispMgr_Append					(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMgr_Nreverse				(TLispManager*, TLispEntity*, TLispEntity** const ppReturn) ;
Boolean	lispMgr_Delete					(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMgr_Delq					(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity** const) ;

/*	lispmarker.c	*/
Boolean	lispMgr_CreateMarker			(TLispManager*, TLispEntity** const) ;
void	lispMgr_DestroyMarker			(TLispManager*, TLispEntity*) ;
Boolean	lispMarker_SetBufferPosition	(TLispManager*, TLispEntity*, TLispEntity*, int) ;
Boolean	lispMarker_SetInsertionType 	(TLispManager*, TLispEntity*, Boolean) ;
Boolean	lispMarker_SetNext				(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispMarker_SetPrevious			(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispMarker_GetInsertionType		(TLispManager*, TLispEntity*, Boolean*) ;
Boolean	lispMarker_GetBufferPosition	(TLispManager*, TLispEntity*, TLispEntity** const, int* const) ;
Boolean	lispMarker_GetNext				(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMarker_GetPrevious			(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMarker_MoveWithInsertion	(TLispManager*, TLispEntity*, int, int) ;
Boolean	lispMarker_MoveWithDeletion		(TLispManager*, TLispEntity*, int, int) ;
Boolean	lispMarker_Print				(TLispManager*, TLispEntity*) ;

/*	lispbuffer.c	*/
Boolean	lispMgr_CreateBuffer			(TLispManager*, TLispEntity** const) ;
void	lispMgr_DestroyBuffer			(TLispManager*, TLispEntity*) ;
Boolean	lispBuffer_SetNext				(TLispEntity*, TLispEntity*) ;
Boolean	lispBuffer_SetPrevious			(TLispEntity*, TLispEntity*) ;
Boolean	lispBuffer_GetNext				(TLispEntity*, TLispEntity** const) ;
Boolean	lispBuffer_GetPrevious			(TLispEntity*, TLispEntity** const) ;
Boolean	lispBuffer_MakeSymbolValue		(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispBuffer_SetSymbolValue		(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity*) ;
Boolean	lispBuffer_SetSymbolValueWithName (TLispManager*, TLispEntity*, const Char*, const int, TLispEntity*) ;
Boolean	lispBuffer_GetSymbolValue		(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity** const) ;
Boolean	lispBuffer_GetSymbolValueWithName (TLispManager*, TLispEntity*, const Char*, const int, TLispEntity** const) ;
Boolean	lispBuffer_AddMarker			(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispBuffer_RemoveMarker			(TLispManager*, TLispEntity*) ;
Boolean	lispBuffer_SetName				(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispBuffer_GetName				(TLispManager*, TLispEntity*, TLispEntity**) ;
Boolean	lispBuffer_SetKeymap			(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispBuffer_GetKeymap			(TLispEntity*, TLispEntity**) ;
Boolean	lispBuffer_SetPrompt			(TLispManager*, TLispEntity*, const Char*, int) ;
Boolean	lispBuffer_Point				(TLispManager*, TLispEntity*, int*) ;
Boolean	lispBuffer_PointBufferEnd		(TLispManager*, TLispEntity*, int*) ;
Boolean	lispBuffer_PointMax				(TLispManager*, TLispEntity*, int*) ;
Boolean	lispBuffer_PointBufferTop		(TLispManager*, TLispEntity*, int*) ;
Boolean	lispBuffer_PointMin				(TLispManager*, TLispEntity*, int*) ;
Boolean	lispBuffer_PointMarker			(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispBuffer_MarkMarker			(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispBuffer_GetString			(TLispManager*, TLispEntity*, TBufStringMarker*, int* const) ;
Boolean	lispBuffer_GetFullString		(TLispManager*, TLispEntity*, TBufStringMarker*, int* const) ;
Boolean	lispBuffer_Narrow				(TLispManager*, TLispEntity*, int, int) ;
Boolean	lispBuffer_Widen				(TLispManager*, TLispEntity*) ;
Boolean	lispBuffer_InsertChar			(TLispManager*, TLispEntity*, int, const Char, int) ;
Boolean	lispBuffer_DeleteChar			(TLispManager*, TLispEntity*, int, int nCount) ;
Boolean	lispBuffer_InsertFileContents	(TLispManager*, TLispEntity*, int, KFILE*, int*) ;
Boolean	lispBuffer_InsertString			(TLispManager*, TLispEntity*, int, const Char*, int) ;
Boolean	lispBuffer_MoveMarkerWithInsertion (TLispManager*, TLispEntity*, int, int) ;
Boolean	lispBuffer_MoveMarkerWithDeletion (TLispManager*, TLispEntity*, int, int) ;
Boolean	lispBuffer_Print				(TLispManager*, TLispEntity*) ;
Boolean	lispBuffer_GetModifiedp			(TLispManager*, TLispEntity*) ;
void	lispBuffer_SetModifiedp			(TLispManager*, TLispEntity*, Boolean) ;
void	lispBuffer_Desync				(TLispManager*, TLispEntity*) ;

/*	lispwindow.c */
Boolean	lispMgr_CreateWindow			(TLispManager*, Boolean, TLispEntity** const) ;
void	lispMgr_DestroyWindow			(TLispManager*, TLispEntity*) ;
Boolean	lispWindow_SetNext				(TLispEntity*, TLispEntity*) ;
Boolean	lispWindow_SetPrevious			(TLispEntity*, TLispEntity*) ;
Boolean	lispWindow_GetNext				(TLispEntity*, TLispEntity** const) ;
Boolean	lispWindow_GetPrevious			(TLispEntity*, TLispEntity** const) ;
Boolean	lispWindow_SetBuffer			(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispWindow_GetBuffer			(TLispEntity*, TLispEntity** const) ;
Boolean	lispWindow_SetFrame				(TLispEntity*, TLispEntity*) ;
Boolean	lispWindow_GetFrame				(TLispEntity*, TLispEntity** const) ;
Boolean	lispWindow_SetArea				(TLispEntity*, const XRectangle*) ;
Boolean	lispWindow_GetArea				(TLispEntity*, XRectangle*) ;
Boolean	lispWindow_HaveFocusp			(TLispEntity*) ;
Boolean	lispWindow_SetFocus				(TLispEntity*, Boolean) ;
Boolean	lispWindow_EnableModeline		(TLispEntity*, Boolean) ;
Boolean	lispWindow_SetMessage			(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispWindow_GetMessage			(TLispEntity*, TLispEntity** const) ;
Boolean	lispWindow_GetViewMarker		(TLispEntity*, TLispEntity** const) ;
Boolean	lispWindow_Minibufferp			(TLispEntity*) ;
void	lispWindow_SetMinibufWindow		(TLispEntity*, Boolean) ;

/*	lispframe.c	*/
Boolean	lispMgr_MakeFrame				(TLispManager*, Widget, TLispEntity*, TLispEntity*, TLispEntity*, TLispEntity** const) ;
void	lispMgr_DestroyFrame			(TLispManager*, TLispEntity*) ;
Boolean	lispFrame_GetTopWindow			(TLispEntity*, TLispEntity** const) ;
Boolean	lispFrame_GetMinibufferWindow	(TLispEntity*, TLispEntity** const) ;
Boolean	lispFrame_GetNext				(TLispEntity*, TLispEntity** const) ;
Boolean	lispFrame_GetPrevious			(TLispEntity*, TLispEntity** const) ;
Boolean	lispFrame_SetNext				(TLispEntity*, TLispEntity*) ;
Boolean	lispFrame_SetPrevious			(TLispEntity*, TLispEntity*) ;
Boolean	lispFrame_InsertWindow			(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispFrame_RemoveWindow			(TLispManager*, TLispEntity*, TLispEntity*) ;
Boolean	lispFrame_GetTerminal			(TLispEntity*, Widget* const) ;
void	lispFrame_Activate				(TLispManager*, TLispEntity*, Boolean) ;
Boolean	lispFrame_NeedUpdatep			(TLispManager*, TLispEntity*) ;
void	lispFrame_ScheduleUpdate		(TLispManager*, TLispEntity*) ;

/*	lispfile.c	*/
Boolean	lispMgr_Load					(TLispManager*, const Char*, int, TLispEntity** const) ;

/*	lispkeymap.kc	*/
Boolean	lispMgr_CreateKeymap			(TLispManager*, TLispEntity*, TLispEntity**) ;
Boolean	lispMgr_CreateSparseKeymap		(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMgr_CopyKeymap				(TLispManager*, TLispEntity*, TLispEntity** const) ;
Boolean	lispEntity_Keymapp				(TLispManager*, TLispEntity*) ;
Boolean	lispKeymap_Lookup				(TLispManager*, TLispEntity*, TLispEntity*, Boolean, Boolean, int*, TLispEntity** const) ;
Boolean	lispKeymap_LookupWithString		(TLispManager*, TLispEntity*, const Char*, int, Boolean, Boolean, int*, TLispEntity** const) ;
Boolean	lispKeymap_LookupWithVector		(TLispManager*, TLispEntity*, TLispEntity**, int, Boolean, Boolean, int*, TLispEntity** const) ;
Boolean	lispKeymap_LookupWithList		(TLispManager*, TLispEntity*, TLispEntity*, Boolean, Boolean, int*, TLispEntity** const) ;
Boolean	lispKeymap_DefineKeyWithVector	(TLispManager*, TLispEntity*, TLispEntity**, int, TLispEntity*) ;
Boolean	lispKeymap_DefineKey			(TLispManager*, TLispEntity*, const Char*, int, TLispEntity*) ;

/*	limclient.c */
Boolean	lispMgr_CreateIMClient			(TLispManager*, void*, void (*)(), void (*)(), void (*)(), TLispEntity** const) ;
Boolean	lispIMClient_KeyNotify			(TLispEntity*, TXEvent*) ;
Boolean	lispIMClient_TextNotify			(TLispEntity*, const Char*, int) ;
Boolean	lispIMClient_EndNotify			(TLispEntity*) ;

/*	lmutex.c */
Boolean	lispMgr_CreateMutex				(TLispManager*, const Char*, int, TLispEntity** const) ;
Boolean	lispEntity_Mutexp				(TLispManager*, TLispEntity*) ;
Boolean	lispMgr_LockMutex				(TLispManager*, TLispEntity*, void*) ;
Boolean	lispMgr_UnlockMutex				(TLispManager*, TLispEntity*, void*) ;
Boolean	lispEntity_GetMutexInfo			(TLispManager*, TLispEntity*, const Char**, int*, unsigned int*, const void**) ;
Boolean	lispMgr_SearchMutex				(TLispManager*, const Char*, int, TLispEntity** const) ;
void	lispMgr_AbondonMutex			(TLispManager*, const void*) ;

Boolean	lispMgr_CreateXEvent			(TLispManager*, TLispEntity*, const XEvent*, TLispEntity** const) ;
void	lispMgr_DestroyXEvent			(TLispManager*, TLispEntity*) ;

/*	Library Internal Functions Prototype */
#include "lentity-inl.h"
#include "lispmgr-inl.h"

#endif

