#include "lmachinep.h"
#include "kanji.h"

typedef struct tagSYM2CODESYS {
	int		m_nIndex ;
	int		m_nCodingSystem ;
}	SYM2CODESYS ;

static	int		lispMachine_getCodingSystemForCommon	(TLispMachine*, int) ;
static	int		lispMachine_findCodingSystem			(TLispManager*, TLispEntity*) ;

/*	coding-system-list ()ʡ
 *
 *	ݡȤƤнʬʡ
 */
static SYM2CODESYS		srKnownCodingSystem []	= {
	{	LISPMGR_INDEX_EUC_JAPAN,			KCODING_SYSTEM_EUCJP, },
	{	LISPMGR_INDEX_EUC_JP,				KCODING_SYSTEM_EUCJP, },
	{	LISPMGR_INDEX_SHIFT_JIS,			KCODING_SYSTEM_SHIFTJIS, },
	{	LISPMGR_INDEX_JAPANESE_SHIFT_JIS,	KCODING_SYSTEM_SHIFTJIS, },
	{	LISPMGR_INDEX_SJIS,					KCODING_SYSTEM_SHIFTJIS, },
	{	LISPMGR_INDEX_JUNET,				KCODING_SYSTEM_ISO2022JP2, },
	{	LISPMGR_INDEX_ISO2022JP,			KCODING_SYSTEM_ISO2022JP2, },
	{	LISPMGR_INDEX_ISO2022JP2,			KCODING_SYSTEM_ISO2022JP2, },
	{	LISPMGR_INDEX_CTEXT,				KCODING_SYSTEM_COMPOUND_TEXT, },
	{	LISPMGR_INDEX_X_CTEXT,				KCODING_SYSTEM_COMPOUND_TEXT, },
	{	LISPMGR_INDEX_COMPOUND_TEXT,		KCODING_SYSTEM_COMPOUND_TEXT, },
} ;

int
lispMachine_GetCodingSystemForRead (
	register TLispMachine*	pLM)
{
	return	lispMachine_getCodingSystemForCommon (pLM, LISPMGR_INDEX_CODING_SYSTEM_FOR_READ) ;
}

int
lispMachine_GetCodingSystemForWrite (
	register TLispMachine*	pLM)
{
	return	lispMachine_getCodingSystemForCommon (pLM, LISPMGR_INDEX_CODING_SYSTEM_FOR_WRITE) ;
}

Boolean
lispMachine_CodingSystemp (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntValue)
{
	return	lispMachine_findCodingSystem (pLispMgr, pEntValue) != KCODING_SYSTEM_UNKNOWN ;
}

int
lispMachine_getCodingSystemForCommon (
	register TLispMachine*	pLM,
	register int			nIndex)
{
	register TLispManager*	pLispMgr ;
	register TLispEntity*	pEntTarget ;
	TLispEntity*			pEntValue	= NULL ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	pEntTarget	= lispMgr_GetReservedEntity (pLispMgr, nIndex) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntTarget, &pEntValue)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pEntValue))) 
		return	KCODING_SYSTEM_UNKNOWN ;

	return	lispMachine_findCodingSystem (pLispMgr, pEntValue) ;
}

int
lispMachine_findCodingSystem (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntCodingSystem)
{
	register const SYM2CODESYS*	pPtr ;
	register TLispEntity*		pEntity ;
	register int				i ;

	pPtr	= srKnownCodingSystem ;
	for (i = 0 ; i < NELEMENTS (srKnownCodingSystem) ; i ++) {
		pEntity	= lispMgr_GetReservedEntity (pLispMgr, pPtr->m_nIndex) ;
		if (lispEntity_Eq (pLispMgr, pEntity, pEntCodingSystem))
			return	pPtr->m_nCodingSystem ;
		pPtr	++ ;
	}
	return	KCODING_SYSTEM_UNKNOWN ;
}


