/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lispmgrp.h"
/*#include "TFrame.h"*/

#define	lispEntity_GetWindowPtr(ptr)	((TLispWindow *)((TLispEntity *)(ptr) + 1))

/*
 *	ץȥ
 */
Boolean	lispWindow_adjustViewMarker (TLispManager*, TLispEntity*) ;

/*
 *	Window Entity (Lisp Object Ǥ) 롣 Window  Buffer 
 *	Ф11˥ޥåԥ󥰤Ƥ롣
 */
Boolean
lispMgr_CreateWindow (
	register TLispManager*			pLispMgr,
	register Boolean				fMinibuf,
	register TLispEntity** const	ppReturn)
{
	TLispEntity*			pEntity ;
	register TLispWindow*	pWindow ;

	assert (pLispMgr != NULL) ;
	assert (ppReturn != NULL) ;

	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, sizeof (TLispWindow), &pEntity)))
		return	False ;
	
	pEntity->m_iType			= LISPENTITY_WINDOW ;
	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	pWindow->m_Range.x			= 0 ;
	pWindow->m_Range.y			= 0 ;
	pWindow->m_Range.width		= 0 ;
	pWindow->m_Range.height		= 0 ;
	pWindow->m_fHaveFocus		= False ;
	pWindow->m_pFrame			= NULL ;
	pWindow->m_pBuffer			= NULL ;
	pWindow->m_pMessage			= NULL ;
	pWindow->m_fMinibufferWindow= fMinibuf ;

	/*	󥰥ꥹȤ1ΡɤǤȤƤ롣*/
	pWindow->m_pPrevWindow		= pEntity ;
	pWindow->m_pNextWindow		= pEntity ;
	/*	ХåեƤƤʤ֤Ǥ 0 Τޤޡ*/
	pWindow->m_nTick			= 0 ;
	pWindow->m_nPointBack		= -1 ;

	/*	View Marker 롣*/
	pWindow->m_pViewMarker		= NULL ;
	if (TFAILED (lispMgr_CreateMarker (pLispMgr, &pWindow->m_pViewMarker))) 
		return	False ;
	lispEntity_AddRef (pLispMgr, pWindow->m_pViewMarker) ;

	lispMgr_RegisterMisc (pLispMgr, pEntity) ;
	*ppReturn	= pEntity ;
	return	True ;
}

void
lispMgr_DestroyWindow (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pEntWindow)
{
	register TLispWindow*	pWindow ;

	assert (pLispMgr   != NULL) ;
	assert (pEntWindow != NULL) ;
	assert (pEntWindow->m_iType == LISPENTITY_WINDOW) ;

#if defined (DEBUG) || 0
	fprintf (stderr, "lispMgr_DestroyWindow (%p, %p)\n", pLispMgr, pEntWindow) ;
#endif
	pWindow	= lispEntity_GetWindowPtr (pEntWindow) ;

	if (pWindow->m_pViewMarker != NULL) {
		lispEntity_Release (pLispMgr, pWindow->m_pViewMarker) ;
		pWindow->m_pViewMarker	= NULL ;
	}
	if (pWindow->m_pBuffer != NULL) {
		lispEntity_Release (pLispMgr, pWindow->m_pBuffer) ;
		pWindow->m_pBuffer	= NULL ;
	}
	if (pWindow->m_pMessage != NULL) {
		lispEntity_Release (pLispMgr, pWindow->m_pMessage) ;
		pWindow->m_pMessage	= NULL ;
	}
	/*	Frame ¦ Destroy  Window ΤǡFrame ¦ Remove 
	 *	ɬפϤʤ⤽⡢Frame ¦黲ȤƤΤˡȤ
	 *	ʤʤä˴˹Ԥä̵Ǥ礦 ߻Ȥǰ¸ط
	 *	롼פƤ뤫顢ξ˴Ǥʤ*/
	pWindow->m_pFrame	= NULL ;
	return ;
}

Boolean
lispWindow_SetNext (
	register TLispEntity*	pEntity,
	register TLispEntity*	pNextEntity)
{
	register TLispWindow*	pWindow ;

	assert (pEntity     != NULL) ;
	assert (pNextEntity != NULL) ;
	assert (pEntity->m_iType     == LISPENTITY_WINDOW) ;
	assert (pNextEntity->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	pWindow->m_pNextWindow	= pNextEntity ;
	return	True ;
}

Boolean
lispWindow_SetPrevious (
	register TLispEntity*	pEntity,
	register TLispEntity*	pPrevEntity)
{
	register TLispWindow*	pWindow ;

	assert (pEntity     != NULL) ;
	assert (pPrevEntity != NULL) ;
	assert (pEntity->m_iType     == LISPENTITY_WINDOW) ;
	assert (pPrevEntity->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	pWindow->m_pPrevWindow	= pPrevEntity ;
	return	True ;
}

Boolean
lispWindow_GetNext (
	register TLispEntity*			pEntity,
	register TLispEntity** const	ppReturn)
{
	register TLispWindow*	pWindow ;

	assert (pEntity     != NULL) ;
	assert (ppReturn    != NULL) ;
	assert (pEntity->m_iType     == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	*ppReturn	= pWindow->m_pNextWindow ;
	return	True ;
}

Boolean
lispWindow_GetPrevious (
	register TLispEntity*			pEntity,
	register TLispEntity** const	ppReturn)
{
	register TLispWindow*	pWindow ;

	assert (pEntity     != NULL) ;
	assert (ppReturn    != NULL) ;
	assert (pEntity->m_iType     == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	*ppReturn	= pWindow->m_pPrevWindow ;
	return	True ;
}

/*
 *	Window  buffer ȤΤϡView ¦Ǥ롣Խ
 *	Ԥ¦ buffer (set-current-buffer ꤵ) ̤
 *	View ϤʤƤ⤫ޤʤ
 *
 *	 SetBuffer ȤΤ View ¦˱ƶ褦ʥޥ
 *	㤨Сswitch-buffer  Window  Buffer бѹ
 *	褦ʤȤºݤ˵Ǥ롣
 *
 *	set-window-buffer Ȥ
 *[]
 *	get-buffer-window-list η̤򸫤ȡcurrent-frame 
 *	buffer ° window 򸡺Ƥߤ
 *	顢buffer  window  list ɬפϤʤȻפ
 */
Boolean
lispWindow_SetBuffer (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity,
	register TLispEntity*	pEntBuffer)
{
	TLispWindow*	pWindow ;

	assert (pEntity       != NULL) ;
	assert (pEntBuffer != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	if (pWindow->m_pBuffer == pEntBuffer) 
		return	True ;

	if (pWindow->m_pBuffer != NULL) 
		lispEntity_Release (pLispMgr, pWindow->m_pBuffer) ;
	pWindow->m_pBuffer	= pEntBuffer ;
	if (pEntBuffer != NULL)
		lispEntity_AddRef (pLispMgr, pEntBuffer) ;

	assert (pWindow->m_pViewMarker != NULL) ;

	/*	ViewMarker ȿǤ롣 Position ꤹ롣*/
	lispBuffer_AddMarker (pLispMgr, pEntBuffer, pWindow->m_pViewMarker) ;
	lispMarker_SetBufferPosition (pLispMgr, pWindow->m_pViewMarker, pEntBuffer, 1) ;
	
	/*	ViewMarker β Position ꤹ롣*/
#if 0
	lispWindow_adjustViewMarker (pLispMgr, pEntity, pEntBuffer) ;
#endif
	pWindow->m_nTick	= lispBuffer_GetTick (pEntBuffer) - 1 ;
	return	True ;
}

Boolean
lispWindow_GetBuffer (
	register TLispEntity*			pEntity,
	register TLispEntity** const	ppReturn)
{
	TLispWindow*	pWindow ;

	assert (pEntity  != NULL) ;
	assert (ppReturn != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	*ppReturn	= pWindow->m_pBuffer ;
	return	True ;
}

Boolean
lispWindow_SetFrame (
	register TLispEntity*		pEntity,
	register TLispEntity* 		pFrameEntity)
{
	register TLispWindow*	pWindow ;

	assert (pEntity      != NULL) ;
	assert (pFrameEntity != NULL) ; 
	assert (pEntity->m_iType == LISPENTITY_WINDOW) ;

	pWindow					= lispEntity_GetWindowPtr (pEntity) ;
	pWindow->m_pFrame		= pFrameEntity ;
	return	True ;
}

/*
 *	lispؿ window-frame ˴ط(Ȧ)δؿ
 *	Window ° Frame ֤
 */
Boolean
lispWindow_GetFrame (
	register TLispEntity*			pEntity,
	register TLispEntity** const	ppReturn)
{
	register TLispWindow*	pWindow ;

	assert (pEntity  != NULL) ;
	assert (ppReturn != NULL) ;

	if (pEntity->m_iType != LISPENTITY_WINDOW)
		return	False ;
	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	*ppReturn	= pWindow->m_pFrame ;
	return	True ;
}

Boolean
lispWindow_SetArea (
	register TLispEntity*			pEntity,
	register const XRectangle*		pArea)
{
	register TLispWindow*	pWindow ;

	assert (pEntity  != NULL) ;
	assert (pArea    != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	memcpy (&pWindow->m_Range, pArea, sizeof (XRectangle)) ;
	/*	ΰѹȽľɬפˤʤ롣*/
	pWindow->m_nTick	-- ;
	return	True ;
}

Boolean
lispWindow_GetArea (
	register TLispEntity*			pEntity,
	register XRectangle*			pArea)
{
	register TLispWindow*	pWindow ;

	assert (pEntity  != NULL) ;
	assert (pArea    != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	memcpy (pArea, &pWindow->m_Range, sizeof (XRectangle)) ;
	return	True ;
}

Boolean
lispWindow_HaveFocusp (
	register TLispEntity*	pEntity)
{
	register TLispWindow*	pWindow ;

	assert (pEntity  != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	return	pWindow->m_fHaveFocus ;
}

Boolean
lispWindow_SetFocus (
	register TLispEntity*	pEntity,
	register Boolean		fFocus)
{
	register TLispWindow*	pWindow ;

	assert (pEntity  != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;

	if (pWindow->m_fHaveFocus != fFocus) {
		pWindow->m_fHaveFocus	= fFocus ;
		pWindow->m_nTick	-- ;
	}
	return	True ;
}

Boolean
lispWindow_SetMessage (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity,
	register TLispEntity*	pStrEntity)
{
	register TLispWindow*	pWindow ;

	assert (pEntity  != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_WINDOW) ;

	if (pStrEntity != NULL &&
		TFAILED (lispEntity_Stringp (pLispMgr, pStrEntity)) &&
		TFAILED (lispEntity_Nullp (pLispMgr, pStrEntity)))
		return	False ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	if (pStrEntity != NULL)
		lispEntity_AddRef (pLispMgr, pStrEntity) ;
	if (pWindow->m_pMessage != NULL) 
		lispEntity_Release (pLispMgr, pWindow->m_pMessage) ;
	pWindow->m_pMessage	= pStrEntity ;
	pWindow->m_nTick	-- ;
	return	True ;
}

Boolean
lispWindow_GetMessage (
	register TLispEntity*			pEntity,
	register TLispEntity** const	ppEntReturn)
{
	register TLispWindow*	pWindow ;

	assert (pEntity  != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_WINDOW) ;
	assert (ppEntReturn != NULL) ;

	pWindow	= lispEntity_GetWindowPtr (pEntity) ;
	if (pWindow->m_pMessage == NULL)
		return	False ;
	*ppEntReturn	= pWindow->m_pMessage ;
	return	True ;
}

void
lispWindow_GetRect (
	register TLispEntity*	pEntWindow,
	register XRectangle*	pRect)
{
	register TLispWindow*	pWindow ;

	assert (pEntWindow  != NULL) ;
	assert (pEntWindow->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntWindow) ;
	memcpy (pRect, &pWindow->m_Range, sizeof (XRectangle)) ;
	return ;
}

Boolean
lispWindow_GetViewMarker (
	register TLispEntity*			pEntWindow,
	register TLispEntity** const	ppEntReturn)
{
	register TLispWindow*	pWindow ;

	assert (pEntWindow  != NULL) ;
	assert (pEntWindow->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntWindow) ;
	*ppEntReturn	= pWindow->m_pViewMarker ;
	return	True ;
}

Boolean
lispWindow_Minibufferp (
	register TLispEntity*			pEntWindow)
{
	register TLispWindow*	pWindow ;

	assert (pEntWindow  != NULL) ;
	assert (pEntWindow->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntWindow) ;
	return	pWindow->m_fMinibufferWindow ;
}

void
lispWindow_SetMinibufWindow (
	register TLispEntity*			pEntWindow,
	register Boolean				fMinibuf)
{
	register TLispWindow*	pWindow ;

	assert (pEntWindow  != NULL) ;
	assert (pEntWindow->m_iType == LISPENTITY_WINDOW) ;

	pWindow	= lispEntity_GetWindowPtr (pEntWindow) ;
	pWindow->m_fMinibufferWindow	= fMinibuf ;
	return ;
}

