/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lispmgrp.h"

Boolean
lispMgr_CreateXEvent (
	register TLispManager* 			pLispMgr,
	register TLispEntity*			pEntValue,
	register const XEvent*			pEvent,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*				pEntity ;
	register TLispXEventInt*	pEv ;

	assert (pLispMgr    != NULL) ;
	assert (pEntValue   != NULL) ;
	assert (ppEntReturn != NULL) ;

	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, sizeof (TLispXEventInt), &pEntity)))
		return	False ;
		
	pEntity->m_iType	= LISPENTITY_XEVENT ;
	pEv					= lispEntity_GetXEventPtr (pEntity) ;
	pEv					= (TLispXEventInt *)(pEntity + 1) ;
	pEv->m_pEntValue	= pEntValue ;
	lispEntity_AddRef (pLispMgr, pEntValue) ;
	memcpy (&pEv->m_evX, pEvent, sizeof (XEvent)) ;
	lispMgr_RegisterMisc (pLispMgr, pEntity) ;
	*ppEntReturn		= pEntity ;
	return	True ;
}

void
lispMgr_DestroyXEvent (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity)
{
	register TLispXEventInt*	pEv	= lispEntity_GetXEventPtr (pEntity) ;
	
	assert (pLispMgr != NULL) ;
	assert (pEntity  != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_XEVENT) ;

	lispEntity_Release (pLispMgr, pEv->m_pEntValue) ;
	pEv->m_pEntValue	= NULL ;
	return ;
}

