/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

/*	im-send-text  im-newline ƤӽФ뤳Ȥ
 *	Ƥ롣
 *	im-newline  j-newline Ƥ롣lisp ͳ
 *	ǡɤäŤννŤ򤹤
 *	ʤϹͤƤʤȤʤ֥ɤȤ
 */
TLMRESULT
lispMachineState_ImSendText (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntIMClient ;
	TLispEntity*	pEntString ;
	const Char*		pString ;
	int				nString, nType ;
	TLispEntity*	pEntNil ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntIMClient)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntString))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	/*	ηåԤäȼưʤΤᤷɡ
	 *	ˤޤȤ᤿⤷ʤ
	 */
	if (TFAILED (lispEntity_GetType (pLispMgr, pEntIMClient, &nType)) ||
		nType != LISPENTITY_IMCLIENT ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pEntString, &pString, &nString))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispIMClient_TextNotify (pEntIMClient, pString, nString) ;
	lispMgr_CreateNil (pLispMgr, &pEntNil) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntNil) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_ImSendEndConversion (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntIMClient ;
	int				nType ;
	TLispEntity*	pEntNil ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntIMClient))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	/*	ηåԤäȼưʤΤᤷɡ
	 *	ˤޤȤ᤿⤷ʤ
	 */
	if (TFAILED (lispEntity_GetType (pLispMgr, pEntIMClient, &nType)) ||
		nType != LISPENTITY_IMCLIENT) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispIMClient_EndNotify (pEntIMClient) ;
	lispMgr_CreateNil (pLispMgr, &pEntNil) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntNil) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_ImSendKey (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntIMClient ;
	TLispEntity*	pEntKey ;
	int				nType ;
	TLispEntity*	pEntNil ;
	TXEvent			ev ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntIMClient)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntKey))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	/*	ηåԤäȼưʤΤᤷɡ
	 *	ˤޤȤ᤿⤷ʤ
	 */
	if (TFAILED (lispEntity_GetType (pLispMgr, pEntIMClient, &nType)) ||
		nType != LISPENTITY_IMCLIENT ||
		TFAILED (lispEntity_GetType (pLispMgr, pEntKey, &nType))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	switch (nType) {
	case	LISPENTITY_INTEGER:
		(void) lispEntity_GetIntegerValue (pLispMgr, pEntKey, &ev.u.m_ch) ;
		ev.m_fChar	= True ;
		break ;
	case	LISPENTITY_SYMBOL:
		/*	SYMBOL 饭ɬפꡣ*/
		ev.m_fChar	= True ;
		ev.u.m_ch	= lispMachine_lispKeyEventSymbol2Char (pLispMgr, pEntKey) ;
		break ;
	case	LISPENTITY_XEVENT:
		(void) lispEntity_GetXEvent (pLispMgr, pEntKey, &ev.u.m_pEv) ;
		ev.m_fChar	= False ;
		break ;
	default:
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispIMClient_KeyNotify (pEntIMClient, &ev) ;
	lispMgr_CreateNil (pLispMgr, &pEntNil) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntNil) ;
	return	LMR_RETURN ;
}

