/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

static	TLMRESULT	lispMachineState_backquoteConscellStart   (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteConscell        (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteConsPostCons    (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteConsPostComma   (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteConsPostCommaAt (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteConscellEnd     (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteConsPostCommon  (TLispMachine*, TLispEntity*) ;
static	TLMRESULT	lispMachineState_backquoteVectorStart	  (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteVector		  (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteVectPostVect	  (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteVectPostComma	  (TLispMachine*) ;
static	TLMRESULT	lispMachineState_backquoteVectorEnd		  (TLispMachine*) ;

static	TLMRESULT	lispMachineState_evalMacroFinalize		  (TLispMachine*) ;


/*
 *	(defmacro NAME ARGLIST [DOCSTRING] BODY...)
 *
 *	ޥȤ NAME 롣ϡ
 *	(macro lambda ARGLIST [DOCSTRING] BODY...) ˤʤ롣
 *	ޥƤФ줿ʤ (NAME ARGS ...) λؿ
 *	(lambda ARGLIST BODY...) ˥ꥹ ARGS ŬѤ롣
 */
TLMRESULT
lispMachineState_Defmacro (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	register TLispEntity*	pEntLambda ;
	register TLispEntity*	pEntMacro ;
	TLispEntity*	pEntMacroForm ;
	TLispEntity*	pEntLambdaForm ;
	TLispEntity*	pEntName ;

	pLispMgr	= pLM->m_pLispMgr ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntLambdaForm) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntLambdaForm, &pEntName)) ||
		TFAILED (lispEntity_Symbolp (pLispMgr, pEntName))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	pEntLambda	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_LAMBDA) ;
	lispEntity_SetCar (pLispMgr, pEntLambdaForm, pEntLambda) ;
	lispEntity_AddRef (pLispMgr, pEntName) ;
	pEntMacro	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_MACRO) ;
	if (TFAILED (lispMgr_CreateConscell (pLispMgr, pEntMacro, pEntLambdaForm, &pEntMacroForm)))
		return	LMR_ERROR ;
	if (TFAILED (lispMachine_SetSymbolFunctionValue (pLM, pEntName, pEntMacroForm))) 
		return	LMR_ERROR ;
	lispEntity_Release (pLispMgr, pEntName) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntName) ;
	return	LMR_RETURN ;
}

/*
 *	(macroexpand FORM &optional ENVIRONMENT)
 *
 *	FORM Υȥåץ٥ˤޥŸƤη̤֤⤷
 *	FORM ޥƤӽФǤʤС⤷ʤ֤
 *	ʤСޥŸơŸ줿Τ FORM 
 *	˹θ롣ޥƤӽФƤʤΤä֤
 *
 *	2ܤ ENVIRONMENT ϥޥδĶꤹ롣
 *	ĶäƲͤĤȤ
 *
 *	(defmacro myinc (var) 
 *		(list 'setq var (list '1+ var))
 *
 *	(macroexpand '(myinc r))
 *	(setq r (1+ r))
 *	(macroexpand '(myinc r) '((myinc lambda (var) (list 'setq var (list '1- var)))))
 *	(setq r (1- r))
 *	
 *	Ȥʤ롣ʤۤɡlet ߤ˰Ū symbol-function value
 *	֤Τ
 *	Сlisp machine ϶ĴưƤ뤱ɡ 
 *	symbol-value ï˲Ǥʡġ
 */
TLMRESULT
lispMachineState_Macroexpand (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMacroForm ;
	TLispEntity*	pEntSym ;
	TLispEntity*	pEntFunc ;
	TLispEntity*	pEntMacro ;

	pLispMgr	= pLM->m_pLispMgr ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	/*	pEntMacroForm  ((macro lambda ...) ARG...) ηˤʤäƤ
	 *	롣ꤷƤ롣*/
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntMacroForm))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntMacroForm, &pEntSym)) ||
		TFAILED (lispMachine_GetSymbolFunctionValue (pLM, pEntSym, &pEntFunc)) ||
		TFAILED (lispEntity_GetCar (pLispMgr, pEntFunc, &pEntMacro)) ||
		TFAILED (lispEntity_Macrop (pLispMgr, pEntMacro))) {
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_GetCdr (pLispMgr, pEntFunc, &pEntFunc))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispEntity_SetCar (pLispMgr, pEntMacroForm, pEntFunc) ;
#if defined (DEBUG)
	fprintf (stderr, "macroexpand start = ") ;
	lispEntity_Print (pLispMgr, pEntMacroForm) ;
	fprintf (stderr, "\n") ;
#endif
	lispMachineCode_SetLReg   (pLM, LM_LREG_ACC, pEntMacroForm) ;
	lispMachineCode_PushState (pLM, &lispMachineState_ReturnOnly) ;
	lispMachineCode_SetState  (pLM, &lispMachineState_EvalLambdaForm) ;
	return	LMR_CONTINUE ;
}

/*
 *	(` ARG)
 *
 *	(, VAR) ڤ (,@ VAR) ξˤ VAR ɾƤη
 *	ꥹȤȤƤĤʤVECTOR ξˤϡVECTOR Ȥ
 *	Ĥʤդ٤
 *	ޤARG ɤʤ˿ NEST äƤƤư
 *	աĤޤϡSTACK MACHINE ϡʿŸɬ
 *	롣
 */
TLMRESULT
lispMachineState_Backquote (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntNextArglist ;
	TLispEntity*	pEntArg ;
	int				nType ;

	pLispMgr	= pLM->m_pLispMgr ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntArglist)) ||
		TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntArg)) ||
		TFAILED (lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntNextArglist)) ||
		TFAILED (lispEntity_Nullp  (pLispMgr, pEntNextArglist)) ||
		TFAILED (lispEntity_GetType (pLispMgr, pEntArg, &nType))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntArg) ;
	switch (nType) {
	case	LISPENTITY_CONSCELL:
		lispMachineCode_SetState (pLM, &lispMachineState_backquoteConscellStart) ;
		return	LMR_CONTINUE ;
	case	LISPENTITY_VECTOR:
		lispMachineCode_SetState (pLM, &lispMachineState_backquoteVectorStart) ;
		return	LMR_CONTINUE ;
	default:
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntArg) ;
		return	LMR_RETURN ;
	}
}

/*
 *	Macro  Expand 塢¹ԤޤǹԤ
 */
TLMRESULT
lispMachineState_EvalMacro (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMacroForm ;
	TLispEntity*	pEntMacro ;
	TLispEntity*	pEntLambdaForm ;

	pLispMgr	= pLM->m_pLispMgr ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	/*	pEntMacroForm  ((macro lambda ...) ARG...) ηˤʤäƤ
	 *	롣ꤷƤ롣*/
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist,   &pEntMacroForm)) ||
		TFAILED (lispEntity_GetCar (pLispMgr, pEntMacroForm, &pEntMacro)) ||
		TFAILED (lispEntity_Macrop (pLispMgr, pEntMacro))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispEntity_GetCdr (pLispMgr, pEntMacroForm, &pEntLambdaForm) ;
	lispEntity_SetCar (pLispMgr, pEntArglist,   pEntLambdaForm) ;
#if defined (DEBUG)
	fprintf (stderr, "eval macro start = ") ;
	lispEntity_Print (pLispMgr, pEntArglist) ;
	fprintf (stderr, "\n") ;
#endif
	lispMachineCode_PushState (pLM, &lispMachineState_evalMacroFinalize) ;
	lispMachineCode_SetState (pLM, &lispMachineState_EvalLambdaForm) ;
	return	LMR_CONTINUE ;
}

/*	private functions */
TLMRESULT
lispMachineState_backquoteConscellStart (
	register TLispMachine*	pLM)
{
	TLispEntity*	pEntNil ;

	lispMgr_CreateNil (pLM->m_pLispMgr, &pEntNil) ;
	lispMachineCode_PushLReg  (pLM, LM_LREG_1) ;
	lispMachineCode_PushLReg  (pLM, LM_LREG_2) ;
	lispMachineCode_PushLReg  (pLM, LM_LREG_3) ;
	lispMachineCode_MoveLReg  (pLM, LM_LREG_1, LM_LREG_ACC) ;
	lispMachineCode_SetLReg   (pLM, LM_LREG_2, pEntNil) ;
	lispMachineCode_SetLReg   (pLM, LM_LREG_3, pEntNil) ;
	lispMachineCode_SetState (pLM, lispMachineState_backquoteConscell) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_backquoteConscell (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntTarget ;
	TLispEntity*	pEntCar ;
	TLispEntity*	pEntNil ;
	TLispEntity*	pEntTail ;
	TLispEntity*	pEntCdr ;
	TLispEntity*	pEntCaar ;
	const Char*		pName ;
	int				nName ;
	int				nType ;

	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pEntTarget) ;
#if defined (DEBUG)
	fprintf (stderr, "backquoteConsell: target = ") ;
	lispEntity_Print (pLispMgr, pEntTarget) ;
	fprintf (stderr, "\n") ;
#endif
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntTarget, &pEntCar)) ||
		TFAILED (lispEntity_GetType (pLispMgr, pEntCar, &nType)))
		goto	error ;

	lispMgr_CreateNil  (pLispMgr, &pEntNil) ;
	switch (nType) {
	case	LISPENTITY_VECTOR:
		lispMachineCode_SetState (pLM, &lispMachineState_backquoteVectorStart) ;
		goto	cons_vect_common ;
	case	LISPENTITY_CONSCELL:
		lispEntity_GetCar (pLispMgr, pEntCar, &pEntCaar) ;
		if (TSUCCEEDED (lispEntity_GetSymbolName (pLispMgr, pEntCaar, &pName, &nName)) &&
			nName == 2 && *pName == ',' && *(pName + 1) == '@') {
			TLispEntity*	pEntCadr ;
			if (TFAILED (lispEntity_GetCadr (pLispMgr, pEntCar, &pEntCadr))) 
				goto	error ;
			lispMachineCode_Evaln (pLM, pEntCadr, &lispMachineState_backquoteConsPostCommaAt) ;
			return	LMR_CONTINUE ;
		} else {
			lispMachineCode_SetState (pLM, &lispMachineState_backquoteConscellStart) ;
		}
	  cons_vect_common:
		lispMachineCode_SetLReg   (pLM, LM_LREG_ACC, pEntCar) ;
		lispMachineCode_PushState (pLM, &lispMachineState_backquoteConsPostCons) ;
		return	LMR_CONTINUE ;

	case	LISPENTITY_SYMBOL:
		lispEntity_GetSymbolName (pLispMgr, pEntCar, &pName, &nName) ;
		if (nName == 1 && *pName == ',') {
			TLispEntity*	pEntCadr ;
			
			if (TFAILED (lispEntity_GetCadr (pLispMgr, pEntTarget, &pEntCadr))) 
				goto	error ;
			
			lispMachineCode_SetLReg (pLM, LM_LREG_1, pEntNil) ;
			lispMachineCode_Evaln (pLM, pEntCadr, &lispMachineState_backquoteConsPostComma) ;
			return	LMR_CONTINUE ;
		}
	default:
		if (TFAILED (lispMgr_CreateConscell  (pLispMgr, pEntCar, pEntNil, &pEntTail)))
			return	LMR_ERROR ;
		if (TFAILED (lispMachineCode_SetTail (pLM, LM_LREG_2, LM_LREG_3, pEntTail)))
			goto	error ;
		break ;
	}
	lispEntity_GetCdr (pLispMgr, pEntTarget, &pEntCdr) ;
	if (TFAILED (lispEntity_Consp (pLispMgr, pEntCdr))) {
		lispEntity_SetCdr (pLispMgr, pEntTail, pEntCdr) ;
		lispMachineCode_SetState (pLM, &lispMachineState_backquoteConscellEnd) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_1, pEntCdr) ;
	}
	return	LMR_CONTINUE ;

  error:
	lispMachineCode_SetError (pLM) ;
	lispMachineCode_SetState (pLM, &lispMachineState_backquoteConscellEnd) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_backquoteConsPostCons (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr = pLM->m_pLispMgr ;
	TLispEntity*	pEntResult ;
	TLispEntity*	pEntNil ;
	TLispEntity*	pEntNewTail ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntResult) ;
	lispMgr_CreateNil (pLispMgr, &pEntNil) ;
	if (TFAILED (lispMgr_CreateConscell  (pLispMgr, pEntResult, pEntNil, &pEntNewTail)))
		return	LMR_ERROR ;
	return	lispMachineState_backquoteConsPostCommon (pLM, pEntNewTail) ;
}

TLMRESULT
lispMachineState_backquoteConsPostCommaAt (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr = pLM->m_pLispMgr ;
	TLispEntity*	pEntResult ;
	TLispEntity*	pEntTarget ;
	TLispEntity*	pEntCar ;
	TLispEntity*	pEntCdr ;
	TLispEntity*	pEntNewTail ;
	TLispEntity*	pEntNil ;

	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) 
		return	LMR_RETURN ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntResult) ;
	lispMgr_CreateNil (pLispMgr, &pEntNil) ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pEntResult))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntResult, &pEntCar)))
			goto	error ;
		if (TFAILED (lispMgr_CreateConscell (pLispMgr, pEntCar, pEntNil, &pEntNewTail)))
			return	LMR_ERROR ;
		if (TFAILED (lispMachineCode_SetTail (pLM, LM_LREG_2, LM_LREG_3, pEntNewTail)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pEntResult, &pEntResult)))
			goto	error ;
	}
	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pEntTarget) ;
	lispEntity_GetCdr (pLispMgr, pEntTarget, &pEntCdr) ;
	if (TFAILED (lispEntity_Consp (pLispMgr, pEntCdr))) {
		lispMachineCode_SetState (pLM, &lispMachineState_backquoteConscellEnd) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_1, pEntCdr) ;
		lispMachineCode_SetState (pLM, &lispMachineState_backquoteConscell) ;
	}
	return	LMR_CONTINUE ;

  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_backquoteConsPostComma (
	register TLispMachine*	pLM)
{
	TLispEntity*	pEntResult ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntResult) ;
#if defined (DEBUG)
	fprintf (stderr, "comma result = ") ;
	lispEntity_Print (pLM->m_pLispMgr, pEntResult) ;
	fprintf (stderr, "\n") ;
#endif
	return	lispMachineState_backquoteConsPostCommon (pLM, pEntResult) ;
}

TLMRESULT
lispMachineState_backquoteConscellEnd (
	register TLispMachine*	pLM)
{
	lispMachineCode_MoveLReg (pLM, LM_LREG_ACC, LM_LREG_2) ;
	lispMachineCode_PopLReg  (pLM, LM_LREG_3) ;
	lispMachineCode_PopLReg  (pLM, LM_LREG_2) ;
	lispMachineCode_PopLReg  (pLM, LM_LREG_1) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_backquoteConsPostCommon (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntResult)
{
	register TLispManager*	pLispMgr = pLM->m_pLispMgr ;
	TLispEntity*	pEntTarget ;
	TLispEntity*	pEntCdr ;

	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) 
		return	LMR_RETURN ;

	if (TFAILED (lispMachineCode_SetTail (pLM, LM_LREG_2, LM_LREG_3, pEntResult))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pEntTarget) ;
	lispEntity_GetCdr (pLispMgr, pEntTarget, &pEntCdr) ;
	if (TFAILED (lispEntity_Consp (pLispMgr, pEntCdr))) {
		/*lispEntity_SetCdr (pLispMgr, pEntResult, pEntCdr) ;*/
		lispMachineCode_SetState (pLM, &lispMachineState_backquoteConscellEnd) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_1, pEntCdr) ;
		lispMachineCode_SetState (pLM, &lispMachineState_backquoteConscell) ;
	}
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_backquoteVectorStart (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntTarget ;
	TLispEntity*	pEntResult ;
	TLispEntity**	ppElement ;
	TLispEntity*	pEntNil ;
	int				nElement ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntTarget) ;
	if (TFAILED (lispEntity_GetVectorValue (pLispMgr, pEntTarget, &ppElement, &nElement))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMgr_CreateNil (pLispMgr, &pEntNil) ;
	if (TFAILED (lispMgr_CreateVectorFill (pLispMgr, pEntNil, nElement, &pEntResult)))
		return	LMR_ERROR ;

	lispMachineCode_PushLReg (pLM, LM_LREG_1) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PushVReg (pLM, LM_VREG_1) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_1, pEntResult) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_2, pEntTarget) ;
	lispMachineCode_SetVRegI (pLM, LM_VREG_1, 0) ;
	lispMachineCode_SetState (pLM, &lispMachineState_backquoteVector) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_backquoteVector (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntResult ;
	TLispEntity*	pEntTarget ;
	long			lCount ;
	TLispEntity**	ppSrcTop ;
	TLispEntity**	ppDestTop ;
	int				nSrc, nDest ;
	int				nType ;
	register TLispEntity**	ppSrc ;
	register TLispEntity**	ppDest ;
	register int			nRest ;

	lispMachineCode_GetLReg  (pLM, LM_LREG_1, &pEntResult) ;
	lispMachineCode_GetLReg  (pLM, LM_LREG_2, &pEntTarget) ;
	lispMachineCode_GetVRegI (pLM, LM_VREG_1, &lCount) ;
	lispEntity_GetVectorValue (pLispMgr, pEntTarget, &ppSrcTop,  &nSrc) ;
	lispEntity_GetVectorValue (pLispMgr, pEntResult, &ppDestTop, &nDest) ;
	nRest	= nSrc - lCount ;
	ppSrc	= ppSrcTop  + lCount ;
	ppDest	= ppDestTop + lCount ;
	while (nRest > 0) {
		lispEntity_GetType (pLispMgr, *ppSrc, &nType) ;
		switch (nType) {
		case	LISPENTITY_CONSCELL:
			lispMachineCode_SetState (pLM, &lispMachineState_backquoteConscellStart) ;
			goto	cons_vector_common ;

		case	LISPENTITY_VECTOR:
			lispMachineCode_SetState (pLM, &lispMachineState_backquoteVectorStart) ;
		  cons_vector_common:
			lispMachineCode_SetLReg   (pLM, LM_LREG_ACC, *ppSrc) ;
			lispMachineCode_PushState (pLM, &lispMachineState_backquoteVectPostVect) ;
			goto	next_step ;

		case	LISPENTITY_SYMBOL:
		{
			const Char*		pName ;
			int				nName ;

			lispEntity_GetSymbolName (pLispMgr, *ppSrc, &pName, &nName) ;
			if (nName == 1 && *pName == ',') {
				/*	ξ vector ̤ɬפ롣*/
				lispEntity_ShrinkVector (pLispMgr, pEntResult, 1) ;
				if (nRest <= 1) 
					goto	exit_loop ;
				ppSrc	++ ;
				lispMachineCode_SetVRegI (pLM, LM_VREG_1, nSrc - nRest) ;
				lispMachineCode_Evaln (pLM, *ppSrc, &lispMachineState_backquoteVectPostComma) ;
				return	LMR_CONTINUE ;
			}
		}
		default:
			break ;
		}
		*ppDest ++	= *ppSrc ++ ;
		nRest	-- ;
	}
  exit_loop:
	lispMachineCode_SetState (pLM, &lispMachineState_backquoteVectorEnd) ;
	return	LMR_CONTINUE ;

  next_step:
	lispMachineCode_SetVRegI (pLM, LM_VREG_1, nSrc - nRest) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_backquoteVectPostVect (
	register TLispMachine*	pLM)
{
	TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntNewElement ;
	TLispEntity*	pEntResult ;
	long			lCount ;

	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) 
		return	lispMachineState_backquoteVectorEnd (pLM) ;

	lispMachineCode_GetLReg  (pLM, LM_LREG_ACC, &pEntNewElement) ;
	lispMachineCode_GetLReg  (pLM, LM_LREG_1, &pEntResult) ;
	lispMachineCode_GetVRegI (pLM, LM_VREG_1, &lCount) ;
	lispEntity_SetVectorElement (pLispMgr, pEntResult, lCount, pEntNewElement) ;
	lCount	++ ;
	lispMachineCode_SetVRegI (pLM, LM_VREG_1, lCount) ;
	lispMachineCode_SetState (pLM, &lispMachineState_backquoteVector) ;
	return	LMR_CONTINUE ;

}

TLMRESULT
lispMachineState_backquoteVectPostComma (
	register TLispMachine* pLM)
{
	TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntResult ;
	TLispEntity*	pEntNewElement ;
	long			lCount ;

	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) 
		goto	exit ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntResult) ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntResult, &pEntNewElement))) {
		lispMachineCode_SetError (pLM) ;
		goto	exit ;
	}
	lispMachineCode_GetVRegI (pLM, LM_VREG_1, &lCount) ;
	lispEntity_SetVectorElement (pLispMgr, pEntResult, lCount, pEntNewElement) ;
  exit:
	return	lispMachineState_backquoteVectorEnd (pLM) ;
}

TLMRESULT
lispMachineState_backquoteVectorEnd (
	register TLispMachine*	pLM)
{
	lispMachineCode_MoveLReg (pLM, LM_LREG_ACC, LM_LREG_1) ;
	lispMachineCode_PopVReg  (pLM, LM_VREG_1) ;
	lispMachineCode_PopLReg  (pLM, LM_LREG_2) ;
	lispMachineCode_PopLReg  (pLM, LM_LREG_1) ;
	return	LMR_RETURN ;
}

/*
 *	lispMachineState_EvalMacro κǽȤƸƤӽФ롣AREG 
 *	Macro Ÿ̤äƤȦʤΤǡ¹Ԥ˰ܤ
 */
TLMRESULT
lispMachineState_evalMacroFinalize (
	register TLispMachine*	pLM)
{
	TLispEntity*	pEntResult ;

	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) 
		return	LMR_RETURN ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntResult) ;
#if defined (DEBUG)
	fprintf (stderr, "eval-macro: result = ") ;
	lispEntity_Print (pLM->m_pLispMgr, pEntResult) ;
	fprintf (stderr, "\n") ;
#endif
	lispMachineCode_Evaln (pLM, pEntResult, &lispMachineState_ReturnOnly) ;
	return	LMR_CONTINUE ;
}


