/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

/*
 *	(string-to-char-list STRING)
 *
 *	`poem-e20 3' ˤؿ餷
 *	STRING ʸǤȤꥹȤ֤STRING  sequence Ǥ롣
 */
TLMRESULT
lispMachineState_StringToCharList (
	register TLispMachine*	pLM)
{
	TLispEntity*	pSequence ;
	TLispEntity*	pRetval ;
	TLispEntity*	pArglist ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	lispEntity_GetCar (pLM->m_pLispMgr, pArglist, &pSequence) ;
	if (TFAILED (lispMgr_StringToCharList (pLM->m_pLispMgr, pSequence, &pRetval))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pRetval) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_EventToCharacter (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntEvent ;
	long			lValue ;
	TLispEntity*	pEntRetval ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntEvent)) ||
		TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntEvent, &lValue))) {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	} else {
		if (TFAILED (lispMgr_CreateInteger (pLispMgr, lValue, &pEntRetval)))
			return	LMR_ERROR ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_CharacterToEvent (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntEvent ;

	/*	ࡢפĤʤΤǡΤޤޡܵ XEvent ᤷƤ⤤...*/
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntEvent))) {
		lispMachineCode_SetError (pLM) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntEvent) ;
	}
	return	LMR_RETURN ;
}

