/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

/*
 *	Function:	symbolp OBJECT
 *
 *	⤷֥Ȥܥʤ t ֤ʤ
 *	 nil ֤
 */
TLMRESULT
lispMachineState_Symbolp (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pObject ;
	TLispEntity*	pRetval ;

	assert (pLM       != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr  != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pObject))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TSUCCEEDED (lispEntity_Symbolp (pLispMgr, pObject))) {
		lispMgr_CreateT   (pLispMgr, &pRetval) ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pRetval) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pRetval) ;
	return	LMR_RETURN ;
}

/*
 *	Function:	symbol-name SYMBOL
 *
 *	SYMBOL ̾Υȥ󥰤֤SYMBOL ̾
 *	֤ƤϢưʤʤäƤ롣ȤԤ
 *	륳ɤưʤ
 */
TLMRESULT
lispMachineState_SymbolName (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntSymbol ;
	TLispEntity*	pEntReturn ;
	const Char*		pSymName ;
	int				nSymName ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntSymbol)) ||
		TFAILED (lispEntity_Symbolp (pLispMgr, pEntSymbol))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispEntity_GetSymbolName (pLispMgr, pEntSymbol, &pSymName, &nSymName) ;
	if (TFAILED (lispMgr_CreateString (pLispMgr, pSymName, nSymName, &pEntReturn)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntReturn) ;
	return	LMR_RETURN ;
}

/*
 *	Function:	make-symbol NAME
 *
 *	̾ NAME Ǥ롢intern Ƥʤܥ򿷤
 *	֤
 */
TLMRESULT
lispMachineState_MakeSymbol (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntName ;
	const Char*		pName ;
	int				nName ;
	TLispEntity*	pEntReturn ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntName)) ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pEntName, &pName, &nName))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMgr_CreateSymbol (pLispMgr, pName, nName, &pEntReturn)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntReturn) ;
	return	LMR_RETURN ;
}

/*
 *	Function:	intern NAME &optional OBARRAY
 *
 *	δؿϡ̾ NAME Ǥ륷ܥ֤OBARRAY Ϳ
 *	줿硢Ѥ OBARRAY ꤹ롣
 *
 *	ȤϤ OBARRAY ̤Ѱդˡפʤ
 *	ǵѲ롣
 */
TLMRESULT
lispMachineState_Intern (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntName ;
	TLispEntity*	pEntObarray ;
	const Char*		pName ;
	int				nName ;
	TLispEntity*	pEntReturn ;
	
	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntName)) ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pEntName, &pName, &nName)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntObarray)) ||
		TFAILED (lispEntity_Nullp   (pLispMgr, pEntObarray))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMgr_InternSymbol (pLispMgr, pName, nName, &pEntReturn)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntReturn) ;
	return	LMR_RETURN ;
}

/*
 *	Function:	intern-soft NAME &optional OBARRAY
 */
TLMRESULT
lispMachineState_InternSoft (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntName ;
	TLispEntity*	pEntObarray ;
	const Char*		pName ;
	int				nName ;
	TLispEntity*	pEntReturn ;
	
	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntName)) ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pEntName, &pName, &nName)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntObarray)) ||
		TFAILED (lispEntity_Nullp   (pLispMgr, pEntObarray))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMgr_SearchSymbol (pLispMgr, pName, nName, &pEntReturn)) ||
		pEntReturn == NULL) 
		lispMgr_CreateNil (pLispMgr, &pEntReturn) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntReturn) ;
	return	LMR_RETURN ;
}

/*
 *	Function:	unintern NAME &optional OBARRAY
 *
 *	 optional  OBARRAY ѤǤʤOBARRAY  NAME 
 *	̾Υܥ롣⤷դС t 
 *	դʤ nil ֤NAME ϥȥ󥰤ޤϥܥ
 *	Ǥ롣
 */
TLMRESULT
lispMachineState_Unintern (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntName ;
	TLispEntity*	pEntObarray ;
	const Char*		pName ;
	int				nName ;
	TLispEntity*	pEntTarget ;
	TLispEntity*	pEntReturn ;
	
	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntName)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntObarray)) ||
		TFAILED (lispEntity_Nullp   (pLispMgr, pEntObarray))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_GetSymbolName  (pLispMgr, pEntName, &pName, &nName)) ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pEntName, &pName, &nName))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMgr_SearchSymbol (pLispMgr, pName, nName, &pEntTarget)) ||
		pEntTarget == NULL) {
		lispMgr_CreateNil (pLispMgr, &pEntReturn) ;
	} else {
		if (TFAILED (lispMgr_UnregisterSymbol (pLispMgr, pEntTarget))) 
			return	LMR_ERROR ;
		lispMgr_CreateT   (pLispMgr, &pEntReturn) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntReturn) ;
	return	LMR_RETURN ;
}

/*
 *	Function:	symbol-plist SYMBOL
 *
 *	SYMBOL ΥץѥƥꥹȤ֤ؿǤ롣
 */
TLMRESULT
lispMachineState_SymbolPlist (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntSymbol ;
	TLispEntity*	pEntValue ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntSymbol)) ||
		TFAILED (lispEntity_Symbolp (pLispMgr, pEntSymbol))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMachine_GetSymbolProperty (pLM, pEntSymbol, &pEntValue))) 
		lispMgr_CreateNil (pLispMgr, &pEntValue) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntValue) ;
	return	LMR_RETURN ;
}

/*
 *	Function:	setplist SYMBOL PLIST
 *
 *	SYMBOL ΥץѥƥꥹȤ PLIST ꤹ롣PLIST 
 *	well-formed ʥץѥƥꥹȤǤ٤Ǥ뤬
 *	
 *
 *	(setplist 'foo '(a 1 b (2 3) c nil)
 *		=> (a 1 b (2 3) c nil)
 *	(symbol-plist 'foo)
 *		=> (a 1 b (2 3) c nil)
 */
TLMRESULT
lispMachineState_Setplist (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntSymbol ;
	TLispEntity*	pEntPlist ;
	
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntSymbol)) ||
		TFAILED (lispEntity_Symbolp (pLispMgr, pEntSymbol)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntPlist)) ||
		TFAILED (lispMachine_SetSymbolProperty (pLM, pEntSymbol, pEntPlist))) {
		lispMachineCode_SetError (pLM) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntPlist) ;
	}
	return	LMR_RETURN ;
}

/*
 *	Function: get SYMBOL PROPERTY
 */
TLMRESULT
lispMachineState_Get (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntSymbol ;
	TLispEntity*	pEntProperty ;
	TLispEntity*	pEntPlist ;
	TLispEntity*	pEntRetval ;
	
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntSymbol)) ||
		TFAILED (lispEntity_Symbolp (pLispMgr, pEntSymbol)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntProperty))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TSUCCEEDED (lispMachine_GetSymbolProperty (pLM, pEntSymbol, &pEntPlist))) {
		if (TFAILED (lispEntity_PlistGet (pLispMgr, pEntPlist, pEntProperty, &pEntRetval))) 
			goto	error ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

/*
 *	Function:	put SYMBOL PROPERTY VALUE
 *
 *	ץѥƥ̾ PROPERTY ǤȤ SYMBOL ΥץѥƥꥹȤ
 *	 VALUE  PUT 롣
 */
TLMRESULT
lispMachineState_Put (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntSymbol ;
	TLispEntity*	pEntPrevPlist ;
	TLispEntity*	pEntNewPlist ;
	TLispEntity*	pEntProperty ;
	TLispEntity*	pEntValue ;
	
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntSymbol)) ||
		TFAILED (lispEntity_Symbolp (pLispMgr, pEntSymbol)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntProperty)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntValue))) 
		goto	error ;

	if (TFAILED (lispMachine_GetSymbolProperty (pLM, pEntSymbol, &pEntPrevPlist)) ||
		TFAILED (lispEntity_PlistPut (pLispMgr, pEntPrevPlist, pEntProperty, pEntValue, &pEntNewPlist))) {
		TLispEntity*	apEntities [2] ;
		apEntities [0]	= pEntProperty ;
		apEntities [1]	= pEntValue ;
		if (TFAILED (lispMgr_CreateList (pLispMgr, apEntities, 2, &pEntNewPlist)))
			return	LMR_ERROR ;
	}
	if (TFAILED (lispMachine_SetSymbolProperty (pLM, pEntSymbol, pEntNewPlist))) 
		goto	error ;
		
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntValue) ;
	return	LMR_RETURN ;
	
  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_PlistGet (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntPlist ;
	TLispEntity*	pEntProperty ;
	TLispEntity*	pEntRetval ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntPlist)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntProperty))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_PlistGet (pLispMgr, pEntPlist, pEntProperty, &pEntRetval))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_PlistPut (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntPlist ;
	TLispEntity*	pEntProperty ;
	TLispEntity*	pEntValue ;
	TLispEntity*	pEntRetval ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntPlist)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntProperty)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntValue))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_PlistPut (pLispMgr, pEntPlist, pEntProperty, pEntValue, &pEntRetval))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

