/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (bufstringp_h)
#define	bufstringp_h

#include "bufstring.h"

struct tagBufStringLeaf ;
struct tagBufStringNode ;

#define	SIZE_TBUFBASESTRING	(224)

/*	ڤˤƥХ󥹤Ȥ褦ˤƤ롣Τޤޥĥ꡼
 *	ꥹȤѤʤ¤ˤʤǽ⤤Τǡ
 */
typedef enum {
	TBUFSTRINGNODECOLOR_RED,
	TBUFSTRINGNODECOLOR_BLACK,
}	TBufStringNodeColor ;

typedef struct tagBufStringLeaf {
	Char		m_achText [SIZE_TBUFBASESTRING] ;
	int			m_nLength ;
	struct tagBufStringLeaf*	m_pPrev ;
	struct tagBufStringLeaf*	m_pNext ;
	struct tagBufStringNode*	m_pParent ;
}	TBufStringLeaf ;

typedef struct tagBufStringLink {
	Boolean					m_fLeaf ;
	union {
		struct tagBufStringNode*	m_pNode ;
		struct tagBufStringLeaf*	m_pLeaf ;
	}	u ;
}	TBufStringLink ;

typedef struct tagBufStringNode {
	unsigned int				m_nLength ;
	TBufStringLink				Left ;
	TBufStringLink				Right ;
	struct tagBufStringNode*	m_pParent ;
	TBufStringNodeColor			m_nColor ;
}	TBufStringNode ;

#endif

