/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if defined (WIN32)
#include "local.h"
#include <assert.h>
#include "kstring.h"
#include "unicodemap.h"

int
dwcstowcs (LPWSTR pwDest, int nDestSize, const Char* pSrc, int nSrcSize)
{
	int	nBackup ;

	assert (pwDest != NULL || nDestSize <= 0) ;
	assert (pSrc   != NULL || nSrcSize  <= 0) ;
	
	nBackup	= nDestSize ;
	while (nDestSize > 0 && nSrcSize > 0) {
		*pwDest		++	= Char_ToUnicode (*pSrc ++) ;
		nDestSize	-- ;
		nSrcSize	-- ;
	}
	return	(nBackup - nDestSize) ;
}

int
wcstodwcs (Char* pDest, int nDestSize, LPCWSTR pwSrc, int nSrcSize)
{
	return	0 ;
}

#endif

