/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include "TTerminalP.h"
#include "dtext.h"

#if !defined (DEFAULT_FONTSET)
#define	DEFAULT_FONTSET	"-*--12-*"
#endif

#define	TTERM_NCHAR_PER_MALLOC	(16)

#define offset(field)	XtOffsetOf(TTerminalRec, tterminal.field)
#define goffset(field)	XtOffsetOf(WidgetRec, core.field )

static	XtResource	srTTerminalResource []	= {
	{	XtNwidth,		XtCWidth,		XtRDimension,	sizeof (Dimension),
		goffset (width),			XtRImmediate,	(XtPointer) 640, },
	{	XtNheight,		XtCHeight,		XtRDimension,	sizeof (Dimension),
		goffset (height),			XtRImmediate,	(XtPointer) 48, },
	{	XtNbackground,	XtCBackground,	XtRPixel,		sizeof (Pixel),
		goffset (background_pixel),	XtRString,		XtDefaultBackground, },
	{	XtNparentWindow,	XtCParentWindow,	XtRWindow,	sizeof (Window),
		offset (m_wndParent),		XtRImmediate,	(XtPointer) None, },
	{	XtNreverseVideo,	XtCReverseVideo,	XtRBoolean,	sizeof (Boolean),
		offset (m_fReverseVideo),	XtRImmediate,	(XtPointer) False, },
	{	XtNforeground,	XtCForeground,	XtRPixel,		sizeof (Pixel),
		offset (m_pxlFore),			XtRString,		XtDefaultForeground, },
	{	XtNfontSet,		XtCFontSet,		XtRString,		sizeof (String),
		offset (m_strFontSet),		XtRString,		DEFAULT_FONTSET, },
} ;

#undef	offset
#undef	goffset

static	void	tterminal_onInitialize	(Widget, Widget, ArgList, Cardinal*) ;
static	void	tterminal_onRealize		(Widget, XtValueMask*, XSetWindowAttributes*) ;
static	void	tterminal_onExpose		(Widget, XEvent*, Region) ;
static	Boolean	tterminal_onSetValues	(Widget, Widget, Widget, ArgList, Cardinal*) ;
static	void	tterminal_onDestroy		(Widget) ;

static	Boolean	tterminal_putcharControl	(Widget, Char) ;
static	Boolean	tterminal_putcharPrintable	(Widget, Char) ;


/* Хѿ
 */
static XtActionsRec		srTTerminalAction [] = {
} ;

static char				sstrTTerminalTranslation [] = "" ;


TTerminalClassRec		tterminalClassRec	= {
    {	/* core fields */
		/* superclass			*/	&widgetClassRec,
		/* class_name			*/	"TTerminal",
		/* size					*/	sizeof (TTerminalRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	tterminal_onInitialize,
		/* initialize_hook		*/	NULL,
		/* realize				*/	tterminal_onRealize,
		/* actions				*/	srTTerminalAction,
		/* num_actions			*/	XtNumber (srTTerminalAction),
		/* resources			*/	srTTerminalResource,
		/* num_resources		*/	XtNumber(srTTerminalResource),
		/* xrm_class			*/	NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy				*/	tterminal_onDestroy,
		/* resize				*/	XtInheritResize,
		/* expose				*/	tterminal_onExpose,
		/* set_values			*/	tterminal_onSetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback_private		*/	NULL,
		/* tm_table				*/	sstrTTerminalTranslation,
		/* query_geometry		*/	XtInheritQueryGeometry,
    },
} ;

WidgetClass	tterminalWidgetClass	= (WidgetClass) &tterminalClassRec ;

void
tterminal_onInitialize (
	Widget		wgRequest,
	Widget		wgNew,
	ArgList		args,
	Cardinal*	num_args)
{
	register TTerminalWidget	w 	= (TTerminalWidget) wgNew ;
	TTermLineInfo				tli ;

	TVarbuffer_Initialize (&w->tterminal.m_vbCurText, sizeof (DChar)) ;
	TVarbuffer_Initialize (&w->tterminal.m_vbReqText, sizeof (DChar)) ;
	TVarbuffer_Initialize (&w->tterminal.m_vbCurLineInfo, sizeof (TTermLineInfo)) ;
	TVarbuffer_Initialize (&w->tterminal.m_vbReqLineInfo, sizeof (TTermLineInfo)) ;

	w->tterminal.m_iRow		= 0 ;
	w->tterminal.m_iColumn	= 0 ;
	w->tterminal.m_fRev		= False ;	/*  reverse video  terminal ȤƤΡ*/

	tli.m_nIndex	= 0 ;
	tli.m_nLength	= 0 ;
	tli.m_nSize		= 0 ;
	tli.m_nPrev		= -1 ;
	tli.m_nNext		= -1 ;
	TVarbuffer_Add (&w->tterminal.m_vbReqLineInfo, &tli, 1) ;
	TVarbuffer_Add (&w->tterminal.m_vbCurLineInfo, &tli, 1) ;
	w->tterminal.m_nReqTailLineIndex	= 0 ;

	/*	եȤν onSetValues ƤФ뤳Ȥ
	 *	̿Ū
	 */
	TFontSet_Initialize (&w->tterminal.m_FontSet) ;
	return ;
}

void
tterminal_onRealize (
	register Widget					wgThis,
	register XtValueMask*			pValueMask,
	register XSetWindowAttributes*	pXSWA)
{
	register TTerminalWidget	wgTerm		= (TTerminalWidget) wgThis ;
	register Display*			pDisplay	= XtDisplay (wgThis) ;
	XGCValues	gcvalue ;
	
	if (wgTerm->tterminal.m_wndParent != None) {
		register Widget				wgParent ;
		register Window				wndRoot ;
		XWindowAttributes	xwa ;

		XGetWindowAttributes (XtDisplay (wgThis), wgTerm->tterminal.m_wndParent, &xwa) ;
		wgParent	= wgThis->core.parent ;
		wndRoot		= wgThis->core.screen->root ;
		wgThis->core.depth			= xwa.depth ;
		wgThis->core.parent			= NULL ;
		wgThis->core.screen->root	= wgTerm->tterminal.m_wndParent ;
		XtCreateWindow (wgThis, (unsigned int)InputOutput, (Visual *)CopyFromParent, *pValueMask, pXSWA) ;
		wgThis->core.parent			= wgParent ;
		wgThis->core.screen->root	= wndRoot ;
	} else {
		XtCreateWindow (wgThis, (unsigned int)InputOutput, (Visual *)CopyFromParent, *pValueMask, pXSWA) ;
	}
#if 0
	gcvalue.foreground	= wgTerm->tterminal.m_pxlFore ;
	gcvalue.background	= wgTerm->core.background_pixel ;
	wgTerm->tterminal.m_gc	= XtGetGC ((Widget) wgThis, GCForeground | GCBackground, &gcvalue) ;
#else
	gcvalue.foreground	= BlackPixel (pDisplay, 0) ;
	gcvalue.background	= WhitePixel (pDisplay, 0) ;
	wgTerm->tterminal.m_gc	= XCreateGC (pDisplay, XtWindow (wgThis), GCForeground | GCBackground, &gcvalue) ;
#endif
	TFontSet_Load (pDisplay, &wgTerm->tterminal.m_FontSet, wgTerm->tterminal.m_strFontSet, False) ;
	return ;
}

void
tterminal_onExpose (
	register Widget		wgThis,
	register XEvent*	pEvent,
	register Region		region)
{
	register	TTerminalWidget	w	= (TTerminalWidget) wgThis ;
	register	Display*		pDisplay ;
	register	Window			wnd ;
	register	GC				gc ;
	register	TFontSet*		pFontSet ;
	register	DChar*			pCurTextTop ;
	register	TTermLineInfo*	pCurLineInfoTop ;
	register	TTermLineInfo*	pCurLineInfo ;
	register	int				nCurLineInfo ;
	register	int				nPoint, y, nHeight ;

	pDisplay		= XtDisplay (wgThis) ;
	wnd				= XtWindow  (wgThis) ;
	gc				= w->tterminal.m_gc ;
	pFontSet		= TTerminal_GetFontSet (wgThis) ;

	pCurLineInfoTop	= TVarbuffer_GetBuffer (&w->tterminal.m_vbCurLineInfo) ;
	nCurLineInfo	= TVarbuffer_GetUsage  (&w->tterminal.m_vbCurLineInfo) ;
	pCurTextTop		= TVarbuffer_GetBuffer (&w->tterminal.m_vbCurText) ;
	nPoint			= 0 ;
	y				= TFontSet_GetAscent (pFontSet) ;
	nHeight			= TFontSet_GetHeight (pFontSet) ;

	while (nCurLineInfo > 0) {
		pCurLineInfo	= pCurLineInfoTop + nPoint ;
		if (pCurLineInfo->m_nLength > 0)
			TDTextOut (pDisplay, wnd, gc, pFontSet, 0, y, pCurTextTop + pCurLineInfo->m_nIndex, pCurLineInfo->m_nLength, NULL) ;
		nPoint			= pCurLineInfo->m_nNext ;
		y				+= nHeight ;
		nCurLineInfo	-- ;
	}
	return ;
}

Boolean
tterminal_onSetValues (
	register Widget		curw,
	register Widget		reqw,
	register Widget		neww,
	register ArgList	args,
	register Cardinal*	num_args)
{
	register TTerminalWidget	curtw	= (TTerminalWidget) curw ;
	register TTerminalWidget	reqtw	= (TTerminalWidget) reqw ;
	register TTerminalWidget	newtw	= (TTerminalWidget) neww ;
	register Boolean		fRetval	= False ;
	
	/*	FontSet ޤ뤴ȤؤؼäΥå
	 *	̤ѹ SetValues ǤϹԤʤ̤ Method Ѥ롣
	 */
	if (curtw->tterminal.m_strFontSet != reqtw->tterminal.m_strFontSet &&
		strcmp (curtw->tterminal.m_strFontSet, reqtw->tterminal.m_strFontSet) == 0) {
		newtw->tterminal.m_strFontSet	= reqtw->tterminal.m_strFontSet ;
		/*	߻ȤäƤեȥåȤơեȥåȤ
		 *	ɤ߹ࡣ*/
		if (XtIsRealized (neww)) {
			TFontSet_Load (XtDisplay (neww), &newtw->tterminal.m_FontSet, newtw->tterminal.m_strFontSet, False) ;
			fRetval	= True ;
		}
	}
	return	fRetval ;
}

void
tterminal_onDestroy (
	register Widget		gw)
{
	register TTerminalWidget	wgThis	= (TTerminalWidget) gw ;

	if (wgThis->tterminal.m_gc != None) {
		XtReleaseGC (gw, wgThis->tterminal.m_gc) ;
		wgThis->tterminal.m_gc	= None ;
	}
	TFontSet_Destroy (&wgThis->tterminal.m_FontSet) ;
	return ;
}

Boolean
TTerminal_Putchar (
	register Widget		wgThis,
	register Char		cc)
{
	if (XtClass (wgThis) != tterminalWidgetClass)
		return	False ;

#if defined (DEBUG)
	if (cc != 10)
		fprintf (stderr, "TTerminal_Putchar (%p, %ld)\n", wgThis, cc) ;
#endif
	if (cc < 0x20) {
		return	tterminal_putcharControl (wgThis, cc) ;
	} else {
		return	tterminal_putcharPrintable (wgThis, cc) ;
	}
}

TFontSet*
TTerminal_GetFontSet (
	register Widget		wgThis)
{
	register TTerminalWidget	wgTerm ;

	if (XtClass (wgThis) != tterminalWidgetClass)
		return	NULL ;

	wgTerm			= (TTerminalWidget) wgThis ;
	return	&wgTerm->tterminal.m_FontSet ;
}

Boolean
TTerminal_Clear (
	register Widget		wgThis)
{
	register TTerminalWidget	wgTerm ;
	TTermLineInfo	tli ;

	if (XtClass (wgThis) != tterminalWidgetClass)
		return	False ;

	wgTerm			= (TTerminalWidget) wgThis ;

	TVarbuffer_Clear (&wgTerm->tterminal.m_vbReqText) ;
	TVarbuffer_Clear (&wgTerm->tterminal.m_vbReqLineInfo) ;
	tli.m_nIndex	= 0 ;
	tli.m_nLength	= 0 ;
	tli.m_nSize		= TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbReqText) ;
	tli.m_nPrev		= -1 ;
	tli.m_nNext		= -1 ;
	TVarbuffer_Add (&wgTerm->tterminal.m_vbReqLineInfo, &tli, 1) ;
	wgTerm->tterminal.m_nReqTailLineIndex	= 0 ;

	/*
	 *	򺸾˰ư롣
	 */
	wgTerm->tterminal.m_iRow		= 0 ;
	wgTerm->tterminal.m_iColumn	= 0 ;
	return	True ;
}


Boolean
TTerminal_Rev (
	register Widget		wgThis,
	register Boolean	fRev)
{
	if (XtClass (wgThis) != tterminalWidgetClass)
		return	False ;

	((TTerminalWidget) wgThis)->tterminal.m_fRev	= fRev ;
	return	True ;
}

Boolean
TTerminal_MoveCursor (
	register Widget		wgThis,
	register int		nRow,
	register int		nColumn)
{
	register TTerminalWidget	wgTerm ;
	register TTermLineInfo*	pLineInfo ;
	register int			nMaxRow ;

	if (XtClass (wgThis) != tterminalWidgetClass)
		return	False ;

	wgTerm	= (TTerminalWidget) wgThis ;

	/*
	 *	Row ¦ɬ¸ߤʤȤʤ
	 */
	nMaxRow	= TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbReqLineInfo) ;
	assert (nMaxRow > 0) ;
	if (nRow >= nMaxRow) 
		nRow	= nMaxRow - 1 ;
	if (nRow < 0)
		nRow	= 0 ;

	pLineInfo	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqLineInfo) ;
	pLineInfo	+= nRow ;
	if (nColumn > pLineInfo->m_nLength)
		nColumn	= pLineInfo->m_nLength ;
	if (nColumn < 0)
		nColumn	= 0 ;

	wgTerm->tterminal.m_iRow		= nRow ;
	wgTerm->tterminal.m_iColumn	= nColumn ;
	return	True ;
}

Boolean
TTerminal_Flush (
	register Widget		wgThis)
{
	register TTerminalWidget	wgTerm ;
	register DChar*			pReq ;
	register DChar*			pCur ;
	register int			nReq ;
	register int			nCur ;

	if (XtClass (wgThis) != tterminalWidgetClass)
		return	False ;

	wgTerm	= (TTerminalWidget) wgThis ;
	pReq	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqText) ;
	nReq	= TVarbuffer_GetUsage  (&wgTerm->tterminal.m_vbReqText) ;
	nCur	= TVarbuffer_GetUsage  (&wgTerm->tterminal.m_vbCurText) ;
	if (nReq != nCur) 
		TVarbuffer_Require (&wgTerm->tterminal.m_vbCurText, nReq - nCur) ;
	pCur	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbCurText) ;
	memcpy (pCur, pReq, nReq * sizeof (DChar)) ;
	return	True ;
}

Boolean
TTerminal_Update (
	register Widget		wgThis)
{
	register	TTerminalWidget	wgTerm ;
	register	Display*		pDisplay ;
	register	Window			wnd ;
	register	GC				gc ;
	register	TFontSet*		pFontSet ;
	register	DChar*			pCurTextTop ;
	register	TTermLineInfo*	pCurLineInfoTop ;
	register	TTermLineInfo*	pCurLineInfo ;
	register	int				nCurLineInfo ;
	register	int				nCurPoint ;
	register	DChar*			pReqTextTop ;
	register	TTermLineInfo*	pReqLineInfoTop ;
	register	TTermLineInfo*	pReqLineInfo ;
	register	int				nReqPoint ;
	register	Boolean			fRedraw ;
	register	int				nReqLineInfo ;
	register	int				nReqLine ;
	register	int				nReqChar ;
	register	int				y, nAscent, nHeight ;
	TSize						szWnd ;

	wgTerm			= (TTerminalWidget) wgThis ;
	pDisplay		= XtDisplay (wgThis) ;
	wnd				= XtWindow  (wgThis) ;
	gc				= wgTerm->tterminal.m_gc ;
	pFontSet		= TTerminal_GetFontSet (wgThis) ;
	szWnd.cx		= wgThis->core.width ;
	szWnd.cy		= wgThis->core.height ;

	pReqLineInfoTop	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqLineInfo) ;
	nReqLine		= TVarbuffer_GetUsage  (&wgTerm->tterminal.m_vbReqLineInfo) ;
	nReqLineInfo	= nReqLine ;
	pReqTextTop		= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqText) ;
	nReqChar 		= TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbReqText) ;
	nReqPoint		= 0 ;
	pCurLineInfoTop	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbCurLineInfo) ;
	nCurLineInfo	= TVarbuffer_GetUsage  (&wgTerm->tterminal.m_vbCurLineInfo) ;
	pCurTextTop		= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbCurText) ;
	nCurPoint		= 0 ;
	nAscent			= TFontSet_GetAscent (pFontSet) ;
	nHeight			= TFontSet_GetHeight (pFontSet) ;
	y				= nAscent ;
	while (nReqLineInfo > 0) {
		pReqLineInfo	= pReqLineInfoTop + nReqPoint ;
		if (nCurLineInfo > 0) {
			pCurLineInfo	= pCurLineInfoTop + nCurPoint ;
			if (pCurLineInfo->m_nLength != pReqLineInfo->m_nLength) {
				fRedraw	= True ;
			} else if (memcmp (pCurTextTop + pCurLineInfo->m_nIndex,
							   pReqTextTop + pReqLineInfo->m_nIndex,
							   pCurLineInfo->m_nLength * sizeof (DChar))) {
				fRedraw	=	True ;
			} else {
				fRedraw	=	False ;
			}
			nCurPoint		= pCurLineInfo->m_nNext ;
			nCurLineInfo	-- ;
		} else {
			fRedraw	= True ;
		}
		if (fRedraw) {
			TSize	sz ;
			if (pReqLineInfo->m_nLength > 0) {
				TDTextOut (pDisplay, wnd, gc, pFontSet, 0, y, pReqTextTop + pReqLineInfo->m_nIndex, pReqLineInfo->m_nLength, &sz) ;
			} else {
				sz.cx	= 0 ;
			}
			XClearArea (pDisplay, wnd, sz.cx, y - nAscent, szWnd.cx - sz.cx, nHeight, False) ;
		}
		nReqPoint		= pReqLineInfo->m_nNext ;
		y				+= nHeight ;
		nReqLineInfo	-- ;
	}
	if (nCurLineInfo > 0) {
		XClearArea (pDisplay, wnd, 0, y - nAscent, szWnd.cx, nHeight * nCurLineInfo, False) ;
	}
	{
		register	int	nCharDiff ;
		register	int	nLineDiff ;
		nCharDiff	= nReqChar - TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbCurText) ;
		nLineDiff	= nReqLine - TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbCurLineInfo) ;
		if (TFAILED (TVarbuffer_Require (&wgTerm->tterminal.m_vbCurText,     nCharDiff)) ||
			TFAILED (TVarbuffer_Require (&wgTerm->tterminal.m_vbCurLineInfo, nLineDiff)))
			return	False ;
	}
	
	pReqLineInfoTop	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqLineInfo) ;
	pCurLineInfoTop	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbCurLineInfo) ;
	memcpy (pCurLineInfoTop, pReqLineInfoTop, sizeof (TTermLineInfo) * nReqLine) ;
	pReqTextTop		= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqText) ;
	pCurTextTop		= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbCurText) ;
	memcpy (pCurTextTop, pReqTextTop, sizeof (DChar) * nReqChar) ;
	return	True ;
}

/*========================================================================*
 *	ؿ
 *========================================================================*/
Boolean
tterminal_putcharControl (
	register Widget		wgThis,
	register Char		cc)
{
	register TTerminalWidget	wgTerm	= (TTerminalWidget) wgThis ;
	register TFontSet*		pFontSet ;
	TSize					sz ;
	register int			nHeight ;

	switch (cc) {
	case	'\n':
		pFontSet					= TTerminal_GetFontSet (wgThis) ;
		nHeight						= TFontSet_GetHeight (pFontSet) ;
		wgTerm->tterminal.m_iColumn	= 0 ;
		/*	뤬̳˽Фʤ褦ա*/
		sz.cx						= wgThis->core.width ;
		sz.cy						= wgThis->core.height ;
		if ((wgTerm->tterminal.m_iRow + 1) * nHeight < sz.cy)
			wgTerm->tterminal.m_iRow		++ ;
		assert (0 <= wgTerm->tterminal.m_iRow) ;
		assert (wgTerm->tterminal.m_iRow <= TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbReqLineInfo)) ;
		/*	˥饤ɲäʤФʤʤ */
		if (wgTerm->tterminal.m_iRow == TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbReqLineInfo)) {
			TTermLineInfo*	pPrevLineInfo ;
			TTermLineInfo	tli ;

			tli.m_nIndex	= TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbReqText) ;
			tli.m_nLength	= 0 ;
			tli.m_nSize		= 0 ;
			tli.m_nPrev		= wgTerm->tterminal.m_nReqTailLineIndex ;
			tli.m_nNext		= -1 ;
			if (TFAILED (TVarbuffer_Add (&wgTerm->tterminal.m_vbReqLineInfo, &tli, 1)))
				return	False ;

			/*
			 *	ιԤξäƤ롣
			 */
			pPrevLineInfo			= (TTermLineInfo *)TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqLineInfo) + wgTerm->tterminal.m_nReqTailLineIndex ;
			pPrevLineInfo->m_nNext	= wgTerm->tterminal.m_iRow ;
			wgTerm->tterminal.m_nReqTailLineIndex	= wgTerm->tterminal.m_iRow ;
#if defined (DEBUG)
		} else {
			fprintf (stderr, "Failure! %d, %d\n",
					 wgTerm->tterminal.m_iRow, 
					 TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbReqLineInfo)) ;
#endif
		}
		break ;
	default:
		/*	ΤȤ԰ʳ control code 򤷤ʤ*/
		break ;
	}
	return	True ;
}

Boolean
tterminal_putcharPrintable (
	register Widget		wgThis,
	register Char		cc)
{
	register TTerminalWidget	wgTerm	= (TTerminalWidget) wgThis ;
	register Pixel			pxlFore ;
	register Pixel			pxlBack ;
	register DChar*			pTextTop ;
	register DChar*			pText ;
	register TTermLineInfo*	pLineInfoTop ;
	register TTermLineInfo*	pLineInfo ;

	assert (0 <= wgTerm->tterminal.m_iRow) ;
	assert (wgTerm->tterminal.m_iRow < TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbReqLineInfo)) ;

	pLineInfoTop	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqLineInfo) ;
	pLineInfo		= pLineInfoTop + wgTerm->tterminal.m_iRow ;
	assert (0 <= wgTerm->tterminal.m_iColumn) ;
	assert (wgTerm->tterminal.m_iColumn <= pLineInfo->m_nLength) ;

	if (wgTerm->tterminal.m_fRev) {
		pxlFore	= wgTerm->core.background_pixel ;
		pxlBack	= wgTerm->tterminal.m_pxlFore ;
	} else {
		pxlFore	= wgTerm->tterminal.m_pxlFore ;
		pxlBack	= wgTerm->core.background_pixel ;
	}

#if defined (DEBUG_LV99)
	fprintf (stderr, "%d\n", wgTerm->tterminal.m_iColumn) ;
#endif
	pText				= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqText) ;
	pText				= pText + pLineInfo->m_nIndex + wgTerm->tterminal.m_iColumn ;
	if (wgTerm->tterminal.m_iColumn < pLineInfo->m_nLength) {
		/*	length ѹƤ롣ѹǤ
		 *	üޤ֤֤Ѥǽġ*/
		pText->m_char		= cc ;
		pText->m_pxlFore	= pxlFore ;
		pText->m_pxlBack	= pxlBack ;
		wgTerm->tterminal.m_iColumn	++ ;
		return	True ;
	}
	if (wgTerm->tterminal.m_iColumn < pLineInfo->m_nSize) {
		/*	Хåե­ƤΤǡlength  +1 롣*/
		pText->m_char		= cc ;
		pText->m_pxlFore	= pxlFore ;
		pText->m_pxlBack	= pxlBack ;
		pLineInfo->m_nLength	++ ;
		wgTerm->tterminal.m_iColumn	++ ;
		return	True ;
	}

	/*
	 *	ХåեĥʤФʤʤʤäν
	 */
	if (pLineInfo->m_nNext < 0) {
		if (TFAILED (TVarbuffer_Require (&wgTerm->tterminal.m_vbReqText, TTERM_NCHAR_PER_MALLOC)))
			return	False ;
		pLineInfo->m_nSize	+= TTERM_NCHAR_PER_MALLOC ;
		pTextTop	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqText) ;
	} else {
		TTermLineInfo*	pTailLineInfo ;
		int				nPos ;

		nPos		= TVarbuffer_GetUsage (&wgTerm->tterminal.m_vbReqText) ;
		if (TFAILED (TVarbuffer_Require (&wgTerm->tterminal.m_vbReqText, pLineInfo->m_nLength + TTERM_NCHAR_PER_MALLOC)))
			return	False ;
		pTextTop	= TVarbuffer_GetBuffer (&wgTerm->tterminal.m_vbReqText) ;
		memcpy (pTextTop + nPos, pTextTop + pLineInfo->m_nIndex, pLineInfo->m_nLength * sizeof (DChar)) ;
		/*	Ϣ³¤ǤȤݾڤʤȤ˵դġ*/
		if (pLineInfo->m_nPrev >= 0) {
			TTermLineInfo*	pPrevLineInfo ;
			pPrevLineInfo	= pLineInfoTop + pLineInfo->m_nPrev ;
			pPrevLineInfo->m_nSize	+= pLineInfo->m_nSize ;
			pPrevLineInfo->m_nNext	=  pLineInfo->m_nNext ;
		} else {
			TTermLineInfo*	pNextLineInfo ;
			pNextLineInfo	= pLineInfoTop + pLineInfo->m_nNext ;
			pNextLineInfo->m_nSize	+= pLineInfo->m_nSize ;
			pNextLineInfo->m_nPrev	= pLineInfo->m_nPrev ;
			memmove (pTextTop + pLineInfo->m_nIndex, pTextTop + pNextLineInfo->m_nIndex, pNextLineInfo->m_nLength * sizeof (DChar)) ;
			pNextLineInfo->m_nIndex	= pLineInfo->m_nIndex ;
		}
		pTailLineInfo		= pLineInfoTop + wgTerm->tterminal.m_nReqTailLineIndex ;
		assert (pTailLineInfo->m_nNext < 0) ;
		pTailLineInfo->m_nNext			= wgTerm->tterminal.m_iRow ;
		wgTerm->tterminal.m_nReqTailLineIndex	= wgTerm->tterminal.m_iRow ;

		pLineInfo->m_nSize		+= TTERM_NCHAR_PER_MALLOC ;
		pLineInfo->m_nIndex		=  nPos ;
		pLineInfo->m_nNext		= -1 ;
	}
	pText				= pTextTop + pLineInfo->m_nIndex + wgTerm->tterminal.m_iColumn ;
	pText->m_char		= cc ;
	pText->m_pxlFore	= pxlFore ;
	pText->m_pxlBack	= pxlBack ;
	pLineInfo->m_nLength	++ ;
	wgTerm->tterminal.m_iColumn	++ ;
	return	True ;
}
