/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (Terminal_h)
#define	Terminal_h

#include "Char.h"
#include "TFontSet.h"

#define	XtNparentWindow	"parentWindow"
#define	XtCParentWindow	"ParentWindow"

typedef struct tagTTerminalRec*			TTerminalWidget ;
typedef struct tagTTerminalClassRec*	TTerminalWidgetClass ;

extern	WidgetClass		tterminalWidgetClass ;


Boolean		TTerminal_Putchar		(Widget, Char) ;
TFontSet*	TTerminal_GetFontSet	(Widget) ;
Boolean		TTerminal_Clear			(Widget) ;
Boolean		TTerminal_Rev			(Widget, Boolean) ;
Boolean		TTerminal_MoveCursor	(Widget, int, int) ;
Boolean		TTerminal_Flush			(Widget) ;
Boolean		TTerminal_Update		(Widget) ;

#endif

