/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include "TFontSet.h"
#include "varbuffer.h"
#include "dtext.h"

#if defined (WIN32)
/*
 *	ǥץ쥤ʸ(°դʸ)̤ɽؿ
 *	(WIN32 )
 */
int
TDTextOut (
	register HWND			hWnd,
	register HDC			hDC,
	register TFontSet*		pFontSet,
	register int			x,
	register int			y,
	register const DChar*	pText,
	register int			nText,
	register TSize*			pSizeReturn)
{
	TVarbuffer		vbText ;
	TFont*			pFont ;
	HFONT			hPrevFont ;
	const DChar*	pHead ;
	int				nSet ;
	int				iOrgX ;
	int				nSize, nUsage ;
	COLORREF		pxlFore, pxlBack, pxlForeBak, pxlBackBak ;
	const wchar_t*	pc ;
	SIZE			sz ;

	assert (nText > 0) ;
	assert (pText != NULL) ;

	TVarbuffer_Initialize (&vbText, sizeof (wchar_t)) ;
	nUsage		= 0 ;
	iOrgX		= x ;
	hFontBak	= SelectObject (hDC, GetStockObject (SYSTEM_FONT)) ;
	pxlForeBak	= GetTextColor (hDC) ;
	pxlBackBak	= GetBkColor   (hDC) ;

	while (nText > 0) {
		nSet	= Char_Charset (pText->m_char) ;
		pxlFore	= pText->m_pxlFore ;
		pxlBack	= pText->m_pxlBack ;
		pHead	= pText ;
		while (nText > 0 &&
			   nSet == Char_Charset (pText->m_char) &&
			   pxlFore == pText->m_pxlFore &&
			   pxlBack == pText->m_pxlBack) {
			pText	++ ;
			nText	-- ;
		}
		
		pFont	= TFontSet_GetFont (pFontSet, nSet) ;
		if (pFont != NULL) {
			nSize	= pText - pHead ;
			if (nSize > nUsage) {
				TVarbuffer_Require (&vbText, nSize - nUsage) ;
				nUsage	= nSize ;
			}
			
			pc	= TVarbuffer_GetBuffer (&vbText) ;
			while (pHead != pText) {
				*pc	++	= Char_ToUnicode (pHead->m_char) ;
				pHead	++ ;
			}
			
			(void) SelectObject (hDC, TFont_GetFont (pFont)) ;
			(void) SetTextColor (hDC, pxlFore) ;
			(void) SetBkColor   (hDC, pxlBack) ;
			TextOut (hDC, x, y, TVarbuffer_GetBuffer (&vbText), nSize) ;
			GetTextExtentPoint32 (hDC, TVarbuffer_GetBuffer (&vbText), nSize, &sz) ;
			x	+= sz.cx ;
		}
	}
	if (pSizeReturn != NULL) {
		pSizeReturn->cx	= x - iOrgX ;
		pSizeReturn->cy	= pFontSet->m_iHeight ;
	}
	TVarbuffer_Uninitialize (&vbText) ;

	/*	ȤΥեȡƥȥ顼طʿ᤹*/
	(void) SelectObject (hDC, hFontBak) ;
	(void) SetTextColor (hDC, pxlForeBak) ;
	(void) ;SetBkColor   (hDC, pxlBackBak) ;
	return	0 ;
}

int
TGetDTextExtents (
	register HDC			hDC,
	register TFontSet*		pFontSet,
	register const DChar*	pText,
	register int			nText,
	register TSize*			pSizeReturn)
{
	TVarbuffer		vbText ;
	TFont*			pFont ;
	const DChar*	pHead ;
	int				nSet ;
	int				nSize, nUsage ;
	int				x ;
	wchar_t*		pc ;
	unsigned long	pxlFore, pxlBack ;
	SIZE			sz ;

	assert (nText > 0) ;
	assert (pText != NULL) ;


	TVarbuffer_Initialize (&vbText,  sizeof (w_char)) ;
	nUsage		= 0 ;
	x			= 0 ;

	while (nText > 0) {
		nSet	= Char_Charset (pText->m_char) ;
		pxlFore	= pText->m_pxlFore ;
		pxlBack	= pText->m_pxlBack ;
		pHead	= pText ;
		while (nText > 0 &&
			   nSet == Char_Charset (pText->m_char) &&
			   pxlFore == pText->m_pxlFore &&
			   pxlBack == pText->m_pxlBack) {
			pText	++ ;
			nText	-- ;
		}
		
		pFont	= TFontSet_GetFont (pFontSet, nSet) ;
		if (pFont != NULL) {
			nSize	= pText - pHead ;
			if (nSize > nUsage8) {
				TVarbuffer_Require (&vbText, nSize - nUsage) ;
				nUsage8	= nSize ;
			}
			
			pc	= TVarbuffer_GetBuffer (&vbText) ;
			while (pHead != pText) {
				*pc ++	= Char_ToUnicode (pHead->m_char) ;
				pHead	++ ;
			}
			/*	Win32  Device Context ¸ߤʤȡ
			 *	եȤ礭Ȥʤ
			 *	Device Context äƤ褤ġ*/
			GetTextExtentPoint32 (hDC, TFont_GetFont (pFont), TVarbuffer_GetBuffer (&vbText), nSize, &sz) ;
			x	+= sz.cx ;
		}
	}
	TVarbuffer_Uninitialize (&vbText) ;

	if (pSizeReturn != NULL) {
		pSizeReturn->cx	= x ;
		pSizeReturn->cy	= pFontSet->m_iHeight ;
	}

	return	0 ;
}

#else

/*
 *	ǥץ쥤ʸ(°դʸ)̤ɽؿ
 *	(X-Window )
 */
int
TDTextOut (
	register Display*		pDisplay,
	register Drawable		d,
	register GC				gc,
	register TFontSet*		pFontSet,
	register int			x,
	register int			y,
	register const DChar*	pText,
	register int			nText,
	register TSize*			pSizeReturn)
{
	TVarbuffer		vbText8 ;
	TVarbuffer		vbText16 ;
	TFont*			pFont ;
	const DChar*	pHead ;
	int				nSet ;
	int				iOrgX ;
	int				nSize, nUsage8, nUsage16 ;
	unsigned long	pxlFore, pxlBack ;
	char*			pc8 ;
	XChar2b*		pc16 ;
	
	assert (nText > 0) ;
	assert (pText != NULL) ;

	TVarbuffer_Initialize (&vbText8,  sizeof (char)) ;
	TVarbuffer_Initialize (&vbText16, sizeof (XChar2b)) ;
	nUsage8		= 0 ;
	nUsage16	= 0 ;
	iOrgX		= x ;

	while (nText > 0) {
		nSet	= Char_Charset (pText->m_char) ;
		pxlFore	= pText->m_pxlFore ;
		pxlBack	= pText->m_pxlBack ;
		pHead	= pText ;
		if (nSet < KCHARSET_2BYTES_CHARACTER) {
			while (nText > 0 &&
				   nSet == Char_Charset (pText->m_char) &&
				   pxlFore == pText->m_pxlFore &&
				   pxlBack == pText->m_pxlBack) {
				pText	++ ;
				nText	-- ;
			}

			pFont	= TFontSet_GetFont (pFontSet, nSet) ;
			if (pFont != NULL) {
				nSize	= pText - pHead ;
				if (nSize > nUsage8) {
					TVarbuffer_Require (&vbText8, nSize - nUsage8) ;
					nUsage8	= nSize ;
				}

				pc8	= TVarbuffer_GetBuffer (&vbText8) ;
				while (pHead != pText) {
					*pc8 ++	= Char_Code (pHead->m_char) ;
					pHead	++ ;
				}

				XSetFont (pDisplay, gc, TFont_GetFontStruct (pFont)->fid) ;
				XSetForeground (pDisplay, gc, pxlFore) ;
				XSetBackground (pDisplay, gc, pxlBack) ;
				XDrawImageString (pDisplay, d, gc, x, y, TVarbuffer_GetBuffer (&vbText8), nSize) ;
				x	+= XTextWidth (TFont_GetFontStruct (pFont), TVarbuffer_GetBuffer (&vbText8), nSize) ;
			}
		} else {
			while (nText > 0 &&
				   nSet == Char_Charset (pText->m_char) &&
				   pxlFore == pText->m_pxlFore &&
				   pxlBack == pText->m_pxlBack) {
				pText	++ ;
				nText	-- ;
			}

			pFont	= TFontSet_GetFont (pFontSet, nSet) ;
			if (pFont != NULL) {
				nSize	= pText - pHead ;
				if (nSize > nUsage16) {
					TVarbuffer_Require (&vbText16, nSize - nUsage16) ;
					nUsage16	= nSize ;
				}

				pc16	= TVarbuffer_GetBuffer (&vbText16) ;
				while (pHead != pText) {
					pc16->byte1	= Char_Code (pHead->m_char) >> 8 ;
					pc16->byte2	= Char_Code (pHead->m_char) ;
					pc16	++ ;
					pHead	++ ;
				}

				XSetFont (pDisplay, gc, TFont_GetFontStruct (pFont)->fid) ;
				XSetForeground (pDisplay, gc, pxlFore) ;
				XSetBackground (pDisplay, gc, pxlBack) ;
				XDrawImageString16 (pDisplay, d, gc, x, y, TVarbuffer_GetBuffer (&vbText16), nSize) ;
				x	+= XTextWidth16 (TFont_GetFontStruct (pFont), TVarbuffer_GetBuffer (&vbText16), nSize) ;
			}
		}
	}

	if (pSizeReturn != NULL) {
		pSizeReturn->cx	= x - iOrgX ;
		pSizeReturn->cy	= pFontSet->m_iHeight ;
	}

	TVarbuffer_Uninitialize (&vbText8) ;
	TVarbuffer_Uninitialize (&vbText16) ;
	return	0 ;
}

int
TGetDTextExtents (
	register TFontSet*		pFontSet,
	register const DChar*	pText,
	register int			nText,
	register TSize*			pSizeReturn)
{
	TVarbuffer		vbText8 ;
	TVarbuffer		vbText16 ;
	TFont*			pFont ;
	const DChar*	pHead ;
	int				nSet ;
	int				nSize, nUsage8, nUsage16 ;
	int				x ;
	char*			pc8 ;
	XChar2b*		pc16 ;
	unsigned long	pxlFore, pxlBack ;

	assert (nText > 0) ;
	assert (pText != NULL) ;


	TVarbuffer_Initialize (&vbText8,  sizeof (char)) ;
	TVarbuffer_Initialize (&vbText16, sizeof (XChar2b)) ;
	nUsage8		= 0 ;
	nUsage16	= 0 ;
	x			= 0 ;

	while (nText > 0) {
		nSet	= Char_Charset (pText->m_char) ;
		pxlFore	= pText->m_pxlFore ;
		pxlBack	= pText->m_pxlBack ;
		pHead	= pText ;
		if (nSet < KCHARSET_2BYTES_CHARACTER) {
			while (nText > 0 &&
				   nSet == Char_Charset (pText->m_char) &&
				   pxlFore == pText->m_pxlFore &&
				   pxlBack == pText->m_pxlBack) {
				pText	++ ;
				nText	-- ;
			}

			pFont	= TFontSet_GetFont (pFontSet, nSet) ;
			if (pFont != NULL) {
				nSize	= pText - pHead ;
				if (nSize > nUsage8) {
					TVarbuffer_Require (&vbText8, nSize - nUsage8) ;
					nUsage8	= nSize ;
				}

				pc8	= TVarbuffer_GetBuffer (&vbText8) ;
				while (pHead != pText) {
					*pc8 ++	= Char_Code (pHead->m_char) ;
					pHead	++ ;
				}

				x	+= XTextWidth (TFont_GetFontStruct (pFont), TVarbuffer_GetBuffer (&vbText8), nSize) ;
			}
		} else {
			while (nText > 0 &&
				   nSet == Char_Charset (pText->m_char) &&
				   pxlFore == pText->m_pxlFore &&
				   pxlBack == pText->m_pxlBack) {
				pText	++ ;
				nText	-- ;
			}

			pFont	= TFontSet_GetFont (pFontSet, nSet) ;
			if (pFont != NULL) {
				nSize	= pText - pHead ;
				if (nSize > nUsage16) {
					TVarbuffer_Require (&vbText16, nSize - nUsage16) ;
					nUsage16	= nSize ;
				}

				pc16	= TVarbuffer_GetBuffer (&vbText16) ;
				while (pHead != pText) {
					pc16->byte1	= Char_Code (pHead->m_char) >> 8 ;
					pc16->byte2	= Char_Code (pHead->m_char) ;
					pc16	++ ;
					pHead	++ ;
				}

				x	+= XTextWidth16 (TFont_GetFontStruct (pFont), TVarbuffer_GetBuffer (&vbText16), nSize) ;
			}
		}
	}

	TVarbuffer_Uninitialize (&vbText8) ;
	TVarbuffer_Uninitialize (&vbText16) ;

	if (pSizeReturn != NULL) {
		pSizeReturn->cx	= x ;
		pSizeReturn->cy	= pFontSet->m_iHeight ;
	}

	return	0 ;
}
#endif

