;;; skk-foreword.el --- 
;; Copyright (C) 1997, 1998, 1999 Mikio Nakajima <minakaji@osaka.email.ne.jp>

;; Author: Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Maintainer: Hideki Sakurada <sakurada@kuis.kyoto-u.ac.jp>
;;             Murata Shuuichirou  <mrt@astec.co.jp>
;;             Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Version: $Id: skk-foreword.el,v 1.1 2002/11/27 13:17:35 tatari Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2002/11/27 13:17:35 $

;; This file is not part of SKK yet.

;; SKK is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; SKK is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:

;; Υեϡ桼ѿΤ˻Ѥޥskk-*.el 
;; Ѥޥʤɡѿskk-*.el κǽƤ
;; ФʤʤΤޤȤ᤿ΤǤ桼ѿˡ
;; 㤴ȥ桼˶̣ʤΤ¤ǤΤǤϡ桼
;; ɥ꡼ǤϤʤȹͤ뤫Ǥ
;;
;;; Code:
(require 'advice)

;; necessary macro and functions to be declared before user variable declarations.

;;;; macros
;; Why I use non-intern temporary variable in the macro --- see comment in
;; save-match-data of subr.el of GNU Emacs. And should we use the same manner
;; in the save-current-buffer, with-temp-buffer and with-temp-file macro
;; definition?
(defmacro skk-save-point (&rest body)
  (` (let ((skk-save-point (point-marker)))
       (unwind-protect
	   (progn (,@ body))
	 (goto-char skk-save-point)
         (skk-set-marker skk-save-point nil) ))))

(defmacro skk-message (japanese english &rest arg)
  ;; skk-japanese-message-and-error  non-nil ä JAPANESE  nil Ǥ
  ;;  ENGLISH 򥨥ꥢɽ롣
  ;; ARG  message ؿ裲ʹߤΰȤϤ롣
  (append (list 'message (list 'if 'skk-japanese-message-and-error
			       japanese english ))
	  arg ))

(defmacro skk-error (japanese english &rest arg)
  ;; skk-japanese-message-and-error  non-nil ä JAPANESE  nil Ǥ
  ;;  ENGLISH 򥨥ꥢɽ顼ȯ롣
  ;; ARG  error ؿ裲ʹߤΰȤϤ롣
  (append (list 'error (list 'if 'skk-japanese-message-and-error
			     japanese english ))
	  arg ))

(defmacro skk-yes-or-no-p (japanese english)
  ;; skk-japanese-message-and-error  non-nil ǤСjapanese  nil Ǥ
  ;;  english ץץȤȤ yes-or-no-p ¹Ԥ롣
  ;; yes-or-no-p ΰΥץץȤʣǤϤΥޥ
  ;; ꥪꥸʥ yes-or-no-p Ѥɤʣˤʤʤ礬
  ;; 롣
  (list 'yes-or-no-p (list 'if 'skk-japanese-message-and-error
				   japanese english )))

(defmacro skk-y-or-n-p (japanese english)
  ;; skk-japanese-message-and-error  non-nil ǤСjapanese  nil Ǥ
  ;;  english ץץȤȤ y-or-n-p ¹Ԥ롣
  (list 'y-or-n-p (list 'if 'skk-japanese-message-and-error
				japanese english )))

(defmacro skk-set-marker (marker position &optional buffer)
  ;; ХåեͤǤ skk-henkan-start-point, skk-henkan-end-point,
  ;; skk-kana-start-point, 뤤 skk-okurigana-start-point  nil ä顢
  ;; ޡä롣
  (list 'progn
        (list 'if (list 'not marker)
              (list 'setq marker (list 'make-marker)) )
        (list 'set-marker marker position buffer) ))

;; From viper-util.el.  Welcome!
(defmacro skk-deflocalvar (var default-value &optional documentation)
  (` (progn
       (defvar (, var) (, default-value)
	       (, (format "%s\n\(buffer local\)" documentation)))
       (make-variable-buffer-local '(, var))
     )))

(defmacro skk-with-point-move (&rest form)
  ;; ݥȤư뤬եå¹ԤƤۤʤ˻Ȥ
  (` (unwind-protect
	 (progn (,@ form))
       (setq skk-previous-point (point)) )))

(defmacro skk-face-on (object start end face &optional priority)
  (static-cond
   ((eq skk-emacs-type 'xemacs)
    (` (let ((inhibit-quit t))
	 (if (not (extentp (, object)))
	     (progn
	       (setq (, object) (make-extent (, start) (, end)))
	       (if (not (, priority))
		   (set-extent-face (, object) (, face))
		 (set-extent-properties
		  (, object) (list 'face (, face) 'priority (, priority)) )))
	   (set-extent-endpoints (, object) (, start) (, end))  ))))
   (t
    (` (let ((inhibit-quit t))
	 (if (not (overlayp (, object)))
	     (progn
	       (setq (, object) (make-overlay (, start) (, end)))
	       (and (, priority) (overlay-put (, object) 'priority (, priority)))
	       (overlay-put (, object) 'face (, face)) )
	   (move-overlay (, object) (, start) (, end)) ))))))

(put 'skk-deflocalvar 'lisp-indent-function 'defun)

;;;; inline functions
(defun skk-file-exists-and-writable-p (file)
  (and (setq file (expand-file-name file))
       (file-exists-p file) (file-writable-p file) ))

(defun skk-lower-case-p (char)
  ;; CHAR ʸΥե٥åȤǤСt ֤
  (and (<= ?a char) (>= ?z char) ))

(defun skk-downcase (char)
  (or (cdr (assq char skk-downcase-alist)) (downcase char)) )

(defun skk-mode-off ()
  (setq skk-mode nil
        skk-abbrev-mode nil
        skk-latin-mode nil
        skk-j-mode nil
        skk-jisx0208-latin-mode nil
        ;; j's sub mode.
        skk-katakana nil )
  ;; initialize
  (setq skk-input-mode-string skk-hiragana-mode-string)
  (force-mode-line-update)
  (remove-hook 'pre-command-hook 'skk-pre-command 'local) )

(defun skk-j-mode-on (&optional katakana)
  (setq skk-mode t
        skk-abbrev-mode nil
        skk-latin-mode nil
        skk-j-mode t
        skk-jisx0208-latin-mode nil
        ;; j's sub mode.
        skk-katakana katakana )
  ;; mode line
  (setq skk-input-mode-string (if katakana skk-katakana-mode-string
				skk-hiragana-mode-string ))
  (force-mode-line-update) )

(defun skk-latin-mode-on ()
  (setq skk-mode t
        skk-abbrev-mode nil
        skk-latin-mode t
        skk-j-mode nil
        skk-jisx0208-latin-mode nil
        ;; j's sub mode.
        skk-katakana nil
        skk-input-mode-string skk-latin-mode-string )
  (force-mode-line-update) )

(defun skk-jisx0208-latin-mode-on ()
  (setq skk-mode t
        skk-abbrev-mode nil
        skk-latin-mode nil
        skk-j-mode nil
        skk-jisx0208-latin-mode t
        ;; j's sub mode.
        skk-katakana nil
        skk-input-mode-string skk-jisx0208-latin-mode-string )
  (force-mode-line-update) )

(defun skk-abbrev-mode-on ()
  (setq skk-mode t
        skk-abbrev-mode t
        skk-latin-mode nil
        skk-j-mode nil
        skk-jisx0208-latin-mode nil
        ;; j's sub mode.
        skk-katakana nil
        skk-input-mode-string skk-abbrev-mode-string )
  (force-mode-line-update) )

(defun skk-in-minibuffer-p ()
  ;; ȥХåեߥ˥Хåեɤå롣
  (window-minibuffer-p (selected-window)) )

(defun skk-insert-prefix (&optional char)
  ;; skk-echo  non-nil ǤХȥХåե skk-prefix 롣
  (and skk-echo
       ;; skk-prefix 򥢥ɥоݤȤʤץեåϡ
       ;; ʸƾõΤǡδ֡buffer-undo-list 
       ;; t ˤƥɥߤʤȤ꤬ʤ
       (let ((buffer-undo-list t))
         (insert (or char skk-prefix)) )))

(defun skk-erase-prefix (&optional clean)
  ;; skk-echo  non-nil ǤХȥХåե줿 skk-prefix 
  ;; ץʥ CLEAN ꤵȡѿȤƤ skk-prefix 
  ;; null ʸˡskk-current-rule-tree  nil 롣
  ;;
  ;; ʸϤޤƤʤˤδؿƤФ줿ȤʤɤϡХ
  ;; եƤ skk-prefix ϺѿȤƤ skk-prefix 
  ;; null ʸˤʤ
  (and skk-echo skk-kana-start-point
       (not (string= skk-prefix ""))	; fail safe.
       ;; skk-prefix ξõ򥢥ɥоݤȤʤ
       (let ((buffer-undo-list t)
	     (start (marker-position skk-kana-start-point)) )
	 (and start
	      (condition-case nil
		  (delete-region start (+ start (length skk-prefix)))
		(error
		 (skk-set-marker skk-kana-start-point nil) 
		 (setq skk-prefix ""
		       skk-current-rule-tree nil ))))))
  (and clean (setq skk-prefix ""
		   skk-current-rule-tree nil ))) ; fail safe

(defun skk-string<= (str1 str2)
  ;; STR1  STR2 ȤӤơstring<  string= ǤСt ֤
  (or (string< str1 str2) (string= str1 str2)) )

(defun skk-do-auto-fill ()
  ;; auto-fill-function ͤƤСdo-auto-fill 򥳡뤹롣
  (and auto-fill-function (funcall auto-fill-function)) )

;;;; from dabbrev.el.  Welcome!
;; Ƚְ㤤Ȥ礢ꡣײɡ
(defun skk-minibuffer-origin ()
  (nth 1 (buffer-list)) )

(defun skk-current-insert-mode ()
  (cond (skk-abbrev-mode 'abbrev)
	(skk-latin-mode 'latin)
	(skk-jisx0208-latin-mode 'jisx0208-latin)
	(skk-katakana 'katakana)
	(skk-j-mode 'hiragana) ))

(defun skk-numeric-p ()
  (and skk-use-numeric-conversion (require 'skk-num) skk-num-list) )

(defun skk-substring-head-character (string)
  (char-to-string (string-to-char string)) )

(defun skk-get-current-candidate-simply (&optional noconv)
  (if (> 0 skk-henkan-count)
      (skk-error "ФȤǤޤ"
		 "Cannot get current candidate" )
    ;; (nth -1 '(A B C)) ϡA ֤ΤǡǤʤɤå롣
    (let ((word (nth skk-henkan-count skk-henkan-list)))
      (and word
	   (if (and (skk-numeric-p) (consp word))
	       (if noconv (car word) (cdr word))
	     word )))))

;; convert skk-rom-kana-rule-list to skk-rule-tree.
;; The rule tree follows the following syntax:
;; <branch-list>    ::= nil | (<tree> . <branch-list>)
;; <tree>         ::= (<char> <prefix> <nextstate> <kana> <branch-list>)
;; <kana>         ::= (<Ҥ餬ʸ> . <ʸ>) | nil
;; <char>         ::= <Ѿʸ>
;; <nextstate>    ::= <Ѿʸʸ> | nil

;; ĥ꡼˥뤿Υ󥿡ե

(defun skk-make-rule-tree (char prefix nextstate kana branch-list)
  (list char
	prefix
	(if (string= nextstate "") nil nextstate)
	kana
	branch-list ))

(defun skk-get-char (tree)
  (car tree) )

(defun skk-set-char (tree char)
  (setcar tree char) )

(defun skk-set-prefix (tree prefix)
  (setcar (nthcdr 1 tree) prefix) )

(defun skk-get-prefix (tree)
  (nth 1 tree) )

(defun skk-get-nextstate (tree)
  (nth 2 tree) )

(defun skk-set-nextstate (tree nextstate)
  (if (string= nextstate "") (setq nextstate nil))
  (setcar (nthcdr 2 tree) nextstate) )

(defun skk-get-kana (tree)
  (nth 3 tree) )

(defun skk-set-kana (tree kana)
  (setcar (nthcdr 3 tree) kana) )

(defun skk-get-branch-list (tree)
  (nth 4 tree) )

(defun skk-set-branch-list (tree branch-list)
  (setcar (nthcdr 4 tree) branch-list) )

;; tree procedure for skk-kana-input.
(defun skk-add-branch (tree branch)
  (skk-set-branch-list tree (cons branch (skk-get-branch-list tree))) )

(defun skk-select-branch (tree char)
  (assq char (skk-get-branch-list tree)) )

(defun skk-kana-cleanup (&optional force)
  (let ((data (or
	       (and skk-current-rule-tree
		    (null (skk-get-nextstate skk-current-rule-tree))
		    (skk-get-kana skk-current-rule-tree) )
	       (and skk-kana-input-search-function
		    (car (funcall skk-kana-input-search-function)) )))
	kana )
	(if (or force data)
	    (progn
	      (skk-erase-prefix 'clean)
	      (setq kana (if (functionp data) (funcall data nil) data))
	      (if (consp kana)
		  (setq kana (if skk-katakana (car kana) (cdr kana))) )
	      (if (stringp kana) (skk-insert-str kana))
	      (skk-set-marker skk-kana-start-point nil)
	      t ))))

(defun skk-pre-command ()
  (and (memq last-command '(skk-insert skk-previous-candidate))
       (null (memq this-command skk-kana-cleanup-command-list))
       (skk-kana-cleanup t) ))

(defun skk-make-raw-arg (arg)
  (cond ((= arg 1) nil)
	((= arg -1) '-)
	((numberp arg) (list arg)) ))

(defun skk-unread-event (event)
  ;; Unread single EVENT.
  (setq unread-command-events (nconc unread-command-events (list event))) )

(defun skk-after-point-move ()
  (and (or (not skk-previous-point) (not (= skk-previous-point (point))))
       (skk-get-prefix skk-current-rule-tree)
       (skk-with-point-move (skk-erase-prefix 'clean)) ))

(defun skk-get-last-henkan-data (key)
  (cdr (assq key skk-last-henkan-data)) )

(defun skk-put-last-henkan-data (key val)
  (setq skk-last-henkan-data (put-alist key val skk-last-henkan-data)) )

(defun skk-terminal-face-p ()
  (and (not window-system)
       ;;; XEmacs does not have this funciton...
       (fboundp 'frame-face-alist) ; ѿ̾ߤʴؿ...
       (fboundp 'selected-frame) ))

;;;; aliases
;; for backward compatibility.
;(define-obsolete-function-alias 'skk-zenkaku-mode 'skk-jisx0208-latin-mode)
;(define-obsolete-function-alias 'skk-zenkaku-mode-on 'skk-jisx0208-latin-mode-on)
;(define-obsolete-function-alias 'skk-zenkaku-insert 'skk-jisx0208-latin-insert)
;(define-obsolete-function-alias 'skk-zenkaku-region 'skk-jisx0208-latin-region)
;(define-obsolete-function-alias 'skk-zenkaku-henkan 'skk-jisx0208-latin-henkan)
;(define-obsolete-function-alias 'skk-ascii-mode-on 'skk-latin-mode-on)
;(define-obsolete-function-alias 'skk-ascii-mode 'skk-latin-mode)
;(define-obsolete-function-alias 'skk-ascii-region 'skk-latin-region)
;(define-obsolete-function-alias 'skk-ascii-henkan 'skk-latin-henkan)
;(define-obsolete-function-alias 'skk-convert-ad-to-gengo 'skk-ad-to-gengo)
;(define-obsolete-function-alias 'skk-convert-gengo-to-ad 'skk-gengo-to-ad)
;(define-obsolete-function-alias 'skk-isearch-forward 'isearch-forward)
;(define-obsolete-function-alias 'skk-isearch-forward-regexp 'isearch-forward-regexp)
;(define-obsolete-function-alias 'skk-isearch-backward 'isearch-backward)
;(define-obsolete-function-alias 'skk-isearch-backward-regexp 'isearch-backward-regexp)

(defconst skk-background-mode
  ;; from font-lock-make-faces of font-lock.el  Welcome!
  'mono)

;;;; version specific matter.
;;; inline functions.
(defun skk-str-length (str)
    (length str))

(defun skk-substring (str pos1 pos2)
    (substring str pos1 pos2))

;; no argument use only in SKK.
(defun skk-read-event ()
  (read-event))

(defun skk-char-to-string (char)
  (char-to-string char))

(defun skk-ascii-char-p (char)
  ;; CHAR  ascii ʸä t ֤
  (eq (char-charset char) 'ascii))
 
(defun skk-str-ref (str pos)
  (aref str pos))

(defun skk-jisx0208-p (char)
  (eq (char-charset char) 'japanese-jisx0208))

(defun skk-char-octet (ch &optional n)
  (char-octet ch n))

;;; normal functions.
;; tiny function, but called once in skk-kcode.el.  So not make it inline.
;; or should I think to move to skk-kcode.el?
(defun skk-make-char (charset n1 n2)
  (make-char charset n1 n2))

;; this one is called once in skk-kcode.el, too.
(defun skk-charsetp (object)
  (charsetp object))

(defun skk-jisx0208-to-ascii (string)
  (let ((char
	 (get-char-code-property (string-to-char string) 'ascii) ))
    (and char (char-to-string char)) ))

(provide 'skk-foreword)
;;; Local Variables:
;;; End:
;;; skk-forwords.el ends here
