
module SkyPeer

  class FileHandler < WEBrick::HTTPServlet::FileHandler
    include WEBrick;
    
    def initialize( server, *options )
      @server = server;
      super( server, *options );
    end
    
    def do_GET( req, res )
      # @server.htaccess.check( req );
      if( req.path_info !~ %r|^/[0-9a-z]{32}\.|i ) then
	# 普通の GET リクエスト
	super( req, res );
      else
	# /data/ ディレクトリ以下のファイルへのアクセス
	filepath = @root.dup;
	filepath << req.path_info.to_s;
	filename = File::basename( req.path_info );
	if( @server.is_privilege_host?( req.addr[ 3 ] ) )
	  # 特権ホストからのアクセス
	  if( req.path_info =~ /([0-9a-f]{32})\.(\w{2,5})$/ ) then
	    hash = $1;
	    ext = $2;
	    # ファイルが存在しなかったらデータベースに問い合わせて GET する
	    unless( File::exist?( filepath ) ) then	 
	      owners = @server.get_fileowner( filename );
	      owners.each { |owner|
		if( owner.nil? ) then next; end
		addr = owner['addr'];
		port = owner['port'].to_i;
		res0 = nil
		Net::HTTP.start( addr, port ) { |http|
		  res0, = http.get2( req.path, {'user-agent'=>'SkyPeer'} );
		  @server.logger.info( "GET #{addr} #{req.path}" );
		}
		if( res0.code != "200" ) then 
		  next; 
		end
		if( Digest::MD5::hexdigest( "#{res0.body}" ) != hash ) then 
		  next;
		end
		File.open( filepath, 'w' ) { |io| 
		  io.flock( File::LOCK_EX );
		  io.write( res0.body ); 
		}
		@server.regist_fileowner( [ filename ] );
		result, fileinfo = @server.get_fileinfo( filename );
		if( result =~ /^200/ && fileinfo ) then
		  @server.fileinfos.transaction {
		    if( @server.fileinfos[filename].nil? ) then
		      @server.fileinfos[filename] = Hash.new( );
		    end
		    @server.fileinfos[filename]['comment'] = fileinfo['comment'].to_s;
		  }
		end
		break; 
	      }
	    end
	  end
	  super( req, res );
	else
	  # 非特権ホストからのリクエスト
	  if( req.path_info =~ /([0-9a-f]{32})\.(\w{2,5})$/ ) then
	    # アクセス可能なのは "hash.ext" のフォーマットのファイルのみ
	    hash = $1;
	    ext = $2;
	    if( File::exist?( filepath ) ) then
	      unless( @server[:AllowExt].match( ext ) ) then
		# アクセス許可されてない拡張子のファイル
		@server.delete_fileowner( [ filename ] );
		raise HTTPStatus::Forbidden;
	      end
	      super( req, res );
	    else
	      @server.delete_fileowner( [ filename ] );	
	      raise HTTPStatus::NotFound;
	    end
	  else
	    # "hash.ext" の形式以外のファイル
	    @server.delete_fileowner( [ filename ] );
	    raise HTTPStatus::Forbidden;
	  end
	end
      end
    end

    def do_POST( req, res )
      do_GET( req, res );
    end

  end
end

