require 'amrita/template';
require 'skypeer/servent';

module SkyPeer

  class FileInfoError < Exception; end

  class FileInfoServlet < WEBrick::HTTPServlet::AbstractServlet
    include WEBrick;
    include Amrita;
    
    def initialize( server, *options )
      @server = server;
      super( server, *options );
    end
    
    def do_GET( req, res )
      do_POST( req, res );
    end
    
    def do_POST( req, res )
      raise HTTPStatus::Forbidden unless( @server.is_privilege_host?( req.addr[ 3 ] ) );
      res['content-type'] = 'text/html; charset=utf-8';
      html = File::open( 'template/head.html', 'r' ) { |io| io.read( ); }
      html << File::open( 'template/fileinfo.html', 'r' ) { |io| io.read( ); }
      html << File::open( 'template/foot.html', 'r' ) { |io| io.read( ); }
      tmpl = TemplateText.new( html );
      tmpl.amrita_id = :spid;
      model = Hash.new( );
      if( req.query['file'].to_s.empty? ) then
	model[:form1] = true;
      elsif( !File::exist?( "#{@server.config[:DataDir]}/#{req.query['file']}" ) ) then
	model[:form1] = true;
	model[:error] = "ERROR: \"#{req.query['file']}\" そんなファイルないよ。";
      else
	model[:form2] = Hash.new( );
	file = req.query['file'].to_s;
	fileurl = "/data/#{file}";
	filepath = "#{@server.config[:DataDir]}/#{file}"
	stat = File::stat( filepath );
	size = stat.size;
	fsize = 1048576 < size ? "#{size/1048576}MB" : 1024 < size ? "#{size/1024}kB" : "#{size}B";
	ctime = stat.ctime;
	fctime = ctime.strftime( "%y/%m/%d %H:%M:%S" );
	comment = "";
	if( req.query['phase'] == 'edit' ) then
	  comment = req.query['comment'].to_s;
	else
	  @server.fileinfos.transaction{
	    unless( @server.fileinfos[file].nil? ) then
	      comment = @server.fileinfos[file]['comment'];
	    end
	  }
	end
	begin
	  if( req.query['phase'] == 'edit' ) then
	    if( req.query['submit'] == 'import' ) then
	      result, fileinfo = @server.get_fileinfo( file.to_s );
	      if( result !~ /^200/ ) then raise FileInfoError, result.to_s; end
	      if( fileinfo ) then
		if( fileinfo['comment'] == comment ) then comment = ''; end
		comment << fileinfo['comment'].to_s;
		digest = Digest::MD5::hexdigest( "#{file}\0#{fileinfo['size']}\0#{fileinfo['comment']}" );
	      end
	      export = ' ';
	    else
	      unless( req.query['export'].to_s.empty? ) then
		fileinfo = { 'file'=>file.to_s, 'size'=>size, 'comment'=>comment.to_s };
		result, fileinfo = @server.set_fileinfo( fileinfo, req.query['digest'].to_s );		
		export = ' ';
		if( result =~ /^200/ ) then 
		  digest = Digest::MD5::hexdigest( "#{file}\0#{fileinfo['size']}\0#{fileinfo['comment']}" );	      
		else
		  if( result =~ /^300/ ) then
		    comment << "\n-----------\n";
		    comment << fileinfo['comment'].to_s;
		  end
		  raise FileInfoError, result;
		end
	      end
	      @server.fileinfos.transaction{
		if( @server.fileinfos[file].nil? ) then
		  @server.fileinfos[file] = Hash.new( );
		end
		@server.fileinfos[file]['comment'] = comment;
	      }
	      model[:message] = '登録したよ。'
	    end
	  end
	rescue FileInfoError
	  model[:error] = "ERROR: #{$!.to_s}";
	end
	model[:form2] = { :fileurl=>a( :href=>fileurl ) { file },
	                  :fsize=>fsize,
                   	  :fctime=>fctime,
	                  :comment=>comment,
	                  :file=>a( :value=>file ),
      	                  :digest=>a( :value=>digest ),
                          :export=>export};
      end
      tmpl.expand( res.body, model );
    end
  end

end
