require 'amrita/template';
require 'skypeer/servent';

module SkyPeer
  
  class FileListServlet < WEBrick::HTTPServlet::AbstractServlet
    include WEBrick;
    include Amrita;

    THUMBDIR = "thumbnail";;
    SORT_ELEMENTS = [ ['file0','ファイル名▲'], ['file1','ファイル名▼'],
                      ['size0','サイズ▲'], ['size1','サイズ▼'], 
                      ['ctime0','日付▲'], ['ctime1','日付▼'],
                      ['comment0','コメント▲'], ['comment1','コメント▼'] ];
    SORT_KEYS = Regexp.new( "(#{SORT_ELEMENTS.collect { |elem| elem[ 0 ] }.join( '|' )})" );
    
    def initialize( server, *options )
      @server = server;
      super( server, *options );
      begin
	require 'GD';
	@thumbnail_enable = true;
      rescue LoadError
      end
    end
    
    def do_GET( req, res )
      raise HTTPStatus::Forbidden unless( @server.is_privilege_host?( req.addr[ 3 ] ) );
      res['content-type'] = 'text/html; charset=utf-8';
      res['cache-control'] = 'no-cache';
      html = File::open( 'template/head.html', 'r' ) { |io| io.read( ); }
      html << File::open( 'template/filelist.html', 'r' ) { |io| io.read( ); }
      html << File::open( 'template/foot.html', 'r' ) { |io| io.read( ); }
      tmpl = TemplateText.new( html );
      tmpl.amrita_id = :spid;
      model = create_model( req );
      tmpl.expand( res.body, model );
    end

    def do_POST( req, res )
      do_GET( req, res );
    end

    def create_model( req )
      model = Hash.new( );
      model[:search] = a( :value=>req.query['search'] );
      sort = req.query['sort'].to_s;
      sort = ( sort =~ SORT_KEYS ) ? sort : 'ctime1';
      model[:sortopt] = Array.new( );
      SORT_ELEMENTS.each { |elem|
	if( sort == elem[ 0 ] ) then
	  model[:sortopt].push( a( :value=>elem[ 0 ], :selected=>'selected' ) { elem[ 1 ] } )
	else
	  model[:sortopt].push( a( :value=>elem[ 0 ] ) { elem[ 1 ] } );
	end
      }
      sort.sub!( /(\d+)$/, '' );
      order = $1.to_i;
      start = req.query['start'].to_i;
      num = req.query['num'].nil? ? 20 : req.query['num'].to_i;
      search = get_search_query( req.query['search'] );
      fileinfos = get_fileinfo_list( search );
      files = fileinfos.keys;
      totalnum = files.size;
      query_string = req.query_string.to_s.gsub( /start=[^&]*&?/, '' ).gsub( /num=[^&]*&?/, '' );
      model[:page] = Array.new( );
      ( 0..( (totalnum-1)/num ) ).each { |i|
	model[:page].push( e(:a, :href=>"?start=#{i*num}&num=#{num}&#{query_string}" ) { " #{i+1} " });
      }
      files.sort! { |file1,file2| 
	if( order == 0 ) then 
	  fileinfos[file1][sort] <=> fileinfos[file2][sort];
	else
	  fileinfos[file2][sort] <=> fileinfos[file1][sort];
	end
      }
      files = files[ start, num ];
      model[:item] = Array.new( );
      files.each { |file|
	filepath = "#{@server.config[:DataDir]}/#{file}"
	size = fileinfos[file]['size'];
	size = 1048576 < size ? "#{size/1048576}MB" : 1024 < size ? "#{size/1024}kB" : "#{size}B";
	ctime = fileinfos[file]['ctime'].strftime( "%y/%m/%d %H:%M:%S" );
	comment = fileinfos[file]['comment'];
	# サムネイル
	thumburl = nil;
	if( file =~ /\.(jpg|png)$/ && @thumbnail_enable ) then
	  thumburl = make_thumbnail( filepath );
	end
	data = Hash.new( );
	data[:file] = a( :href=>"/data/#{file}" ) { file };
	data[:size] = size;
	data[:ctime] = ctime;
	data[:comment] = "#{comment}";
	data[:info] = a( :href=>"/info?file=#{file}" );
	data[:delete] = a(:href=>"/delete?file=#{file}" );
	data[:thumbnail] = a( :src=>thumburl ) if( thumburl );
	model[:item].push( data );
      }
      return( model );
    end
    private :create_model;
    
    def get_search_query( str )
      if( str.nil? ) then return( nil ); end
      search = Array.new( );
      str.sub!( /^[\s　]+/, '' );
      str.sub!( /[\s　]+$/, '' );
      tokens = str.split( /[\s　]+/ );
      tokens.each { |token|
	key, value = token.split( /:/ );
	if( key =~ /(?:file|size|ctime|comment)/ && !value.nil? )
	  search.push( [ key, value ] );
	else
	  search.push( [ 'comment', token ] );
	end
      }
      return( search );
    end
    
    def get_fileinfo_list( search = nil )
      fileinfos = Hash.new( );
      @server.fileinfos.transaction {
	Dir::foreach( "#{@server.config[:DataDir]}" ) { |file|
	  filepath = "#{@server.config[:DataDir]}/#{file}";
	  unless( File::file?( filepath ) ) then next; end
	  unless( @server.fileinfos[file].nil? ) then
	    comment = @server.fileinfos[file]['comment'];
	  end
	  stat = File::stat( filepath );
	  fileinfo = { 'filepath'=>filepath, 'file'=>file, 'size'=>stat.size, 'ctime'=>stat.ctime, 'comment'=>comment.to_s };
	  if( match_file?( fileinfo, search ) ) then
	    fileinfos[file] = fileinfo;
	  end
	}
      }
      return( fileinfos );
    end
    
    def match_file?( fileinfo, search )
      if( search.nil? ) then return( true ); end
      flag = true;
      search.each { |q|
	unless( flag ) then  break; end
	case q[ 0 ]
	when 'file'
	  flag = false if( fileinfo['file'] !~ /#{q[1]}/i );
	when 'size'
	  q[1].gsub!( /kb?/i, '000' );
	  q[1].gsub( /mb?/i, '000000' );
	  q[1].gsub( /[^-\d]/, '' );
	  flag = false if( q[1] !~ /-/ && fileinfo['size'] != q[1].to_i );
	  flag = false if( q[1] =~ /-(\d+)/ && $1.to_i < fileinfo['size'] );
	  flag = false if( q[1] =~ /(\d+)-/ && fileinfo['size'] <  $1.to_i );
	when 'ctime'
	  q[1].gsub!( /[^-\d]/, '' );
	  if( q[1] !~ /-/ ) then
	    t = q[1].scan( /\d{2}/ ).collect{ |a| a.to_i; };
	    ctime = Time.local( t[ 0 ], t[ 1 ], t[ 2 ], t[ 3 ], t[ 4 ], t[ 5 ] );
	    flag = false if( fileinfo['ctime'] != ctime );
	  end
	  if( q[1] =~ /-(\d+)/ ) then
	    t = $1.scan( /\d{2}/ ).collect{ |a| a.to_i; };
	    ctime = Time.local( t[ 0 ], t[ 1 ], t[ 2 ], t[ 3 ], t[ 4 ], t[ 5 ] );
	    flag = false if( ctime < fileinfo['ctime'] );
	  end
	  if(  q[1] =~ /(\d+)-/ ) then
	    t = $1.scan( /\d{2}/ ).collect{ |a| a.to_i; };
	    ctime = Time.local( t[ 0 ], t[ 1 ], t[ 2 ], t[ 3 ], t[ 4 ], t[ 5 ] );
	    flag = false if( fileinfo['ctime'] < ctime );
	  end
	when 'comment'
	  flag = false if( fileinfo['comment'] !~ /#{q[1]}/i );
	end
      }
      return( flag );
    end
    
    def make_thumbnail( imgpath )
      file = File::basename( imgpath );
      thumbpath = "#{@server.config[:DataDir]}/#{THUMBDIR}/#{file}";
      thumburl = "/data/#{THUMBDIR}/#{file}";
      if( !File::exist?( imgpath ) ) then return( nil ); end
      if( File::exist?( thumbpath ) ) then return( thumburl ); end
      if( imgpath =~ /\.jpg/ ) then
	img1 = GD::Image.new_from_jpeg( imgpath );
      elsif( imgpath =~ /\.png/ ) then
	img1 = GD::Image.new_from_png( imgpath );
      else
	return( nil );
      end
      defwidth = 100;  defheight = 100;
      width = img1.width; height = img1.height; 
      if( defwidth < width ) then
	height = img1.height*(defwidth/img1.width.to_f);
	width = defwidth;
      end
      if( defheight < height ) then
	# よ〜っく考えよ〜 順番は大事だよ〜 う〜う
	width = width*(defheight/height.to_f);
	height = defheight;
      end
      ### リサイズ画像用 Image インスタンス
      img2 = GD::Image.new( width, height );
      ## img1をリサイズしてimg2に張り付け
      img1.copyResized( img2, 0, 0, 0, 0, img2.width, img2.height, img1.width, img1.height );
      ## リサイズしたjpegファイルを作成
      open( thumbpath, "w" ) { |io| img2.jpeg( io, 100 ); }
      return( thumburl );
    end
    private :make_thumbnail;

  end
  
end
