{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: InvitationForm

 Channel invitation window

*********************************************************}
unit InvitationForm;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Classes;

type
  TSlavaNapInvitation = class(TForm)
    Panel1: TPanel;
    Btn_Accept: TButton;
    Btn_Deny: TButton;
    Btn_Whois: TButton;
    Btn_Message: TButton;
    Btn_Hotlist: TButton;
    Label1: TLabel;
    Lbl_Channel: TLabel;
    Lbl_Topic: TLabel;
    Edit_Channel: TEdit;
    Edit_Topic: TEdit;
    Btn_Ignore: TButton;
    procedure FormCreate(Sender: TObject);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure FormShow(Sender: TObject);
    procedure Btn_AcceptClick(Sender: TObject);
    procedure Btn_DenyClick(Sender: TObject);
    procedure Btn_WhoisClick(Sender: TObject);
    procedure Btn_MessageClick(Sender: TObject);
    procedure Btn_HotlistClick(Sender: TObject);
    procedure Btn_IgnoreClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    User, Channel, Topic: string;
  end;

var
  SlavaNapInvitation: TSlavaNapInvitation;

implementation

uses Lang, Constants, Console, MainForm, Vars, STypes, Languages;

{$R *.DFM}

procedure TSlavaNapInvitation.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.ExStyle := Params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapInvitation.FormCreate(Sender: TObject);
var
  R: TRect;
begin
  SystemParametersInfo(SPI_GETWORKAREA, 0, @R, 0);
  Top := (R.Top + R.Bottom - Height) div 2;
  Left := (R.Right + R.Left - Width - 4) div 2;
end;

procedure TSlavaNapInvitation.FormShow(Sender: TObject);
var
  R: TRect;
  I, J: Integer;
begin
  SystemParametersInfo(SPI_GETWORKAREA, 0, @R, 0);
  Top := (R.Top + R.Bottom - Height) div 2;
  Left := (R.Right + R.Left - Width - 4) div 2;
  SetFont(Self.Font);
  Caption := GetLangI(LNG_INV_CAPTION);
  Lbl_Channel.Caption := GetLangI(LNG_INV_NAME);
  Lbl_Topic.Caption := GetLangI(LNG_INV_TOPIC);
  I := Max(Lbl_Channel.Width, Lbl_Topic.Width) + 16;
  Edit_Channel.Left := I;
  Edit_Topic.Left := I;
  Edit_Channel.Text := Channel;
  Edit_Topic.Text := Topic;
  Btn_Accept.Caption := GetLangI(LNG_INV_ACCEPT);
  Btn_Accept.Width := Canvas.TextWidth(Btn_Accept.Caption) + 20;
  I := Btn_Accept.Left + Btn_Accept.Width + 8;
  Btn_Deny.Caption := GetLangI(LNG_INV_DENY);
  Btn_Deny.Width := Canvas.TextWidth(Btn_Deny.Caption) + 25;
  Btn_Deny.Left := I;
  Inc(I, Btn_Deny.Width + 8);
  Btn_Whois.Caption := GetLangI(LNG_INV_WHOIS);
  Btn_Whois.Width := Canvas.TextWidth(Btn_Whois.Caption) + 25;
  Btn_Whois.Left := I;
  Inc(I, Btn_Whois.Width + 8);
  Btn_Message.Caption := GetLangI(LNG_INV_PRIVMSG);
  Btn_Message.Width := Canvas.TextWidth(Btn_Message.Caption) + 25;
  Btn_Message.Left := I;
  Inc(I, Btn_Message.Width + 8);
  Btn_Hotlist.Caption := GetLangI(LNG_INV_HOTLIST);
  Btn_Hotlist.Width := Canvas.TextWidth(Btn_Hotlist.Caption) + 25;
  Btn_Hotlist.Left := I;
  Inc(I, Btn_Hotlist.Width + 8);
  Btn_Ignore.Caption := GetLangI(LNG_INV_IGNORE);
  Btn_Ignore.Width := Canvas.TextWidth(Btn_Ignore.Caption) + 25;
  Btn_Ignore.Left := I;
  Inc(I, Btn_Ignore.Width + 8);
  ClientWidth := I;
  Panel1.Width := ClientWidth - 16;
  Edit_Channel.Width := Panel1.Width - Edit_Channel.Left - 10;
  Edit_Topic.Width := Panel1.Width - Edit_Topic.Left - 10;
  Label1.Caption := GetLangI(LNG_INV_MESSAGE, User);
  Label1.Left := (Width - Label1.Width) div 2;
end;

procedure TSlavaNapInvitation.Btn_AcceptClick(Sender: TObject);
begin
  if not Running then Exit;
  Close;
  Cmd_List.AddDoubleCmd(MSG_CLIENT_CHANNEL_INVITE_ACCEPT, 0, '', '');
  Cmd_List.AddDoubleCmd(MSG_CLIENT_JOIN, 0, Channel, '');
end;

procedure TSlavaNapInvitation.Btn_DenyClick(Sender: TObject);
begin
  if not Running then Exit;
  Close;
  Cmd_List.AddDoubleCmd(MSG_CLIENT_CHANNEL_INVITE_DECLINE, 0, '', '');
end;

procedure TSlavaNapInvitation.Btn_WhoisClick(Sender: TObject);
begin
  if not Running then Exit;
  Cmd_List.AddDoubleCmd(MSG_CLIENT_WHOIS, 0, User, '');
end;

procedure TSlavaNapInvitation.Btn_MessageClick(Sender: TObject);
begin
  if Running then
    SlavaNapWindow.CreateChatWindow(User);
end;

procedure TSlavaNapInvitation.Btn_HotlistClick(Sender: TObject);
begin
  if not Running then Exit;
  Cmd_List.AddDoubleCmd(MSG_CLIENT_ADD_HOTLIST, 0, User, '');
end;

procedure TSlavaNapInvitation.Btn_IgnoreClick(Sender: TObject);
begin
  if not Running then Exit;
  Close;
  Cmd_List.AddDoubleCmd(MSG_CLIENT_IGNORE_USER, 0, User, '');
end;

end.
