{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: ServerAttr

 Server attributes window

*********************************************************}
unit ServerAttr;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, Classes;

type
  TSlavaNapServerAttr = class(TForm)
    Btn_Ok: TButton;
    Btn_Cancel: TButton;
    Lbl_Host: TLabel;
    Edit_Host: TEdit;
    Lbl_Port: TLabel;
    Box_Auth: TGroupBox;
    Edit_Port: TSpinEdit;
    Cb_Auth_Resolve: TRadioButton;
    Edit_Ip: TEdit;
    Lbl_Ip: TLabel;
    Lbl_Ipinfo: TLabel;
    Cb_Auth_Password: TRadioButton;
    Lbl_Auth_Mypass: TLabel;
    Lbl_Auth_Remotepass: TLabel;
    Edit_Mypass: TEdit;
    Edit_Remotepass: TEdit;
    Box_Compress: TGroupBox;
    Cb_Comp_0: TRadioButton;
    Cb_Comp_1: TRadioButton;
    Cb_Comp_2: TRadioButton;
    Cb_Comp_3: TRadioButton;
    Cb_Relink: TCheckBox;
    Edit_Relink: TSpinEdit;
    Lbl_Comments: TLabel;
    Edit_Comments: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Btn_CancelClick(Sender: TObject);
    procedure Btn_OkClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Server: string;
    procedure ShowServer(Str: string);
  end;

var
  SlavaNapServerAttr: TSlavaNapServerAttr;

implementation

uses
  Servers, STypes, Vars, MainForm, ZLibEx, Lang, Constants, Languages;

{$R *.DFM}

procedure TSlavaNapServerAttr.FormCreate(Sender: TObject);
var
  R: TRect;
begin
  SystemParametersInfo(SPI_GETWORKAREA, 0, @R, 0);
  Top := (R.Top + R.Bottom - Height) div 2;
  Left := (R.Right + R.Left - Width - 4) div 2;
end;

procedure TSlavaNapServerAttr.FormShow(Sender: TObject);
var
  I, J: Integer;
begin
  SetFont(Self.Font);
  Caption := GetLangI(LNG_EDITSRV_CAPTION, Server);
  Lbl_Host.Caption := GetLangI(LNG_EDITSRV_HOST);
  Lbl_Port.Caption := GetLangI(LNG_EDITSRV_PORT);
  Lbl_Ipinfo.Caption := GetLangI(LNG_EDITSRV_IPINFO);
  Lbl_Ip.Caption := GetLangI(LNG_EDITSRV_IPTEXT);
  Box_Auth.Caption := ' ' + GetLangI(LNG_EDITSRV_BOX) + ' ';
  Cb_Auth_Resolve.Caption := GetLangI(LNG_EDITSRV_RESOLVE);
  Cb_Auth_Password.Caption := GetLangI(LNG_EDITSRV_PASSWORD);
  Lbl_Auth_Mypass.Caption := GetLangI(LNG_EDITSRV_MYPASS);
  Lbl_Auth_Remotepass.Caption := GetLangI(LNG_EDITSRV_REMOTEPASS);
  Box_Compress.Caption := ' ' + GetLangI(LNG_EDITSRV_BOX2) + ' ';
  Cb_Comp_0.Caption := GetLangI(LNG_EDITSRV_COMP0);
  Cb_Comp_1.Caption := GetLangI(LNG_EDITSRV_COMP1);
  Cb_Comp_2.Caption := GetLangI(LNG_EDITSRV_COMP2);
  Cb_Comp_3.Caption := GetLangI(LNG_EDITSRV_COMP3);
  Lbl_Comments.Caption := GetLangI(LNG_EDITSRV_COMMENTS);
  Cb_Relink.Caption := GetLangI(LNG_EDITSRV_RELINK);
  Btn_Ok.Caption := GetLangI(LNG_EDITSRV_OK);
  Btn_Cancel.Caption := GetLangI(LNG_EDITSRV_CANCEL);
  I := Max(Lbl_Host.Width, Lbl_Port.Width) + Lbl_Host.Left + 8;
  J := Edit_Host.Left + Edit_Host.Width; // Right Border
  Edit_Host.Left := I;
  Edit_Host.Width := J - I;
  Edit_Port.Left := I;
  Edit_Port.Width := J - I;
  I := Lbl_Ip.Left + Lbl_Ip.Width + 8;
  Edit_Ip.Left := I;
  Edit_Ip.Width := J - I;
  I := Lbl_Comments.Left + Lbl_Comments.Width + 8;
  Edit_Comments.Left := I;
  Edit_Comments.Width := J - I;
  I := Canvas.TextWidth(Cb_Relink.Caption) + 20;
  Cb_Relink.Width := I;
  Inc(I, Cb_Relink.Left + 8);
  Edit_Relink.Left := I;
  Edit_Relink.Width := J - I;
  J := Edit_Mypass.Left + Edit_Mypass.Width;
  I := Max(Lbl_Auth_Mypass.Width, Lbl_Auth_Remotepass.Width) +
    Lbl_Auth_Mypass.Left + 8;
  Edit_Mypass.Left := I;
  Edit_Mypass.Width := J - I;
  Edit_Remotepass.Left := I;
  Edit_Remotepass.Width := J - I;
end;

procedure TSlavaNapServerAttr.ShowServer(Str: string);
var
  Srv: TServer;
begin
  try
    Hide;
  except
  end;
  if not Running then Exit;
  Server := Str;
  Srv := FindServer(Str, False);
  if Srv = nil then Exit;
  Edit_Host.Text := Srv.Host;
  Edit_Port.Value := Srv.Port;
  Edit_Ip.Text := Srv.Forced_Ip;
  if Srv.Authentication = authPassword then
    Cb_Auth_Password.Checked := True
  else
    Cb_Auth_Resolve.Checked := True;
  Edit_Mypass.Text := Srv.MyPassword;
  Edit_Remotepass.Text := Srv.RemotePassword;
  case Srv.Compress of
    zcMax: Cb_Comp_3.Checked := True;
    zcDefault: Cb_Comp_2.Checked := True;
    zcFastest: Cb_Comp_1.Checked := True;
  else
    Cb_Comp_0.Checked := True;
  end;
  Cb_Relink.Checked := Srv.Relink > 0;
  Edit_Relink.Value := Srv.Relink div 60000;
  Edit_Comments.Text := Srv.Comments;
  if Srv.Connected = conNotConnected then
  begin
    Edit_Host.ReadOnly := False;
    Edit_Port.ReadOnly := False;
  end
  else
  begin
    Edit_Host.ReadOnly := True;
    Edit_Port.ReadOnly := True;
  end;
  try
    Show;
    if Srv.Connected = conNotConnected then
      Edit_Host.SetFocus
    else
      Edit_Ip.SetFocus;
  except
  end;
end;

procedure TSlavaNapServerAttr.Btn_CancelClick(Sender: TObject);
begin
  Close;
end;

procedure TSlavaNapServerAttr.Btn_OkClick(Sender: TObject);
begin
  Hide;
  if not Running then Exit;
  Cmd_List.AddDoubleCmd(MSG_CMD_UPDATESERVERPROPS, 0, Server, '');
end;

end.
