{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: WhoisForm

 Whois window

*********************************************************}
unit WhoisForm;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls, ComCtrls, Classes;

type
  TSlavaNapWhois = class(TForm)
    MainMenu1: TMainMenu;
    Mnu_Close: TMenuItem;
    Mnu_Hotlist: TMenuItem;
    Mnu_Friend: TMenuItem;
    Mnu_Ignore: TMenuItem;
    Mnu_Message: TMenuItem;
    Panel1: TPanel;
    Log: TRichEdit;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure Mnu_Draw(Sender: TObject; ACanvas: TCanvas; ARect: TRect;
      Selected: Boolean);
    procedure Mnu_CloseClick(Sender: TObject);
    procedure Mnu_HotlistClick(Sender: TObject);
    procedure Mnu_FriendClick(Sender: TObject);
    procedure Mnu_IgnoreClick(Sender: TObject);
    procedure Mnu_MessageClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    User: string;
  end;

implementation

uses Lang, STypes, Vars, MainForm, Constants, SlavaMenu, Languages;

{$R *.DFM}

procedure TSlavaNapWhois.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TSlavaNapWhois.FormCreate(Sender: TObject);
var
  R: TRect;
begin
  SystemParametersInfo(SPI_GETWORKAREA, 0, @R, 0);
  Top := (R.Top + R.Bottom - Height) div 2;
  Left := (R.Right + R.Left - Width - 4) div 2;
  SetFont(Self.Font);
  Log.Lines.Clear;
  Log.Color := slBackground;
  Log.Font.Color := slText;
end;

procedure TSlavaNapWhois.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.ExStyle := Params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapWhois.Mnu_Draw(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
begin
  SlavaDrawMainMenu(Self, Sender, ACanvas, ARect, Selected);
end;

procedure TSlavaNapWhois.Mnu_CloseClick(Sender: TObject);
begin
  Close;
end;

procedure TSlavaNapWhois.Mnu_HotlistClick(Sender: TObject);
begin
  if Running then
    Cmd_List.AddDoubleCmd(MSG_CLIENT_ADD_HOTLIST, 0, User, '');
end;

procedure TSlavaNapWhois.Mnu_FriendClick(Sender: TObject);
begin
  if Running then
    Cmd_List.AddDoubleCmd(MSG_CLIENT_FRIENDS, 0, 'Add ' + User, '');
end;

procedure TSlavaNapWhois.Mnu_IgnoreClick(Sender: TObject);
begin
  if Running then
    Cmd_List.AddDoubleCmd(MSG_CLIENT_IGNORE_USER, 0, User, '');
end;

procedure TSlavaNapWhois.Mnu_MessageClick(Sender: TObject);
begin
  if Running then
    SlavaNapWindow.CreateChatWindow(User);
end;

procedure TSlavaNapWhois.FormDestroy(Sender: TObject);
var
  I: Integer;
begin
  if Cons_Whois <> nil then
    for I := Cons_Whois.Count - 1 downto 0 do
      if Cons_Whois.Items[I] = Self then
        Cons_Whois.Delete(I);
end;

end.
