{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by CyberAlien@users.sourceforge.net
 Released under GNU General Public License

 Latest version is available at
 http://slavanap2.sourceforge.net

**********************************************************

 Unit: handler

 Handlers for all client-server and server-server messages

*********************************************************}
unit handler;

interface

uses
 SysUtils, Classes, graphics, zlib, slavasplitter, slavapanel, winsock, windows,
 constants, users, servers, stypes, blcksock, synsock, localusers, registered,
 slavastrings, class_cmdlist, class_cmdexlist, local2global;

function ProcessCommand(usr: TLocalUser; q: TQuery=queryNormal): Boolean;
procedure ProcessServerCommand(srv: TServer);
procedure DisconnectUser(usr: TLocalUser; reason, text, sender: String;close_socket: Boolean);
procedure KickUser(user: POnlineUser;msg: String);
procedure DisconnectServer(srv: TServer; inform_servers, do_wallop: Boolean; sender: String);
procedure Exec(usr: POnlineUser; id: Integer; cmd: String);
procedure WriteAllServersEx(srv: TServer;id: Integer; sender,cmd: String);
function WriteAllServers(id: Integer; sender,cmd: String; ignored: TServer=nil): Integer;
function FormatString(user: POnlineUser; str: String; strip_quotes: Boolean): String;
procedure Wallop(id: Integer; wid: TWallopType; cmd: String; local_only: Boolean);
procedure Error(str: String; check_permission: Boolean=false);
procedure PermissionDenied(func: String; check_permission: Boolean=false);
procedure CountStats;
procedure CompleteSyncUser(srv: TServer; user: POnlineUser);
procedure Handler_JoinChannel;
procedure UpdateUser(user: POnlineUser; ignored: TServer=nil);
procedure Handler_ServerConnect(srv: TServer; timer: Boolean);
procedure BanUser(ban,server: String;time: Integer; reason: String; write_all: Boolean);
procedure AddReconnector(ip: String);

var
 gcmd: TNapCmd;

implementation

{$I defines.pas}

uses
 lang, vars, share, thread, channels, bans, config, md5, memory_manager;

var
 hlist,hlst: TStringList;
 user: POnlineUser;
 server: TServer;
 local: TLocalUser;
 query: TQuery;
 query_channel: String;
 search_data: TSearchStruct;
 search_data_old: TSearchStruct;
 compressed: Boolean;

function FindLocalUser(data: POnlineUser): TLocalUser; overload;
var
 i: Integer;
begin
 Result:=nil;
 if data=nil then exit;
 if data^.server<>nil then exit;
 try
   if (local<>nil) and (local.data=data) then Result:=local
   else for i:=0 to db_local.Count-1 do
   if TLocalUser(db_local.Items[i]).data=data then
   begin
    Result:=db_local.Items[i];
    exit;
   end;
  except
 end  
end;

function FindLocalUser(nick: String): TLocalUser; overload;
var
 i: Integer;
begin
 Result:=nil;
 nick:=AnsiLowerCase(nick);
 try
   if (local<>nil) and (AnsiLowerCase(local.nick)=nick) then Result:=local
   else for i:=0 to db_local.Count-1 do
   if AnsiLowerCase(TLocalUser(db_local.Items[i]).nick)=nick then
   begin
    Result:=db_local.Items[i];
    exit;
   end;
  except
 end
end;

procedure Exec(usr: POnlineUser; id: Integer; cmd: String);
var
 user2: TLocalUser;
begin
 if usr=nil then exit;
 try
   if usr^.server=nil then
   begin
    if (local<>nil) and (local.data=usr) then user2:=local
    else user2:=FindLocalUser(usr);
    if user2<>nil then user2.Exec(id,cmd);
    exit;
   end;
   usr^.server.Exec(MSG_CLIENT_RELAY,IntToStr(id)+' '+usr^.nick+' '+cmd);
  except
 end;  
end;

function CanSendError(usr: POnlineUser;q: TQuery): Boolean;
begin
 case q of
  queryServer: Result:=false;
  queryOperServ, queryChanServ, queryNickServ, queryMsgServ, queryChannel: Result:=true;
  else if usr=nil then Result:=true
       else Result:=not (userHideErrors in usr^.state);
 end;
end;

procedure Error(str: String; check_permission: Boolean=false);
begin
 if user=nil then exit;
 if check_permission then
  if not CanSendError(user,query) then exit;
 case query of
   queryOperServ:  Exec(user,MSG_SERVER_PRIVMSG,'OperServ '+str);
   queryNickServ:  Exec(user,MSG_SERVER_PRIVMSG,'NickServ '+str);
   queryChanServ:  Exec(user,MSG_SERVER_PRIVMSG,'ChanServ '+str);
   queryMsgServ:   Exec(user,MSG_SERVER_PRIVMSG,'MsgServ '+str);
   queryChannel:   Exec(user,MSG_SERVER_PUBLIC,query_channel+' Server '+str);
   queryRemoteUser,
   queryServer: begin end;
   else Exec(user,MSG_SERVER_NOSUCH,str);
 end;
end;

procedure PermissionDenied(func: String; check_permission: Boolean=false);
begin
 if func='' then Error('permission denied',check_permission)
 else Error(func+': permission denied',check_permission);
end;

procedure UserIsOffline(str: String; check_permission: Boolean=false);
begin
 Error(GetLangT(LNG_OFFLINE2,str),check_permission);
end;

procedure NoSuchUser(check_permission: Boolean=false);
begin
 Error(GetLangT(LNG_NOUSER),check_permission);
end;

function CheckRange(num: String; min,max: Integer): Boolean;
var
 n: Integer;
begin
 n:=StrToIntDef(num,min-1);
 Result:=(n>=min) and (n<=max);
end;

function CheckRangeEx(num: String; min,max: Integer): Boolean;
var
 n: Integer;
begin
 n:=StrToIntDef(num,min-1);
 Result:=(n>=min) and (n<=max);
 if Result=false then
  Error(GetLangT(LNG_INVALIDARGS),true);
end;

function CheckParams(count: Integer; show_error: Boolean=true): Boolean;
begin
 SplitString(gcmd.cmd,hlist);
 if hlist.Count<count then
 begin
  Result:=false;
  if query<>queryServer then
   if show_error then
    Error(GetLangT(LNG_INVALIDARGS),true);
 end
 else
  Result:=true;
end;

function CheckParamsEx(count: Integer): Boolean;
begin
 SplitStringEx(gcmd.cmd,hlist);
 if hlist.Count<count then
 begin
  Result:=false;
  Error(GetLangT(LNG_INVALIDARGS),true);
 end
 else
  Result:=true;
end;

function CheckLevel(func: String;lev: TNapUserLevel): Boolean;
begin
 if user=nil then
 begin
   Result:=false;
   exit;
 end;
 if user^.level<lev then
 begin
   Result:=false;
   PermissionDenied(func,true);
 end
 else
   Result:=true;
end;

function isLogged: Boolean;
begin
 Result:=user<>nil;
end;

function isLocal: Boolean;
begin
 Result:=local<>nil;
end;

procedure AddSoftware(str: String);
var
 i: Integer;
 str1: String;
begin
  str1:=Trim(AnsiLowerCase(str));
  if db_software=nil then exit;
  for i:=0 to db_software.Count-1 do
   if AnsiLowerCase(PNapCmd(db_software.Items[i])^.cmd)=str1 then
   begin
    PNapCmd(db_software.Items[i])^.id:=PNapCmd(db_software.Items[i])^.id+1;
    exit;
   end;
  if db_software.count>MAX_SOFTWARE_INDEX then
  begin
    i:=0;
    while i<db_software.count do
    begin
     if PNapCmd(db_software.Items[i])^.id<2 then db_software.Delete(i)
     else inc(i);
    end;
    exit;
  end;
  if db_software.count>MAX_SOFTWARE_INDEX then exit;
  db_software.AddCmd(1,str);
end;

procedure BlockCQEXChat(var str: String);
begin
  if pos('<',str)<1 then exit;
  if pos('>',str)<1 then exit;
  ReplaceString(str,'<b>','');
  ReplaceString(str,'</b>','');
  ReplaceString(str,'<c>','');
  ReplaceString(str,'</c>','');
  ReplaceString(str,'<u>','');
  ReplaceString(str,'</u>','');
  ReplaceString(str,'<inverse>','');
  ReplaceString(str,'</inverse>','');
  ReplaceString(str,'<underline>','');
  ReplaceString(str,'</underline>','');
  ReplaceString(str,'<bold>','');
  ReplaceString(str,'</bold>','');
  ReplaceString(str,'<white>','');
  ReplaceString(str,'<black>','');
  ReplaceString(str,'<navy>','');
  ReplaceString(str,'<green>','');
  ReplaceString(str,'<red>','');
  ReplaceString(str,'<maroon>','');
  ReplaceString(str,'<purple>','');
  ReplaceString(str,'<orange>','');
  ReplaceString(str,'<yellow>','');
  ReplaceString(str,'<lime>','');
  ReplaceString(str,'<teal>','');
  ReplaceString(str,'<aqua>','');
  ReplaceString(str,'<blue>','');
  ReplaceString(str,'<fuchsia>','');
  ReplaceString(str,'<gray>','');
  ReplaceString(str,'<silver>','');
end;

function WriteAllServers(id: Integer; sender,cmd: String; ignored: TServer=nil): Integer;
var
 i,num: Integer;
 srv: TServer;
 str: String;
begin
 tmp_pos:=100;
 if sender='' then
  str:=cmd
 else if cmd<>'' then
  str:=sender+' '+cmd
 else
  str:=sender;
 str:=IntToStr(id)+' '+IntToStr(myserverhandle)+' '+str;
 num:=0;
 ignored:=GetServerLink(ignored);
 tmp_pos:=101;
 for i:=0 to db_servers.Count-1 do
 begin
   srv:=db_servers.Items[i];
   if srv<>ignored then
   if srv.logged then
   if srv.hub=nil then
   begin
    srv.Exec(MSG_SRV_FORWARDALL,str);
    inc(num);
   end;
 end;
 Result:=num;
 tmp_pos:=102;
end;

procedure WriteAllServersEx(srv: TServer;id: Integer; sender,cmd: String);
var
 str: String;
begin
 tmp_pos:=110;
 if sender='' then
  str:=cmd
 else if cmd<>'' then
  str:=sender+' '+cmd
 else
  str:=sender;
 str:=IntToStr(id)+' '+IntToStr(myserverhandle)+' '+str;
 tmp_pos:=111;
 srv:=GetServerLink(srv);
 tmp_pos:=112;
 if srv.logged then
 if srv.hub=nil then
  srv.Exec(MSG_SRV_FORWARDALL,str);
 tmp_pos:=113; 
end;

procedure Handler_Stats;
begin
 if user<>nil then
  Exec(user,MSG_SERVER_STATS,IntToStr(total_users)+' '+IntToStr(total_files)+' '+IntToStr(total_bytes div 1073741824)); // +' GB '+IntToStr(user^.shared)
end;

procedure Wallop(id: Integer; wid: TWallopType; cmd: String; local_only: Boolean);
var
 i: Integer;
 user2: TLocalUser;
 b: Boolean;
begin
 tmp_pos:=120;
 for i:=0 to db_local.count-1 do
 begin
   user2:=db_local.Items[i];
   if user2.logged then
    if user2.data^.level>napUserUser then
    begin
     b:=false;
     case wid of
       wallopWallop:   b:=userHideWallop in user2.data^.state;
       wallopBan:      b:=userHideBans in user2.data^.state;
       wallopChange:   b:=userHideChange in user2.data^.state;
       wallopKill:     b:=userHideKill in user2.data^.state;
       wallopLevel:    b:=userHideLevel in user2.data^.state;
       wallopServer:   b:=userHideServer in user2.data^.state;
       wallopMuzzle:   b:=userHideMuzzle in user2.data^.state;
       wallopPort:     b:=userHidePort in user2.data^.state;
       wallopCloak:    b:=userHideCloak in user2.data^.state;
       wallopFlood:    b:=userHideFlood in user2.data^.state;
       wallopPing:     b:=userHidePing in user2.data^.state;
       wallopWhois:    b:=userHideWhois in user2.data^.state;
       wallopFriends:  b:=userHideFriends in user2.data^.state;
       wallopAnnouncement: b:=userHideAnnouncements in user2.data^.state;
       wallopChannel:  b:=userHideChannel in user2.data^.state;
       wallopRegister: b:=userHideRegister in user2.data^.state;
       wallopVar:      b:=userHideVar in user2.data^.state;
       wallopMotd:     b:=userHideMotd in user2.data^.state;
     end;
     if not b then
      user2.Exec(id,cmd);
    end;
 end;
 tmp_pos:=121;
 if not local_only then WriteAllServers(MSG_SRV_WALLOP,IntToStr(id)+' '+IntToStr(Ord(wid)),cmd);
end;

procedure RegisterUser(user: POnlineUser);
var
 reg: TRegisteredUser;
 preg: PRegisteredUser;
begin
 reg.nick:=user^.nick;
 reg.password:=user^.password;
 reg.level:=user^.level;
 reg.downloads:=user^.total_down;
 reg.uploads:=user^.total_up;
 reg.last_ip:=user^.ip;
 reg.last_seen:=GetTickCountT;
 reg.state:=user^.state - [userChatting];
 preg:=db_registered.FindUser(user^.nick);
 if preg<>nil then db_registered.Delete(user^.nick);
 db_registered.Add(reg);
end;

procedure UserDisconnected(user: POnlineUser);
var
 str: String;
 i: Integer;
 cmd: TNapCmdEx;
begin
 tmp_pos:=1253;
 str:=AnsiLowerCase(user^.nick);
 i:=db_whowas.FindByCmd(str);
 if i<>-1 then db_whowas.Delete(i);
 tmp_pos:=1254;
 cmd.cmd:=str;
 cmd.data:=AddStr(user^.nick)+' '+AddStr(Level2Str(user^.level))+' '+IntToStr(GetTickCountT)+' '+
    IntToStr(user^.ip)+' '+AddStr(GetServerName(user^.server))+' '+AddStr(user^.software);
 tmp_pos:=1255;
 cmd.id:=user^.ip;
 tmp_pos:=1256;
 db_whowas.Add(cmd);
end;

procedure UserOnline(usr: TLocalUser; mail: String='');
var
 i: Integer;
 user2: TLocalUser;
 l: TNapUserLevel;
 str: String;
begin
 tmp_pos:=130;
 if usr.data=nil then exit;
 usr.last_seen:=GetTickCount;
 usr.data.last_seen:=GetTickCountT;
 CompleteSyncUser(nil,usr.data);
 CheckSync;
 tmp_pos:=131;
 if running and log_login then
 begin
  if mail='' then
   log(slOnline,GetLangT(LNG_USERONLINE,usr.nick,usr.software,decode_ip(usr.ip)))
  else
   log(slOnline,GetLangT(LNG_USERREGISTER,usr.nick,usr.software,decode_ip(usr.ip),mail));
 end;
 tmp_pos:=132;
  if usr.level>napUserUser then
  begin
   usr.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_LEVEL,servername_t,Level2Str(usr.level),Ord(usr.level)));
   l:=usr.level;
   usr.data^.level:=napUserUser; // to avoid sending this message to usr
   Wallop(MSG_SERVER_NOSUCH,wallopLevel,GetLangT(LNG_LEVEL1,servername_t,usr.nick,Level2Str(l),IntToStr(Ord(l))),false);
   usr.data^.level:=l;
  end;
  tmp_pos:=133;
  inc(local_users);
  local_users_max:=max(local_users,local_users_max);
  inc(total_connections);
  inc(total_users);
  if total_users>total_users_max then total_users_max:=total_users;
  tmp_pos:=134;
  for i:=0 to db_local.count-1 do
  begin
   user2:=db_local.Items[i];
   if user2<>usr then
   begin
    str:=StrHash_FindStringEx(user2.hotlist,usr.nick,true);
    if str<>'' then
     user2.Exec(MSG_SERVER_USER_SIGNON,str+' '+IntToStr(Ord(usr.data^.speed)));
   end;
  end;
  tmp_pos:=135;
  usr.localstate:=usr.localstate-[locNeedsUpdate];
  Handler_Stats;
end;

procedure UserOffline(usr: TLocalUser; reason: String; off_message: String; sender: String);
var
 preg: PRegisteredUser;
 i: Integer;
 b,cloaked: Boolean;
 user2: TLocalUser;
 ch: TChannel;
 str: String;
begin
 try
   tmp_pos:=140;
   if usr=cons then
    if running then
     exit;
   tmp_pos:=141;
   if (usr.data<>nil) and (usr.nick<>'') then
   begin
    dec(total_users);
    dec(local_users);
    tmp_pos:=1250;
    UserDisconnected(usr.data);
    tmp_pos:=1251;
    WriteAllServers(MSG_SRV_USEROFFLINE,usr.nick,'');
    tmp_pos:=142;
    if db_channels<>nil then
    for i:=db_channels.count-1 downto 0 do
    begin
      ch:=db_channels.Items[i];
      if ch.FindUser(usr.data)<>-1 then
      begin
       ch.Part(usr.data);
       if ch.users.count=0 then
        if not (chRegistered in ch.state) then
        begin
         db_channels.Delete(i);
         ch.Free;
        end;
      end;
    end;
    cloaked:=userCloaked in usr.data^.state;
    tmp_pos:=143;
    if usr.shared<>nil then
    begin
      tmp_pos:=1204;
      dec(local_files,usr.data^.shared);
      dec(local_bytes,usr.shared_size);
      dec(total_files,usr.data^.shared);
      dec(total_bytes,usr.shared_size);
      tmp_pos:=1205;
      usr.shared_size:=0;
      usr.shared_mp3:=0;
      usr.shared_audio:=0;
      usr.shared_video:=0;
      usr.shared_images:=0;
      usr.shared_apps:=0;
      usr.shared_text:=0;
      usr.shared_cd:=0;
      tmp_pos:=1206;
      usr.shared.Clear;
      tmp_pos:=1207;
      FreeShareList(usr.shared);
      tmp_pos:=1208;
      usr.shared:=nil;
    end;
    tmp_pos:=144;
    b:=registered_only;
    if b=false then
    begin
      if userMuzzled in usr.data^.state then b:=true;
      if usr.level<>napUserUser then b:=true;
    end;
    preg:=db_registered.FindUser(usr.nick);
    if preg<>nil then b:=true;
    if usr.data^.level=napUserConsole then
    begin
     if preg<>nil then db_registered.Delete(usr.data^.nick);
     b:=false;
    end;
    tmp_pos:=145;
    if b then RegisterUser(usr.data);
    tmp_pos:=146;
    if running and log_login then
    begin
     if off_message<>'' then
      log(slOffline,off_message)
     else
     begin
       if reason='' then
        log(slOffline,GetLangT(LNG_USEROFFLINE2,usr.nick,usr.software))
       else
        log(slOffline,GetLangT(LNG_USEROFFLINE,usr.nick,usr.software,reason,sender));
     end;
    end;
    tmp_pos:=147;
    for i:=0 to db_local.count-1 do
    begin
     user2:=db_local.Items[i];
     if user2.logged then
     if user2<>usr then
     if (not cloaked) or (user2.level>napUserUser) then
     begin
      str:=StrHash_FindStringEx(user2.hotlist,usr.nick,true);
      if str<>'' then
       user2.Exec(MSG_SERVER_USER_SIGNOFF,str);
     end;
    end;
    tmp_pos:=148;
    StrHash_Clear(usr.hotlist);
    StrHash_Clear(usr.ignored);
   end;
   tmp_pos:=149;
   if usr.data<>nil then
   begin
     db_online.Delete(usr.data^.nick);
     usr.data:=nil;
   end;
  except
   on E:Exception do
    DebugLog('Exception in UserOffline (pos='+IntToStr(tmp_pos)+') : '+E.Message);
  end;
end;

procedure DisconnectUser(usr: TLocalUser; reason, text, sender: String;close_socket: Boolean);
begin
 tmp_pos:=150;
 if usr=cons then
 begin
   DebugLog('Warning: someone tried to kick console user. (DisconnectUser arguments: reason="'+reason+'" text="'+text+'" sender="'+sender+'" cmd.id='+IntToStr(gcmd.id)+' cmd.cmd="'+gcmd.cmd+'" query='+IntToStr(Ord(query))+')');
   exit;
 end;
 tmp_pos:=151;
 UserOffline(usr, reason, text, 'DisconnectUser-'+sender);
 if close_socket then
   usr.last_seen:=0
 else
 begin
   usr.last_seen:=SetSocketCloseTime;
   usr.localstate:=usr.localstate+[locWriteOnly];
 end;
 tmp_pos:=152;
 if running and close_socket then
  TCPSocket_Free(usr.socket);
 tmp_pos:=153;
end;

procedure KickUser(user: POnlineUser;msg: String);
var
 preg: PRegisteredUser;
 i: Integer;
 b: Boolean;
 user2: TLocalUser;
 ch: TChannel;
 str: String;
begin
 tmp_pos:=160;
 if user=nil then exit;
 if user^.server=nil then
 begin
   user2:=FindLocalUser(user);
   if user2=nil then exit;
   if msg<>'' then
    user2.Exec(MSG_SERVER_NOSUCH,msg);
   DisconnectUser(user2,'','','KickUser',false);
   exit;
 end;
 tmp_pos:=161;
 UserDisconnected(user);
 if db_channels<>nil then
 for i:=db_channels.count-1 downto 0 do
 begin
  ch:=db_channels.Items[i];
  if ch.FindUser(user)<>-1 then
  begin
   ch.Part(user);
   if ch.users.count=0 then
    if not (chRegistered in ch.state) then
    begin
     db_channels.Delete(i);
     ch.Free;
    end;
  end;
 end;
 tmp_pos:=162;
 b:=registered_only;
 if b=false then
 begin
   if userMuzzled in user^.state then b:=true;
   if user^.level<>napUserUser then b:=true;
 end;
 tmp_pos:=163;
 preg:=db_registered.FindUser(user^.nick);
 if preg<>nil then b:=true;
 if user^.level=napUserConsole then
 begin
   b:=false;
   db_registered.Delete(user^.nick);
 end;
 if b then RegisterUser(user);
 tmp_pos:=164;
 for i:=0 to db_local.count-1 do
 begin
   user2:=db_local.Items[i];
   str:=StrHash_FindStringEx(user2.hotlist,user^.nick,true);
   if str<>'' then
    user2.Exec(MSG_SERVER_USER_SIGNOFF,str);
 end;
 tmp_pos:=165;
 db_online.Delete(user^.nick);
 tmp_pos:=166;
end;

function CountClones(ip: Cardinal): Integer;
begin
  Result:=db_online.CountClones(ip);
end;

function FormatString(user: POnlineUser; str: String; strip_quotes: Boolean): String;
begin
 // variables:
 //
 // $user$       - user's name
 // $server$     - server's name (server user is connected to)
 // $level$      - user's level
 // $levelnum$   - user's level as digit (0..4)
 // $client$     - user's software
 // $speed$      - user's connection speed
 // $minshare$   - minimum shared files
 // $maxshare$   - maximum shared files
 // $maxusers$   - user's limit
 // $maxusers_total$ - total user's limit (on all linked servers)
 // $version$    - server version
 // $build$      - server build
 // $console$    - console user's name
 // $users$      - number of users online
 // $users_local$ - number of local users
 // $files$      - total number of shared files (by all users)
 // $files_local$ - number of shared files only on this server
 // $files_ex$   - total number of shared files (by all users), but thousands are separated by dots (example: 12.345.678 instead of 12345678)
 // $files_local_ex$
 // $gb$         - size of shared files in Gb. (by all users)
 // $gb_ex$      - size of shared files in Gb using dots
 // $gb_local$   - size of shared files on this server
 // $gb_local_ex$ -
 // $servers$    - number of linked servers
 // $connections$ - number of connections
 // $memory$     - number of bytes used by application
 // $memory_ex$  - same as memory, but thousands are separated by dot.
 //

 tmp_pos:=170;
 if strip_quotes then
  ReplaceString(str,'"','`');
 // $user$
 if pos('$user$',str)>0 then
 if user<>nil then
  ReplaceString(str,'$user$',user^.nick)
 else
  ReplaceString(str,'$user$','<unknown>');
 // $server$
 if pos('$server$',str)>0 then
  if user=nil then
   ReplaceString(str,'$server$',servername_t)
  else
   ReplaceString(str,'$server$',GetServerName(user^.server));
 // $level$
 if pos('$level$',str)>0 then
 if user<>nil then
  ReplaceString(str,'$level$',Level2Str(user^.level))
 else
  ReplaceString(str,'$level$','<unknown>');
 // $levelnum$
 if pos('$levelnum$',str)>0 then
 if user<>nil then
  ReplaceString(str,'$levelnum$',IntToStr(Ord(user^.level)))
 else
  ReplaceString(str,'$levelnum$','<unknown>');
 tmp_pos:=171;
 // $client$
 if pos('$client$',str)>0 then
 if user<>nil then
  ReplaceString(str,'$client$',user^.software)
 else
  ReplaceString(str,'$client$','<unknown>');
 // $speed$
 if pos('$speed$',str)>0 then
 if user<>nil then
  ReplaceString(str,'$speed$',Speed2Str(user^.speed))
 else
  ReplaceString(str,'$speed$','<unknown>');
 // $minshare$
 if pos('$minshare$',str)>0 then
  ReplaceString(str,'$minshare$',IntToStr(minshare));
 // $maxshare$
 if pos('$maxshare$',str)>0 then
  ReplaceString(str,'$maxshare$',IntToStr(maxshare));
 // $maxusers$
 if pos('$maxusers$',str)>0 then
  ReplaceString(str,'$maxusers$',IntToStr(max_users));
 // $maxusers_total$
 if pos('$maxusers_total$',str)>0 then
  ReplaceString(str,'$maxusers_total$',IntToStr(total_users_limit));
 tmp_pos:=172;
 // $version$
 if pos('$version$',str)>0 then
  ReplaceString(str,'$version$',SLAVANAP_VERSION_SHORT);
 // $build$
 if pos('$build$',str)>0 then
  ReplaceString(str,'$build$',SLAVANAP_BUILD);
 // $console$
 if pos('$console$',str)>0 then
  ReplaceString(str,'$console$',cons.data^.nick);
 // $users$
 if pos('$users$',str)>0 then
  ReplaceString(str,'$users$',IntToStr(total_users));
 // $users_local$
 if pos('$users_local$',str)>0 then
  ReplaceString(str,'$users_local$',IntToStr(local_users));
 // $files$
 if pos('$files$',str)>0 then
  ReplaceString(str,'$files$',IntToStr(total_files));
 // $files_local$
 if pos('$files_local$',str)>0 then
  ReplaceString(str,'$files_local$',IntToStr(local_files));
 // $gb$
 if pos('$gb$',str)>0 then
  ReplaceString(str,'$gb$',IntToStr(total_bytes div 1073741824));
 // $gb_local$
 if pos('$gb_local$',str)>0 then
  ReplaceString(str,'$gb_local$',IntToStr(local_bytes div 1073741824));
 // $files_ex$
 if pos('$files_ex$',str)>0 then
  ReplaceString(str,'$files_ex$',IntToStrDot(total_files));
 // $files_local_ex$
 if pos('$files_local_ex$',str)>0 then
  ReplaceString(str,'$files_local_ex$',IntToStrDot(local_files));
 // $gb_ex$
 if pos('$gb_ex$',str)>0 then
  ReplaceString(str,'$gb_ex$',IntToStrDot(total_bytes div 1073741824));
 // $gb_local_ex$
 if pos('$gb_local_ex$',str)>0 then
  ReplaceString(str,'$gb_local_ex$',IntToStrDot(local_bytes div 1073741824));
 tmp_pos:=173;
 // $servers$
 if pos('$servers$',str)>0 then
  ReplaceString(str,'$servers$',IntToStr(num_servers));
 // $connections$
 if pos('$connections$',str)>0 then
  ReplaceString(str,'$connections$',IntToStr(total_connections));
 // $memory$
 if pos('$memory$',str)>0 then
  ReplaceString(str,'$memory$',IntToStr(AllocMemSize));
 // $memory_ex$
 if pos('$memory_ex$',str)>0 then
  ReplaceString(str,'$memory_ex$',IntToStrDot(AllocMemSize));
 Result:=str;
 tmp_pos:=174;
end;

{* * * * * handlers * * * * *}

procedure Handler_Motd;
var
 str: String;
 t: PStringHashItem;
begin
 tmp_pos:=180;
 if local=nil then exit;
 if query<>queryNormal then exit;
 if user=nil then exit;
 if userHideMotd in user^.state then exit;
 //
 // !!!!!  DO NOT translate or modify the following
 // strings - some clients use it to detect server version
 //
 local.Exec(MSG_SERVER_MOTD,'VERSION SlavaNap '+SLAVANAP_VERSION+'.'+SLAVANAP_BUILD+ ' {o[W');
 local.Exec(MSG_SERVER_MOTD,'SERVER '+servername_t);
 {$IFDEF SHOW_CONNECTIONS}
 local.Exec(MSG_SERVER_MOTD,'̃T[o[ɂ͂̂'+IntToStr(total_connections)+'̐ڑ܂B');
 {$ENDIF}
 tmp_pos:=181;
 t:=db_motd.first;
 while t<>nil do
 try
   str:=FormatString(user,t^.data,false);
   if (Length(str)>0) and (str[1]=';') then
    // do nothing
   else
    local.Exec(MSG_SERVER_MOTD,str);
   t:=t^.next;
  except
   on E:Exception do
   begin
    DebugLog('Exception in Handler_Motd : '+E.Message);
    exit;
   end;
 end;
 tmp_pos:=182;
end;

procedure AddReconnector(ip: String);
begin
 if not reconnect_delay then exit;
 if GetIndex(db_reconnect,ip,false)=-1 then
  db_reconnect.Add(ip);
end;

procedure LoginError(str: String);
begin
 if local=nil then exit;
 AddReconnector(decode_ip(local.ip));
 local.Exec(MSG_SERVER_ERROR,str);
 DisconnectUser(local,'','','LoginError',false);
end;

procedure RedirectUser(def: String);
var
 srv: TServer;
 i,j,k: Integer;
begin
 if local=nil then exit;
 if num_servers<1 then
 begin
   LoginError(def);
   exit;
 end;
 AddReconnector(decode_ip(local.ip));
 k:=0;
 for i:=0 to db_servers.Count-1 do
 begin
   srv:=db_servers.Items[i];
   if srv.logged then
    if srv.num_users<(srv.max_users-10) then
     inc(k,srv.max_users-srv.num_users);
 end;
 if k=0 then
 begin
   LoginError(def);
   exit;
 end;
 k:=random(k); // selecting random server
 j:=0;
 for i:=0 to db_servers.Count-1 do
 begin
   srv:=db_servers.Items[i];
   if srv.logged then
    if srv.num_users<(srv.max_users-10) then
    begin
      inc(j,srv.max_users-srv.num_users);
      if j>=k then
      begin
       local.Exec(MSG_CLIENT_REDIRECT,srv.host+' '+IntToStr(srv.port));
       LoginError(def);
       exit;
      end;
    end;
 end;
 LoginError(def);
end;

procedure Handler_Login;
var
 rec: TOnlineUser;
 user2: POnlineUser;
 reg: PRegisteredUser;
 str, bandata,loginims: String;
 i: Integer;
 sin: TSockAddrIn;
 ban: PBan;
begin
 tmp_pos:=190;
 if local=nil then exit;
 if (user<>nil) or (local.socket=INVALID_SOCKET) then
 begin
   LoginError(GetLangT(LNG_LOGGED));
   exit;
 end;
 if query<>queryNormal then
 begin
   LoginError(GetLangT(LNG_ACCESS));
   exit;
 end;
 SplitString(gcmd.cmd,hlist);
 if hlist.Count<5 then
 begin
   LoginError(GetLangT(LNG_INVALIDARGS));
   exit;
 end;
 tmp_pos:=191;
 if not CheckRange(hlist.Strings[4],0,10) then
 begin
   LoginError(GetLangT(LNG_INVSPEED));
   exit;
 end;
 if not check_name(hlist.Strings[0]) then
 begin
   LoginError(GetLangT(LNG_INVALIDNICK2,hlist.Strings[0]));
   exit;
 end;
 if not check_software(hlist.Strings[3]) then
 begin
   LoginError(GetLangT(LNG_INVALIDSOFTWARE));
   exit;
 end;
 tmp_pos:=192;
 if check_loginpass then
 if AnsiPos(loginpass,hlist.Strings[1])<>1 then begin
   LoginError('̃pX[hł͂̃T[o[ɃOCł܂B');
   exit;
 end;
 local.SoftwareId:=GetSoftware(hlist.Strings[3]);
 ResetOnlineRec(rec);
 tmp_pos:=193;
 rec.nick:=hlist.Strings[0];
 sin:=TCPSocket_GetRemoteSin(local.socket);
 rec.ip:=sin.sin_addr.S_addr;
 rec.dataport:=StrToIntDef(hlist.Strings[2],0);
 rec.software:=Copy(trim(hlist.Strings[3]),1,max_software);
 tmp_pos:=194;
 bandata:=JoinBan(rec.nick,decode_ip(rec.ip));
 user2:=db_online.FindUser(rec.nick);
 if user2<>nil then
 begin
   Exec(user2,MSG_SERVER_GHOST,'');
   LoginError(GetLangT(LNG_GHOST));
   exit;
 end;
 tmp_pos:=195;
 reg:=db_registered.FindUser(rec.nick);
 if (reg=nil) or ((reg<>nil) and (reg^.level<napUserModerator)) then
 if not StrHash_FindString(db_friends,rec.nick,true) then
// if not StrHash_FindString(db_friends,decode_ip(rec.ip),false) then
 begin
   tmp_pos:=196;
   if GetIndex(db_reconnect,decode_ip(rec.ip),false)<>-1 then
   begin // reconnector
     RedirectUser(GetLangT(LNG_RECONNECT));
     local.localstate:=local.localstate+[locWriteOnly];
     exit;
   end;
   if network_hub then
   begin
     if redirect_cqex then RedirectUser(GetLangT(LNG_ACCESS))
     else LoginError(GetLangT(LNG_ACCESS));
     exit;
   end;
   if linking then
   begin
     if redirect_cqex then RedirectUser(GetLangT(LNG_LINKING))
     else LoginError(GetLangT(LNG_LINKING));
     exit;
   end;
   if bandwidth_limited then
   begin
     if redirect_cqex and (local.softwareID=softCQEX) then RedirectUser(GetLangT(LNG_BANDWIDTHLIMIT))
     else LoginError(GetLangT(LNG_BANDWIDTHLIMIT));
     inc(num_rejects);
     exit;
   end;
   if local_users>=max_users then
   begin
     if redirect_cqex and (local.softwareID=softCQEX) then RedirectUser(GetLangT(LNG_USERSLIMIT,local_users))
     else LoginError(GetLangT(LNG_USERSLIMIT,local_users));
     inc(num_rejects);
     exit;
   end;
   if memory_limit>0 then
    if AllocMemSize>memory_limit then
    begin
      if redirect_cqex and (local.softwareID=softCQEX) then RedirectUser(GetLangT(LNG_MEMORYLIMIT))
      else LoginError(GetLangT(LNG_MEMORYLIMIT));
      inc(num_rejects);
      exit;
    end;
   tmp_pos:=197;
   if db_bans.Banned(rec.nick,decode_ip(rec.ip),ban) then
   begin
     if banmail<>'' then LoginError(GetLangT(LNG_BANNED3,banmail,ban^.reason))
     else LoginError(GetLangT(LNG_BANNED2,ban^.reason));
     Wallop(MSG_SERVER_NOSUCH,wallopBan,GetLangEx('Connection from $1: $2 banned: $3',bandata,JoinBan(ban^.user,ban^.ip),ban^.reason),true);
     exit;
   end;
   if registered_only then
   if db_registered.FindUser(rec.nick)=nil then
   begin
     LoginError(GetLangT(LNG_REGISTEREDONLY));
     exit;
   end;
   tmp_pos:=198;
   str:=AnsiLowerCase(rec.software);
   for i:=0 to max_custom_block do
    if blocked_custom[i]<>'' then
     if Copy(str,1,Length(blocked_custom[i]))=blocked_custom[i] then
     begin
       case blocked_messagetype of
        blckNone:   begin
                      AddReconnector(decode_ip(local.ip));
                      DisconnectUser(local,'','','LoginError',false);
                    end;
        blckCustom: LoginError(FormatString(@rec,blocked_message,false))
        else LoginError(GetLangT(LNG_CLIENTBLOCK,hlist.Strings[3]));
       end;
       exit;
     end;
   tmp_pos:=199;
   if blocked_clients[local.SoftwareID] then
   begin
     case blocked_messagetype of
      blckNone:   begin
                    AddReconnector(decode_ip(local.ip));
                    DisconnectUser(local,'','','LoginError',false);
                  end;
      blckCustom: LoginError(FormatString(@rec,blocked_message,false))
      else LoginError(GetLangT(LNG_CLIENTBLOCK,hlist.Strings[3]));
     end;
     exit;
   end;
   tmp_pos:=200;
   if max_clones>0 then
   if CountClones(rec.ip)>=max_clones then
   begin
     LoginError(GetLangT(LNG_MAXCLONES));
     exit;
   end;
 end;
 tmp_pos:=201;
 rec.password:=encode(hlist.Strings[1]);
 if not db_registered.PasswordOk(rec.nick,rec.password) then
 begin
   LoginError(GetLangT(LNG_INVALIDPASS));
   exit;
 end;
 if sin.sin_addr.S_addr<>TCPSocket_GetLocalSin(local.socket).sin_addr.S_addr then
  AddSoftware(rec.software);
 tmp_pos:=202;
 rec.speed:=TNapSpeed(StrToIntDef(hlist.Strings[4],0));
 if reg<>nil then
 begin
   rec.total_up:=reg^.uploads;
   rec.total_down:=reg^.downloads;
   rec.level:=reg^.level;
   rec.state:=reg^.state;
   if userChatting in rec.state then
    rec.state:=rec.state-[userChatting];
   if userCloaked in rec.state then
    if rec.level<napUserModerator then
     rec.state:=rec.state-[userCloaked];
   if userMuzzled in rec.state then
    if rec.level>napUserUser then
     rec.state:=rec.state-[userMuzzled];  
 end;
 tmp_pos:=203;
 local.data:=db_online.Add(rec);
 user:=local.data;
 local.Exec(MSG_SERVER_EMAIL,'anon@'+servername_t);
 inc(num_login);
 tmp_pos:=204;
 Handler_Motd;
 CnvLocalIPtoGlobalIP(local);
 UserOnline(local);
 tmp_pos:=205;
 if userCloaked in rec.state then
 begin
   Wallop(MSG_SERVER_NOSUCH,wallopCloak,GetLangT(LNG_CLOAKED,local.nick),true);
   if user^.server=nil then WriteAllServers(MSG_CLIENT_CLOAK,local.nick,'1');
 end;
 tmp_pos:=206;
 if dengon_enabled then begin
   gcmd.id:=MSG_CLIENT_DENGON_READNEW;
   gcmd.cmd:='';
   ProcessCommand(local,queryMsgServ);
 end;
 if loginim_enabled then begin
   if AnsiPos('WinMX',local.software)<>0 then begin
   for i:=0 to max_loginim do
     if loginim[i]<>'' then
       loginims:=loginims+loginim[i]+#13#10;
   local.Exec(MSG_CLIENT_PRIVMSG,loginim_user+' '+loginims);
   end
   else
     for i:=0 to max_loginim do
       if loginim[i]<>'' then
         local.Exec(MSG_CLIENT_PRIVMSG,loginim_user+' '+loginim[i]);
 end;
 if force_enter then begin
   gcmd.cmd:=force_enter_channel;
   Handler_JoinChannel;
 end;
 local.Flush;
end;

procedure Handler_LoginRegister;
var
 rec: TOnlineUser;
 user2: POnlineUser;
 str, bandata: String;
 i: Integer;
 sin: TSockAddrIn;
 ban: PBan;
begin
 tmp_pos:=210;
 if local=nil then exit;
 if (user<>nil) or (local.socket=INVALID_SOCKET) then
 begin
   LoginError(GetLangT(LNG_LOGGED));
   exit;
 end;
 if query<>queryNormal then
 begin
   LoginError(GetLangT(LNG_ACCESS));
   exit;
 end;
 if registered_only then
 if not allow_register then
 begin
   LoginError(GetLangT(LNG_REGISTEREDONLY));
   exit;
 end;
 tmp_pos:=211;
 SplitString(gcmd.cmd,hlist);
 if hlist.Count<5 then
 begin
   LoginError(GetLangT(LNG_INVALIDARGS));
   exit;
 end;
 if not CheckRange(hlist.Strings[4],0,10) then
 begin
   LoginError(GetLangT(LNG_INVSPEED));
   exit;
 end;
 if not check_name(hlist.Strings[0]) then
 begin
   LoginError(GetLangT(LNG_INVALIDNICK2,hlist.Strings[0]));
   exit;
 end;
 if not check_software(hlist.Strings[3]) then
 begin
   LoginError(GetLangT(LNG_INVALIDSOFTWARE));
   exit;
 end;
 tmp_pos:=212;
 local.SoftwareId:=GetSoftware(hlist.Strings[3]);
 ResetOnlineRec(rec);
 rec.nick:=hlist.Strings[0];
 sin:=TCPSocket_GetRemoteSin(local.socket);
 rec.ip:=sin.sin_addr.S_addr;
 rec.password:=encode(hlist.Strings[1]);
 rec.dataport:=StrToIntDef(hlist.Strings[2],0);
 rec.software:=Copy(trim(hlist.Strings[3]),1,max_software);
 rec.speed:=TNapSpeed(StrToIntDef(hlist.Strings[4],0));
 tmp_pos:=213;
 bandata:=JoinBan(rec.nick,decode_ip(rec.ip));
 user2:=db_online.FindUser(rec.nick);
 if user2<>nil then
 begin
   Exec(user2,MSG_SERVER_GHOST,'');
   LoginError(GetLangT(LNG_GHOST));
   exit;
 end;
 if GetIndex(db_reconnect,decode_ip(rec.ip),false)<>-1 then
 begin // reconnector
   RedirectUser(GetLangT(LNG_RECONNECT));
   local.localstate:=local.localstate+[locWriteOnly];
   exit;
 end;
 if db_registered.FindUser(rec.nick)<>nil then
 begin
   LoginError(GetLangT(LNG_REGISTERED));
   exit;
 end;
 tmp_pos:=214;
 if network_hub then
 begin
   if redirect_cqex then RedirectUser(GetLangT(LNG_ACCESS))
   else LoginError(GetLangT(LNG_ACCESS));
   exit;
 end;
 if linking then
 begin
   if redirect_cqex then RedirectUser(GetLangT(LNG_LINKING))
   else LoginError(GetLangT(LNG_LINKING));
   exit;
 end;
 if bandwidth_limited then
 begin
   if redirect_cqex and (local.softwareID=softCQEX) then RedirectUser(GetLangT(LNG_BANDWIDTHLIMIT))
   else LoginError(GetLangT(LNG_BANDWIDTHLIMIT));
   inc(num_rejects);
   exit;
 end;
 if local_users>=max_users then
 begin
   if redirect_cqex and (local.softwareID=softCQEX) then RedirectUser(GetLangT(LNG_USERSLIMIT,local_users))
   else LoginError(GetLangT(LNG_USERSLIMIT,local_users));
   inc(num_rejects);
   exit;
 end;
 if memory_limit>0 then
  if AllocMemSize>memory_limit then
  begin
    if redirect_cqex and (local.softwareID=softCQEX) then RedirectUser(GetLangT(LNG_MEMORYLIMIT))
    else LoginError(GetLangT(LNG_MEMORYLIMIT));
    inc(num_rejects);
    exit;
  end;
 tmp_pos:=215;
 if db_bans.Banned(rec.nick,decode_ip(rec.ip),ban) then
 begin
   if banmail<>'' then LoginError(GetLangT(LNG_BANNED3,banmail,ban^.reason))
   else LoginError(GetLangT(LNG_BANNED2,ban^.reason));
   Wallop(MSG_SERVER_NOSUCH,wallopBan,GetLangEx('Connection from $1: $2 banned: $3',bandata,JoinBan(ban^.user,ban^.ip),ban^.reason),true);
   exit;
 end;
 if max_clones>0 then
  if CountClones(rec.ip)>=max_clones then
  begin
    LoginError(GetLangT(LNG_MAXCLONES));
    exit;
  end;
 tmp_pos:=216;
 str:=AnsiLowerCase(rec.software);
 for i:=0 to max_custom_block do
  if blocked_custom[i]<>'' then
   if Copy(str,1,Length(blocked_custom[i]))=blocked_custom[i] then
   begin
     case blocked_messagetype of
      blckNone:   begin
                    AddReconnector(decode_ip(local.ip));
                    DisconnectUser(local,'','','LoginError',false);
                  end;
      blckCustom: LoginError(FormatString(@rec,blocked_message,false))
      else LoginError(GetLangT(LNG_CLIENTBLOCK,hlist.Strings[3]));
     end;
     exit;
   end;
 if blocked_clients[local.SoftwareID] then
 begin
   case blocked_messagetype of
     blckNone:   begin
                   AddReconnector(decodE_ip(local.ip));
                   DisconnectUser(local,'','','LoginError',false);
                 end;
     blckCustom: LoginError(FormatString(@rec,blocked_message,false))
     else LoginError(GetLangT(LNG_CLIENTBLOCK,hlist.Strings[3]));
   end;
   exit;
 end;
 tmp_pos:=217;
 if sin.sin_addr.S_addr<>TCPSocket_GetLocalSin(local.socket).sin_addr.S_addr then
  AddSoftware(rec.software);
 local.data:=db_online.Add(rec);
 user:=local.data;
 local.Exec(MSG_SERVER_EMAIL,'anon@'+servername_t);
 inc(num_login);
 tmp_pos:=218;
 Handler_Motd;
 UserOnline(local);
 tmp_pos:=219;
 local.Flush;
end;

procedure Handler_CheckNick;
begin
 tmp_pos:=220;
 if local=nil then exit;
 if query<>queryNormal then exit;
 if user<>nil then exit;
 if (user<>nil) or (local.socket=INVALID_SOCKET) then
 begin
   local.Exec(MSG_SERVER_REGISTER_FAIL,'');
   Error(GetLangT(LNG_LOGGED),true);
   exit;
 end;
 if not check_name(gcmd.cmd) then
 begin
   local.Exec(MSG_SERVER_BAD_NICK,'');
   exit;
 end;
 tmp_pos:=221;
 if db_registered.FindUser(gcmd.cmd)<>nil then
 begin
   local.Exec(MSG_SERVER_REGISTER_FAIL,'');
   exit;
 end;
 if db_online.FindUser(gcmd.cmd)<>nil then
 begin
   local.Exec(MSG_SERVER_REGISTER_FAIL,'');
   exit;
 end;
 tmp_pos:=222;
 local.Exec(MSG_SERVER_REGISTER_OK,'');
end;

procedure Handler_PassCheck;
begin
 tmp_pos:=230;
 if not isLocal then exit;
 if query<>queryNormal then exit;
 if (user<>nil) or (local.socket=INVALID_SOCKET) then
 begin
   Error(GetLangT(LNG_LOGGED),true);
   exit;
 end;
 if not CheckParams(2) then exit;
 if not check_name(hlist.Strings[0]) then
 begin
  LoginError(GetLangT(LNG_INVALIDPASS));
  exit;
 end;
 tmp_pos:=231;
 if db_online.FindUser(hlist.Strings[0])<>nil then
 begin
  LoginError(GetLangT(LNG_INVALIDPASS));
  exit;
 end;
 if db_registered.FindUser(hlist.Strings[0])=nil then
 begin
   local.Exec(MSG_SERVER_PASS_OK,'');
   exit;
 end;
 tmp_pos:=232;
 if db_registered.PasswordOk(hlist.Strings[0],encode(hlist.Strings[1])) then
  local.Exec(MSG_SERVER_PASS_OK,'')
 else
  LoginError(GetLangT(LNG_INVALIDPASS));
end;

procedure Handler_Echo;
begin
 Exec(user,gcmd.id,gcmd.cmd);
end;

procedure Handler_ServerLinks;
var
 i: Integer;
 str: String;
 srv: TServer;
begin
 tmp_pos:=240;
 if query<>queryNormal then
 begin
  if num_servers=0 then
  begin
    Error('no linked servers');
    exit;
  end;
  Error('Servers linked to '+servername_t);
 end;
 tmp_pos:=241;
 for i:=0 to db_servers.Count-1 do
 begin
   srv:=db_servers.Items[i];
   if srv.logged then
   begin
    if query<>queryNormal then
    begin
      str:=srv.host;
      if srv.hub<>nil then str:=str+' (->'+srv.hub.host+')';
      str:=str+#9'   id='+IntToStr(srv.server_handle);
      str:=str+', users='+IntToStr(srv.num_users)+'/'+IntToStr(srv.max_users);
      Error(str);
    end
    else
     if (user.level>napUserUser) or (srv.max_users=0) then
     begin
       if (user.level<napUserModerator) and (srv.hub<>nil) and (srv.hub.max_users=0) then
         Exec(user,gcmd.id,GetServerName(srv)+' 0 '+GetServerName(srv)+' '+IntToStr(srv.port)+' 1')
       else
         Exec(user,gcmd.id,GetServerName(srv.hub)+' 0 '+GetServerName(srv)+' '+IntToStr(srv.port)+' 1');
     end;
   end;
 end;
 tmp_pos:=242;
 if query<>queryNormal then
  Error('Total: '+IntToStr(num_servers)+' linked servers.')
 else
  Exec(user,gcmd.id,'');
end;

procedure Handler_HotList;
var
 user2: POnlineUser;
begin
 tmp_pos:=250;
 if not isLocal then exit;
 if query<>queryNormal then exit;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 tmp_pos:=251;
 case gcmd.id of
    MSG_CLIENT_ADD_HOTLIST,
    MSG_CLIENT_ADD_HOTLIST_SEQ:  begin
                                   user2:=db_online.FindUser(gcmd.cmd);
                                   if user2=nil then
                                   begin
                                     if not check_name(gcmd.cmd) then
                                     begin
                                        if gcmd.id=MSG_CLIENT_ADD_HOTLIST then
                                          local.Exec(MSG_SERVER_HOTLIST_ERROR,gcmd.cmd);
                                        exit;
                                     end;
                                   end;
                                   tmp_pos:=252;
                                   if max_hotlist>0 then
                                    if local.level<napUserModerator then
                                     if local.hotlist.Count>=max_hotlist then exit;
                                   if StrHash_FindString(local.hotlist,gcmd.cmd,true) then exit;
                                   tmp_pos:=253;
                                   StrHash_Add(local.hotlist,gcmd.cmd);
                                   if gcmd.id=MSG_CLIENT_ADD_HOTLIST then
                                    local.Exec(MSG_SERVER_HOTLIST_ACK,gcmd.cmd);
                                   if user2<>nil then
                                    local.Exec(MSG_SERVER_USER_SIGNON,gcmd.cmd+' '+IntToStr(Ord(user2^.speed)));
                                   tmp_pos:=254;
                                 end;
    MSG_CLIENT_REMOVE_HOTLIST:   StrHash_Delete(local.hotlist,gcmd.cmd,true);
 end;
end;

procedure Handler_IgnoreList;
var
 i: Integer;
 item: PStringHashItem;
begin
 tmp_pos:=260;
 if not isLocal then exit;
 if query<>queryNormal then exit;
 if not isLogged then exit;
 tmp_pos:=261;
 case gcmd.id of
    MSG_CLIENT_IGNORE_LIST: begin
                              tmp_pos:=262;
                              item:=local.ignored.first;
                              while item<>nil do
                              begin
                                local.Exec(MSG_SERVER_IGNORE_ENTRY,item^.data);
                                item:=item^.next;
                              end;
                              local.Exec(MSG_CLIENT_IGNORE_LIST,IntToStr(local.ignored.Count));
                            end;
    MSG_CLIENT_IGNORE_USER: begin
                              if not CheckParams(1) then exit;
                              if StrHash_FindString(local.ignored,AnsiLowerCase(gcmd.cmd),false) then
                              begin
                                local.Exec(MSG_SERVER_ALREADY_IGNORED,gcmd.cmd);
                                exit;
                              end;
                              tmp_pos:=263;
                              if max_ignorelist>0 then
                               if local.level<napUserModerator then
                                 if local.ignored.count>=max_ignorelist then
                                 begin
                                   local.Exec(MSG_SERVER_NOT_IGNORED,gcmd.cmd);
                                   exit;
                                 end;
                              StrHash_add(local.ignored,AnsiLowerCase(gcmd.cmd));
                              local.Exec(gcmd.id,gcmd.cmd);
                            end;
    MSG_CLIENT_UNIGNORE_USER: begin
                              if not CheckParams(1) then exit;
                              if StrHash_Delete(local.ignored,AnsiLowerCase(gcmd.cmd),false) then
                                local.Exec(gcmd.id,gcmd.cmd)
                              else
                                local.Exec(MSG_SERVER_NOT_IGNORED,gcmd.cmd);
                            end;
    MSG_CLIENT_CLEAR_IGNORE: begin
                              i:=local.ignored.Count;
                              StrHash_Clear(local.ignored);
                              local.Exec(gcmd.id,IntToStr(i));
                            end;
  end;
end;

procedure Handler_OperServ;
var
 action: String;
begin
 query:=queryOperServ;
 if not isLogged then exit;
 if not isLocal then exit;
 if hlist.count<2 then hlist.Add('help');
 action:=AnsiLowerCase(hlist.Strings[1]);
 gcmd.cmd:=NextParam(gcmd.cmd,2);
 gcmd.id:=0;
 if action='links' then gcmd.id:=MSG_CLIENT_LINKS
 else if action='block' then gcmd.id:=MSG_CLIENT_BLOCK
 else if action='blocklist' then gcmd.id:=MSG_CLIENT_BLOCKLIST
 else if action='unblock' then gcmd.id:=MSG_CLIENT_UNBLOCK
 else if action='stats' then gcmd.id:=MSG_CLIENT_USAGE_STATS
 else if action='nuke' then gcmd.id:=MSG_CLIENT_NUKE
 else if action='register' then gcmd.id:=MSG_CLIENT_REGISTER_USER
 else if action='chanlevel' then gcmd.id:=MSG_CLIENT_SET_CHAN_LEVEL
 else if action='chanlimit' then gcmd.id:=MSG_CLIENT_CHANNEL_LIMIT
 else if action='kick' then gcmd.id:=MSG_CLIENT_KICK
 else if action='config' then gcmd.id:=MSG_CLIENT_SERVER_CONFIG
 else if action='reconfig' then gcmd.id:=MSG_CLIENT_SERVER_RECONFIG
 else if action='cban' then gcmd.id:=MSG_CLIENT_CHANNEL_BAN
 else if action='cunban' then gcmd.id:=MSG_CLIENT_CHANNEL_UNBAN
 else if action='cbanlist' then gcmd.id:=MSG_CLIENT_CHANNEL_BAN_LIST
 else if action='cbanclear' then gcmd.id:=MSG_CLIENT_CHANNEL_CLEAR_BANS
 else if action='clearchan' then gcmd.id:=MSG_CLIENT_CLEAR_CHANNEL
 else if action='cloak' then gcmd.id:=MSG_CLIENT_CLOAK
 else if action='op' then gcmd.id:=MSG_CLIENT_OP
 else if action='deop' then gcmd.id:=MSG_CLIENT_DEOP
 else if action='redirect' then gcmd.id:=MSG_CLIENT_REDIRECT
 else if action='cycle' then gcmd.id:=MSG_CLIENT_CYCLE
 else if action='whowas' then gcmd.id:=MSG_CLIENT_WHO_WAS
 else if action='restart' then gcmd.id:=MSG_CLIENT_RESTART
 else if action='setvar' then gcmd.id:=MSG_CLIENT_SETVAR
 else if action='userlist' then gcmd.id:=MSG_CLIENT_USERLIST
 else if action='connect' then gcmd.id:=MSG_CLIENT_CONNECT
 else if action='disconnect' then gcmd.id:=MSG_CLIENT_DISCONNECT
 else if action='killserver' then gcmd.id:=MSG_CLIENT_KILL_SERVER
 else if action='removeserver' then gcmd.id:=MSG_CLIENT_REMOVE_SERVER
 else if action='usermode' then gcmd.id:=MSG_CLIENT_USER_MODE
 else if action='muzzle' then gcmd.id:=MSG_CLIENT_MUZZLE
 else if action='unmuzzle' then gcmd.id:=MSG_CLIENT_UNMUZZLE
 else if action='help' then
 begin
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ OperSerṽR}hXg :');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ --------------------------------');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ connect <server>[:port] - T[o[ɐڑ');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ block <expression> [<expression2> ...] - t@CubN');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ blocklist - ubNt@Cꗗ');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ chanlevel <channel> <level> - `l̍Œxݒ');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ chanlimit <channel> <limit> - `l̒ݒ');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ clearchan <channel> - ׂẴ[U[`lǕ');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ cloak - ʃ[U[Ɏ\/\');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ cycle <nick> <host> - ^T[o[ <host> ɍĐڑ悤ɃNCAgɗv');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ deop <channel> <user> [<user2> ...] - `lIy[^[͂');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ disconnect <server> - T[o[ؒf');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ help - ̃wvbZ[W\');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ kick <nick> - [U[Ǖ');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ killserver <server> - T[o[ؒf');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ muzzle <user> [reason] - [U[𔭌֎~');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ nuke <nick> - [U[ǕĂ̖Oł̃OC֎~');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ op <channel> <user> [<user2> ...] - `lIy[^[C');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ redirect <nick> <host> <port> - T[o[<host>:<port>֐ڑ悤ɃNCAgɗv');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ removeserver <server> - T[o[ꗗ폜');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ restart - T[o[ċN');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ setvar [<variable=value>] - T[o[ϐύX');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ stats - T[o[v\');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ unblock <expression> [<expression2> ...] - ̃t@CubN');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ unmuzzle <user> [reason] - [U[̔֎~');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ userlist - ׂẴ[U[ꗗ');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ usermode [+|-mode1 ...] - [hݒ("usermode help"Ń[hꗗ)');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ whowas <nick> - ݃OAEgς݂̃NCAg̏\');
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ --------------------------------');
   exit;
 end
 else
 begin
   local.Exec(MSG_CLIENT_PRIVMSG,'OperServ '+GetLangT(LNG_INVALIDCOMMAND,action));
   exit;
 end;
 if gcmd.id<>0 then
  ProcessCommand(local,queryOperServ);
end;

procedure Handler_NickServ;
var
 action: String;
begin
 query:=queryNickServ;
 if not isLogged then exit;
 if not isLocal then exit;
 if hlist.count<2 then hlist.Add('help');
 action:=AnsiLowerCase(hlist.Strings[1]);
 gcmd.cmd:=NextParam(gcmd.cmd,2);
 gcmd.id:=0;


 if gcmd.id<>0 then
  ProcessCommand(local,queryNickServ);
end;

procedure Handler_ChanServ;
var
 action: String;
begin
 query:=queryChanServ;
 if not isLogged then exit;
 if not isLocal then exit;
 if hlist.count<2 then hlist.Add('help');
 action:=AnsiLowerCase(hlist.Strings[1]);
 gcmd.cmd:=NextParam(gcmd.cmd,2);
 gcmd.id:=0;
 if action='ban' then gcmd.id:=MSG_CLIENT_CHANNEL_BAN
 else if action='unban' then gcmd.id:=MSG_CLIENT_CHANNEL_UNBAN
 else if action='banclear' then gcmd.id:=MSG_CLIENT_CHANNEL_CLEAR_BANS
 else if action='banlist' then gcmd.id:=MSG_CLIENT_CHANNEL_BAN_LIST
 else if action='clear' then gcmd.id:=MSG_CLIENT_CLEAR_CHANNEL
 else if action='kick' then gcmd.id:=MSG_CLIENT_KICK
 else if action='topic' then gcmd.id:=MSG_SERVER_TOPIC
 else if action='limit' then gcmd.id:=MSG_CLIENT_CHANNEL_LIMIT
 else if action='drop' then gcmd.id:=MSG_CLIENT_DROP_CHANNEL
 else if action='op' then gcmd.id:=MSG_CLIENT_OP
 else if action='deop' then gcmd.id:=MSG_CLIENT_DEOP
 else if action='wallop' then gcmd.id:=MSG_CLIENT_CHANNEL_WALLOP
 else if action='invite' then gcmd.id:=MSG_CLIENT_CHANNEL_INVITE_OPENNAP
 else if action='mode' then gcmd.id:=MSG_CLIENT_CHANNEL_MODE
 else if action='muzzle' then gcmd.id:=MSG_CLIENT_CHANNEL_MUZZLE
 else if action='unmuzzle' then gcmd.id:=MSG_CLIENT_CHANNEL_UNMUZZLE
 else if action='unvoice' then gcmd.id:=MSG_CLIENT_CHANNEL_UNVOICE
 else if action='voice' then gcmd.id:=MSG_CLIENT_CHANNEL_VOICE
 else if action='level' then gcmd.id:=MSG_CLIENT_SET_CHAN_LEVEL
 else if action='help' then
 begin
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ ChanSerṽR}hXg :');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ --------------------------------');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ ban <channel> <user> - `l̃[U[֎~');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ banclear <channel> - `l̓֎~ׂĉ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ banlist <channel> - `l̓֎~҂ꗗ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ clear <channel> - `l̓҂ׂĒǕ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ deop <channel> [user [user ...]] - `lIy[^[͂');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ drop <channel> - `l폜');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ help - ̃wvbZ[W\');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ invite <channel> <user> - [U[`lɏ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ kick <channel> <user> [reason] - [U[`lǕ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ level <channel> [level] - ɕKvȍŒ჆[U[x\/ݒ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ limit <channel> [number] - `l̒ݒ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ mode <channel> [mode [mode ...]] - `l[h\/ݒ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ muzzle <channel> <user> - [U[𔭌֎~ɂ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ op <channel> [user [user ...] - `lIy[^[\/ݒ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ topic <channel> [topic] - `lgsbN̕\/ݒ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ unban <channel> <user> - ֎~');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ unmuzzle <channel> <user> - ֎~');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ unvoice <channel> [user [user ...]] - ');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ voice <channel> [user [user ...]] - ^');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ wallop <channel> <text> - ׂẴ`lIy[^[ɃbZ[W𑗂');
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ --------------------------------');
   exit;
 end
 else
 begin
   local.Exec(MSG_CLIENT_PRIVMSG,'ChanServ '+GetLangT(LNG_INVALIDCOMMAND,action));
   exit;
 end;
 if gcmd.id<>0 then
  ProcessCommand(local,queryChanServ);
end;

procedure Handler_MsgServ;
//205 msgserv write receiver msg
//205 msgserv read
//205 msgserv help
var
 action: String;
begin
 query:=queryMsgServ;
 if not isLogged then exit;
 if not isLocal then exit;
 if hlist.Count<2 then hlist.Add('help');
 action:=AnsiLowerCase(hlist.Strings[1]);
 gcmd.cmd:=NextParam(gcmd.cmd,2);
 gcmd.id:=0;
 if action='read' then gcmd.id:=MSG_CLIENT_DENGON_READ
 else if action='readnew' then gcmd.id:=MSG_CLIENT_DENGON_READNEW
 else if action='write' then gcmd.id:=MSG_CLIENT_DENGON_WRITE
 else if action='delete' then gcmd.id:=MSG_CLIENT_DENGON_DELETE
 else if action='clear' then gcmd.id:=MSG_CLIENT_DENGON_CLEAR
 else if action='help' then
 begin
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ MsgSerṽR}hXg :');
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ --------------------------------');
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ read - `ԓǂ');
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ readnew - V`ǂ');
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ write <user> <message> - `c');
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ delete <date> <time> <user> <message> - `');
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ clear - `ׂď');
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ help - ̃wvbZ[W\');
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ --------------------------------');
   exit;
 end
 else
 begin
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ '+GetLangT(LNG_INVALIDCOMMAND,action));
   exit;
 end;
 if gcmd.id<>0 then
  ProcessCommand(local,queryMsgServ);
end;

procedure Handler_DengonRead;
var
 t: PStringHashItem;
begin
 if not isLogged then exit;
 t:=db_dengon.first;
 while t<>nil do
 try
   if FirstParam(t^.data)=local.nick then
   begin
     local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ '+NextParam(t^.data));
     if FirstParam(NextParam(t^.data))='new' then
       t^.data:=FirstParam(t^.data)+' old '+NextParam(t^.data,2);
   end;
   t:=t^.next;
  except
   on E:Exception do
   begin
    DebugLog('Exception in Handler_DengonRead : '+E.Message);
    exit;
   end;
 end;
end;

procedure Handler_DengonReadNew;
var
 t: PStringHashItem;
begin
 if not isLogged then exit;
 t:=db_dengon.first;
 while t<>nil do
 try
   if FirstParam(t^.data)=local.nick then
   if FirstParam(NextParam(t^.data))='new' then
   begin
     local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ '+NextParam(t^.data,2));
     t^.data:=FirstParam(t^.data)+' old '+NextParam(t^.data,2);
   end;
   t:=t^.next;
  except
   on E:Exception do
   begin
    DebugLog('Exception in Handler_DengonReadNew : '+E.Message);
    exit;
   end;
 end;
end;

procedure Handler_DengonWrite;//write <user> <message>
begin
 if not isLogged then exit;
 if not CheckParams(2) then exit;
 StrHash_Add(db_dengon,FirstParam(gcmd.cmd)+' new '+DateTimeToStr(now)+' <'+local.nick+'> '+NextParam(gcmd.cmd));
 //t^.data:='receiver yyyy/mm/dd hh:mm:ss <sender> msg';
 local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ `bZ[WL܂B');
end;

procedure Handler_DengonDelete;//delete <date> <time> <user> <message>
begin
 if not isLogged then exit;
 if not CheckParams(4) then exit;
 if StrHash_Delete(db_dengon,local.nick+' old '+gcmd.cmd,false) then
   local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ `bZ[W1폜܂')
 else local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ ̂悤ȓ`͂Ȃ悤ł');
end;

procedure Handler_DengonClear;//clear
var
 t,next_t: PStringHashItem;
begin
 if not isLogged then exit;
 t:=db_dengon.first;
 while t<>nil do
 try
   next_t:=t^.next;
   if FirstParam(t^.data)=local.nick then
     StrHash_Delete(db_dengon,t^.data,false);
   t:=next_t;
  except
   on E:Exception do
   begin
    DebugLog('Exception in Handler_DengonClear : '+E.Message);
    exit;
   end;
 end;
 local.Exec(MSG_CLIENT_PRIVMSG,'MsgServ `bZ[Wׂč폜܂');
end;

procedure Handler_PrivateMessage;
var
 user2: POnlineUser;
 l2: TLocalUser;
 str,msg: String;
begin
 tmp_pos:=270;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 str:=AnsiLowerCase(hlist.Strings[0]);
 tmp_pos:=271;
 if str='operserv' then
 begin
   if user^.level>napUserUser then
    Handler_OperServ
   else
    Exec(user,MSG_SERVER_PRIVMSG,'OperServ '+GetLangT(LNG_ACCESS));
   exit;
 end;
 if str='nickserv' then
 begin
   Handler_NickServ;
   exit;
 end;
 if str='chanserv' then
 begin
   Handler_ChanServ;
   exit;
 end;
 if str='msgserv' then
 begin
   if dengon_enabled then
     Handler_MsgServ
   else Exec(user,MSG_SERVER_PRIVMSG,'MsgServ '+'~I');
   exit;
 end;
 tmp_pos:=272;
 msg:=Copy(NextParamEx(gcmd.cmd),1,max_privmsg_len);
 if msg='//WantQueue' then
 begin
   if smart_block_winmx then
    if blocked_clients[softWinMX] then
     if local<>nil then
     if local.SoftwareID<>softLopster then // lopster uses this message to fix winmx cheating
     if user^.level<napUserModerator then
     if not StrHash_FindString(db_friends,user^.nick,true) then
     begin
       local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_BLOCKEDWINMX));
       if local.SoftwareId<>softWinMX then
        BanUser(decode_ip(local.ip),servername_t,blocked_bantime,GetLangT(LNG_REASON_WIMXBAN,servername_t),true);
       DisconnectUser(local,'',GetLangT(LNG_DISCONNECT_WINMX,local.nick,local.software),'Handler_PrivateMessage',false);
       exit;
     end;
   if block_wantqueue then exit;
   inc(user^.wantqueuep3m);
   if user^.level<napUserModerator then
   if not StrHash_FindString(db_friends,user^.nick,true) then
   if user^.wantqueuep3m>flood_max_wantqueue then
   begin
     Exec(user,MSG_SERVER_NOSUCH,'AL[ubN܂:WantQueue/(3Ԃ)='
     +IntToStr(user^.wantqueuep3m)+'/'+IntToStr(flood_max_wantqueue));
     exit;
   end;
 end;
 tmp_pos:=273;
 user2:=db_online.FindUser(str);
 if user2=nil then
 begin
   UserIsOffline(str,true);
   exit;
 end;
 if userHidePM in user2^.state then exit;
 if (user^.server=nil) and (userMuzzled in user^.state) then
 if user2^.level<napUserModerator then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=274;
 if user2^.server<>nil then
 begin
   if local=nil then exit;
   user2^.server.Exec(gcmd.id,user^.nick+' '+gcmd.cmd);
   exit;
 end;
 if user^.level<napUserModerator then
 begin
   if user2^.server=nil then
    l2:=FindLocalUser(user2)
   else
    l2:=nil;
   if l2<>nil then
    if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
    begin
      UserIsOffline(hlist.Strings[0],true);
      exit;
    end;
 end;
 tmp_pos:=275;
 Exec(user2,gcmd.id,user^.nick+' '+msg);
end;

procedure Handler_Resume;
begin
 if not isLocal then exit;
 local.Exec(MSG_SERVER_RESUME_MATCH_END,'');
end;

procedure Handler_GetData;
var
 user2: POnlineUser;
begin
 if not isLogged then exit;
 case gcmd.id of
   MSG_CLIENT_USERSPEED:            begin
                                     if not CheckParams(1) then exit;
                                     user2:=db_online.FindUser(gcmd.cmd);
                                     if user2=nil then UserIsOffline(gcmd.cmd,true)
                                     else Exec(user,MSG_SERVER_USER_SPEED,user2^.nick+' '+IntToStr(Ord(user2^.speed)));
                                    end;
 end;
end;

function ShareFile(folder: String; rec:TShare):Boolean;
var
 j:Integer;
begin
 tmp_pos:=280;
 Result:=true;
 if not allow_share then exit;
 if rec.mime=TYPE_INVALID then
 begin
  Result:=false;
  exit;
 end;
 CheckSync;
 tmp_pos:=281;
 if share_nomodem then
  if (user^.speed<napSpeed64ISDN) and (user^.speed<>napSpeedUnknown) then
   exit; // modem sharing disabled
 case rec.mime of
   TYPE_AUDIO:     j:=SHARED_AUDIO;
   TYPE_VIDEO:     j:=SHARED_VIDEO;
   TYPE_TEXT:      j:=SHARED_TEXT;
   TYPE_IMAGE:     j:=SHARED_IMAGE;
   TYPE_APP:       j:=SHARED_APP;
   TYPE_CD:        j:=SHARED_CD;
   else // MP3/WMA/OGG
    case rec.bitrate of
       320:     if not share_320 then j:=-1
                else j:=SHARED_320;
       256:     if not share_256 then j:=-1
                else j:=SHARED_256;
       224:     if not share_224 then j:=-1
                else j:=SHARED_224;
       192:     if not share_192 then j:=-1
                else j:=SHARED_192;
       160:     if not share_160 then j:=-1
                else j:=SHARED_160;
       128:     if not share_128 then j:=-1
                else j:=SHARED_128;
       112:     if not share_112 then j:=-1
                else j:=SHARED_112;
       96:      if not share_96 then j:=-1
                else j:=SHARED_OTHER;
       80:      if not share_80 then j:=-1
                else j:=SHARED_OTHER;
       64:      if not share_64 then j:=-1
                else j:=SHARED_64;
       56:      if not share_56 then j:=-1
                else j:=SHARED_OTHER;
       48:      if not share_48 then j:=-1
                else j:=SHARED_OTHER;
       40:      if not share_40 then j:=-1
                else j:=SHARED_OTHER;
       32:      if not share_32 then j:=-1
                else j:=SHARED_OTHER;
       24:      if not share_24 then j:=-1
                else j:=SHARED_OTHER;
       else     if not share_unknown then j:=-1
                else j:=SHARED_OTHER;
    end;
    if j=-1 then
    begin
      if shareinform and CanSendError(user,query) then
       local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_NOSHARE_BITRATE,rec.bitrate));
      exit;
    end;
 end;
 tmp_pos:=282;
 try
   if local.shared=nil then local.shared:=CreateShareList;
   if local.shared.FindFile(folder,rec.name)<>-1 then
   begin
     Result:=false; // already shared
     exit;
   end;
   tmp_pos:=283;
   rec.id:=j;
   rec.index:=local.shared.AddFolder(folder);
   local.shared.Add(rec);
   inc(user^.shared);
   tmp_pos:=284;
   case rec.mime of
     TYPE_MP3: inc(local.shared_mp3);
     TYPE_AUDIO: inc(local.shared_audio);
     TYPE_VIDEO: inc(local.shared_video);
     TYPE_IMAGE: inc(local.shared_images);
     TYPE_APP: inc(local.shared_apps);
     TYPE_CD: inc(local.shared_cd);
     TYPE_TEXT: inc(local.shared_text);
   end;
   inc(total_files);
   inc(local_files);
   inc(total_bytes,Int64(rec.size));
   inc(local_bytes,Int64(rec.size));
   inc(local.shared_size,Int64(rec.size));
   local.localstate:=local.localstate+[locNeedsUpdate];
   if local_files_max<local_files then local_files_max:=local_files;
   if total_files_max<total_files then total_files_max:=total_files;
   if local_bytes_max<local_bytes then local_bytes_max:=local_bytes;
   if total_bytes_max<total_bytes then total_bytes_max:=total_bytes;
   tmp_pos:=285;
  except
   on E:Exception do
    DebugLog('Exception in ShareFile (pos='+IntToStr(tmp_pos)+') : '+E.Message);
 end;
end;

procedure Handler_Share(dir: String; valid_dir: Boolean);
var
 rec: TShare;
 folder_name, str, filename, file_ext: String;
 i,j: Integer;
 k,l,fsize: Int64;
begin
 tmp_pos:=290;
 // valid_dir=false if this proc is called from Handler_ShareDir
 if not allow_share then exit;
 if network_hub then exit;
 if not isLocal then exit;
 if not isLogged then exit;
 if query<>queryNormal then exit;
 if user^.level=napUserLeech then exit;
 if not valid_dir then SplitString(gcmd.cmd,hlist);
 if hlist.Count<6 then
 begin
  Error(GetLangT(LNG_INVALIDARGS),true);
  exit;
 end;
 tmp_pos:=291;
 rec.mime:=TYPE_INVALID;
 filename:=dir+hlist.Strings[0];
 SplitFileName(filename,folder_name,rec.name);
 // checking FileNavigator
 if copy(filename,1,3)='|||' then
 begin
   str:=ExtractFileName(Copy(filename,4,Length(filename)));
   i:=Length(ExtractFileExt(str));
   str:=Copy(str,1,Length(str)-i);
   i:=pos('|',str);
   while i>0 do
   begin
     str[i]:='.';
     i:=pos('|',str);
   end;
   filename:=str;
 end;
 tmp_pos:=292;
 if maxshare>0 then
  if user^.shared>=maxshare then
  begin
    if shareinform and CanSendError(user,query) then
     local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_LIMIT,filename,maxshare));
    exit;
  end;
 tmp_pos:=293;
 if maxshare_total>0 then
  if local_files>=maxshare_total then
  begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_TOTAL_LIMIT,filename));
   exit;
  end;
 if memory_limit>0 then
  if AllocMemSize>=memory_limit then
  begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_MEMORY_LIMIT,filename));
   exit;
  end;
 tmp_pos:=294;
 if Length(filename)<minfilename then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_SHORT,filename));
   exit;
 end;
 fsize:=StrToInt64Def(hlist.Strings[2],0);
 rec.size:=StrToInt64Def(hlist.Strings[2],0);
 rec.bitrate:=StrToIntDef(hlist.Strings[3],-1);
{ if rec.bitrate<0 then // remarked because bitrate is always positive
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_BITRATE,filename));
   exit;
 end;}
 tmp_pos:=295;
 rec.frequency:=StrToIntDef(hlist.Strings[4],0);
{ if rec.frequency<0 then // same as with bitrate
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_FREQ,filename));
   exit;
 end;}
 if (rec.bitrate=0) or (rec.frequency=0) then // Fixing bug in SunshineUE
 begin
   rec.bitrate:=24;
   rec.frequency:=16000;
   rec.time:=600;
 end;
 file_ext:=AnsiLowerCase(ExtractFileExt(filename));
 if Length(file_ext)>0 then if file_ext[1]='.' then file_ext:=Copy(file_ext,2,Length(file_ext));
 tmp_pos:=296;
 rec.mime:=GetType(file_ext);
 if rec.mime=TYPE_INVALID then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_ERROR,filename));
   exit;
 end;
 rec.time:=StrToIntDef(hlist.Strings[5],0);
 if rec.mime=TYPE_MP3 then
 if rec.time<minduration then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_TIME,filename));
   exit;
 end;
 tmp_pos:=297;
 case rec.mime of
   TYPE_AUDIO: begin i:=maxshare_audio; j:=local.shared_audio; end;
   TYPE_VIDEO: begin i:=maxshare_video; j:=local.shared_video; end;
   TYPE_IMAGE: begin i:=maxshare_image; j:=local.shared_images; end;
   TYPE_APP:   begin i:=maxshare_app; j:=local.shared_apps; end;
   TYPE_CD:    begin i:=maxshare_cd; j:=local.shared_cd; end;
   TYPE_TEXT:  begin i:=maxshare_text; j:=local.shared_text; end;
   else i:=maxshare_mp3; j:=local.shared_mp3;
 end;
 if j>=i then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_LIMIT,filename,i));
   exit;
 end;
 tmp_pos:=298;
 case rec.mime of
   TYPE_AUDIO: begin k:=minfilesize_audio; l:=maxfilesize_audio; end;
   TYPE_VIDEO: begin k:=minfilesize_video; l:=maxfilesize_video; end;
   TYPE_IMAGE: begin k:=minfilesize_image; l:=maxfilesize_image; end;
   TYPE_APP: begin k:=minfilesize_app; l:=maxfilesize_app; end;
   TYPE_CD: begin k:=minfilesize_cd; l:=maxfilesize_cd; end;
   TYPE_TEXT: begin k:=minfilesize_text; l:=maxfilesize_text; end;
   else k:=minfilesize_mp3; l:=maxfilesize_mp3;
 end;
 if k>0 then
 if fsize<k then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_SMALL,filename));
   exit;
 end;
 if l>0 then
 if fsize>l then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_LARGE,filename));
   exit;
 end;
 tmp_pos:=299;
 rec.short:=ExtractMPName(filename);
 if rec.short='' then exit;
 if rec.short='_' then
 begin // blocked
   if shareinform then
     local.Exec(MSG_SERVER_BLOCKMD5,hlist.Strings[1]); // Napster 10.2+ message
   exit;
 end;
 if not ShareFile(folder_name,rec) then
  if shareinform and CanSendError(user,query) then
   local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_ERROR,filename));

 if force_enter and force_enter_furiwake then
 begin
   if AnsiPos('NapDev',rec.name)>0 then
     gcmd.cmd:='#developer'
   else if AnsiPos('PV',rec.name)>0 then
     gcmd.cmd:='#pv'
   else if AnsiPos('f',rec.name)>0 then
     gcmd.cmd:='#movie'
   else if AnsiPos('Aj',rec.name)>0 then
     gcmd.cmd:='#anime'
   else exit;
   Handler_JoinChannel;
 end;
end;

procedure Handler_ShareDir;
var
 i:Integer;
 dir: String;
begin
 tmp_pos:=300;
 if not allow_share then exit;
 if network_hub then exit;
 if not isLocal then exit;
 if not isLogged then exit;
 if user^.level=napUserLeech then exit;
 if query<>queryNormal then exit;
 tmp_pos:=301;
 if not CheckParams(7,false) then
 begin
   if hlist.count=1 then // possible winmx
    if smart_block_winmx then
     if blocked_clients[softWinMX] then
     if user^.level<napUserModerator then
     if not StrHash_FindString(db_friends,user^.nick,true) then
//     if not StrHash_FindString(db_friends,decode_ip(local.ip),false) then
     begin
       local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_BLOCKEDWINMX));
       if local.SoftwareId<>softWinMX then
        BanUser(decode_ip(local.ip),servername_t,blocked_bantime,GetLangT(LNG_REASON_WIMXBAN,servername_t),true);
       DisconnectUser(local,'',GetLangT(LNG_DISCONNECT_WINMX,local.nick,local.software),'Handler_ShareDir',false);
     end;
   exit;
 end;
 tmp_pos:=302;
 dir:=hlist.Strings[0];
 hlist.Delete(0);
 tmp_pos:=303;
 while hlist.Count>5 do
 begin
   if not local.logged then exit;
   if not running then exit;
   if maxshare>0 then if user^.shared>=maxshare then exit;
   tmp_pos:=304;
   Handler_Share(dir,true);
   tmp_pos:=305;
   for i:=0 to 5 do
    hlist.Delete(0);
   CheckSync;
 end;
end;

procedure Handler_ShareFile;
var
 rec: TShare;
 i,j: Integer;
 k,l,fsize: Int64;
 folder,file_ext: String;
begin
 tmp_pos:=310;
 if not allow_share then exit;
 if network_hub then exit;
 if not isLocal then exit;
 if not isLogged then exit;
 if query<>queryNormal then exit;
 if user^.level=napUserLeech then exit;
 if not CheckParams(4) then exit;
 tmp_pos:=311;
 rec.mime:=StrToType(hlist.Strings[3]);
 if rec.mime=TYPE_INVALID then exit;
 if rec.mime=TYPE_MP3 then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_10300));
   exit;
 end;
 case rec.mime of
   TYPE_AUDIO: begin i:=maxshare_audio; j:=local.shared_audio; end;
   TYPE_VIDEO: begin i:=maxshare_video; j:=local.shared_video; end;
   TYPE_IMAGE: begin i:=maxshare_image; j:=local.shared_images; end;
   TYPE_APP:   begin i:=maxshare_app; j:=local.shared_apps; end;
   TYPE_CD:    begin i:=maxshare_cd; j:=local.shared_cd; end;
   TYPE_TEXT:  begin i:=maxshare_text; j:=local.shared_text; end;
   else i:=maxshare_mp3; j:=local.shared_mp3;
 end;
 tmp_pos:=312;
 if j>=i then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_LIMIT,hlist.Strings[0],i));
   exit;
 end;
 case rec.mime of
   TYPE_AUDIO: begin k:=minfilesize_audio; l:=maxfilesize_audio; end;
   TYPE_VIDEO: begin k:=minfilesize_video; l:=maxfilesize_video; end;
   TYPE_IMAGE: begin k:=minfilesize_image; l:=maxfilesize_image; end;
   TYPE_APP: begin k:=minfilesize_app; l:=maxfilesize_app; end;
   TYPE_CD: begin k:=minfilesize_cd; l:=maxfilesize_cd; end;
   TYPE_TEXT: begin k:=minfilesize_text; l:=maxfilesize_text; end;
   else k:=minfilesize_mp3; l:=maxfilesize_mp3;
 end;
 tmp_pos:=313;
 rec.size:=StrToInt64Def(hlist.Strings[1],0);
 fsize:=StrToInt64Def(hlist.Strings[1],0);
 if k>0 then
 if fsize<k then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_SMALL,hlist.Strings[0]));
   exit;
 end;
 if l>0 then
 if fsize>l then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_LARGE,hlist.Strings[0]));
   exit;
 end;
 tmp_pos:=314;
 // let's make these values compatible with WinMX and some other clients
 rec.bitrate:=24;
 rec.frequency:=16000;
 rec.time:=600;
 if Length(hlist.Strings[0])<minfilename then
 begin
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_SHARE_SHORT,hlist.Strings[0]));
   exit;
 end;
 tmp_pos:=315;
 file_ext:=AnsiLowerCase(ExtractFileExt(hlist.Strings[0]));
 if Length(file_ext)>0 then if file_ext[1]='.' then file_ext:=Copy(file_ext,2,Length(file_ext));
 rec.short:=ExtractMPName(hlist.Strings[0]);
 if rec.short='' then exit;
 if rec.short='_' then
 begin // blocked
   if shareinform and CanSendError(user,query) then
    local.Exec(MSG_SERVER_BLOCKMD5,hlist.Strings[2]); // Napster 10.2+ message
   exit;
 end;
 tmp_pos:=316;
 SplitFileName(hlist.Strings[0],folder,rec.name);
 ShareFile(folder,rec);
end;

procedure Handler_Unshare(filename: String='');
var
 i,j:Integer;
 n: Int64;
begin
 tmp_pos:=320;
 if not isLocal then exit;
 if not isLogged then exit;
 if local.shared=nil then exit;
 if user^.shared=0 then exit;
 tmp_pos:=321;
 if filename='' then
 begin
  if local.shared<>nil then
  begin
   dec(total_bytes,local.shared_size);
   dec(local_bytes,local.shared_size);
   dec(total_files,local.shared.count);
   dec(local_files,local.shared.count);
   local.shared.Clear;
   local.localstate:=local.localstate+[locNeedsUpdate];
  end;
  tmp_pos:=322;
  user^.shared:=0;
  local.shared_mp3:=0;
  local.shared_audio:=0;
  local.shared_video:=0;
  local.shared_cd:=0;
  local.shared_images:=0;
  local.shared_text:=0;
  local.shared_apps:=0;
  local.shared_size:=0;
  exit;
 end;
 tmp_pos:=323;
 if Length(filename)>2 then
  if filename[1]='"' then filename:=Copy(filename,2,length(filename)-2);
 if local.shared=nil then exit;
 j:=local.shared.FindFile(filename);
 tmp_pos:=324;
 if j<>-1 then
 begin
   n:=Int64(PShare(local.shared.Items[j])^.size);
   i:=local.shared.Id(j);
   local.shared.Delete(j);
   dec(total_bytes,n);
   dec(local_bytes,n);
   dec(local.shared_size,n);
   dec(total_files);
   dec(local_files);
   dec(user^.shared);
   local.localstate:=local.localstate+[locNeedsUpdate];
   case i of
     SHARED_AUDIO: dec(local.shared_audio);
     SHARED_VIDEO: dec(local.shared_video);
     SHARED_TEXT:  dec(local.shared_text);
     SHARED_IMAGE: dec(local.shared_images);
     SHARED_APP:   dec(local.shared_apps);
     SHARED_CD:    dec(local.shared_cd);
     else          dec(local.shared_mp3);
   end;
 end;
end;

function Search: Integer;
var
 i,j,k,m: Integer;
 count: Integer;
 b: Array[0..SHARED_MAX] of Boolean;
 match: Boolean;
 str: String;
 sh: PShare;
 user2: TLocalUser;
begin
 tmp_pos:=330;
 Result:=0;
 CheckSync;
 if local_users<1 then exit;
 for i:=0 to SHARED_MAX do b[i]:=false;
 // checking file types
 match:=false;
 tmp_pos:=1235;
 case search_data.mime of
   TYPE_AUDIO:    b[SHARED_AUDIO]:=true;
   TYPE_VIDEO:    b[SHARED_VIDEO]:=true;
   TYPE_TEXT:     b[SHARED_TEXT]:=true;
   TYPE_IMAGE:    b[SHARED_IMAGE]:=true;
   TYPE_APP:      b[SHARED_APP]:=true;
   else
       if search_data.nonmp3=false then
       begin
         tmp_pos:=1236;
         if search_data.mime=TYPE_INVALID then
         begin
           b[SHARED_AUDIO]:=true;
           b[SHARED_VIDEO]:=true;
           b[SHARED_TEXT]:=true;
           b[SHARED_IMAGE]:=true;
           b[SHARED_APP]:=true;
         end;
         b[SHARED_320]:=compare(search_data.bitrate_cmp,search_data.bitrate,320);
         b[SHARED_256]:=compare(search_data.bitrate_cmp,search_data.bitrate,256);
         b[SHARED_224]:=compare(search_data.bitrate_cmp,search_data.bitrate,224);
         b[SHARED_192]:=compare(search_data.bitrate_cmp,search_data.bitrate,192);
         b[SHARED_160]:=compare(search_data.bitrate_cmp,search_data.bitrate,160);
         b[SHARED_128]:=compare(search_data.bitrate_cmp,search_data.bitrate,128);
         b[SHARED_112]:=compare(search_data.bitrate_cmp,search_data.bitrate,112);
         b[SHARED_64]:=compare(search_data.bitrate_cmp,search_data.bitrate,64);
         tmp_pos:=1237;
         if search_data.bitrate_cmp<>napEqual then b[SHARED_OTHER]:=true
         else
          if search_data.bitrate<>320 then
          if search_data.bitrate<>256 then
          if search_data.bitrate<>224 then
          if search_data.bitrate<>192 then
          if search_data.bitrate<>160 then
          if search_data.bitrate<>128 then
          if search_data.bitrate<>112 then
          if search_data.bitrate<>64 then
           b[SHARED_OTHER]:=true;
         match:=true;
         tmp_pos:=1238;
         for i:=0 to max_search_array-1 do
         if search_data.include[i]<>'' then
         begin // allow user to type file extension in search string
           str:=search_data.include[i];
           j:=GetType(str);
           search_data.include[i]:='';
           tmp_pos:=1239;
           case j of
             TYPE_AUDIO:  b[SHARED_AUDIO]:=true;
             TYPE_VIDEO:  b[SHARED_VIDEO]:=true;
             TYPE_IMAGE:  b[SHARED_IMAGE]:=true;
             TYPE_APP:    b[SHARED_APP]:=true;
             TYPE_CD:     b[SHARED_CD]:=true;
             TYPE_TEXT:   b[SHARED_TEXT]:=true;
             TYPE_MP3:    begin end; // just ignore it
             else search_data.include[i]:=str;
           end;
         end;
       end;
 end;
 tmp_pos:=331;
 {if not match then
  for i:=0 to max_search_array-1 do
   if search_data.include[i]<>'' then
    search_data.include[i]:=' '+search_data.include[i]+' ';}
 tmp_pos:=1240;
 if search_data.nonmp3 then // if searching all non-mp3s
 begin
   for i:=0 to SHARED_MAX do
     if i<SHARED_MP3_MIN then b[i]:=true
     else b[i]:=false;
 end;
 tmp_pos:=332;
 CheckSync;
 count:=0;
 // searching
 for i:=db_local.count-1 downto 0 do
 if db_local.Items[i]<>local then
 begin
   tmp_pos:=333;
   if not running then exit;
   if (i mod 5)=0 then CheckSync;
   user2:=db_local.Items[i];
   tmp_pos:=334;
   if user2.logged then
   if user2.data^.shared>0 then
   begin
     tmp_pos:=335;
     if (user^.dataport<>0) or (user2.data^.dataport<>0) then // both users firewalled
     if compare(search_data.speed_cmp,Ord(search_data.speed),Ord(user2.data^.speed)) then
     begin
       tmp_pos:=336;
       if user2.shared<>nil then
       if user2.shared.Count>0 then
       for k:=0 to user2.shared.Count-1 do
       begin
         tmp_pos:=1241;
         sh:=user2.shared.Items[k];
         j:=sh^.id;
         if (k mod 20)=0 then CheckSync;
         match:=true;
         if not b[j] then
          match:=false;
         tmp_pos:=1242;
         if match then
          if (j=SHARED_OTHER) or (sh^.mime=TYPE_AUDIO) or (sh^.mime=TYPE_VIDEO) then
           if not compare(search_data.bitrate_cmp,search_data.bitrate,sh^.bitrate) then match:=false;
         if match then
          if not compare(search_data.size_cmp,search_data.size,sh^.size) then match:=false;
         tmp_pos:=1243;
         if match then
         if (sh^.mime=TYPE_MP3) or (sh^.mime=TYPE_AUDIO) or (sh^.mime=TYPE_VIDEO) then
         begin
           if not compare(search_data.freq_cmp,search_data.freq,sh^.frequency) then match:=false
           else if not compare(search_data.time_cmp,search_data.time,sh^.time) then match:=false;
         end;
         tmp_pos:=1244;
         if match then
         begin
           tmp_pos:=1245;
           for m:=0 to max_search_array-1 do
            if match then
             if search_data.include[m]<>'' then
              if pos(search_data.include[m],sh^.short)=0 then match:=false;
           tmp_pos:=337;
           for m:=0 to max_search_array-1 do
            if match then
             if search_data.exclude[m]<>'' then
              if pos(search_data.exclude[m],sh^.short)<>0 then match:=false;
           tmp_pos:=1246;
           if match then
           begin
             // found a match
             tmp_pos:=1247;
             str:='"'+user2.shared.GetFileName(k)+'" '+null_md5+' '+IntToStr(sh^.size)+' '+IntToStr(sh^.bitrate)+' '+IntToStr(sh^.frequency)+' '+IntToStr(sh^.time)+' '+user2.nick+' 0 '+IntToStr(Ord(user2.data^.speed));
             tmp_pos:=1248;
             if search_data.ext_queue then
             begin
               if user2.data^.queue=-1 then str:=str+' n/a'
               else str:=str+' '+IntToStr(user2.data^.uploads+user2.data^.queue-user2.data^.max_up);
             end;
             tmp_pos:=340;
             if search_data.ext_soft then str:=str+' '+AddStr(user2.data^.software);
             tmp_pos:=1249;
             if local=nil then user^.server.Exec(MSG_SRV_SEARCH_RESULT,user^.nick+' '+str)
             else Exec(user,MSG_SERVER_SEARCH_RESULT,str);
             inc(count);
             tmp_pos:=341;
             if count>=search_data.max then
             begin
               Result:=count;
               exit;
             end;
           end;
         end;
       end;
     end;
   end;
 end;
 tmp_pos:=342;
 Result:=count;
end;

procedure Handler_Search;
var
 i,j,k:Integer;
 dec: Integer;
 err: Boolean;
 srv: TServer;
begin
 tmp_pos:=360;
 if not isLogged then exit;
 if local<>nil then
 begin // local user
   tmp_pos:=361;
   if not CheckParams(3)then
   begin
     local.Exec(MSG_SERVER_SEARCH_END,'');
     exit;
   end;
   tmp_pos:=1232;
   if not allow_share then
   begin
     local.Exec(MSG_SERVER_SEARCH_END,'');
     exit;
   end;
   tmp_pos:=12262;
   if search_searchblock then
   if local.level<napUserModerator then
   if not StrHash_FindString(db_friends,local.nick,true) then
   begin
     if local.shared.Count<search_searchblockshare then
     begin
       local.Exec(MSG_SERVER_SEARCH_END,'');
       Error('Lt@CȂ̂Ōł܂B('
       +IntToStr(local.shared.Count)+'/'+IntToStr(search_searchblockshare)+'t@C)',true);
       exit;
     end;
     if local.shared_size<=search_searchblocksharesize then
     begin
       local.Exec(MSG_SERVER_SEARCH_END,'');
       Error('Lt@CTCYȂ̂Ōł܂B('
       +IntToStr(local.shared_size div Megabyte)+'/'+IntToStr(search_searchblocksharesize div Megabyte)+'Mb)',true);
       exit;
     end;
   end;
   tmp_pos:=1233;
   if not local.BufferEmpty then
   begin
     local.Exec(MSG_SERVER_NOSUCH,'search failed: too many pending searches');
     local.Exec(MSG_SERVER_SEARCH_END,'');
     local.searches_count:=0;
     exit;
   end;
   tmp_pos:=362;
   if local.searchespm>=flood_max_searches then
   begin
     local.Exec(MSG_SERVER_NOSUCH,'search failed: too many pending searches');
     local.Exec(MSG_SERVER_SEARCH_END,'');
     inc(local.searchespm);
     exit;
   end;
   tmp_pos:=1234;
   if local.searches_count>0 then
   begin
     local.Exec(MSG_SERVER_NOSUCH,'search failed: too many pending searches');
     local.Exec(MSG_SERVER_SEARCH_END,'');
     inc(local.searchespm);
     local.searches_count:=0;
     exit;
   end;
   tmp_pos:=363;
   if pos('FILENAME CONTAINS',uppercase(gcmd.cmd))=0 then
   begin
     local.Exec(MSG_SERVER_NOSUCH,'search failed: request contained no valid words');
     local.Exec(MSG_SERVER_SEARCH_END,'');
     exit;
   end;
   inc(local.searchespm);
 end
 else
 begin
   tmp_pos:=364;
   if (not allow_share) or disableremotesearch or (local_files<1) then
   begin
     user^.server.Exec(MSG_SRV_SEARCH_END,user^.nick);
     exit;
   end;
   if search_noforward_results and CheckLag(user^.server) then
   begin
     user^.server.Exec(MSG_SRV_SEARCH_END,user^.nick);
     exit;
   end;
   tmp_pos:=12262;
   if search_searchblock then
   if user^.level<napUserModerator then
   if not StrHash_FindString(db_friends,user^.nick,true) then
   if user^.shared<search_searchblockshare then
   begin
     user^.server.Exec(MSG_SERVER_SEARCH_END,user^.nick);
     Exec(user,MSG_SERVER_NOSUCH,'<'+servername_t+'> Lt@CȂ̂Ń[gł܂B('
     +IntToStr(user^.shared)+'/'+IntToStr(search_searchblockshare)+'t@C)');
     exit;
   end;
   tmp_pos:=365;
   SplitString(gcmd.cmd,hlist);
 end;
 tmp_pos:=366;
 with search_data do
 begin
    for j:=0 to max_search_array-1 do
    begin
     include[j]:='';
     exclude[j]:='';
    end;
    max:=defsearchresults;
    mime:=TYPE_MP3;
    speed_cmp:=napNoCompare;
    bitrate_cmp:=napNoCompare;
    freq_cmp:=napNoCompare;
    size_cmp:=napNoCompare;
    time_cmp:=napNoCompare;
    local:=false;
    nonmp3:=false;
    ext_soft:=false;
    ext_queue:=false;
 end;
 err:=false;
 tmp_pos:=367;
 while hlist.Count>0 do
 begin
   hlist.Strings[0]:=uppercase(hlist.Strings[0]);
   dec:=0;
   if hlist.Strings[0]='FILENAME' then
   begin
     if hlist.Count<3 then err:=true
     else
     begin
       dec:=3;
       if uppercase(hlist.Strings[1])='CONTAINS' then
         SearchInclude(search_data,hlist.Strings[2],true)
       else if uppercase(hlist.Strings[1])='EXCLUDES' then
         SearchInclude(search_data,hlist.Strings[2],false)
       else err:=true;
     end;
   end; // end FILENAME
   if hlist.Strings[0]='MAX_RESULTS' then
   begin
     if hlist.Count<2 then err:=true
     else search_data.max:=StrToIntDef(hlist.Strings[1],search_data.max);
     dec:=2;
   end; // end MAX_RESULTS
   if hlist.Strings[0]='TYPE' then
   begin
     if hlist.Count<2 then err:=true
     else search_data.mime:=StrToType(hlist.Strings[1]);
     dec:=2;
   end; // end TYPE
   if hlist.Strings[0]='LINESPEED' then
   begin
     if hlist.Count<3 then err:=true
     else
     begin
       search_data.speed_cmp:=Str2Compare(hlist.Strings[1]);
       search_data.speed:=TNapSpeed(StrToIntDef(hlist.Strings[2],0));
       dec:=3;
     end;
   end; // end LINESPEED
   if hlist.Strings[0]='BITRATE' then
   begin
     if hlist.Count<3 then err:=true
     else
     begin
       search_data.bitrate_cmp:=Str2Compare(hlist.Strings[1]);
       search_data.bitrate:=StrToIntDef(hlist.Strings[2],0);
       if search_data.bitrate=0 then search_data.bitrate:=24;
       dec:=3;
     end;
   end; // end BITRATE
   if hlist.Strings[0]='FREQ' then
   begin
     if hlist.Count<3 then err:=true
     else
     begin
       search_data.freq_cmp:=Str2Compare(hlist.Strings[1]);
       search_data.freq:=StrToIntDef(hlist.Strings[2],0);
       if search_data.freq=0 then search_data.freq:=16000;
       dec:=3;
     end;
   end; // end FREQ
   if (hlist.Strings[0]='SIZE') or (hlist.Strings[0]='FILESIZE') then
   begin
     if hlist.Count<3 then err:=true
     else
     begin
       search_data.size_cmp:=Str2Compare(hlist.Strings[1]);
       search_data.size:=StrToInt64Def(hlist.Strings[2],0);
       dec:=3;
     end;
   end; // end SIZE
   if hlist.Strings[0]='DURATION' then
   begin
     if hlist.Count<3 then err:=true
     else
     begin
       search_data.time_cmp:=Str2Compare(hlist.Strings[1]);
       search_data.time:=StrToIntDef(hlist.Strings[2],0);
       dec:=3;
     end;
   end; // end DURATION
   if (hlist.Strings[0]='LOCAL') or (hlist.Strings[0]='LOCAL_ONLY') then
   begin // local only
     if local<>nil then
      search_data.local:=true;
     dec:=1;
   end;
   if hlist.Strings[0]='SHOW_SOFTWARE' then
   begin
     search_data.ext_soft:=true;
     dec:=1;
   end;
   if hlist.Strings[0]='SHOW_QUEUE' then
   begin
     search_data.ext_queue:=true;
     dec:=1;
   end;
   if (hlist.Strings[0]='WMA-FILE') or (hlist.Strings[0]='WMA_FILE') then
   begin // WMA-FILE
     //search_data.mime:=napTypeAudio;
     dec:=1;
   end;
   if dec=0 then err:=true;
   if err then
   begin
     tmp_pos:=368;
     if local=nil then user^.server.Exec(MSG_SRV_SEARCH_END,user^.nick)
     else Exec(user,MSG_SERVER_SEARCH_END,'');
     exit;
   end;
   for i:=1 to dec do
    if hlist.count>0 then
     hlist.Delete(0);
 end;
 tmp_pos:=369;
 // checking parsed parameters
 err:=false;
 with search_data do
 begin
  j:=0;
  for i:=0 to max_search_array-1 do
   if Length(include[i])>j then j:=Length(include[i]);
  if j<2 then
   if search_data.size_cmp=napNoCompare then
    err:=true;
  if max<1 then
  begin
    if user^.server<>nil then user^.server.Exec(MSG_SRV_SEARCH_END,user^.nick)
    else
    begin
      Exec(user,MSG_SERVER_NOSUCH,'search failed: request contained no valid words');
      Exec(user,MSG_SERVER_SEARCH_END,'');
    end;
    exit;
  end;
  tmp_pos:=370;
  if user^.server<>nil then
  begin
    if maxremotesearchresults>0 then
     if max>maxremotesearchresults then max:=maxremotesearchresults;
  end
  else
   if maxsearchresults>0 then
    if max>maxsearchresults then max:=maxsearchresults;
 end;
 tmp_pos:=371;
 if err then
 begin
   if local=nil then user^.server.Exec(MSG_SRV_SEARCH_END,user^.nick)
   else Exec(user,MSG_SERVER_SEARCH_END,'');
   exit;
 end;
 tmp_pos:=372;
 with search_data do // checking for WinMX/FileNavigator command
 begin
   nonmp3:=false;
   if bitrate_cmp=napEqual then
    if bitrate=24 then
     if freq_cmp=napEqual then
      if freq=16000 then
       nonmp3:=true;
 end;
 inc(num_searches);
 CheckSync;
 search_data_old:=search_data; // saving old data, cos "search" changes .include strings
 if network_hub or (not allow_share) then i:=0
 else i:=Search;
 search_data:=search_data_old;
 if log_search then
 begin
  if local=nil then Log(slSearch,GetLangT(LNG_SEARCHLOG4,user^.nick,user^.software,gcmd.cmd,IntToStr(i)))
  else Log(slSearch,GetLangT(LNG_SEARCHLOG3,local.nick,local.software,gcmd.cmd,IntToStr(i)));
 end;
 tmp_pos:=373;
 if local=nil then
 begin // that was remote search
   user^.server.Exec(MSG_SRV_SEARCH_END,user^.nick);
   exit;
 end;
 local.last_search_time:=GetTickCount;
 local.searches_count:=0;
 tmp_pos:=374;
 k:=0;
 if num_servers>0 then
  for j:=0 to db_servers.Count-1 do
  begin
    srv:=db_servers.Items[j];
    if srv.logged then
    if srv.hub=nil then
     if not srv.lag then
      inc(k);
  end;
 if  (i<search_data.max) and (num_servers>0) and (search_data.local=false) and (k>0) then
 begin
   WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
   local.searches_count:=num_servers;
 end
 else
  local.Exec(MSG_SERVER_SEARCH_END,'');
end;

procedure Handler_RemoteSearchResult;
var
 user: POnlineUser;
 loc: TLocalUser;
begin
 tmp_pos:=380;
 user:=db_online.FindUser(FirstParam(gcmd.cmd));
 if user=nil then exit;
 if user^.server<>nil then exit;
 tmp_pos:=381;
 loc:=FindLocalUser(user);
 if loc=nil then exit;
 if loc.searches_count<1 then exit;
 tmp_pos:=382;
 loc.Exec(MSG_SERVER_SEARCH_RESULT,NextParam(gcmd.cmd));
end;

procedure Handler_RemoteSearchEnd;
var
 user: POnlineUser;
 loc: TLocalUser;
begin
 tmp_pos:=390;
 user:=db_online.FindUser(gcmd.cmd);
 if user=nil then exit;
 if user^.server<>nil then exit;
 tmp_pos:=391;
 loc:=FindLocalUser(user);
 if loc=nil then exit;
 if loc.searches_count<1 then exit;
 dec(loc.searches_count);
 tmp_pos:=392;
 if loc.searches_count=0 then
  loc.Exec(MSG_SERVER_SEARCH_END,'');
end;

procedure Handler_Download;
var
 user2: POnlineUser;
 l2: TLocalUser;
begin
 tmp_pos:=400;
 if not isLogged then exit;
 if not CheckParams(2) then exit;
 if (query<>queryNormal) and (query<>queryRemoteUser) then exit;
 if user=nil then exit;
 if search_antidom then
 if user^.level<NapUserModerator then
 if not StrHash_FindString(db_friends,user^.nick,true) then
 begin
   if user^.shared<=search_domshare then
   begin
     Error('Lt@CȂ̂Ń_E[hł܂B('
     +IntToStr(user^.shared)+'/'+IntToStr(search_domshare)+'t@C)',true);
     exit;
   end;
   if local<>nil then
   if local.shared_size<=search_domsharesize then
   begin
     Error('Lt@CTCYȂ̂Ń_E[hł܂B('
     +IntToStr(local.shared_size div Megabyte)+'/'+IntToStr(search_domsharesize div Megabyte)+'Mb)',true);
     exit;
   end;
 end;
 tmp_pos:=401;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   Exec(user,MSG_SERVER_UPLOAD_FAILED,gcmd.cmd);
   UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 if user2^.server<>nil then
 begin
   if local=nil then exit;
   user2^.server.Exec(gcmd.id,user^.nick+' '+gcmd.cmd);
   exit;
 end;
 tmp_pos:=402;
 l2:=FindLocalUser(user2);
 if l2<>nil then
  if user^.level<napUserModerator then
   if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
   begin
     Exec(user,MSG_SERVER_UPLOAD_FAILED,gcmd.cmd);
     UserIsOffline(hlist.Strings[0],true);
     exit;
   end;
 tmp_pos:=403;
 if (user^.dataport=0) and (user2^.dataport=0) then
 begin
   Exec(user,MSG_SERVER_UPLOAD_FAILED,gcmd.cmd);
   Error(GetLangT(LNG_FIREWALL),true);
   exit;
 end;
 tmp_pos:=404;
 if l2=nil then
  Exec(user2,MSG_SERVER_UPLOAD_REQUEST,user^.nick+' "'+hlist.Strings[1]+'" '+IntToStr(Ord(user^.speed)))
 else
  l2.Exec(MSG_SERVER_UPLOAD_REQUEST,user^.nick+' "'+hlist.Strings[1]+'" '+IntToStr(Ord(user^.speed)));
end;

procedure Handler_DownloadFirewall;
var
 str: String;
 user2: POnlineUser;
 l2: TLocalUser;
begin
 tmp_pos:=410;
 if not isLogged then exit;
 if (query<>queryNormal) and (query<>queryRemoteUser) then exit;
 if user=nil then exit;
 if not CheckParams(2) then exit;
 tmp_pos:=411;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   Exec(user,MSG_SERVER_UPLOAD_FAILED,gcmd.cmd);
   UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 if user2^.server<>nil then
 begin
   if local=nil then exit;
   user2^.server.Exec(gcmd.id,user^.nick+' '+gcmd.cmd);
   exit;
 end;
 tmp_pos:=412;
 l2:=FindLocalUser(user2);
 if l2<>nil then
  if user^.level<napUserModerator then
   if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
   begin
     Exec(user,MSG_SERVER_UPLOAD_FAILED,gcmd.cmd);
     UserIsOffline(hlist.Strings[0],true);
     exit;
   end;
 if (user^.dataport=0) and (user2^.dataport=0) then
 begin
   Exec(user,MSG_SERVER_UPLOAD_FAILED,gcmd.cmd);
   Error(GetLangT(LNG_FIREWALL),true);
   exit;
 end;
 tmp_pos:=413;
 str:=user^.nick+' '+IntToStr(user^.ip)+' '+IntToStr(user^.dataport)+' "'+hlist.Strings[1]+
  '" '+null_md5+' '+IntToStr(Ord(user^.speed));
 tmp_pos:=414;
 if l2=nil then
  Exec(user2,MSG_SERVER_UPLOAD_FIREWALL,str)
 else
  l2.Exec(MSG_SERVER_UPLOAD_FIREWALL,str)
end;

procedure Handler_Upload;
var
 str: String;
 user2: POnlineUser;
 l2: TLocalUser;
begin
 tmp_pos:=420;
 if not isLogged then exit;
 if (query<>queryNormal) and (query<>queryRemoteUser) then exit;
 if user=nil then exit;
 if not CheckParams(2) then exit;
 tmp_pos:=421;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 tmp_pos:=422;
 if user2^.server<>nil then
 begin
   if local=nil then exit;
   if gcmd.id<>MSG_SERVER_UPLOAD_FAILED then
   begin
    if log_transfers then
     Log(slTransfer,GetLangT(LNG_TRANSFERLOG5,hlist.Strings[1],user2^.nick,GetServerName(user2^.server),user^.nick));
    inc(num_transfers);
   end;
   user2^.server.Exec(gcmd.id,user^.nick+' '+gcmd.cmd);
   exit;
 end;
 tmp_pos:=423;
 l2:=FindLocalUser(user2);
 if l2<>nil then
  if user^.level<napUserModerator then
   if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
   begin
     Error(GetLangT(LNG_OFFLINE2,hlist.Strings[0]),true);
     exit;
   end;
 if (user^.dataport=0) and (user2^.dataport=0) then
 begin
   Error(GetLangT(LNG_FIREWALL),true);
   exit;
 end;
 tmp_pos:=424;
 if gcmd.id=MSG_SERVER_UPLOAD_FAILED then
 begin
   if l2<>nil then
    l2.Exec(gcmd.id,user^.nick+' '+NextParam(gcmd.cmd))
   else
    Exec(user2,gcmd.id,user^.nick+' '+NextParam(gcmd.cmd));
   exit;
 end;
 tmp_pos:=425;
 if log_transfers then
 begin
  if user^.server<>nil then
    Log(slTransfer,GetLangT(LNG_TRANSFERLOG4,hlist.Strings[1],user2^.nick,user^.nick,GetServerName(user^.server)))
  else
    Log(slTransfer,GetLangT(LNG_TRANSFERLOG3,hlist.Strings[1],user2^.nick,user^.nick));
 end;
 inc(num_transfers);
 tmp_pos:=427;
 str:=user^.nick+' '+IntToStr(user^.ip)+' '+IntToStr(user^.dataport)+' "'+hlist.Strings[1]+'" '+
 null_md5+' '+IntToStr(Ord(user^.speed));
 if l2=nil then
  Exec(user2,MSG_SERVER_FILE_READY,str)
 else
  l2.Exec(MSG_SERVER_FILE_READY,str);
end;

procedure Handler_Browse; // 211
var
 user2: POnlineUser;
 l2: TLocalUser;
 i,j,limit: Integer;
 str: String;
 sh: PShare;
begin
 tmp_pos:=430;
 if not isLogged then exit;
 if (query<>queryNormal) and (query<>queryRemoteUser) then exit;
 if user=nil then exit;
 tmp_pos:=12262;
 if user^.nick<>gcmd.cmd then
 if search_antidom then
 if user^.level<napUserModerator then
 if not StrHash_FindString(db_friends,user^.nick,true) then
 begin
   if user^.shared<search_domshare then
   begin
     Exec(user,MSG_SERVER_BROWSE_END,gcmd.cmd);
     Exec(user,MSG_SERVER_NOSUCH,'<'+servername_t+'> Lt@CȂ̂ŎQƂł܂B('
       +IntToStr(user^.shared)+'/'+IntToStr(search_domshare)+'t@C)');
     exit;
   end;
   if local<>nil then
   if local.shared_size<=search_domsharesize then
   begin
     local.Exec(MSG_SERVER_BROWSE_END,gcmd.cmd);
     Error('Lt@CTCYȂ̂ŎQƂł܂B('
     +IntToStr(local.shared_size div Megabyte)+'/'+IntToStr(search_domsharesize div Megabyte)+'Mb)',true);
     exit;
   end;
 end;
 tmp_pos:=431;
 if user^.level=napUserLeech then
 begin
   Exec(user,MSG_SERVER_BROWSE_END,gcmd.cmd);
   exit;
 end;
 if local<>nil then
 begin
   if not local.BufferEmpty then
   begin
     local.Exec(MSG_SERVER_BROWSE_END,gcmd.cmd);
     exit;
   end;
   if local.searchespm>=flood_max_searches then
   begin
     local.Exec(MSG_SERVER_BROWSE_END,gcmd.cmd);
     inc(local.searchespm);
     exit;
   end;
 end;
 tmp_pos:=432;
 if not CheckParams(1) then exit;
 if user^.server<>nil then
  if browse_noforward_results then
   if CheckLag(GetServerLink(user^.server)) then
   begin // block browse
     Exec(user,MSG_SERVER_BROWSE_END,gcmd.cmd);
     exit;
   end;
 tmp_pos:=433;
 user2:=db_online.FindUser(gcmd.cmd);
 if user2=nil then
 begin
   Error(GetLangT(LNG_BROWSEFAIL),true);
   Exec(user,MSG_SERVER_BROWSE_END,gcmd.cmd);
   exit;
 end;
 tmp_pos:=434;
 if local<>nil then inc(local.searchespm);
 if user2^.server<>nil then
 begin
   if local=nil then exit;
   if browse_noforward_requests then
   if CheckLag(GetServerLink(user2^.server)) then
   begin // block browse
     Exec(user,MSG_SERVER_BROWSE_END,gcmd.cmd);
     exit;
   end;
   user2^.server.Exec(MSG_CLIENT_BROWSE,user^.nick+' '+gcmd.cmd);
   exit;
 end;
 tmp_pos:=435;
 l2:=FindLocalUser(user2);
 if l2=nil then exit; // weird error
  if user^.level<napUserModerator then
   if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
   begin
     Exec(user,MSG_SERVER_BROWSE_END,gcmd.cmd);
     exit;
   end;
 tmp_pos:=436;
 if user2^.level>napUserUser then
  if user<>user2 then // do not inform self
   if not (userHideBrowse in user2^.state) then
    Exec(user2,MSG_SERVER_NOSUCH,GetLangT(LNG_BROWSEMOD,AddStr(Level2Str(user^.level)),user^.nick,decode_ip(user^.ip)));
 j:=0;
 limit:=maxbrowseresults;
 if user^.server<>nil then limit:=maxremotebrowse;
 tmp_pos:=437;
 if l2.shared<>nil then
  for i:=0 to l2.shared.count-1 do
  begin
   sh:=l2.shared.Items[i];
   str:=user2^.nick+' "'+l2.shared.GetFileName(i)+'" '+null_md5+' '+IntToStr(sh^.size)+' '+IntToStr(sh^.bitrate)+' '+IntToStr(sh^.frequency)+' '+IntToStr(sh^.time);
   Exec(user,MSG_SERVER_BROWSE_RESPONSE,str);
   inc(j);
   if limit>0 then
    if j>=limit then
    begin
      Exec(user,MSG_SERVER_BROWSE_END,gcmd.cmd+' 0');
      exit;
    end;
  end;
 Exec(user,MSG_SERVER_BROWSE_END,gcmd.cmd+' 0');
end;

procedure Handler_Queue;
var
 rec: PShare;
 str: String;
 size: Integer;
 user2: POnlineUser;
 l2: TLocalUser;
begin
 tmp_pos:=440;
 if not isLogged then exit;
 if (query<>queryNormal) and (query<>queryRemoteUser) then exit;
 if user=nil then exit;
 if not CheckParams(2) then exit;
 tmp_pos:=441;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 tmp_pos:=442;
 if user2^.server<>nil then
 begin
   if local=nil then exit;
   user2^.server.Exec(gcmd.id,user^.nick+' '+gcmd.cmd);
   exit;
 end;
 l2:=FindLocalUser(user2);
 tmp_pos:=443;
 if (l2=nil) or (l2.shared=nil) then
 begin
  str:=hlist.Strings[1];
  size:=0;
 end
 else
 begin
  rec:=l2.shared.FindRec(hlist.Strings[1]);
  if rec=nil then
  begin
   str:=hlist.Strings[1];
   size:=0;
  end
  else
  begin
   str:=hlist.Strings[1];
   size:=rec^.size;
  end;
 end;
 tmp_pos:=444;
 str:=user^.nick+' "'+str+'" '+IntToStr(size)+' ';
 if hlist.Count<3 then str:=str+'0'
 else str:=str+hlist.Strings[2];
 if l2=nil then
  Exec(user2,MSG_SERVER_LIMIT,str)
 else
  l2.Exec(MSG_SERVER_LIMIT,str)
end;

procedure Handler_Friends;
var
 str: String;
 p: PStringHashItem;
begin
  tmp_pos:=450;
  if not isLogged then exit;
  if not CheckLevel('',napUserAdmin) then exit;
  if not CheckParams(1) then
  begin
   if query=queryChannel then Error(STR_CHSTR_A_FRIENDS);
   exit;
  end;
  tmp_pos:=451;
  str:=AnsiLowerCase(FirstParam(gcmd.cmd));
  if str='add' then
  begin
    str:=trim(AnsiLowerCase(NextParam(gcmd.cmd)));
    if str<>'' then
     if not StrHash_FindString(db_Friends,str,false) then
     begin
       StrHash_Add(db_friends,str);
       Wallop(MSG_SERVER_NOSUCH,wallopFriends,GetLangT(LNG_ADDFRIEND,user^.nick,str),true);
     end;
  end else if str='remove' then
  begin
    str:=trim(AnsiLowerCase(NextParam(gcmd.cmd)));
    if StrHash_Delete(db_friends,str,false) then
     Wallop(MSG_SERVER_NOSUCH,wallopFriends,GetLangT(LNG_REMOVEFRIEND,user^.nick,str),true);
  end else if str='list' then
  begin
    p:=db_friends.first;
    while p<>nil do
    begin
     Error(p^.data);
     p:=p^.next;
    end;
    Error('.');
  end else
  begin
   if query=queryChannel then
    Error(STR_CHSTR_A_FRIENDS)
   else
    Error(GetLangT(LNG_INVALIDARGS),true);
  end;
end;

procedure Handler_JoinChannel;
var
 i,j: Integer;
 ch: TChannel;
 str: String;
 s: PNapCmdEx;
begin
 tmp_pos:=460;
 if db_channels=nil then exit;
 if not isLogged then exit;
 if user=nil then exit;
 if local<>nil then
 begin
   tmp_pos:=461;
   str:=gcmd.cmd;
   if isDigit(str) then // fixing Napster 9.6+ bug
   for i:=db_invitations.count-1 downto 0 do
   begin
     s:=db_invitations.Items[i];
     if s^.data=local.nick then
     begin
       str:=s^.cmd;
       db_invitations.Delete(i);
     end
     else
      if (GetTickCount-s^.id)>EXPIRE_INVITATION then
       db_invitations.Delete(i);
   end;
   str:=channelname(str);
   tmp_pos:=462;
   if (str='') or (str='#') then // invalid channel
   begin
     Error(GetLangT(LNG_INVALIDCHANNEL),true);
     exit;
   end;
   if userMuzzled in user^.state then
   begin
     Error(GetLangT(LNG_CANTTALK),true);
     exit;
   end;
   tmp_pos:=463;
   ch:=FindChannel(str);
   if ch=nil then
   begin
     tmp_pos:=464;
     if (user^.level<napUserModerator) and (allow_create_channels=false) then
     begin
       Error(GetLangT(LNG_NOCREATE),true);
       exit;
     end;
     if db_channels.count>=max_channels_total then
     begin
       Error(GetLangT(LNG_CHANNELLIMIT),true);
       exit;
     end;
     tmp_pos:=465;
     if user^.level<napUserModerator then
     begin
       j:=0;
       for i:=0 to db_channels.count-1 do
       begin
         ch:=db_channels.Items[i];
         if ch.FindUser(user)<>-1 then inc(j);
       end;
       if j>=max_channels then
       begin
         Error(GetLangT(LNG_CHANNELLIMIT),true);
         exit;
       end;
     end;
     tmp_pos:=466;
     ch:=TChannel.Create(str);
     db_channels.Add(ch);
   end
   else
   begin
     tmp_pos:=467;
     if ch.level>user^.level then
     begin
       PermissionDenied('',true);
       exit;
     end;
     tmp_pos:=468;
     if user^.level<napUserModerator then
      if ch.Banned(user^.nick,decode_ip(user^.ip)) then
      begin
        PermissionDenied('',true);
        exit;
      end;
     tmp_pos:=469;
     if not ch.Operator(user) then
     begin
       if ch.users.count>=ch.limit then
       begin
         Error(GetLangT(LNG_CHANNELLIMIT2),true);
         exit;
       end;
       j:=0;
       tmp_pos:=470;
       for i:=0 to db_channels.count-1 do
         if TChannel(db_channels.Items[i]).FindUser(user)<>-1 then inc(j);
       if j>=max_channels then
       begin
         Error(GetLangT(LNG_CHANNELLIMIT),true);
         exit;
       end;
     end;
   end;
   tmp_pos:=471;
 end
 else
 begin
   tmp_pos:=472;
   ch:=FindChannel(gcmd.cmd);
   if ch=nil then
   begin
     ch:=TChannel.Create(gcmd.cmd);
     db_channels.Add(ch);
   end;
 end;
 tmp_pos:=473;
 ch.Join(user);
end;

procedure Handler_PartChannel;
var
 ch: TChannel;
 i: Integer;
begin
 tmp_pos:=480;
 ch:=FindChannel(gcmd.cmd);
 if ch<>nil then
 begin
   tmp_pos:=481;
   ch.Part(user);
   tmp_pos:=482;
   if ch.users.count=0 then
    if not (chRegistered in ch.state) then
     for i:=db_channels.count-1 downto 0 do
      if db_channels.Items[i]=ch then
      begin
        db_channels.Delete(i);
        ch.Free;
      end;
   tmp_pos:=483;
 end;
end;

procedure Handler_ChannelServerCommand(args: String;count: Integer);
var
 moderator, admin, elite, console: Boolean;
 list: TStringList;
 action, str: String;
 i,j: Integer;
 user2: POnlineUser;
 srv: TServer;
begin
 moderator:=user^.level>napUserUser;
 admin:=user^.level>napUserModerator;
 elite:=user^.level>napUserAdmin;
 console:=user^.level=napUserConsole;
 list:=CreateStringList;
 SplitStringEx(args,list);
 if list.count<1 then list.Add('help');
 count:=list.Count-1;
 action:=AnsiLowerCase(list.Strings[0]);
 args:=NextParam(args);
 gcmd.cmd:=args;
 FreeStringList(list);
 if action='version' then
 begin
   if num_servers=0 then Error(SLAVANAP_FULL)
   else begin
     Error(servername_t+'      '#9+SLAVANAP_FULL);
     for i:=0 to db_servers.count-1 do
     begin
       srv:=db_servers.Items[i];
       if srv.logged then
        Error(srv.host+'      '#9+srv.version);
     end;
     Error('.');
   end;
 end else if action='lag' then
 begin
   for i:=0 to db_servers.count-1 do
   begin
     srv:=db_servers.Items[i];
     if srv.logged then
      if srv.hub=nil then
       Error(srv.host+'      '#9+GetLangT(LNG_SLIST_LAGSEC,srv.CountLag));
   end;
   Error('.');
 end else if (action='connect') or (action='link') then
 begin
   if count<1 then
    Error(STR_CHSTR_S_CONNECT)
   else
    gcmd.id:=MSG_CLIENT_CONNECT;
 end else if (action='remove') or (action='kill') then
 begin
   if count<1 then
    Error(STR_CHSTR_S_REMOVE)
   else
    gcmd.id:=MSG_CLIENT_REMOVE_SERVER;
 end else if (action='disconnect') or (action='delink') then
 begin
   if count<1 then
    Error(STR_CHSTR_S_DISCONNECT)
   else
    gcmd.id:=MSG_CLIENT_DISCONNECT;
 end else if action='links' then
   gcmd.id:=MSG_CLIENT_LINKS
 else if action='console' then
 begin
   if num_servers=0 then Error(cons.data^.nick)
   else
   begin
     Error(servername_t+'      '#9+cons.data^.nick);
     for i:=0 to db_servers.count-1 do
     begin
       srv:=db_servers.Items[i];
       if srv.logged then
        Error(srv.host+'      '#9+srv.console);
     end;
     Error('.');
   end;
 end else if action='reconnectors' then
 begin
   Error('db_reconnect:');
   for i:=0 to db_reconnect.count-1 do
    Error('  '+db_reconnect.Strings[i]);
   Error('.');
 end else if action='stats' then
 begin
   if not moderator then
     PermissionDenied('',true)
   else
   begin
     Error('Statistics for '+servername_t);
     Error('Local: '+IntToStr(local_users)+'/'+IntToStr(max_users)+' users, '+IntToStrDot(local_files)+' files, '+IntToStrDot(local_bytes div GigaByte)+' Gb.');
     Error('Total: '+IntToStr(total_users)+'/'+IntToStr(total_users_limit)+' users, '+IntToStrDot(total_files)+' files, '+IntToStrDot(total_bytes div GigaByte)+' Gb.');
     Error('Maximum users: '+IntToStr(local_users_max)+' local, '+IntToStr(total_users_max)+' total.');
     Error(IntToStrDot(total_connections)+' connections, '+IntToStrDot(total_searches+num_searches)+' searches, '+IntToStrDot(total_transfers+num_transfers)+' transfers.');
     Error(IntToStr(sockets_count)+' sockets used.');
     Error(IntToStr(num_servers)+' linked servers.');
     Error('Memory usage: '+IntToStrDot(AllocMemSize)+' bytes.');
     j:=(GetTickCount-start_time) div 60000;
     str:=IntToStr(j mod 60)+' min.';
     if j>59 then
     begin
       j:=j div 60;
       str:=IntToStr(j mod 24)+' hours, '+str;
       if j>23 then
         str:=IntToStr(j div 24)+' days, '+str;
     end;
     Error('Uptime: '+str);
     Error('Bandwidth usage: '+IntToStrDot(total_bytes_in+bytes_in)+' bytes in, '+IntToStrdot(total_bytes_out+bytes_out)+' bytes out.');
     Error('.');
   end;
 end else if action='pingall' then
 begin
   if not moderator then
     PermissionDenied('',true)
   else
   begin
     str:=user^.nick+' pingall '+query_channel+' '+IntToStr(GetTickCount);
     cons.Exec(MSG_SERVER_PING,str);
     Error('Sending ping to '+servername_t);
     for i:=0 to db_servers.count-1 do
     begin
       srv:=db_servers.Items[i];
       if srv.logged then
       begin
         user2:=db_online.FindUser(srv.console);
         if user2<>nil then
         begin
          Exec(user2,MSG_SERVER_PING,str);
          Error('Sending ping to '+srv.host);
         end;
       end;
     end;
   end;
 end else if action='ping' then
 begin
   if not moderator then
     PermissionDenied('',true)
   else if count<1 then
     Error(STR_CHSTR_S_PING)
   else
   begin
     SplitString(AnsiLowerCase(args),hlist);
     str:=user^.nick+' pingall '+query_channel+' '+IntToStr(GetTickCount);
     for j:=0 to hlist.count-1 do
     begin
       if MatchesMaskEx(servername_t,hlist.Strings[j]) then
       begin
         cons.Exec(MSG_SERVER_PING,str);
         Error('Sending ping to '+servername_t);
       end;
       for i:=0 to db_servers.count-1 do
       begin
         srv:=db_servers.Items[i];
         if srv.logged then
         if MatchesMaskEx(srv.host,hlist.Strings[j]) then
         begin
           user2:=db_online.FindUser(srv.console);
           if user2<>nil then
           begin
            Exec(user2,MSG_SERVER_PING,str);
            Error('Sending ping to '+srv.host);
           end;
         end;
       end;
     end;
   end;
 end else if action='help' then
 begin
   if local<>cons then
    Error(STR_CHHLP_MAIN);
   Error(STR_CHHLP_HELPLISTSERVER);
   if moderator then Error(STR_CHHLP_S_CONNECT);
   Error(STR_CHHLP_S_CONSOLE);
   if moderator then Error(STR_CHHLP_S_DISCONNECT);
   if moderator then Error(STR_CHHLP_S_LAG);
   if moderator then Error(STR_CHHLP_S_LINKS);
   if moderator then Error(STR_CHHLP_S_PING);
   if moderator then Error(STR_CHHLP_S_PINGALL);
   if elite then Error(STR_CHHLP_S_REMOVE);
   if moderator then Error(STR_CHHLP_S_STATS);         
   Error(STR_CHHLP_S_VERSION);
   Error('.');
 end
 else
   Error(Format(STR_CHSTR_UNKNOWNSERVER,[action]));
end;

procedure Handler_ChannelAdmin(args: String;count: Integer);
var
 moderator, admin, elite, console: Boolean;
 list: TStringList;
 action: String;
 i,j: Integer;
 user2: POnlineUser;
begin
 moderator:=user^.level>napUserUser;
 admin:=user^.level>napUserModerator;
 elite:=user^.level>napUserAdmin;
 console:=user^.level=napUserConsole;
 list:=CreateStringList;
 SplitStringEx(args,list);
 if list.count<1 then list.Add('help');
 count:=list.Count-1;
 action:=AnsiLowerCase(list.Strings[0]);
 args:=NextParam(args);
 gcmd.cmd:=args;
 FreeStringList(list);
 if action='debug' then
 begin
   if not moderator then
     PermissionDenied('',true)
   else
   begin
     Error('db_online items = '+IntToStr(db_online.CountItems));
     Error('db_local.count = '+IntToStr(db_local.count));
     Error('db_local.capacity = '+IntToStr(db_local.capacity));
     Error('db_servers.count = '+IntToStr(db_servers.count));
     Error('db_registered items = '+IntToStr(db_registered.CountUsers));
     Error('db_bans.count = '+IntToStr(db_bans.count));
     Error('cmd_list.count = '+IntToStr(cmd_list.count));
     Error('sync_reply_list.count = '+IntToStr(sync_reply_list.count));
     Error('.');
   end;
 end else if action='register' then
 begin
   if count<1 then
    Error(STR_CHSTR_A_REGISTER)
   else
    gcmd.id:=MSG_CLIENT_REGISTER_USER;
 end else if action='wallop' then
   gcmd.id:=MSG_CLIENT_WALLOP
 else if action='announce' then
   gcmd.id:=MSG_CLIENT_ANNOUNCE
 else if action='ban' then
 begin
   if count<1 then
     Error(STR_CHSTR_A_BAN)
   else
     gcmd.id:=MSG_CLIENT_BAN;
 end else if action='unban' then
 begin
   if count<1 then
     Error(STR_CHSTR_A_UNBAN)
   else
     gcmd.id:=MSG_CLIENT_UNBAN;
 end else if action='kill' then
 begin
   if count<1 then
     Error(STR_CHSTR_A_KILL)
   else
     gcmd.id:=MSG_CLIENT_KILL;
 end else if action='nuke' then
 begin
   if count<1 then
     Error(STR_CHSTR_A_NUKE)
   else
     gcmd.id:=MSG_CLIENT_NUKE;
 end else if action='level' then
 begin
   if count<2 then
     Error(STR_CHSTR_A_LEVEL)
   else
     gcmd.id:=MSG_CLIENT_SETUSERLEVEL;
 end else if action='muzzle' then
 begin
   if count<1 then
     Error(STR_CHSTR_A_MUZZLE)
   else
     gcmd.id:=MSG_CLIENT_MUZZLE;
 end else if action='unmuzzle' then
 begin
   if count<1 then
     Error(STR_CHSTR_A_UNMUZZLE)
   else
     gcmd.id:=MSG_CLIENT_UNMUZZLE;
 end else if action='cloak' then
   gcmd.id:=MSG_CLIENT_CLOAK
 else if action='banlist' then
   gcmd.id:=MSG_CLIENT_BANLIST
 else if action='software' then
   gcmd.id:=MSG_CLIENT_VERSION_STATS
 else if action='set' then
   gcmd.id:=MSG_CLIENT_SERVER_CONFIG
 else if action='redirect' then
 begin
   if not elite then
     PermissionDenied('',true)
   else if count<2 then
     Error(STR_CHSTR_A_REDIRECT)
   else
     for j:=0 to MAX_INDEX do
     for i:=0 to db_online.list[j].Count-1 do
     begin
       user2:=db_online.list[j].Items[i];
        if user2^.server=nil then
         if user2^.level<>napUserConsole then
          Exec(user2,MSG_CLIENT_REDIRECT,gcmd.cmd);
     end;
 end else if action='cycle' then
 begin
   if not elite then
     PermissionDenied('',true)
   else if count<1 then
     Error(STR_CHSTR_A_CYCLE)
   else
     for j:=0 to MAX_INDEX do
     for i:=0 to db_online.list[j].Count-1 do
     begin
       user2:=db_online.list[j].Items[i];
       if user2^.server=nil then
        if user2^.level<>napUserConsole then
         Exec(user2,MSG_CLIENT_CYCLE,gcmd.cmd);
     end;
 end else if action='ip' then
 begin
   if not moderator then
     PermissionDenied('',true)
   else if count<1 then
     Error(STR_CHSTR_A_IP)
   else
   begin
     user2:=db_online.FindUser(gcmd.cmd);
     if user2=nil then
       UserIsOffline(gcmd.cmd)
     else
       Error('IP for '+user2^.nick+' is '+decode_ip(user2^.ip));
   end;
 end else if action='friends' then
 begin
   if not admin then
     PermissionDenied('',true)
   else if count<1 then
     Error(STR_CHSTR_A_FRIENDS)
   else
     gcmd.id:=MSG_CLIENT_FRIENDS;
 end else if action='help' then
 begin
   if local<>cons then
    Error(STR_CHHLP_MAIN);
   Error(STR_CHHLP_HELPLISTADMIN);
   if moderator then Error(STR_CHHLP_A_ANNOUNCE);
   if moderator then Error(STR_CHHLP_A_BAN);
   if moderator then Error(STR_CHHLP_A_BANLIST);
   if moderator then Error(STR_CHHLP_A_CLOAK);
   if elite then Error(STR_CHHLP_A_CYCLE);
   if admin then Error(STR_CHHLP_A_FRIENDS);
   if moderator then Error(STR_CHHLP_A_IP);
   if moderator then Error(STR_CHHLP_A_KILL);
   if moderator then Error(STR_CHHLP_A_LEVEL);
   if moderator then Error(STR_CHHLP_A_MUZZLE);
   if moderator then Error(STR_CHHLP_A_NUKE);
   if elite then Error(STR_CHHLP_A_REDIRECT);
   if moderator then Error(STR_CHHLP_A_REGISTER);
   if elite then Error(STR_CHHLP_A_VARIABLE)
   else if admin then Error(STR_CHHLP_A_VARIABLE2);
   if moderator then Error(STR_CHHLP_A_SOFTWARE);
   if moderator then Error(STR_CHHLP_A_UNBAN);
   if moderator then Error(STR_CHHLP_A_UNMUZZLE);
   if moderator then Error(STR_CHHLP_A_WALLOP);
   Error('.');
 end
 else
   Error(Format(STR_CHSTR_UNKNOWNADMIN,[action]));
end;

procedure Handler_ChannelCommand(command: String);
var
 action, args: String;
 count: Integer;
 moderator,operator,add_ch: Boolean;
 ch: TChannel;
 p: PStringHashItem;
begin
 ch:=Findchannel(query_channel);
 if ch=nil then exit;
 operator:=ch.Operator(user);
 moderator:=user^.level>napUserUser;
 SplitStringEx(command,hlist);
 if hlist.count<1 then
  action:='>help'
 else
  action:=AnsiLowerCase(hlist.Strings[0]);
 if Length(action)<2 then action:='>help';
 if hlist.count>1 then
  args:=NextParamEx(command)
 else
  args:='';
 count:=hlist.Count-1;
 if count<0 then count:=0;
 gcmd.id:=0;
 gcmd.cmd:=args;
 add_ch:=true;
 action:=copy(action,2,length(action));
 if isdigit(action) then
 begin
   args:=action+' '+args;
   inc(count);
   action:='raw';
 end;
 if action='raw' then
 begin
   SplitStringEx(args,hlist);
   if hlist.count>0 then
   begin
     gcmd.id:=StrToIntDef(hlist.Strings[0],0);
     if gcmd.id<1 then exit;
     gcmd.cmd:=NextParamEx(args);
     ProcessCommand(local,queryChannel);
     exit;
   end;
   action:='help';
 end;
 if (action='admin') or (action='a') then
 begin
   Handler_ChannelAdmin(args,count);
   add_ch:=false;
 end else if (action='server') or (action='s') then
 begin
   Handler_ChannelServerCommand(args,count);
   add_ch:=false;
 end else if action='opsay' then
   gcmd.id:=MSG_CLIENT_CHANNEL_WALLOP
 else if (action='opme') or (action='opemote') then
   gcmd.id:=MSG_CLIENT_CHANNEL_OPEMOTE
 else if (action='me') or (action='emote') then
   gcmd.id:=MSG_CLIENT_EMOTE
 else if action='say' then
   gcmd.id:=0 // do nothing
 else if action='wallop' then
 begin
   gcmd.id:=MSG_CLIENT_WALLOP;
   add_ch:=false;
 end else if action='announce' then
 begin
   gcmd.id:=MSG_CLIENT_ANNOUNCE;
   add_ch:=false;
 end else if action='usermode' then
 begin
   gcmd.id:=MSG_CLIENT_USER_MODE;
   add_ch:=false;
 end else if action='showserver' then
 begin
   if count<1 then
    Error(STR_CHSTR_SHOWSERVER)
   else
    gcmd.id:=MSG_CLIENT_WHICH_SERVER;
   add_ch:=false;
 end else if action='banlist' then
   gcmd.id:=MSG_CLIENT_CHANNEL_BAN_LIST
 else if action='ban' then
 begin
   if count<1 then
     Error(STR_CHSTR_BAN)
   else
     gcmd.id:=MSG_CLIENT_CHANNEL_BAN;
 end else if action='banip' then
 begin
   if count<1 then
     Error(STR_CHSTR_BANIP)
   else
     gcmd.id:=MSG_CLIENT_CHANNEL_BANIP;
 end else if action='unban' then
 begin
   if count<1 then
     Error(STR_CHSTR_UNBAN)
   else
     gcmd.id:=MSG_CLIENT_CHANNEL_UNBAN;
 end else if action='banclear' then
   gcmd.id:=MSG_CLIENT_CHANNEL_CLEAR_BANS
 else if action='banlist' then
   gcmd.id:=MSG_CLIENT_CHANNEL_BAN_LIST
 else if action='op' then
 begin
   if count<1 then
     Error(STR_CHSTR_OP)
   else
     gcmd.id:=MSG_CLIENT_OP;
 end else if action='deop' then
 begin
   if count<1 then
     Error(STR_CHSTR_DEOP)
   else
     gcmd.id:=MSG_CLIENT_DEOP;
 end else if action='oplist' then
 begin
  if not moderator then
    PermissionDenied('',true)
  else
  begin
    p:=ch.ops.first;
    while p<>nil do
    begin
      Error(p^.data);
      p:=p^.next;
    end;
    Error('.');
  end;
 end else if action='voice' then
 begin
   if count<1 then
     Error(STR_CHSTR_VOICE)
   else
     gcmd.id:=MSG_CLIENT_CHANNEL_VOICE;
 end else if action='unvoice' then
 begin
   if count<1 then
     Error(STR_CHSTR_UNVOICE)
   else
     gcmd.id:=MSG_CLIENT_CHANNEL_UNVOICE;
 end else if action='kick' then
 begin
   if count<1 then
     Error(STR_CHSTR_KICK)
   else
     gcmd.id:=MSG_CLIENT_KICK;
 end else if action='mode' then
   gcmd.id:=MSG_CLIENT_CHANNEL_MODE
 else if action='whois' then
 begin
   gcmd.id:=MSG_CLIENT_WHOIS;
   add_ch:=false;
 end else if action='topic' then
   gcmd.id:=MSG_SERVER_TOPIC
 else if action='drop' then
   gcmd.id:=MSG_CLIENT_DROP_CHANNEL
 else if action='remove' then
 begin
   if count<1 then
     Error(STR_CHSTR_REMOVE)
   else
     gcmd.id:=MSG_CLIENT_DROP_CHANNEL;
   add_ch:=false;
 end else if action='clear' then
   gcmd.id:=MSG_CLIENT_CLEAR_CHANNEL
 else if action='part' then
   gcmd.id:=MSG_CLIENT_PART
 else if action='limit' then
 begin
   if count<1 then
     Error(GetLangT(LNG_CHLIMIT,ch.limit))
   else
     gcmd.id:=MSG_CLIENT_CHANNEL_LIMIT;
 end else if action='level' then
 begin
   if count<1 then
     Error(GetLangT(LNG_CHLEVEL2,Level2Str(ch.level)))
   else
     gcmd.id:=MSG_CLIENT_SET_CHAN_LEVEL
 end else if action='invite' then
 begin
   if count<1 then
     Error(STR_CHSTR_INVITE)
   else
     gcmd.id:=MSG_CLIENT_CHANNEL_INVITE_OPENNAP;
 end else if action='motd' then
 begin
   p:=ch.motd.first;
   while p<>nil do
   begin
     if Length(p^.data)<1 then
      Exec(user,MSG_SERVER_EMOTE,ch.channel+' Server ""')
     else
      if p^.data[1]<>';' then
       Exec(user,MSG_SERVER_EMOTE,ch.channel+' Server "'+FormatString(user,p^.data,true)+'"');
     p:=p^.next;  
   end;
 end else if action='help' then
 begin
   if local<>cons then
    Error(STR_CHHLP_MAIN);
   Error(STR_CHHLP_HELPLIST);
   if operator then Error(STR_CHHLP_ADMIN);
   if operator then Error(STR_CHHLP_BAN);
   if operator then Error(STR_CHHLP_BANCLEAR);
   if operator then Error(STR_CHHLP_BANIP);
   if operator then Error(STR_CHHLP_BANLIST);
   if moderator then Error(STR_CHHLP_CLEAR);
   if local=cons then Error(STR_CHHLP_CLS);
   if moderator then Error(STR_CHHLP_DEOP);
   if moderator then Error(STR_CHHLP_DROP);
   Error(STR_CHHLP_EMOTE);
   Error(STR_CHHLP_HELP);
   Error(STR_CHHLP_INVITE);
   if operator then Error(STR_CHHLP_KICK);
   if moderator then Error(STR_CHHLP_LEVEL);
   if operator then Error(STR_CHHLP_LIMIT);
   if operator then Error(STR_CHHLP_MODE);
   if moderator then Error(STR_CHHLP_OP);
   if moderator then Error(STR_CHHLP_OPLIST);
   if operator then Error(STR_CHHLP_OPEMOTE);
   if operator then Error(STR_CHHLP_OPSAY);
   Error(STR_CHHLP_PART);
   Error(STR_CHHLP_RAW);
   if moderator then Error(STR_CHHLP_REMOVE);
   Error(STR_CHHLP_SERVER);
   if moderator then Error(STR_CHHLP_SHOWSERVER);
   if (chTopic in ch.state) or operator then Error(STR_CHHLP_TOPIC);
   if operator then Error(STR_CHHLP_UNBAN);
   if operator then Error(STR_CHHLP_UNVOICE);
   Error(STR_CHHLP_USERMODE);
   if operator then Error(STR_CHHLP_VOICE);
   Error(STR_CHHLP_WHOIS);
   Error('.');
 end
 else
   Error(Format(STR_CHSTR_UNKNOWN,[action]));
 if gcmd.id<>0 then
 begin
   if add_ch then gcmd.cmd:=Trim(ch.channel+' '+gcmd.cmd);
   ProcessCommand(local,queryChannel);
 end;
end;

function CheckFlood(ch: TChannel; text: String): Boolean;
var
 i,user_message, same_message: Integer;
 t: Cardinal;
 str: String;
 data: TNapCmdEx;
 usr: POnlineUser;
begin
 t:=GetTickCount;
 Result:=true;
 if not flood_enable then exit;
 if ch=nil then exit;
 if local=nil then exit;
 if user^.level>napUserUser then exit; // mods+ can bypass flood control
 user_message:=0;
 same_message:=0;
 ch.history.AddCmd(t,local.nick,text);
 for i:=ch.history.Count-1 downto 0 do
 begin
   data:=ch.history.CmdEx(i);
   if (t-data.id)>10000 then
    ch.history.Delete(i)
   else
    if data.cmd=local.nick then
    begin
      inc(user_message);
      if data.data=text then inc(same_message);
    end;
 end;
 if same_message>flood_max_same_message then Result:=false
 else if user_message>flood_max_user_message then
 begin
   if flood_warning then
    if not (locFloodWarning in local.localstate) then
    begin
      local.localstate:=local.localstate+[locFloodWarning];
      local.Exec(MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_FLOODWARN));
      for i:=ch.history.count-1 downto 0 do
       if ch.history.CmdEx(i).cmd=local.nick then
        ch.history.Delete(i);
      exit;
    end;
   Result:=false;
 end;
 if Result=false then
 begin
   for i:=ch.history.count-1 downto 0 do
    if ch.history.CmdEx(i).cmd=local.nick then
     ch.history.Delete(i);
   local.localstate:=local.localstate-[locFloodWarning];
   local.Exec(MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_FLOODMUZZLE1));
   str:=ch.channel+' Server '+GetLangT(LNG_FLOODMUZZLE2,user^.nick);
   for i:=0 to ch.users.count-1 do
   begin
     usr:=ch.users.Items[i];
     if (usr^.server=nil) and (usr<>user) then
      Exec(usr,MSG_SERVER_PUBLIC,str);
   end;
   user^.state:=user^.state+[userMuzzled];
   WriteAllServers(MSG_SRV_FLOODER,'',ch.channel+' '+user^.nick);
   CompleteSyncUser(nil,user);
 end;
end;

procedure Handler_Flooder;
var
 usr: POnlineUser;
 ch: TChannel;
 str: String;
 i: Integer;
begin
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then exit;
 str:=ch.channel+' Server '+GetLangT(LNG_FLOODMUZZLE2,hlist.Strings[1]);
 for i:=0 to ch.users.count-1 do
 begin
   usr:=ch.users.Items[i];
   if usr^.server=nil then
    Exec(usr,MSG_SERVER_PUBLIC,str);
 end;
end;

procedure Handler_Public;
var
 ch: TChannel;
 usr: POnlineUser;
 str: String;
 vis: Boolean;
 i: Integer;
begin
 tmp_pos:=490;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 if query=queryChannel then exit;
 tmp_pos:=491;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then exit;
 if ch.FindUser(user)=-1 then exit;
 str:=NextParamEx(gcmd.cmd);
 tmp_pos:=492;
 if prevent_shouting then
  if uppercase(str)=str then
  begin
    str:=AnsiLowerCase(str);
    gcmd.cmd:=ch.channel+' '+str;
  end;
 if Length(str)>0 then
  if str[1]='>' then
  if query=queryNormal then
  begin
   query_channel:=ch.channel;
   query:=queryChannel;
   Handler_ChannelCommand(str);
   exit;
  end;
 tmp_pos:=493;
 if (user^.server=nil) and (userMuzzled in user^.state) then
 begin
   Error(GetLangT(LNG_CANTTALK),true);
   exit;
 end;
 if user^.server=nil then
  if not ch.Operator(user) then
   if chModerated in ch.state then
   if not StrHash_FindString(ch.voices,user^.nick,true) then
   begin
     Error(GetLangT(LNG_CANTTALK),true);
     exit;
   end;
 tmp_pos:=494;
 if block_cqex_chat then BlockCQEXChat(str);
 if Length(str)>max_channelmsg_len then
  str:=Copy(str,1,max_channelmsg_len);
 if local<>nil then
  if not CheckFlood(ch,str) then exit;
 tmp_pos:=495;
 vis:=ch.Visible(user);
 for i:=0 to ch.users.count-1 do
 begin
   usr:=ch.users.Items[i];
   if usr^.server=nil then
   begin
    if vis or (usr^.level>napUserUser) then
     Exec(usr,MSG_SERVER_PUBLIC,ch.channel+' '+user^.nick+' '+str)
    else
     Exec(usr,MSG_SERVER_PUBLIC,ch.channel+' Operator '+str);
   end;
 end;
 tmp_pos:=496;
 if user^.server=nil then
  ch.WriteChannelServers(gcmd.id,user^.nick+' '+gcmd.cmd);
end;

procedure Handler_Emote;
var
 ch: TChannel;
 usr: POnlineUser;
 str: String;
 vis: Boolean;
 i: Integer;
begin
 tmp_pos:=500;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 if (user^.server=nil) and (userMuzzled in user^.state) then
 begin
   Error(GetLangT(LNG_CANTTALK),true);
   exit;
 end;
 tmp_pos:=501;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then exit;
 if ch.FindUser(user)=-1 then exit;
 if hlist.count=1 then str:='""'
 else if hlist.count=2 then str:='"'+hlist.Strings[1]+'"'
 else str:='"'+NextParamEx(gcmd.cmd)+'"';
 tmp_pos:=502;
 if block_cqex_chat then BlockCQEXChat(str);
 if Length(str)>max_channelmsg_len then
  str:=Copy(str,1,max_channelmsg_len);
 if prevent_shouting then
  if uppercase(str)=str then
  begin
   str:=AnsiLowerCase(str);
   gcmd.cmd:=ch.channel+' '+str;
  end;
 if local<>nil then
  if not CheckFlood(ch,str) then exit;
 vis:=ch.Visible(user);
 tmp_pos:=503;
 for i:=0 to ch.users.count-1 do
 begin
   usr:=ch.users.Items[i];
   if usr^.server=nil then
   begin
    if vis or (usr^.level>napUserUser) then
     Exec(usr,MSG_SERVER_EMOTE,ch.channel+' '+user^.nick+' '+str)
    else
     Exec(usr,MSG_SERVER_EMOTE,ch.channel+' Operator '+str);
   end;
 end;
 tmp_pos:=504;
 if user^.server=nil then
  ch.WriteChannelServers(gcmd.id,user^.nick+' '+gcmd.cmd);
end;

procedure Handler_ListChannels;
var
 ch: TChannel;
 i: Integer;
begin
 tmp_pos:=510;
 if not isLogged then exit;
 if user=nil then exit;
 tmp_pos:=511;
 for i:=0 to db_channels.count-1 do
 begin
   ch:=db_channels.Items[i];
   if (not (chPrivate in ch.state)) or (user^.level>napUserUser) then
   if ch.level<=user^.level then
   case query of
     queryChannel,
     queryOperServ,
     queryNickServ,
     queryChanServ,
     queryMsgServ: Error('['+IntToStr(ch.users.count)+'] '+ch.channel);
     else Exec(user,MSG_SERVER_CHANNEL_LIST,ch.channel+' '+IntToStr(ch.users.count)+' '+ch.topic);
   end;
 end;
 tmp_pos:=512;
 case query of
  queryChannel,
  queryOperServ,
  queryNickServ,
  queryChanServ,
  queryMsgServ: Error('.');
  else Exec(user,MSG_SERVER_CHANNEL_LIST_END,'');
 end;
 tmp_pos:=513;
end;

procedure Handler_ListAllChannels;
var
 ch: TChannel;
 i: Integer;
begin
 tmp_pos:=520;
 if not isLogged then exit;
 if user=nil then exit;
 tmp_pos:=521;
 for i:=0 to db_channels.count-1 do
 begin
   ch:=db_channels.Items[i];
   case query of
     queryChannel,
     queryOperServ,
     queryNickServ,
     queryChanServ,
     queryMsgServ: Error('['+IntToStr(ch.users.count)+'] '+ch.channel);
     else Exec(user,MSG_SERVER_FULL_CHANNEL_INFO,ch.channel+' '+IntToStr(ch.users.count)+' '+IntToStr(Ord(chPrivate in ch.state))+' '+IntToStr(Ord(ch.level))+' '+IntToStr(ch.limit)+' '+AddStr(ch.topic));
   end;
 end;
 tmp_pos:=522;
 case query of
  queryChannel,
  queryOperServ,
  queryNickServ,
  queryChanServ,
  queryMsgServ: Error('.');
  else Exec(user,MSG_CLIENT_FULL_CHANNEL_LIST,'');
 end;
end;

procedure Handler_ChannelTopic;
var
 ch: TChannel;
begin
 tmp_pos:=530;
 if query=queryServer then
 begin
  if not CheckParams(2) then exit;
  ch:=FindChannel(hlist.Strings[0]);
  if ch=nil then exit;
  ch.SetTopic(NextParamEx(gcmd.cmd));
  exit;
 end;
 tmp_pos:=531;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 tmp_pos:=532;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then exit;
 if ch.FindUser(user)=-1 then
 begin
   if user.level>napUserUser then
   if hlist.count>1 then
   begin
    ch.SetTopic(NextParamEx(gcmd.cmd));
    if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
   end;
   exit;
 end;
 tmp_pos:=533;
 if hlist.count=1 then
 begin
   Exec(user,MSG_SERVER_TOPIC,ch.channel+' '+ch.topic);
   exit;
 end;
 if not ch.Operator(user) then
 if not (chTopic in ch.state) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=534;
 ch.SetTopic(NextParamEx(gcmd.cmd));
 Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangT(LNG_CHTOPIC,Level2Str(user^.level),user^.nick,ch.channel,ch.topic),true);
 if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_ChanBanList;
var
 ch: TChannel;
 p: PStringHashItem;
begin
 tmp_pos:=540;
 if not isLogged then exit;
 if user=nil then exit;
 if not CheckParams(1) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=541;
 if not ch.Operator(user) then
  if user^.level<napUserModerator then
  begin
    PermissionDenied('',true);
    exit;
  end;
 tmp_pos:=542;
 p:=ch.bans.first;
 while p<>nil do
 begin
   case query of
     queryOperServ,
     queryNickServ,
     queryChanServ,
     queryMsgServ,
     queryChannel: Error(p^.data);
     else Exec(user,MSG_SERVER_CHANNEL_BAN_LIST,ch.channel+' '+p^.data);
   end;
   p:=p^.next;
 end;
 tmp_pos:=543;
 case query of
   queryOperServ,
   queryNickServ,
   queryChanServ,
   queryMsgServ,
   queryChannel: Error('.');
   else Exec(user,MSG_CLIENT_CHANNEL_BAN_LIST,ch.channel);
 end;
 tmp_pos:=544;
end;

procedure Handler_ChanBan; // 422
var
 ch: TChannel;
 user2: POnlineUser;
 ban,name,ip: String;
begin
 tmp_pos:=550;
 if query<>queryServer then
  if not isLogged then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 tmp_pos:=551;
 if ch=nil then
 begin
   Error('channel ban failed: no such channel',true);
   exit;
 end;
 tmp_pos:=552;
 if query<>queryServer then
 if not ch.Operator(user) then
  if user^.level<napUserModerator then
  begin
   PermissionDenied('',true);
   exit;
  end;
 tmp_pos:=553;
 SplitBan(hlist.Strings[1],name,ip);
 ban:=JoinBan(name,ip);
 if gcmd.id=MSG_CLIENT_CHANNEL_BANIP then
 begin
   user2:=db_online.FindUser(name);
   if user2=nil then
   begin
     UserIsOffline(hlist.Strings[1],true);
     exit;
   end;
   ip:=decode_ip(user2^.ip);
   ban:=JoinBan(name,ip);
 end;
 tmp_pos:=554;
 if StrHash_FindString(ch.bans,ban,true) then
 begin
   Error(GetLangT(LNG_CHALREADYBANNED),true);
   exit;
 end;
 StrHash_Add(ch.bans,ban);
 tmp_pos:=555;
 if query<>queryServer then
 begin
  Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangT(LNG_CHBANNED,user^.nick,ban,ch.channel),true);
  if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
 end; 
end;

procedure Handler_ChanUnban; // 423
var
 ch: TChannel;
begin
 tmp_pos:=560;
 if query<>queryServer then
  if not isLogged then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error('channel ban failed: no such channel',true);
   exit;
 end;
 tmp_pos:=561;
 if query<>queryServer then
 if not ch.Operator(user) then
  if user^.level<napUserModerator then
  begin
    PermissionDenied('',true);
    exit;
  end;
 tmp_pos:=562;
 if not StrHash_Delete(ch.bans,hlist.Strings[1],true) then
 begin
   Error('channel unban failed: no such ban',true);
   exit;
 end;
 tmp_pos:=563;
 if query<>queryServer then
 begin
   Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangT(LNG_CHUNBANNED,user^.nick,hlist.Strings[1],ch.channel),true);
   if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
 end;
end;

procedure Handler_ChanBanClear;
var
 ch: TChannel;
begin
 tmp_pos:=564;
 if query<>queryServer then
  if not isLogged then exit;
 if not CheckParams(1) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=565;
 if query<>queryServer then
 if not ch.Operator(user) then
  if user^.level<napUserModerator then
  begin
    PermissionDenied('',true);
    exit;
  end;
 if ch.bans.Count<1 then
 begin
   Error('There are no bans',true);
   exit;
 end;
 tmp_pos:=566;
 StrHash_Clear(ch.bans);
 if query<>queryServer then
 begin
  Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangEx('$1 cleared the ban list on $2',user^.nick,ch.channel),true);
  if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
 end; 
end;

procedure Handler_Whois;
var
 user2: POnlineUser;
 rec: PRegisteredUser;
 l2: TLocalUser;
 i,j: Integer;
 state, str: String;
 ch: TChannel;
 cloaked: Boolean;
 p: PNapCmdEx;
begin
 tmp_pos:=570;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 user2:=db_online.FindUser(gcmd.cmd);
 tmp_pos:=571;
 cloaked:=false;
 if user2<>nil then
  if userCloaked in user2^.state then
   if user^.level<napUserModerator then
    cloaked:=true;
 tmp_pos:=1224;
 if (user2=nil) or cloaked then
 begin
   rec:=db_registered.FindUser(gcmd.cmd);
   tmp_pos:=1225;
   if rec=nil then
   begin
     i:=db_whowas.FindByCmd(AnsiLowerCase(gcmd.cmd));
     str:=gcmd.cmd+' User 0';
     tmp_pos:=1226;
     if (i<>-1) and (not cloaked) then
     begin
       p:=db_whowas.Items[i];
       SplitString(p.data,hlst);
       tmp_pos:=1227;
       if hlst.count>2 then
        str:=gcmd.cmd+' '+AddStr(hlst.Strings[1])+' '+hlst.Strings[2];
     end;
     tmp_pos:=1228;
     Exec(user,MSG_SERVER_WHOWAS,str);
     NoSuchUser(true);
     exit;
   end;
   tmp_pos:=572;
   str:=gcmd.cmd+' '+AddStr(Level2Str(rec^.level))+' '+IntToStr(rec^.last_seen);
   Exec(user,MSG_SERVER_WHOWAS,str);
   exit;
 end;
 tmp_pos:=1229;
 j:=DateTimeToUnixTime(now)-user2^.last_seen;
 if j<0 then j:=0;
 tmp_pos:=573;
 str:=gcmd.cmd+' '+AddStr(Level2Str(user2^.level))+' '+IntToStr(j)+' "';
 for i:=0 to db_channels.Count-1 do
 begin
   ch:=db_channels.Items[i];
   if ch.FindUser(user2)<>-1 then
    str:=str+ch.channel+' ';
 end;
 tmp_pos:=574;
 str:=str+'" ';
 if user2^.server=nil then state:='Active'
 else state:='Remote';
 if (user^.level>napUserUser) and (userCloaked in user2^.state) then state:=state+' (cloaked)'; 
 str:=str+AddStr(state)+' ';
 str:=str+IntToStr(user2^.shared)+' '+IntToStr(user2^.downloads)+' '+
 IntToStr(user2^.uploads)+' '+IntToStr(Ord(user2^.speed))+' "'+
 user2^.software+'"';
 i:=0;
 tmp_pos:=1230;
 if user^.level>napUserUser then i:=1;
 if user=user2 then i:=1;
 tmp_pos:=575;
 if i=1 then
 begin // complete whois reply
   str:=str+' '+IntToStr(user2^.total_down)+' '+IntToStr(user2^.total_up)+' '+decode_ip(user2^.ip)+' ';
   l2:=FindLocalUser(user2);
   tmp_pos:=1231;
   if (l2<>nil) and (l2.socket<>INVALID_SOCKET) then
     str:=str+IntToStr(TCPSocket_GetRemoteSin(l2.socket).sin_port)+' '
   else
     str:=str+'0 ';
   str:=str+IntToStr(user2^.dataport)+' anon@'+GetServerName(user2^.server);
   str:=str+' '+GetServerName(user2^.server);
 end;
 tmp_pos:=576;
 Exec(user,MSG_SERVER_WHOIS_RESPONSE,str);
 if user2^.level>napUserUser then
  if user<>user2 then // do not inform self
   if not (userHideWhois in user2^.state) then
    Exec(user2,MSG_SERVER_NOSUCH,GetLangT(LNG_WHOISMOD,AddStr(Level2Str(user^.level)),user^.nick,decode_ip(user^.ip)));
 tmp_pos:=577;
 if (user2=user) and (query=queryNormal) then  // probably Napster asking info about itself. For 10.3+ it would be better to receive stats.
  if user^.server=nil then
   Handler_Stats;
end;

procedure BanUser(ban,server: String;time: Integer; reason: String; write_all: Boolean);
begin
  tmp_pos:=580;
  if time<1 then exit;
  ban:=AnsiLowerCase(ban);
  tmp_pos:=581;
  if db_bans.FindRec(ban)<>-1 then exit;
  db_bans.Ban('server: '+server,ban,reason,time);
  tmp_pos:=582;
  if wallop_serverban then
  begin
   if time=0 then
     Wallop(MSG_SERVER_NOSUCH,wallopBan,GetLangEx('Server $1 banned $2: $3',server,ban,reason),true)
   else
     Wallop(MSG_SERVER_NOSUCH,wallopBan,GetLangEx('Server $1 banned $2 for $3: $4',server,ban,BanTime2Str(time),reason),true);
  end;
  if write_all then WriteAllServers(MSG_SRV_SERVERBAN,'',AddStr(ban)+' '+AddStr(server)+' '+IntToStr(time)+' '+AddStr(reason));
end;

procedure Ban(ban,reason: String;timeout: time_t; write_all: Boolean);
begin
  tmp_pos:=583;
  ban:=AnsiLowerCase(ban);
  if ban='' then exit;
  if ban='*' then exit;
  if ban='*!*' then exit;
  tmp_pos:=584;
  if db_bans.FindRec(ban)<>-1 then
  begin
   if user^.server=nil then
    Exec(user,MSG_SERVER_NOSUCH,'already banned');
   exit;
  end;
  tmp_pos:=585;
  db_bans.Ban(user^.nick,ban,reason,timeout);
  if timeout=0 then
   Wallop(MSG_SERVER_NOSUCH,wallopBan,GetLangEx('$1 banned $2: $3',user^.nick,ban,reason),true)
  else
   Wallop(MSG_SERVER_NOSUCH,wallopBan,GetLangEx('$1 banned $2 for $3: $4',user^.nick,ban,BanTime2Str(timeout),reason),true);
  tmp_pos:=586;
  if write_all then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_BanEx; // 8116
var
 timeout: time_t;
 reason: String;
begin
 tmp_pos:=600;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 tmp_pos:=601;
 if hlist.count<2 then hlist.Add(IntToStr(def_ban_timeout));
 tmp_pos:=602;
 timeout:=StrToIntDef(hlist.Strings[1],def_ban_timeout);
 if (timeout<60) and (timeout<>0) then exit;
 if hlist.count=3 then
  reason:=hlist.Strings[2]
 else
  reason:=NextParam(gcmd.cmd,2);
 Ban(hlist.Strings[0],reason,timeout,user^.server=nil);
end;

procedure Handler_Ban; // 612
var
 reason: String;
begin
 tmp_pos:=590;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 if hlist.count=3 then
  if isDigit(hlist.Strings[2]) then
  begin
    gcmd.id:=MSG_CLIENT_BANEX;
    gcmd.cmd:=AddStr(hlist.Strings[0])+' '+AddStr(hlist.Strings[2])+' '+AddStr(hlist.Strings[1]);
    Handler_BanEx;
  end;
 tmp_pos:=591;
 if hlist.count=2 then
  reason:=hlist.Strings[1]
 else
  reason:=NextParam(gcmd.cmd);
 Ban(hlist.Strings[0],reason,def_ban_timeout,user^.server=nil);
end;

procedure Handler_Unban; // 614
var
 ban: String;
 i: Integer;
begin
 tmp_pos:=610;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 ban:=AnsiLowerCase(hlist.Strings[0]);
 tmp_pos:=612;
 i:=db_bans.FindRec(ban);
 while i<>-1 do
 begin
  Wallop(MSG_SERVER_NOSUCH,wallopBan,GetLangEx('$1 removed ban on $2: $3',user^.nick,ban,NextParam(gcmd.cmd)),true);
  db_bans.Delete(i);
  i:=db_bans.FindRec(ban);
 end;
 tmp_pos:=613;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_Banlist; // 615
var
 str: String;
 i: Integer;
 b: PBan;
begin
 tmp_pos:=620;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if Length(gcmd.cmd)>2 then
 begin // ????? TekNap sends 615 to ban user ???
   gcmd.id:=MSG_CLIENT_BAN;
   Handler_Ban;
 end;
 tmp_pos:=621;
 for i:=0 to db_bans.Count-1 do
 begin
   b:=db_bans.Items[i];
   case query of
     queryChannel,
     queryOperServ,
     queryNickServ,
     queryChanServ,
     queryMsgServ: begin
                    str:=b^.user+'!'+b^.ip+' '+b^.admin+' '+UnixTimeToStr(b^.time)+'-';
                    if b^.expires>0 then
                     str:=str+UnixTimeToStr(b^.expires)
                    else
                     str:=str+'never'; 
                    str:=str+': '+b^.reason;
                    Error(str);
                   end;
     else
      str:=b^.user+' '+b^.ip+' "'+b^.reason+'" '+IntToStr(b^.time)+' ';
      if b^.expires>0 then
       str:=str+IntToStr(b^.expires-b^.time)
      else
       str:=str+'0';
      Exec(user,MSG_SERVER_IP_BANLIST,str);
   end;
 end;
 tmp_pos:=622;
 case query of
      queryChannel,
      queryOperServ,
      queryNickServ,
      queryChanServ,
      queryMsgServ: Error('.');
      else Exec(user,MSG_CLIENT_BANLIST,'');
 end;
end;

procedure Handler_ChangeBan;
var
 b: PBan;
 exp: time_t;
 str,reason: String;
 i: Integer;
 name,ip: String;
 a: Boolean;
begin
 tmp_pos:=623;
 if not isLogged then exit;
 if not CheckParams(2) then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if hlist.count=3 then hlist.Add('');
 tmp_pos:=624;
 SplitBan(hlist.Strings[0],name,ip);
 for i:=0 to db_bans.Count-1 do
 begin
   b:=db_bans.Items[i];
   if (b^.user=name) and (b^.ip=ip) then
   begin
     exp:=StrToIntDef(hlist.Strings[1],b^.expires);
     reason:=hlist.Strings[2];
     a:=false;
     if exp<>b^.expires then
     begin
       b^.expires:=exp;
       if b^.expires>0 then
         str:=UnixTimeToStr(b^.expires)
       else
         str:=GetLangT(LNG_BANS_NEVER_EXPIRE);
       Wallop(MSG_SERVER_NOSUCH,wallopBan,GetLangT(LNG_BANEXPCHANGE,user^.nick,hlist.Strings[0],str),true);
       a:=true;
     end;
     tmp_pos:=625;
     if (reason<>'') and (b^.reason<>reason) then
     begin
       b^.reason:=reason;
       Wallop(MSG_SERVER_NOSUCH,wallopBan,GetLangT(LNG_BANREASONCHANGE,user^.nick,hlist.Strings[0],reason),true);
       a:=true;
     end;
     if a then
      if user^.server=nil then
       WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
     exit;
   end;
 end;
end;

procedure Handler_ChannelDeclineInvite;
var
 i: Integer;
 s: PNapCmdEx;
begin
 if local=nil then exit;
 for i:=db_invitations.count-1 downto 0 do
 begin
   s:=db_invitations.Items[i];
   if s^.data=local.nick then
    db_invitations.Delete(i)
   else
    if (GetTickCount-s^.id)>EXPIRE_INVITATION then
     db_invitations.Delete(i);
 end;
end;

procedure Handler_ChannelInvite;
var
 ch: TChannel;
 str: String;
 user2: POnlineUser;
 l2: TLocalUser;
 s: PNapCmdEx;
 i: Integer;
begin
 tmp_pos:=630;
 if not isLogged then exit;
 if not CheckParams(2) then exit;
 if gcmd.id=MSG_CLIENT_CHANNEL_INVITE_OPENNAP then
 begin // swap arguments
   str:=hlist.Strings[1];
   hlist.Strings[1]:=hlist.Strings[0];
   hlist.Strings[0]:=str;
 end;
 tmp_pos:=631;
 ch:=FindChannel(hlist.Strings[1]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 if (user^.level<napUserModerator) and (ch.FindUser(user)=-1) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=632;
 if user^.level<ch.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   NoSuchUser(true);
   exit;
 end;
 tmp_pos:=633;
 if ch.FindUser(user2)<>-1 then
 begin
   Error(GetLangT(LNG_CHJOINED,user2^.nick,ch.channel),true);
   exit;
 end;
 if user2^.server<>nil then
 begin
   if local=nil then exit;
   user2^.server.Exec(gcmd.id,user^.nick+' '+gcmd.cmd);
   exit;
 end;
 tmp_pos:=634;
 if user2^.server<>nil then
 begin
   user2^.server.Exec(MSG_SRV_SETLASTINV,user2^.nick+' '+hlist.Strings[1]);
 end
 else
 begin
   l2:=FindLocalUser(user2);
   if l2=nil then exit; // weird error
   for i:=db_invitations.count-1 downto 0 do
   begin
     s:=db_invitations.Items[i];
     if s^.data=l2.nick then
      db_invitations.Delete(i)
     else
      if (GetTickCount-s^.id)>EXPIRE_INVITATION then
       db_invitations.Delete(i);
   end;
   db_invitations.AddCmd(GetTickCount,hlist.Strings[1],l2.nick);
 end;
 tmp_pos:=635;
 Exec(user2,MSG_SERVER_NOSUCH,GetLangT(LNG_INVITE,ch.channel,user^.nick));
 Exec(user2,MSG_CLIENT_CHANNEL_INVITE,user^.nick+' '+ch.channel+' "'+ch.topic+'" 0 0');
end;

procedure Handler_Muzzle;
var
 user2: POnlineUser;
 reg: PRegisteredUser;
 str: String;
 l: TNapUserLevel;
 b: Boolean;
begin
 tmp_pos:=640;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 user2:=db_online.FindUser(hlist.Strings[0]);
 reg:=db_registered.FindUser(hlist.Strings[0]);
 tmp_pos:=641;
 if (user2=nil) and (reg=nil) then
 begin
   NoSuchUser(true);
   exit;
 end;
 if user2<>nil then
 begin
   l:=user2^.level;
   b:=userMuzzled in user2^.state;
 end
 else
 begin
   l:=reg^.level;
   b:=userMuzzled in reg^.state;
 end;
 tmp_pos:=642;
 if l>napUserUser then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if b then
 begin
   Error(GetLangT(LNG_MUZZLE1),true);
   exit;
 end;
 tmp_pos:=643;
 if user2<>nil then user2^.state:=user2^.state+[userMuzzled];
 if reg<>nil then reg^.state:=reg^.state+[userMuzzled];
 case hlist.Count of
  1:  str:='';
  2:  str:=' : '+hlist.Strings[1];
  else str:=' : '+Trim(NextParam(gcmd.cmd));
 end;
 Wallop(MSG_SERVER_NOSUCH,wallopMuzzle,GetLangT(LNG_MUZZLE,hlist.Strings[0],user^.nick)+str,true);
 tmp_pos:=644;
 if user^.server=nil then
  WriteAllServers(MSG_CLIENT_MUZZLE,user^.nick,gcmd.cmd);
 if user2<>nil then
  if user2^.server=nil then
   Exec(user2,MSG_SERVER_NOSUCH,GetLangT(LNG_MUZZLE3,NextParam(gcmd.cmd)));
end;

procedure Handler_Unmuzzle;
var
 user2: POnlineUser;
 reg: PRegisteredUser;
 str: String;
 l: TNapUserLevel;
 b: Boolean;
begin
 tmp_pos:=645;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 user2:=db_online.FindUser(hlist.Strings[0]);
 reg:=db_registered.FindUser(hlist.Strings[0]);
 if (user2=nil) and (reg=nil) then
 begin
   NoSuchUser(true);
   exit;
 end;
 tmp_pos:=646;
 if user2<>nil then
 begin
   l:=user2^.level;
   b:=userMuzzled in user2^.state;
 end
 else
 begin
   l:=reg^.level;
   b:=userMuzzled in reg^.state;
 end;
{ if l>user^.level then
 begin
   PermissionDenied(true);
   exit;
 end;} // mods+ can unmuzzle all other mods+ if accedently got muzzled
 tmp_pos:=647;
 if b=false then
 begin
   Error(GetLangT(LNG_UNMUZZLE1),true);
   exit;
 end;
 if user<>nil then user2^.state:=user2^.state-[userMuzzled];
 if reg<>nil then reg^.state:=reg^.state-[userMuzzled];
 case hlist.Count of
  1:  str:='';
  2:  str:=' : '+hlist.Strings[1];
  else str:=' : '+Trim(NextParam(gcmd.cmd));
 end;
 tmp_pos:=648;
 Wallop(MSG_SERVER_NOSUCH,wallopMuzzle,GetLangT(LNG_UNMUZZLE,hlist.Strings[0],user^.nick)+str,true);
 if user^.server=nil then
  WriteAllServers(MSG_CLIENT_UNMUZZLE,user^.nick,gcmd.cmd);
 if user2<>nil then
  if user2^.server=nil then
   Exec(user2,MSG_SERVER_NOSUCH,GetLangT(LNG_UNMUZZLE3));
end;

procedure Handler_MuzzleInv;
var
 user2: POnlineUser;
 reg: PRegisteredUser;
 b: Boolean;
 l: TNapUserLevel;
begin
 tmp_pos:=650;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 user2:=db_online.FindUser(hlist.Strings[0]);
 reg:=db_registered.FindUser(hlist.Strings[0]);
 tmp_pos:=651;
 if user2=nil then
 begin
   NoSuchUser(true);
   exit;
 end;
 if user2<>nil then
 begin
   b:=userMuzzled in user2^.state;
   l:=user2^.level;
 end
 else
 begin
   b:=userMuzzled in reg^.state;
   l:=reg^.level;
 end;
 tmp_pos:=652;
{ if l>=user^.level then
 begin
   PermissionDenied(true);
   exit;
 end;}
 if b then
 begin
   gcmd.id:=MSG_CLIENT_UNMUZZLE;
   Handler_Unmuzzle;
 end
 else
 begin
   gcmd.id:=MSG_CLIENT_MUZZLE;
   Handler_Muzzle;
 end;
end;

procedure Handler_AlterPort; // 613
var
 user2: POnlineUser;
 i: Integer;
begin
 if not isLogged then exit;
 if not CheckLevel('alter_port()',napUserAdmin) then exit;
 if not CheckParams(2) then exit;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 if user2^.level>=user^.level then
 begin
   PermissionDenied('alter port failed',true);
   exit;
 end;
 i:=StrToIntDef(hlist.Strings[1],-1);
 if (i<0) or (i>65535) then
 begin
   Error(hlist.Strings[1]+' is an invalid port',true);
   exit;
 end;
 if user2^.dataport<>i then
 begin
   Wallop(MSG_SERVER_NOSUCH,wallopChange,user^.nick+' changed '+user2^.nick+'''s data port to '+IntToStr(i)+': '+NextParam(gcmd.cmd,2),true);
   user2^.dataport:=i;
 end;
 if user2^.server=nil then Exec(user2,gcmd.id,hlist.Strings[1]);
 if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_AlterSpeed; // 625
var
 user2: POnlineUser;
 i: Integer;
begin
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(2) then exit;
 i:=StrToIntDef(hlist.Strings[1],-1);
 if (i<0) or (i>10) then
 begin
   Error('Invalid speed',true);
   exit;
 end;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 if user2^.level>=user^.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if Ord(user2^.speed)=i then
 begin
   if user^.server=nil then
    Error(hlist.Strings[0]+'''s speed is already '+hlist.Strings[1],true);
   exit;
 end;
 user2^.speed:=TNapSpeed(i);
 Wallop(MSG_SERVER_NOSUCH,wallopChange,GetLangT(LNG_ALTERSPEED,user^.nick,user2^.nick,hlist.Strings[1]),true);
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_Relay;
var
 user2: POnlineUser;
begin
 tmp_pos:=660;
 if not isLogged then exit;
 if not CheckParamsEx(1) then exit;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   if AnsiLowerCase(hlist.Strings[0])<>'server' then
    UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 tmp_pos:=661;
 if hlist.Count>1 then
  Exec(user2,gcmd.id,user^.nick+' '+NextParam(gcmd.cmd))
 else
  Exec(user2,gcmd.id,user^.nick);
end;

procedure Handler_Relay2;
var
 user2: POnlineUser;
 l2: TLocalUser;
begin
 tmp_pos:=662;
 if not isLogged then exit;
 if not CheckParamsEx(1) then exit;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   if AnsiLowerCase(hlist.Strings[0])<>'server' then
    UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 tmp_pos:=663;
 l2:=FindLocalUser(user2);
 if l2<>nil then
  if user^.level<napUserModerator then
   if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
   begin
     UserIsOffline(hlist.Strings[0],true);
     exit;
   end;
 tmp_pos:=664;
 if hlist.Count>1 then
  Exec(user2,gcmd.id,user^.nick+' '+NextParam(gcmd.cmd))
 else
  Exec(user2,gcmd.id,user^.nick);
end;

procedure Handler_UserMode;
var
 st: TUserState;
 str: String;
begin
 if not isLogged then exit;
 SplitString(uppercase(gcmd.cmd),hlist);
 if hlist.count=0 then
 begin
   str:='';
   if query<>queryNormal then
   begin
     if userHideErrors in user^.state then str:='-ERROR '
     else str:='+ERROR ';
     if userHideAnnouncements in user^.state then str:=str+'-ANNOUNCE'
     else str:=str+'+ANNOUNCE';
     if user^.level>napUserUser then
     begin
       if userHideBans in user^.state then str:=str+' -BAN '
       else str:=str+' +BAN ';
       if userHideChange in user^.state then str:=str+'-CHANGE '
       else str:=str+'+CHANGE ';
       if userHideKill in user^.state then str:=str+'-KILL '
       else str:=str+'+KILL ';
       if userHideLevel in user^.state then str:=str+'-LEVEL '
       else str:=str+'+LEVEL ';
       if userHideServer in user^.state then str:=str+'-SERVER '
       else str:=str+'+SERVER ';
       if userHideMuzzle in user^.state then str:=str+'-MUZZLE '
       else str:=str+'+MUZZLE ';
       if userHidePort in user^.state then str:=str+'-PORT '
       else str:=str+'+PORT ';
       if userHideWallop in user^.state then str:=str+'-WALLOP '
       else str:=str+'+WALLOP ';
       if userHideCloak in user^.state then str:=str+'-CLOAK '
       else str:=str+'+CLOAK ';
       if userHideFlood in user^.state then str:=str+'-FLOOD '
       else str:=str+'+FLOOD ';
       if userHidePM in user^.state then str:=str+'-MSG '
       else str:=str+'+MSG ';
       if userHideWhois in user^.state then str:=str+'-WHOIS '
       else str:=str+'+WHOIS ';
       if userHideBrowse in user^.state then str:=str+'-BROWSE '
       else str:=str+'+BROWSE ';
       if userHideMotd in user^.state then str:=str+'-MOTD '
       else str:=str+'+MOTD ';
       if userHideFriends in user^.state then str:=str+'-FRIEND '
       else str:=str+'+FRIEND ';
       if userHideChannel in user^.state then str:=str+'-CHANNEL '
       else str:=str+'+CHANNEL ';
       if userHideRegister in user^.state then str:=str+'-REGISTER '
       else str:=str+'+REGISTER ';
       if userHideVar in user^.state then str:=str+'-VAR'
       else str:=str+'+VAR';
       if userHidePing in user^.state then str:=str+'-PING '
       else str:=str+'+PING ';
     end;
     Error(str);
   end
   else
   begin
     if not (userHideErrors in user^.state) then str:='ERROR ';
     if not (userHideAnnouncements in user^.state) then str:=str+'ANNOUNCE ';
     if user^.level>napUserUser then
     begin
       if not (userHideBans in user^.state) then str:=str+'BAN ';
       if not (userHideChange in user^.state) then str:=str+'CHANGE ';
       if not (userHideKill in user^.state) then str:=str+'KILL ';
       if not (userHideLevel in user^.state) then str:=str+'LEVEL ';
       if not (userHideServer in user^.state) then str:=str+'SERVER ';
       if not (userHideMuzzle in user^.state) then str:=str+'MUZZLE ';
       if not (userHidePort in user^.state) then str:=str+'PORT ';
       if not (userHideWallop in user^.state) then str:=str+'WALLOP ';
       if not (userHideCloak in user^.state) then str:=str+'CLOAK ';
       if not (userHideFlood in user^.state) then str:=str+'FLOOD ';
       if not (userHidePM in user^.state) then str:=str+'MSG ';
       if not (userHideWhois in user^.state) then str:=str+'WHOIS ';
       if not (userHideBrowse in user^.state) then str:=str+'BROWSE ';
       if not (userHideMotd in user^.state) then str:=str+'MOTD ';
       if not (userHideFriends in user^.state) then str:=str+'FRIEND ';
       if not (userHideChannel in user^.state) then str:=str+'CHANNEL ';
       if not (userHideRegister in user^.state) then str:=str+'REGISTER ';
       if not (userHideVar in user^.state) then str:=str+'VAR ';
       if not (userHidePing in user^.state) then str:=str+'PING ';
     end;
     Exec(user,gcmd.id,trim(str));
   end;
   exit;
 end;
 st:=user^.state;
 if uppercase(gcmd.cmd)='HELP' then
 begin
   Error('[U[[h̃wv - pł郂[ḧꗗ :');
   Error('ERROR    '#9' - G[bZ[W\/\');
   Error('ANNOUNCE '#9' - AiEX\/\');
   if user^.level<napUserModerator then
    Error('̑̃[hmods+̂ݗpł܂B')
   else
   begin
    Error('BAN     '#9#9' - Ban/Ban̍m\/\');
    Error('CHANGE  '#9' - [U[̕ύXbZ[W\/\');
    Error('KILL    '#9#9' - ؒf/AJEg폜̍m\/\');
    Error('LEVEL   '#9#9' - [U[̃xύXm\/\');
    Error('SERVER  '#9' - T[o[N̍m\/\');
    Error('MUZZLE  '#9' - ֎~/֎~̍m\/\');
    Error('PORT    '#9#9' - f[^|[gύX̍m\/\');
    Error('WALLOP  '#9' - wallopbZ[W\/\');
    Error('CLOAK   '#9' - N[N/̍m\/\');
    Error('FLOOD   '#9' - flooder̍m\/\');
    Error('MSG     '#9#9' - ̃[U[炠ȂɑIM\/\');
    Error('WHOIS   '#9' - ݂ꂽƂ̍m\/\');
    Error('BROWSE  '#9' - QƂꂽƂ̍m\/\');
    Error('MOTD    '#9' - MOTD\/\(o^ς݃[U[ɂ̂ݗL)');
    Error('FRIEND  '#9' - FlXg̕ύXm\/\');
    Error('CHANNEL '#9' - `lւ̓֎~AǕA폜AIy[^[ǉ/폜...Ȃǂ̃bZ[W\/\');
    Error('REGISTER '#9' - T[o[ւ̐VKo^̍m\/\');
    Error('VAR     '#9#9' - T[o[ϐ̕ύX\/\');
    Error('PING    '#9#9' - T[o[ping/pong̕\/\');
   end;
   Error('.');
 end;
 while hlist.count>0 do
 begin
   str:=hlist.Strings[0];
   hlist.Delete(0);
   if str='NONE' then st:=st+[userHideErrors,userHideAnnouncements,userHideBans,
      userHideChange,userHideKill,userHideLevel,userHideServer,userHideMuzzle,
      userHidePort,userHideWallop,userHideCloak,userHideFlood,userHidePM,
      userHideWhois,userHideBrowse,userHideMotd,userHideFriends,userHideChannel,
      userHideRegister,userHideVar,userHidePing]
   else if str='ALL' then st:=st-[userHideErrors,userHideAnnouncements,userHideBans,
      userHideChange,userHideKill,userHideLevel,userHideServer,userHideMuzzle,
      userHidePort,userHideWallop,userHideCloak,userHideFlood,userHidePM,
      userHideWhois,userHideBrowse,userHideMotd,userHideFriends,userHideChannel,
      userHideRegister,userHideVar,userHidePing]
   else if str='-ERROR' then st:=st+[userHideErrors]
   else if str='+ERROR' then st:=st-[userHideErrors]
   else if str='-ANNOUNCE' then st:=st+[userHideAnnouncements]
   else if str='+ANNOUNCE' then st:=st-[userHideAnnouncements]
   else if user^.level>napUserUser then
   begin
     if str='-BAN' then st:=st+[userHideBans]
     else if str='+BAN' then st:=st-[userHideBans]
     else if str='-CHANGE' then st:=st+[userHideChange]
     else if str='+CHANGE' then st:=st-[userHideChange]
     else if str='-KILL' then st:=st+[userHideKill]
     else if str='+KILL' then st:=st-[userHideKill]
     else if str='-LEVEL' then st:=st+[userHideLevel]
     else if str='+LEVEL' then st:=st-[userHideLevel]
     else if str='-SERVER' then st:=st+[userHideServer]
     else if str='+SERVER' then st:=st-[userHideServer]
     else if str='-MUZZLE' then st:=st+[userHideMuzzle]
     else if str='+MUZZLE' then st:=st-[userHideMuzzle]
     else if str='-PORT' then st:=st+[userHidePort]
     else if str='+PORT' then st:=st-[userHidePort]
     else if str='-WALLOP' then st:=st+[userHideWallop]
     else if str='+WALLOP' then st:=st-[userHideWallop]
     else if str='-CLOAK' then st:=st+[userHideCloak]
     else if str='+CLOAK' then st:=st-[userHideCloak]
     else if str='-FLOOD' then st:=st+[userHideFlood]
     else if str='+FLOOD' then st:=st-[userHideFlood]
     else if str='-MSG' then st:=st+[userHidePM]
     else if str='+MSG' then st:=st-[userHidePM]
     else if str='-WHOIS' then st:=st+[userHideWhois]
     else if str='+WHOIS' then st:=st-[userHideWhois]
     else if str='-BROWSE' then st:=st+[userHideBrowse]
     else if str='+BROWSE' then st:=st-[userHideBrowse]
     else if str='-MOTD' then st:=st+[userHideMotd]
     else if str='+MOTD' then st:=st-[userHideMotd]
     else if str='-FRIEND' then st:=st+[userHideFriends]
     else if str='+FRIEND' then st:=st-[userHideFriends]
     else if str='-CHANNEL' then st:=st+[userHideChannel]
     else if str='+CHANNEL' then st:=st-[userHideChannel]
     else if str='-REGISTER' then st:=st+[userHideRegister]
     else if str='+REGISTER' then st:=st-[userHideRegister]
     else if str='-VAR' then st:=st+[userHideVar]
     else if str='+VAR' then st:=st-[userHideVar]
     else if str='-PING' then st:=st+[userHidePing]
     else if str='+PING' then st:=st-[userHidePing];
   end;
 end;
 if user^.state=st then exit;
 user^.state:=st;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_Wallop; // 627
begin
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if gcmd.cmd='' then exit;
 tmp_pos:=665;
 Wallop(MSG_SERVER_WALLOP,wallopWallop,user^.nick+' '+gcmd.cmd,true);
 if user^.server=nil then
   WriteAllServers(MSG_CLIENT_WALLOP,user^.nick,gcmd.cmd);
end;

procedure Handler_Announce; // 627
var
 i: Integer;
 l: TLocalUser;
begin
 if not isLogged then exit;
 if not CheckLevel('',napUserAdmin) then exit;
 if gcmd.cmd='' then exit;
 tmp_pos:=666;
 for i:=0 to db_local.Count-1 do
 begin
   l:=db_local.Items[i];
   if l.logged then
    if not (userHideWallop in l.data^.state) then
     l.Exec(MSG_SERVER_ANNOUNCE,user^.nick+' '+gcmd.cmd);
 end;
 if user^.server=nil then
   WriteAllServers(MSG_CLIENT_ANNOUNCE,user^.nick,gcmd.cmd);
end;

procedure Handler_DirectBrowse;
var
 str: String;
 user2: POnlineUser;
 l2: TLocalUser;
begin
 tmp_pos:=670;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 if user^.level=napUserLeech then
 begin
   Exec(user,MSG_SERVER_BROWSE_DIRECT_ERR,hlist.Strings[0]+' "'+GetLangT(LNG_BROWSELEECH)+'"');
   exit;
 end;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   Exec(user,MSG_SERVER_BROWSE_DIRECT_ERR,hlist.Strings[0]+' "'+GetLangT(LNG_OFFLINE2,hlist.Strings[0])+'"');
   exit;
 end;
 tmp_pos:=671;
 if user2^.server<>nil then
 begin
   if local=nil then exit;
   user2^.server.Exec(gcmd.id,user^.nick+' '+gcmd.cmd);
   exit;
 end;
 tmp_pos:=672;
 l2:=FindLocalUser(user2);
 if l2<>nil then
  if user^.level<napUserModerator then
   if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
   begin
     Exec(user,MSG_SERVER_BROWSE_DIRECT_ERR,hlist.Strings[0]+' "'+GetLangT(LNG_OFFLINE2,hlist.Strings[0])+'"');
     exit;
   end;
 tmp_pos:=673;
 if (user^.dataport=0) and (user2^.dataport=0) then
 begin
   Exec(user,MSG_SERVER_BROWSE_DIRECT_ERR,hlist.Strings[0]+' "'+GetLangT(LNG_BROWSEFIREWALL)+'"');
   exit;
 end;
 str:=user^.nick;
 if user2^.dataport=0 then
  str:=str+' '+IntToStr(user^.ip)+' '+IntToStr(user^.dataport);
 Exec(user2,gcmd.id,str);
end;

procedure Handler_DirectBrowseOK;
var
 str: String;
 user2: POnlineUser;
 l2: TLocalUser;
begin
 tmp_pos:=674;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   Exec(user,MSG_SERVER_BROWSE_DIRECT_ERR,hlist.Strings[0]+' "'+GetLangT(LNG_OFFLINE2,hlist.Strings[0])+'"');
   exit;
 end;
 tmp_pos:=675;
 if user2^.server<>nil then
 begin
   if local=nil then exit;
   user2^.server.Exec(gcmd.id,user^.nick+' '+gcmd.cmd);
   exit;
 end;
 tmp_pos:=676;
 l2:=FindLocalUser(user2);
 if l2<>nil then
  if user^.level<napUserModerator then
   if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
   begin
     Exec(user,MSG_SERVER_BROWSE_DIRECT_ERR,hlist.Strings[0]+' "'+GetLangT(LNG_OFFLINE2,hlist.Strings[0])+'"');
     exit;
   end;
 tmp_pos:=677;
 if (user^.dataport=0) and (user2^.dataport=0) then
 begin
   Exec(user,MSG_SERVER_BROWSE_DIRECT_ERR,hlist.Strings[0]+' "'+GetLangT(LNG_BROWSEFIREWALL)+'"');
   exit;
 end;
 str:=user^.nick+' '+IntToStr(user^.ip)+' '+IntToStr(user^.dataport);
 Exec(user2,gcmd.id,str);
end;

procedure Handler_Cloak; // 652
var
 i,j: Integer;
 b: Boolean;
 ch: TChannel;
 user2: POnlineUser;
 loc: TLocalUser;
 str: String;
begin
 tmp_pos:=680;
 if not isLogged then exit;
 if not CheckLevel('['+servername_t+'] cloak failed',napUserModerator) then exit;
 b:=userCloaked in user.state;
 if gcmd.cmd='1' then
 begin
   if b then
   begin
     Error(GetLangT(LNG_ERRCLOAKED),true);
     exit;
   end;
   b:=true;
 end else if gcmd.cmd='0' then
 begin
   if not b then
   begin
     Error(GetLangT(LNG_ERRUNCLOAK),true);
     exit;
   end;
   b:=false;
 end else b:=not b;
 tmp_pos:=681;
 if b then
 begin
   user^.state:=user^.state+[userCloaked];
   Wallop(MSG_SERVER_NOSUCH,wallopCloak,GetLangT(LNG_CLOAKED,user^.nick),true);
   if user^.server=nil then WriteAllServers(MSG_CLIENT_CLOAK,user^.nick,'1');
 end
 else
 begin
   user^.state:=user^.state-[userCloaked];
   Wallop(MSG_SERVER_NOSUCH,wallopCloak,GetLangT(LNG_UNCLOAKED,user^.nick),true);
   if user^.server=nil then WriteAllServers(MSG_CLIENT_CLOAK,user^.nick,'0');
 end;
 tmp_pos:=682;
 for i:=0 to db_channels.Count-1 do
 begin
   ch:=db_channels.Items[i];
   j:=ch.FindUser(user);
   if j<>-1 then
   for j:=0 to ch.users.Count-1 do
   try
     user2:=ch.users.Items[j];
     if user2<>user then
     if user2^.server=nil then
     if user2^.level<napUserModerator then
     begin
       if not b then
        Exec(user2,MSG_SERVER_JOIN,ch.channel+' '+user^.nick+' '+IntToStr(user^.shared)+' '+IntToStr(Ord(user^.speed)))
       else
        Exec(user2,MSG_SERVER_PART,ch.channel+' '+user^.nick+' '+IntToStr(user^.shared)+' '+IntToStr(Ord(user^.speed)));
     end;
    except
     on E:Exception do
      DebugLog('Handler_Cloak : exception '+E.Message);
   end;
  end;
  for i:=0 to db_local.count-1 do
  begin
   loc:=db_local.Items[i];
   if loc.logged then
   if loc<>local then
   if loc.level<napUserModerator then
   begin
    str:=StrHash_FindStringEx(loc.hotlist,user^.nick,true);
    if str<>'' then
    begin
     if not b then
      loc.Exec(MSG_SERVER_USER_SIGNON,str+' '+IntToStr(Ord(user^.speed)))
     else
      loc.Exec(MSG_SERVER_USER_SIGNOFF,str);
    end;
   end;
  end;
end;

procedure Handler_SetSpeed; // 700
var
 i: Integer;
begin
 tmp_pos:=690;
 if not isLogged then exit;
 i:=StrToIntdef(gcmd.cmd,-1);
 if (i<0) or (i>10) then
 begin
   Error('invalid speed');
   exit;
 end;
 if Ord(user^.speed)=i then
 begin // probably winmx
   if query=queryNormal then
   if local<>nil then
   if smart_block_winmx then
    if blocked_clients[softWinMX] then
     if (GetTickCount-local.last_seen)<max_winmx_speed_delay then
     if user^.level<napUserModerator then
     if not StrHash_FindString(db_friends,user^.nick,true) then
//     if not StrHash_FindString(db_friends,decode_ip(local.ip),false) then
     begin
       local.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_BLOCKEDWINMX));
       if local.SoftwareId<>softWinMX then
        BanUser(decode_ip(local.ip),servername_t,blocked_bantime,GetLangT(LNG_REASON_WIMXBAN,servername_t),true);
       DisconnectUser(local,'',GetLangT(LNG_DISCONNECT_WINMX,local.nick,local.software),'Handler_SetSpeed',false);
     end;
   exit;
 end;
 tmp_pos:=691;
 user^.speed:=TNapSpeed(i);
 if user^.server=nil then
 begin
   if local=nil then
     WriteAllServers(gcmd.id,user^.nick,gcmd.cmd)
   else
     local.localstate:=local.localstate+[locNeedsUpdate];
 end;
end;

procedure Handler_SetPass; // 701
var
 str: String;
 reg: PRegisteredUser;
begin
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 str:=encode(hlist.Strings[0]);
 if user^.password=str then exit;
 user^.password:=str;
 reg:=db_registered.FindUser(user^.nick);
 if reg<>nil then reg^.password:=str;
 if user^.server=nil then
 begin
   Error('password changed',true);
   WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
 end;
end;

procedure Handler_SetDataPort; // 703
var
 i: Integer;
begin
 if not isLogged then exit;
 if not CheckRangeEx(gcmd.cmd,0,65535) then exit;
 i:=StrToIntDef(gcmd.cmd,-1);
 if (i<0) or (i>65535) then
 begin
   Error('invalid data port',true);
   exit;
 end;
 if i=user^.dataport then exit;
 user^.dataport:=i;
 if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_AlterPass; // 753
var
 user2: POnlineUser;
 reg: PRegisteredUser;
 str: String;
 l: TNapUserLevel;
 i: Integer;
 srv: TServer;
begin
 if not isLogged then exit;
 if not CheckLevel('',napUserAdmin) then exit;
 if not CheckParams(2) then exit;
 str:=AnsiLowerCase(hlist.Strings[0]);
 if num_servers>0 then
  for i:=0 to db_servers.count-1 do
  begin
    srv:=db_servers.Items[i];
    if srv.logged then
     if AnsiLowerCase(srv.reg_user)=str then
     begin
       PermissionDenied('',true);
       exit;
     end;
  end;
 user2:=db_online.FindUser(hlist.Strings[0]);
 reg:=db_registered.FindUser(hlist.Strings[0]);
 if (user2=nil) and (reg=nil) then
 begin
   UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 if user2<>nil then l:=user2^.level
 else l:=reg^.level;
 if l>=user^.level then
 begin
   Error('alter password failed: permission denied',true);
   exit;
 end;
 str:=encode(hlist.Strings[1]);
 if user2<>nil then user2^.password:=str;
 if reg<>nil then reg^.password:=str;
 Wallop(MSG_SERVER_NOSUCH,wallopChange,GetLangT(LNG_CHPASS2,user^.nick,hlist.Strings[0]),true);
 if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_Restart;
begin
 if not isLogged then exit;
 if not CheckLevel('',napUserElite) then exit;
 restart_user:=user^.nick;
 sync_reply_list.AddDoubleCmd(MSG_SR_RESTART,0,'','');
end;

procedure Handler_ServerVersion;
var
 srv: TServer;
 i: Integer;
begin
 if gcmd.cmd<>'' then
 begin
   gcmd.cmd:=AnsiLowerCase(gcmd.cmd);
   for i:=0 to db_servers.Count-1 do
   begin
     srv:=db_servers.Items[i];
     if srv.host=gcmd.cmd then
     if srv.logged then
     begin
       Error('--');
       Error('Server '+srv.host);
       Error(srv.version);
       Error('--');
       exit;
     end;
   end;
 end;
 Error('--');
 Error(SLAVANAP_FULL);
 Error('--');
end;

procedure Handler_ClearChannel;
var
 ch: TChannel;
 i: Integer;
begin
 tmp_pos:=700;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 tmp_pos:=701;
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 if ch.level>=user^.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=702;
 while ch.users.count>0 do
  ch.Part(ch.users.Items[0]);
 Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangT(LNG_CLEARCHANNEL,user^.nick,ch.channel,NextParam(gcmd.cmd)),true);
 tmp_pos:=703;
 if not (chRegistered in ch.state) then
  for i:=db_channels.count-1 downto 0 do
  if db_channels.Items[i]=ch then
  begin
    db_channels.Delete(i);
    ch.Free;
  end;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_DropChannel;
var
 ch: TChannel;
 i: Integer;
begin
 tmp_pos:=710;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=711;
 if ch.level>=user^.level then
 if ch.level<>napUserConsole then
 begin
   PermissionDenied('',true);
   exit;
 end;
 while ch.users.count>0 do
  ch.Part(ch.users.Items[0]);
 Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangT(LNG_DROPCHANNEL,user^.nick,ch.channel,NextParam(gcmd.cmd)),true);
 tmp_pos:=712;
 for i:=db_channels.count-1 downto 0 do
 if db_channels.Items[i]=ch then
 begin
   db_channels.Delete(i);
   ch.Free;
 end;
 tmp_pos:=713;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_Redirect;
var
 user2: POnlineUser;
begin
 tmp_pos:=720;
 if not isLogged then exit;
 if not CheckLevel('',napUserElite) then exit;
 case gcmd.id of
   MSG_CLIENT_REDIRECT: if not CheckParams(3) then exit;
   else if not CheckParams(2) then exit;
 end;
 tmp_pos:=721;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=nil then
 begin
   UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 tmp_pos:=722;
 if user2^.level>=user^.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 Exec(user2,gcmd.id,NextParam(gcmd.cmd));
end;

procedure Handler_ChannelLevel;
var
 ch: TChannel;
 l: TNapUserLevel;
 i: Integer;
 user2: POnlineUser;
 b: Boolean;
begin
 tmp_pos:=730;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=731;
 if ch.level>user^.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if not isLevel(hlist.Strings[1]) then
 begin
   Error(GetLangT(LNG_INVALIDLEVEL,hlist.Strings[1]),true);
   exit;
 end;
 l:=Str2Level(hlist.Strings[1]);
 if ch.level=l then exit;
 if l>user^.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=732;
 ch.level:=l;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
 b:=userCloaked in user^.state;
 tmp_pos:=733;
 for i:=0 to ch.users.count-1 do
 begin
   user2:=ch.users.Items[i];
   if user2^.server=nil then
   begin
     if (user2^.level>napUserUser) or (b=false) then
      Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_CHLEVEL,user^.nick,ch.channel,Level2Str(ch.level)))
     else
      Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_CHLEVEL,'Operator',ch.channel,Level2Str(ch.level)))
   end;
 end;
end;

procedure Handler_ChannelLimit;
var
 ch: TChannel;
 i: Integer;
 user2: POnlineUser;
 b: Boolean;
begin
 tmp_pos:=734;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=735;
 if ch.level>user^.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if not isDigit(hlist.Strings[1]) then
 begin
   Error(GetLangT(LNG_INVALIDARGS),true);
   exit;
 end;
 tmp_pos:=736;
 i:=StrToIntDef(hlist.Strings[1],-1);
 if (i<2) or (i>65535) then
 begin
  Error(GetLangT(LNG_INVALIDARGS),true);
  exit;
 end;
 if ch.limit=i then exit;
 ch.limit:=i;
 tmp_pos:=737;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
 b:=userCloaked in user^.state;
 tmp_pos:=738;
 for i:=0 to ch.users.count-1 do
 begin
   user2:=ch.users.Items[i];
   if user2^.server=nil then
   begin
     if (user2^.level>napUserUser) or (b=false) then
      Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_LIMIT,user^.nick,ch.channel,IntToStr(ch.limit)))
     else
      Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_CHLEVEL,'Operator',ch.channel,IntToStr(ch.limit)))
   end;
 end;
end;

procedure Handler_Nuke; // 611
var
 user2: POnlineUser;
 user3: TLocalUser;
 b: Boolean;
 preg: PRegisteredUser;
 l: TNapUserLevel;
 i: Integer;
 srv: TServer;
 str: String;
begin
 tmp_pos:=740;
 if not isLogged then exit;
 if not CheckLevel('['+servername_t+'] nuke failed',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 b:=false;
 user2:=db_online.FindUser(hlist.Strings[0]);
 if user2=user then user2:=nil;
 tmp_pos:=741;
 str:=AnsiLowerCase(hlist.Strings[0]);
 if user2<>nil then
 begin
   if user2^.level>=user^.level then
   begin
     PermissionDenied('['+servername_t+'] nuke failed',true);
     exit;
   end;
   if user^.server=nil then
    if user2^.level>napUserModerator then
    for i:=0 to db_servers.count-1 do
    begin
      srv:=db_servers.Items[i];
      if srv.logged then
       if AnsiLowerCase(srv.reg_user)=str then
       begin
         Error(GetLangT(LNG_ACCESSREG,Level2Str(user2^.level),user2^.nick,srv.host,srv.console),true);
         exit;
       end;
    end;
   tmp_pos:=742;
   if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
   user3:=FindLocalUser(user2);
   if user3<>nil then
    if user3<>cons then
    begin
      user3.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_NUKEMSG));
      DisconnectUser(user3,'',GetLangT(LNG_NUKED,user2^.nick,user2^.software,user^.nick),'Handler_Nuke',false);
    end;
   tmp_pos:=743;
   b:=true;
 end;
 tmp_pos:=744;
 preg:=db_registered.FindUser(hlist.Strings[0]);
 if preg<>nil then
 begin
   l:=preg^.level;
   if l>=user^.level then
   begin
     PermissionDenied('',true);
     exit;
   end;
   if user^.server=nil then
    if l>napUserModerator then
    for i:=0 to db_servers.count-1 do
    begin
      srv:=db_servers.Items[i];
      if srv.logged then
       if srv.reg_user=str then
       begin
         Error(GetLangT(LNG_ACCESSREG,Level2Str(l),preg^.nick,srv.host,srv.console),true);
         exit;
       end;
    end;
   tmp_pos:=745;
   if not b then
    if user^.server=nil then
     WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
   db_registered.Delete(hlist.Strings[0]);
 end
 else
 if not b then
 begin
   tmp_pos:=746;
   if user^.server<>nil then
    NoSuchUser(true);
   exit;
 end;
 tmp_pos:=747;
 Wallop(MSG_SERVER_NOSUCH,wallopKill,GetLangT(LNG_NUKE,user^.nick,hlist.Strings[0],NextParam(gcmd.cmd)),true);
end;

procedure Handler_SetUserLevel;
var
 l,l1: TNapUserLevel;
 b: Boolean;
 user2, user3: POnlineUser;
 preg: PRegisteredUser;
 ch: TChannel;
 srv: TServer;
 i,j,k: Integer;
 str: String;
begin
 tmp_pos:=750;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(2) then exit;
 if not isLevel(hlist.Strings[1]) then
 begin
   Error(GetLangT(LNG_INVALIDLEVEL,hlist.Strings[1]),true);
   exit;
 end;
 tmp_pos:=751;
 l:=Str2Level(hlist.Strings[1]);
 if l>=user^.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 b:=false;
 str:=AnsiLowerCase(hlist.Strings[0]);
 user2:=db_online.FindUser(hlist.Strings[0]);
 tmp_pos:=752;
 if user2<>nil then
 begin
   b:=true;
   if user2^.level>=user^.level then
   begin
     PermissionDenied('',true);
     exit;
   end;
   if user^.server=nil then
    if user2^.level>napUserModerator then
    if l<>napUserElite then
    for i:=0 to db_servers.count-1 do
    begin
      srv:=db_servers.Items[i];
      if srv.logged then
       if AnsiLowerCase(srv.reg_user)=str then
       begin
         Error(GetLangT(LNG_ACCESSREG,Level2Str(user2^.level),user2^.nick,srv.host,srv.console),true);
         exit;
       end;
    end;
   tmp_pos:=753;
   l1:=user2^.level;
   j:=0; if l>napUserUser then j:=1;
   if l1>napUserUser then inc(j,2);
   tmp_pos:=754;
   if (l<napUserModerator) or (l1<napUserModerator) then
   if userCloaked in user2^.state then
   if (j=1) or (j=2) then
   for i:=0 to db_channels.count-1 do
   begin
     ch:=db_channels.Items[i];
     tmp_pos:=755;
     if ch.FindUser(user2)<>-1 then
     begin
       case j of
         1: // hide user
            for k:=0 to ch.users.count-1 do
            begin
              user3:=ch.users.Items[i];
              if not ch.Operator(user3) then
               Exec(user3,MSG_SERVER_PART,ch.channel+' '+user2^.nick+' '+IntToStr(user2^.shared)+' '+IntToStr(Ord(user2^.speed)));
            end;
         2: // show user
            for k:=0 to ch.users.count-1 do
            begin
              user3:=ch.users.Items[i];
              if not ch.Operator(user3) then
               Exec(user3,MSG_SERVER_JOIN,ch.channel+' '+user2^.nick+' '+IntToStr(user2^.shared)+' '+IntToStr(Ord(user2^.speed)));
            end;
       end;
     end;
   end;
   tmp_pos:=756;
   user2^.level:=l;
   RegisterUser(user2);
 end;
 tmp_pos:=757;
 preg:=db_registered.FindUser(hlist.Strings[0]);
 if preg<>nil then
 begin
   if b=false then
   if preg^.level>=user^.level then
   begin
     PermissionDenied('',true);
     exit;
   end;
   if user^.server=nil then
    if preg^.level>napUserModerator then
    if l<>napUserElite then
    for i:=0 to db_servers.count-1 do
    begin
      srv:=db_servers.Items[i];
      if srv.logged then
       if AnsiLowerCase(srv.reg_user)=str then
       begin
         Error(GetLangT(LNG_ACCESSREG,Level2Str(preg^.level),preg^.nick,srv.host,srv.console),true);
         exit;
       end;
    end;
   preg^.level:=l;
   b:=true;
 end;
 tmp_pos:=758;
 if b then
 begin
   if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
   Wallop(MSG_SERVER_NOSUCH,wallopLevel,GetLangT(LNG_LEVEL2,user^.nick,hlist.Strings[0],Level2Str(l),IntToStr(Ord(l))),true);
   if preg=nil then
    if user2<>nil then
     RegisterUser(user2);
 end
 else
  NoSuchUser(true);
end;

procedure Handler_Kill;
var
 user2: POnlineUser;
 user3: TLocalUser;
 srv: TServer;
 i: Integer;
begin
 tmp_pos:=760;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 user2:=db_online.FindUser(hlist.Strings[0]);
 tmp_pos:=761;
 if user2=nil then
 begin
   UserIsOffline(hlist.Strings[0],true);
   exit;
 end;
 tmp_pos:=762;
 if user2^.level>=user^.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if num_servers>0 then
  if user2^.level=napUserElite then
   for i:=0 to db_servers.count-1 do
   begin
     srv:=db_servers.Items[i];
     if srv.logged then
      if AnsiLowerCase(srv.reg_user)=AnsiLowerCase(user2^.nick) then
      begin
        PermissionDenied('',true);
        exit;
      end;
   end;
 tmp_pos:=763;
 Wallop(MSG_SERVER_NOSUCH,wallopKill,GetLangT(LNG_KICK,user^.nick,user2^.nick,NextParam(gcmd.cmd)),true);
 if user^.server=nil then WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
 user3:=FindLocalUser(user2);
 tmp_pos:=764;
 if user3<>nil then
  if user3<>cons then
  begin
   user3.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_KICKMSG));
   if user2^.level<napUserModerator then
    AddReconnector(decode_ip(user3.ip));
   DisconnectUser(user3,'',GetLangT(LNG_KILLED,user2^.nick,user2^.software,user^.nick),'Handler_Kill',false);
  end;
end;

procedure Handler_Kick;
var
 ch: TChannel;
 user2: POnlineUser;
 str,str1: String;
 i: Integer;
begin
 tmp_pos:=770;
 if not isLogged then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=771;
 if not ch.Operator(user) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 user2:=db_online.FindUser(hlist.Strings[1]);
 if user2=nil then
 begin
   NoSuchUser(true);
   exit;
 end;
 tmp_pos:=772;
 if ch.FindUser(user2)=-1 then
 begin
   NoSuchUser(true);
   exit;
 end;
 if user2^.level>=user^.level then
 begin
  if user^.level<>napUserUser then
  begin
    PermissionDenied('',true);
    exit;
  end;
  tmp_pos:=773;
  if ch.Operator(user2) then
  begin
    PermissionDenied('',true);
    exit;
  end;
 end;
 ch.Part(user2);
 case hlist.Count of
   2: str1:='';
   3: str1:=hlist.Strings[2];
   else str1:=NextParam(gcmd.cmd,2);
 end;
 tmp_pos:=774;
 str:=GetLangT(LNG_CHKICK,user^.nick,user2^.nick,ch.channel,str1);
 str1:=GetLangT(LNG_CHKICK,'Operator',user2^.nick,ch.channel,str1);
 if not (userCloaked in user^.state) then str1:=str;
 for i:=0 to ch.users.count-1 do
 begin
   user2:=ch.users.Items[i];
   if user2^.server=nil then
   begin
     if user2^.level>napUserUser then
      Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+str)
     else
      Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+str1);
   end;
 end;
 tmp_pos:=775;
 if ch.users.count=0 then
  if not (chRegistered in ch.state) then
   for i:=db_channels.count-1 downto 0 do
   if db_channels.Items[i]=ch then
   begin
     db_channels.Delete(i);
     ch.Free;
   end;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_ChannelUsersList;
var
 i: Integer;
 user2: POnlineUser;
 ch: TChannel;
begin
 tmp_pos:=780;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=781;
 if user^.level<napUserModerator then
  if ch.FindUser(user)=-1 then
  begin
    PermissionDenied('',true);
    exit;
  end;
 if user^.level<ch.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=782;
 for i:=0 to ch.users.Count-1 do
 begin
   user2:=ch.users.Items[i];
   if (not (userCloaked in user2^.state)) or (user^.level>napUserUser) then
     Exec(user,MSG_SERVER_NAMES_LIST,ch.channel+' '+user2^.nick+' '+IntToStr(user2^.shared)+' '+IntToStr(Ord(user2^.speed)));
  end;
 Exec(user,gcmd.id,'');
end;

procedure Handler_UserList;
var
 str,ip_mask: String;
 server_name: String;
 soft_mask: String;
 user2: POnlineUser;
 i,j,k: Integer;
 b,b_console, b_elite, b_admin, b_mod, b_user, b_leech, b_all, b_mask, b_server_mask,
 b_cloaked, b_notshare, b_softmask, b_showsoft, b_showshared, b_showserver: Boolean;
begin
 tmp_pos:=790;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 b_all:=true; ip_mask:='*'; soft_mask:='';
 b_console:=false; b_elite:=false; b_admin:=false; b_mod:=false;
 b_user:=false; b_leech:=false; b_cloaked:=false; b_notshare:=false;
 b_showsoft:=false; b_showshared:=false; b_softmask:=false; b_showserver:=false;
 SplitString(AnsiLowerCase(gcmd.cmd),hlist);
 j:=0;
 if hlist.count>0 then server_name:=AnsiLowerCase(hlist.strings[0])
 else server_name:='*';
 tmp_pos:=791;
 if hlist.count>1 then
 while j<hlist.count do
 begin
   if hlist.strings[j]='c' then b_console:=true
   else if hlist.strings[j]='e' then b_elite:=true
   else if hlist.strings[j]='a' then b_admin:=true
   else if hlist.strings[j]='m' then b_mod:=true
   else if hlist.strings[j]='u' then b_user:=true
   else if hlist.strings[j]='l' then b_leech:=true
   else if hlist.strings[j]='-c' then b_console:=true
   else if hlist.strings[j]='-e' then b_elite:=true
   else if hlist.strings[j]='-a' then b_admin:=true
   else if hlist.strings[j]='-m' then b_mod:=true
   else if hlist.strings[j]='-u' then b_user:=true
   else if hlist.strings[j]='-l' then b_leech:=true
   else if hlist.strings[j]='-cl' then b_cloaked:=true
   else if hlist.strings[j]='-cloak' then b_cloaked:=true
   else if hlist.strings[j]='-console' then b_console:=true
   else if hlist.strings[j]='-elite' then b_elite:=true
   else if hlist.strings[j]='-admin' then b_admin:=true
   else if hlist.strings[j]='-administrator' then b_admin:=true
   else if hlist.strings[j]='-mod' then b_mod:=true
   else if hlist.strings[j]='-moderator' then b_mod:=true
   else if hlist.strings[j]='-user' then b_user:=true
   else if hlist.strings[j]='-leech' then b_leech:=true
   else if hlist.strings[j]='-notshare' then b_notshare:=true
   else if hlist.strings[j]='-showshared' then b_showshared:=true
   else if hlist.strings[j]='-showsoftware' then b_showsoft:=true
   else if hlist.strings[j]='-showclient' then b_showsoft:=true
   else if hlist.strings[j]='-showserver' then b_showserver:=true
   else if hlist.Strings[j]='-mods' then
   begin
     b_mod:=true;
     b_admin:=true;
     b_elite:=true;
     b_console:=true;
   end
   else if (hlist.strings[j]='i') or (hlist.strings[j]='-ip') then
   begin
     if hlist.count>(j+1) then
      ip_mask:=hlist.strings[j+1];
     inc(j);
   end
   else if (hlist.strings[j]='-client') or (hlist.strings[j]='-software') then
   begin
     if hlist.count>(j+1) then
      soft_mask:=hlist.strings[j+1];
     inc(j);
   end;
   inc(j);
 end;
 tmp_pos:=792;
 if b_console or b_elite or b_admin or b_mod or b_user or b_leech then b_all:=false;
 b_mask:=ip_mask<>'*';
 b_server_mask:=server_name<>'*';
 if soft_mask<>'' then b_softmask:=true;
 if soft_mask='*' then b_softmask:=false;
 if b_softmask then soft_mask:=AnsiLowerCase(soft_mask);
 for k:=0 to MAX_INDEX do
 for i:=0 to db_online.list[k].Count-1 do
 begin
   tmp_pos:=793;
   if (i mod 10)=0 then CheckSync;
   user2:=db_online.list[k].Items[i];
   b:=true;
   if not b_all then
   case user2^.level of
     napUserLeech: b:=b_leech;
     napUserUser: b:=b_user;
     napUserModerator: b:=b_mod;
     napUserAdmin: b:=b_admin;
     napUserElite: b:=b_elite;
     napUserConsole: b:=b_console;
   end;
   if (userCloaked in user2^.state) then b:=b_cloaked;
   if b and b_notshare then
    if user2^.shared>0 then b:=false;
   tmp_pos:=794;
   if b and b_mask then
    b:=MatchesMaskEx(decode_ip(user2^.ip),ip_mask);
   if b and b_server_mask then
    b:=MatchesMaskEx(AnsiLowerCase(GetServerName(user2^.server)),server_name);
   if b and b_softmask then
    b:=MatchesMaskEx(AnsiLowerCase(user2^.software),soft_mask);
   if b then
   begin
    str:=user2^.nick+' '+decode_ip(user2^.ip);
    if b_showshared then str:=str+' '+IntToStr(user2^.shared);
    if b_showsoft then str:=str+' '+AddStr(user2^.software);
    if b_showserver then str:=str+' '+AddStr(GetServerName(user2^.server));
    if query=queryNormal then
     Exec(user,MSG_SERVER_GLOBAL_USER_LIST,str)
    else
     Error(str);
   end;
 end;
 if query=queryNormal then
  Exec(user,MSG_CLIENT_GLOBAL_USER_LIST,'')
 else
  Error('.'); 
 tmp_pos:=795;
 CheckSync;
end;

procedure Handler_SetConfig;
begin
 SetConfig(user,gcmd.cmd);
end;

procedure Handler_RelayMessage;
var
 user2: POnlineUser;
 i: Integer;
begin
 tmp_pos:=800;
 if query=queryServer then
  SplitString(gcmd.cmd,hlist)
 else
 begin
  if not isLogged then exit;
  if not checkParams(2) then exit;
  if not CheckLevel('',napUserAdmin) then exit;
 end;
 tmp_pos:=801;
 if not isDigit(hlist.Strings[0]) then
 begin
   Error(GetLangT(LNG_INVALIDARGS),true);
   exit;
 end;
 user2:=db_online.FindUser(hlist.Strings[1]);
 tmp_pos:=802;
 if user2=nil then
 begin
   NoSuchUser(true);
   exit;
 end;
 i:=StrToIntDef(hlist.Strings[0],MSG_SERVER_NOSUCH);
 if query<>queryServer then
 if user2^.level>napUserUser then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=803;
 Exec(user2,i,NextParam(gcmd.cmd,2));
end;

procedure Handler_RelayAll;
var
 i,j,k: Integer;
 str: String;
 user2: POnlineUser;
begin
 tmp_pos:=804;
 if query<>queryServer then exit;
 if not CheckParams(1) then exit;
 if not isDigit(hlist.Strings[0]) then
 begin
   Error(GetLangT(LNG_INVALIDARGS),true);
   exit;
 end;
 tmp_pos:=805;
 i:=StrToIntDef(hlist.Strings[0],404);
 str:=NextParamEx(gcmd.cmd);
 for k:=0 to MAX_INDEX do
 for j:=0 to db_online.list[k].Count-1 do
 begin
   if (j mod 10)=0 then CheckSync;
   user2:=db_online.list[k].Items[j];
   if user2<>user then
   if user2^.server=nil then
    Exec(user2,i,str);
 end;
 tmp_pos:=806;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_Block;
var
 i: Integer;
 str: String;
 h: TStringHash;
 hash,h2: PStringHash;
begin
 tmp_pos:=810;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 StrHash_Reset(h);
 case gcmd.id of
    MSG_CLIENT_BLOCKLIST: begin
                            tmp_pos:=811;
                            for i:=0 to db_blocks.Count-1 do
                            begin
                              hash:=db_blocks.Items[i];
                              str:=JoinString(hash^);
                              case query of
                               queryOperServ, queryNickServ, queryChanServ, queryMsgServ,
                               queryChannel: Error('block:'+str)
                               else Exec(user,gcmd.id,str);
                              end;
                              if (i mod 10)=0 then CheckSync; 
                            end;
                            tmp_pos:=812;
                            case query of
                             queryOperServ, queryNickServ, queryChanServ, queryMsgServ,
                             queryChannel: Error('.');
                             else Exec(user,gcmd.id,'');
                            end;
                          end;
   MSG_CLIENT_BLOCK:      begin
                            if not CheckParams(1) then exit;
                            if hlist.Count=1 then
                             if Length(hlist.Strings[0])<2 then exit;
                            tmp_pos:=813;
                            hash:=StrHash_Create;
                            for i:=0 to hlist.Count-1 do
                            begin
                              str:=AnsiLowerCase(Trim(StripString(hlist.Strings[i])));
                              if Length(str)>0 then
                               StrHash_AddEx(hash^,str);
                            end;
                            tmp_pos:=814;
                            if hash^.count>0 then
                            begin
                              for i:=0 to db_blocks.count-1 do
                              begin
                                h2:=db_blocks.Items[i];
                                if StrHash_Equal(hash^,h2^) then
                                begin
                                  StrHash_Free(hash);
                                  exit;
                                end;
                              end;
                              db_blocks.Add(hash);
                            end
                            else StrHash_Free(hash);
                            tmp_pos:=815;
                          end;
   MSG_CLIENT_UNBLOCK:    begin
                            if not CheckParams(1) then exit;
                            tmp_pos:=816;
                            for i:=0 to hlist.Count-1 do
                            begin
                              str:=AnsiLowerCase(Trim(StripString(hlist.Strings[i])));
                              if Length(str)>0 then
                               StrHash_AddEx(h,str);
                            end;
                            for i:=db_blocks.count-1 downto 0 do
                            begin
                              hash:=db_blocks.Items[i];
                              tmp_pos:=817;
                              if StrHash_Equal(hash^,h) then
                              begin
                                StrHash_Free(hash);
                                db_blocks.Delete(i);
                              end;
                            end;
                          end;
 end;
 StrHash_Clear(h);
end;

procedure Handler_UsageStats;
var
 str: String;
 i,j: Integer;
 srv2: TServer;
begin
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 j:=0;
 for i:=0 to db_servers.Count-1 do
 begin
  srv2:=db_servers.Items[i];
  if srv2.logged and (srv2.hub=nil) then inc(j);
 end;
 str:=Format('%d %d %d %d %d %d %d %d %d %d %.2f %.2f %.2f %d %d 0',[
      local_users,
      j,
      total_users,
      total_files,
      total_bytes div 1073741824,
      db_channels.count,
      start_time_t,
      DateTimeToUnixTime(now)-start_time_t,
      AllocMemCount,
      db_registered.CountUsers,
      last_bytes_in / 60.0 / 1024.0,
      last_bytes_out / 60 / 1024,
      last_searches / 60,
      total_bytes_in,
      total_bytes_out
 ]);
 Exec(user,gcmd.id,str);
 case query of
  queryOperServ, queryNickServ, queryChanServ, queryMsgServ, queryChannel: Error('stats: '+str);
 end;
end;

procedure Handler_SoftwareStats;
var
 i: Integer;
 a: PNapCmd;
begin
 if not isLogged then exit;
 tmp_pos:=820;
 if db_software<>nil then
 begin
   db_software.Sort;
   tmp_pos:=821;
   case query of
    queryOperServ, queryNickServ, queryChanServ, queryMsgServ, queryChannel:
                   begin
                    Error('Client Software usage statistics:');
                    Error('Format: <number of users> <software name>');
                   end;
   end;
   for i:=0 to db_software.count-1 do
   begin
     if (i mod 10)=0 then CheckSync;
     a:=db_software.Items[i];
     case query of
       queryOperServ, queryNickServ, queryChanServ, queryMsgServ,
       queryChannel:  Error(IntToStr(a^.id)+'        '+#9+' '+a^.cmd);
       else Exec(user,MSG_CLIENT_VERSION_STATS,AddStr(a^.cmd)+' '+IntToStr(a^.id));
     end;
   end;
 end;
 tmp_pos:=822;
 case query of
   queryOperServ, queryNickServ, queryChanServ, queryMsgServ,
   queryChannel: Error('.');
   else Exec(user,MSG_CLIENT_VERSION_STATS,'');
 end;
end;

procedure Handler_WhichServer;
var
 user2: POnlineUser;
 l2: TLocalUser;
begin
 if not isLogged then exit;
 if (user^.level=napUserLeech) or (userMuzzled in user^.state) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=823;
 user2:=db_online.FindUser(gcmd.cmd);
 if user2=nil then
 begin
   UserIsOffline(gcmd.cmd,true);
   exit;
 end;
 if userCloaked in user2.state then
  if user^.level<napUserModerator then
  begin
    UserIsOffline(gcmd.cmd,true);
    exit;
  end;
 l2:=FindLocalUser(user2);
 tmp_pos:=824;
 if l2<>nil then
 begin
   if user^.level<napUserModerator then
    if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
    begin
      UserIsOffline(gcmd.cmd,true);
      exit;
    end;
 end;
 tmp_pos:=825;
 Error(GetLangT(LNG_USERSERVER,user2^.nick,GetServerName(user2^.server)));
end;

procedure Handler_WhoWas; // 10121
var
 user2: POnlineUser;
 reg: PRegisteredUser;
 l2: TLocalUser;
 i: Integer;
 p: PNapCmdEx;
 str: String;
begin
 tmp_pos:=830;
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 user2:=db_online.FindUser(gcmd.cmd);
 if user2<>nil then
 begin
   l2:=FindLocalUser(user2);
   if l2<>nil then
    if user^.level<napUserModerator then
     if StrHash_FindString(l2.ignored,AnsiLowerCase(user^.nick),false) then
      user2:=nil;
 end;
 tmp_pos:=831;
 if user=nil then
 begin
   reg:=db_registered.FindUser(gcmd.cmd);
   if reg<>nil then
   begin
     if user^.level>napUserUser then
      Exec(user,gcmd.id,reg^.nick+' '+IntToStr(reg^.last_ip)+' '+servername_t+' '+IntToStr(reg^.last_seen)+' "n/a"')
     else
      Exec(user,gcmd.id,reg^.nick+' 0 '+servername_t+' '+IntToStr(reg^.last_seen)+' "n/a"');
     exit;
   end
   else
   begin
     i:=db_whowas.FindByCmd(AnsiLowerCase(gcmd.cmd));
     if i<>-1 then
     begin
       p:=db_whowas.Items[i];
       SplitString(p^.data,hlst);
       if hlst.count>5 then
       begin
         str:=gcmd.cmd+' ';
         if user^.level>napUserUser then
           str:=str+hlst.Strings[3]+' '
         else
           str:=str+'0 ';
         str:=str+AddStr(hlst.Strings[4])+' '+hlst.Strings[2]+' '+AddStr(hlst.Strings[5]);
         Exec(user,gcmd.id,str);
       end;
     end;
   end;
   tmp_pos:=832;
   UserIsOffline(gcmd.cmd,true);
   exit;
 end;
 tmp_pos:=833;
 if user^.level>napUserUser then
  Exec(user,gcmd.id,user2^.nick+' '+IntToStr(user2^.ip)+' '+GetServerName(user2^.server)+' '+IntToStr(user2^.last_seen)+' "'+user2^.software+'"')
 else
  Exec(user,gcmd.id,user2^.nick+' 0 '+GetServerName(user2^.server)+' '+IntToStr(user2^.last_seen)+' "'+user2^.software+'"');
end;

procedure Handler_AdminRegister;
var
 l: TNapUserLevel;
 reg: TRegisteredUser;
 preg: PRegisteredUser;
 usr: POnlineUser;
begin
 if not isLogged then exit;
 if not CheckParams(1) then exit;
 if hlist.count=1 then
 begin
   usr:=db_online.FindUser(hlist.Strings[0]);
   if usr=nil then UserIsOffline(hlist.Strings[0],true)
   else
   begin
     preg:=db_registered.FindUser(hlist.Strings[0]);
     if preg<>nil then Error(GetLangT(LNG_ALREADYREGISTERED,Level2Str(preg^.level),preg^.nick),true)
     else
     begin
       RegisterUser(usr);
       Wallop(MSG_SERVER_NOSUCH,wallopRegister,GetLangT(LNG_REGOK2,user^.nick,usr^.nick,Level2Str(usr^.level)),true);
       if user^.server=nil then
        WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
     end;
   end;
   exit;
 end;
 if hlist.Count=2 then hlist.Add('anon@'+servername_t);
 if hlist.Count=3 then hlist.Add('1');
 tmp_pos:=840;
 if not isLevel(hlist.Strings[3]) then
 begin
   Error(GetLangT(LNG_INVALIDLEVEL,hlist.Strings[3]),true);
   exit;
 end;
 l:=Str2Level(hlist.Strings[3]);
 tmp_pos:=841;
 if (l>=user^.level) or (l<napUserUser) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if not check_name(hlist.Strings[0]) then
 begin
   Error(GetLangT(LNG_INVALIDNICK2,hlist.Strings[0]),true);
   exit;
 end;
 tmp_pos:=842;
 if db_registered.FindUser(hlist.Strings[0])<>nil then
 begin
   Error(GetLangT(LNG_REGEXISTS,hlist.Strings[0]),true);
   exit;
 end;
 tmp_pos:=843;
 ResetRegistered(reg);
 reg.nick:=hlist.Strings[0];
 reg.password:=encode(hlist.Strings[1]);
 reg.level:=l;
 db_registered.Add(reg);
 tmp_pos:=844;
 Wallop(MSG_SERVER_NOSUCH,wallopRegister,GetLangT(LNG_REGOK2,user^.nick,reg.nick,Level2Str(reg.level)),true);
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_ChannelOp;
var
 ch: TChannel;
 user2: POnlineUser;
 str: String;
begin
 tmp_pos:=850;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=851;
 if ch.level>napUserUser then
 begin
   Error(GetLangT(LNG_CHNOOPS),true);
   exit;
 end;
 hlist.Delete(0);
 tmp_pos:=852;
 while hlist.Count>0 do
 begin
   str:=hlist.Strings[0];
   hlist.Delete(0);
   tmp_pos:=853;
   if not check_name(str) then
   begin
    if user^.server=nil then
     Error(GetLangT(LNG_INVALIDNICK2,str),true);
   end
   else if StrHash_FindString(ch.ops,str,true) then
   begin
     if user^.server=nil then
      Error(GetLangT(LNG_CHANOP3,str,ch.channel),true);
   end
   else
   begin
     user2:=db_online.FindUser(str);
     tmp_pos:=854;
     if (user2<>nil) and (user2^.level>napUserUser) then
     begin
       if user^.server=nil then
        Error(GetLangT(LNG_CHANOP3,str,ch.channel),true);
     end
     else
     begin
       tmp_pos:=855;
       StrHash_AddEx(ch.ops,str);
       Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangT(LNG_CHANOP,user^.nick,str,ch.channel),true);
       if user2<>nil then
       if user2^.server=nil then
       begin
         if ch.FindUser(user2)<>-1 then
           Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_CHANOP2,ch.channel))
         else
          if user^.server=nil then
           Error(GetLangT(LNG_CHANOP2,ch.channel),true);  
       end;
       tmp_pos:=856;
     end;
   end;
 end;
 tmp_pos:=857;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_ChannelDeop;
var
 ch: TChannel;
 user2: POnlineUser;
 str: String;
begin
 tmp_pos:=860;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   if user^.server=nil then
    Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=861;
 if ch.level>napUserUser then
 begin
   Error(GetLangT(LNG_CHNOOPS),true);
   StrHash_Clear(ch.ops);
   exit;
 end;
 hlist.Delete(0);
 tmp_pos:=862;
 while hlist.Count>0 do
 begin
   str:=hlist.Strings[0];
   hlist.Delete(0);
   tmp_pos:=863;
   if not check_name(str) then
   begin
     if user^.server=nil then
      Error(GetLangT(LNG_INVALIDNICK2,str),true);
   end
   else
   begin
     tmp_pos:=864;
     if not StrHash_FindString(ch.ops,str,true) then
     begin
       if user^.server=nil then
        Error(GetLangT(LNG_CHANDEOP3,str,ch.channel),true);
     end
     else
     begin
       user2:=db_online.FindUser(str);
       if (user2<>nil) and (user2^.level>napUserUser) then
       begin
         if user^.server=nil then
           Error(GetLangT(LNG_CHANDEOP4,str),true);
       end
       else
       begin
         tmp_pos:=865;
         StrHash_Delete(ch.ops,str,true);
         Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangT(LNG_CHANDEOP,user^.nick,str,ch.channel),true);
         if user2<>nil then
         if user2^.server=nil then
         begin
           tmp_pos:=866;
           if ch.FindUser(user2)<>-1 then
             Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_CHANDEOP2,ch.channel))
           else
             Exec(user2,MSG_SERVER_NOSUCH,GetLangT(LNG_CHANDEOP2,ch.channel));
         end;
       end;
     end;
   end;
 end;
 tmp_pos:=867;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_ChannelOpEmote;
var
 ch: TChannel;
 str: String;
 i: Integer;
 user2: POnlineUser;
begin
 tmp_pos:=870;
 if not isLogged then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=871;
 if not ch.Operator(user) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 str:=NextParamEx(gcmd.cmd);
 if Length(str)>0 then
  if str[1]<>'"' then
   str:='"'+str+'"';
 if prevent_shouting then
  if uppercase(str)=str then
  begin
   str:=AnsiLowerCase(str);
   gcmd.cmd:=ch.channel+' '+str;
  end;
 str:=ch.channel+' ops/'+user^.nick+' '+str;
 tmp_pos:=872;
 for i:=0 to ch.users.Count-1 do
 begin
   user2:=ch.users.Items[i];
   if user2^.server=nil then
    if ch.Operator(user2) then
    begin
     if old_opsay then
      Exec(user2,MSG_SERVER_NOSUCH,str)
     else
      Exec(user2,MSG_SERVER_EMOTE,str);
    end;
 end;
 tmp_pos:=873;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_ChannelWallop; // 10208
var
 ch: TChannel;
 str: String;
 i: Integer;
 user2: POnlineUser;
begin
 tmp_pos:=870;
 if not isLogged then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=871;
 if not ch.Operator(user) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 str:=NextParamEx(gcmd.cmd);
 if prevent_shouting then
  if uppercase(str)=str then
  begin
   str:=AnsiLowerCase(str);
   gcmd.cmd:=ch.channel+' '+str;
  end;
 if old_opsay then
  str:=user^.nick+' [ops/'+ch.channel+']: '+str
 else
  str:=ch.channel+' ops/'+user^.nick+' '+str;
 tmp_pos:=872;
 for i:=0 to ch.users.Count-1 do
 begin
   user2:=ch.users.Items[i];
   if user2^.server=nil then
    if ch.Operator(user2) then
    begin
     if old_opsay then
      Exec(user2,MSG_SERVER_NOSUCH,str)
     else
      Exec(user2,MSG_SERVER_PUBLIC,str);
    end;
 end;
 tmp_pos:=873;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_ChannelMode; // 10209
var
 ch: TChannel;
 st,old_st: TChannelState;
 str: String;
begin
 tmp_pos:=880;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(1) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=881;
 if ch.level>user^.level then
 begin
   PermissionDenied('',true);
   exit;
 end;
 hlist.Delete(0);
 tmp_pos:=882;
 old_st:=ch.state;
 st:=ch.state;
 while hlist.Count>0 do
 begin
   str:=AnsiLowerCase(hlist.Strings[0]);
   hlist.Delete(0);
   if str='+private' then st:=st+[chPrivate]
   else if str='-private' then st:=st-[chPrivate]
   else if str='+moderated' then st:=st+[chModerated]
   else if str='-moderated' then st:=st-[chModerated]
   else if str='+topic' then st:=st+[chTopic]
   else if str='-topic' then st:=st-[chTopic]
   else if str='+registered' then st:=st+[chRegistered]
   else if str='-registered' then st:=st-[chRegistered]
   else Error(GetLangT(LNG_UNKNOWNCHMODE,str));
 end;
 tmp_pos:=883;
 ch.state:=st;
 if st<>old_st then
 begin
   str:='';
   if (chPrivate in st) and (not (chPrivate in old_st)) then str:=str+' +PRIVATE';
   if (chPrivate in old_st) and (not (chPrivate in st)) then str:=str+' -PRIVATE';
   if (chModerated in st) and (not (chModerated in old_st)) then str:=str+' +MODERATED';
   if (chModerated in old_st) and (not (chModerated in st)) then str:=str+' -MODERATED';
   if (chTopic in st) and (not (chTopic in old_st)) then str:=str+' +TOPIC';
   if (chTopic in old_st) and (not (chTopic in st)) then str:=str+' -TOPIC';
   if (chRegistered in st) and (not (chRegistered in old_st)) then str:=str+' +REGISTERED';
   if (chRegistered in old_st) and (not (chRegistered in st)) then str:=str+' -REGISTERED';
   Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangEx('$1 changed mode on channel $2:$3',user^.nick,ch.channel,str),true);
   if user^.server=nil then
    WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
 end;
 if user^.server<>nil then exit;
 tmp_pos:=884;
 str:='';
 if chRegistered in st then str:='+REGISTERED';
 if chPrivate in st then
 begin
  if str<>'' then str:=str+' ';
  str:=str+'+PRIVATE';
 end;
 if chModerated in st then
 begin
  if str<>'' then str:=str+' ';
  str:=str+'+MODERATED';
 end;
 if chTopic in st then
 begin
  if str<>'' then str:=str+' ';
  str:=str+'+TOPIC';
 end;
 if str='' then str:='<empty>';
 tmp_pos:=885;
 if (local<>cons) or (query<>queryNormal) then
  Error(GetLangEx('mode for channel $1 $2',ch.channel,str));
end;

procedure Handler_ChannelVoice;
var
 ch: TChannel;
 user2: POnlineUser;
 str,str1: String;
begin
 tmp_pos:=890;
 if not isLogged then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=891;
 if not ch.Operator(user) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if (not (chModerated in ch.state)) or (ch.level>napUserUser) then
 begin
   Error(GetLangT(LNG_NOMODERATE,ch.channel),true);
   exit;
 end;
 hlist.Delete(0);
 tmp_pos:=892;
 str1:=user^.nick;
 if userCloaked in user^.state then str1:='Operator';
 while hlist.Count>0 do
 begin
   str:=hlist.Strings[0];
   hlist.Delete(0);
   tmp_pos:=893;
   if not check_name(str) then
     Error(GetLangT(LNG_INVALIDNICK2,str),true)
   else if StrHash_FindString(ch.voices,str,true) then
     Error(GetLangT(LNG_VOICE3,str,ch.channel),true)
   else
   begin
     tmp_pos:=894;
     user2:=db_online.FindUser(str);
     if (user2<>nil) and (user2^.level>napUserUser) then
       Error(GetLangT(LNG_VOICE3,str,ch.channel),true)
     else
     begin
       tmp_pos:=895;
       StrHash_AddEx(ch.voices,str);
       if user^.server=nil then
        ch.Wallop(GetLangT(LNG_VOICE4,user^.nick,str));
       if user2<>nil then
       if user2^.server=nil then
       begin
         if ch.FindUser(user2)<>-1 then
           Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_VOICE,str1,ch.channel))
         else
           Exec(user2,MSG_SERVER_NOSUCH,GetLangT(LNG_VOICE,str1,ch.channel));
       end;
     end;
   end;
 end;
 tmp_pos:=896;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_ChannelUnvoice;
var
 ch: TChannel;
 user2: POnlineUser;
 str: String;
begin
 tmp_pos:=900;
 if not isLogged then exit;
 if not CheckLevel('',napUserModerator) then exit;
 if not CheckParams(2) then exit;
 ch:=FindChannel(hlist.Strings[0]);
 if ch=nil then
 begin
   Error(GetLangT(LNG_NOCHANNEL),true);
   exit;
 end;
 tmp_pos:=901;
 if not ch.Operator(user) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if (not (chModerated in ch.state)) or (ch.level>napUserUser) then
 begin
   Error(GetLangT(LNG_NOMODERATE,ch.channel),true);
   StrHash_Clear(ch.voices);
   exit;
 end;
 hlist.Delete(0);
 tmp_pos:=902;
 while hlist.Count>0 do
 begin
   str:=hlist.Strings[0];
   hlist.Delete(0);
   tmp_pos:=903;
   if not check_name(str) then
     Error(GetLangT(LNG_INVALIDNICK2,str),true)
   else
   begin
     if not StrHash_FindString(ch.voices,str,true) then
       Error(GetLangT(LNG_DEVOICE3,str,ch.channel),true)
     else
     begin
       tmp_pos:=904;
       user2:=db_online.FindUser(str);
       if (user2<>nil) and (user2^.level>napUserUser) then
         Error(GetLangT(LNG_DEVOICE4,str),true)
       else
       begin
         tmp_pos:=905;
         StrHash_Delete(ch.voices,str,true);
         if user^.server=nil then
          ch.Wallop(GetLangT(LNG_DEVOICE5,user^.nick,str));
         if user2<>nil then
         if user2^.server=nil then
         begin
           tmp_pos:=906;
           if ch.FindUser(user2)<>-1 then
             Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_DEVOICE,ch.channel))
           else
             Exec(user2,MSG_SERVER_NOSUCH,GetLangT(LNG_DEVOICE,ch.channel));
         end;
       end;
     end;
   end;
 end;
 tmp_pos:=907;
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
end;

procedure Handler_GetConsole;
var
 i,j: Integer;
 srv: TServer;
begin
 if num_servers=0 then
 begin
   Error(cons.data^.nick+'  '#9+servername_t);
   Error('.');
   exit;
 end;
 Error(cons.data^.nick+'  '#9+servername_t);
 for i:=0 to db_servers.count-1 do
 begin
   srv:=db_servers.Items[i];
   if srv.logged then
    Error(srv.console+'  '#9+srv.host);
 end;
 Error('.');
end;

procedure Handler_Transfer;
begin
 if not isLogged then exit;
 if (query<>queryNormal) and (query<>queryRemoteUser) then exit;
 case gcmd.id of
   //MSG_CLIENT_DOWNLOAD_START: begin inc(user^.downloads); inc(user^.total_down); end;
   MSG_CLIENT_DOWNLOAD_START:
        begin
          inc(user^.downloads);
          inc(user^.total_down);
          if user^.downloads>toami_judge then Error('xDLłI',true);
          Wallop(MSG_SERVER_NOSUCH,wallopFlood,'ԂF'+
          user^.nick+'!'+decode_ip(user.ip)+' L='+IntToStr(user^.shared)+' '+
          'DL='+IntToStr(user^.downloads)+'/'+IntToStr(user^.total_down)+' '+
          'UL='+IntToStr(user^.uploads)+'/'+IntToStr(user^.total_up),true);
        end;
   MSG_CLIENT_DOWNLOAD_END: begin dec(user^.downloads); if user^.downloads<0 then user^.downloads:=0; end;
   MSG_CLIENT_UPLOAD_START: begin inc(user^.uploads); inc(user^.total_up); end;
   MSG_CLIENT_UPLOAD_END: begin dec(user^.uploads); if user^.uploads<0 then user^.uploads:=0; end;
 end;
 if local<>nil then local.localstate:=local.localstate+[locNeedsUpdate];
end;

procedure Handler_SetTransfers;
begin
 if not isLogged then exit;
 if not CheckParams(4) then exit;
 if user=nil then exit;
 user^.downloads:=StrToIntDef(hlist.Strings[0],0);
 user^.uploads:=StrToIntDef(hlist.Strings[1],0);
 user^.max_up:=StrToIntDef(hlist.Strings[2],-1);
 user^.queue:=StrToIntDef(hlist.Strings[3],-1);
 if user^.server=nil then
 begin
  if local=nil then
    WriteAllServers(gcmd.id,user^.nick,gcmd.cmd)
  else
    local.localstate:=local.localstate+[locNeedsUpdate];
 end;
end;

procedure Handler_GetTransfers;
var
 user2: POnlineUser;
begin
 if not isLogged then exit;
 user2:=db_online.FindUser(gcmd.cmd);
 if user2=nil then
 begin
   UserIsOffline(gcmd.cmd,true);
   exit;
 end;
 Exec(user,gcmd.id,user2^.nick+' '+IntToStr(user2^.downloads)+' '+IntToStr(user2^.uploads)+' '+IntToStr(user2^.max_up)+' '+IntToStr(user2^.queue));
end;

procedure Handler_AddChannel;
var
 ch: TChannel;
 str: String;
begin
 tmp_pos:=910;
 if not CheckLevel('',napUserModerator) then exit;
 str:=ChannelName(gcmd.cmd);
 if str='' then
 begin
   Error(GetLangT(LNG_INVALIDARGS),true);
   exit;
 end;
 ch:=Findchannel(str);
 tmp_pos:=911;
 if ch<>nil then exit;
 if db_channels.count>=max_channels_total then
 if user^.server=nil then
 begin
   Error(GetLangT(LNG_CHANNELLIMIT),true);
   exit;
 end;
 tmp_pos:=912;
 ch:=TChannel.Create(str);
 ch.state:=[chModerated];
 db_channels.Add(ch);
 tmp_pos:=913;
 Wallop(MSG_SERVER_NOSUCH,wallopChannel,GetLangT(LNG_CHCREATED,Level2Str(user^.level),user^.nick,str),true);
 if user^.server=nil then
  WriteAllServers(gcmd.id,user^.nick,gcmd.cmd);
 tmp_pos:=914;
 if local=cons then
  cmd_list.AddDoubleCmd(MSG_CMD_LISTCHANNELS,0,'',''); 
end;

procedure Handler_ServerConnect(srv: TServer; timer: Boolean);
var
 host,port: String;
 i: Integer;
begin
 tmp_pos:=915;
 if not timer then
 begin
   if not isLogged then exit;
   if not CheckLevel('',napUserAdmin) then exit;
   if not CheckParams(1) then exit;
   if local=nil then exit;
   hlist.Strings[0]:=AnsiLowerCase(hlist.Strings[0]);
   i:=pos(':',hlist.Strings[0]);
   if i=0 then
   begin
     host:=hlist.Strings[0];
     port:='8888';
   end
   else
   begin
     host:=copy(hlist.Strings[0],1,i-1);
     port:=copy(hlist.Strings[0],i+1,5);
   end;
   host:=AnsiLowerCase(host);
   srv:=FindServer(host);
   if local<>cons then
   if AnsiLowerCase(local.nick)<>AnsiLowerCase(cons_reg_user) then
   if restrict_outgoing then
   if (srv=nil) or (srv.relink=0) then
   begin
     SplitString(outgoing_list,hlst);
     if GetIndex(hlst,host,false)=-1 then
     begin
       Error(GetLangT(LNG_OUTGOINGRESTRICTED,host));
       exit;
     end;
   end;
   tmp_pos:=916;
   if srv=nil then
   begin
     srv:=TServer.Create;
     srv.host:=host;
     srv.port:=StrToIntDef(port,8888);
     db_servers.Add(srv);
   end;
 end
 else
  if srv=nil then exit;
 tmp_pos:=917;
 if srv.connected<>conNotConnected then
 begin
   if not timer then
    Error(GetLangT(LNG_LINKED),true);
   exit;
 end;
 tmp_pos:=918;
 if timer then
  Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKREQ2,srv.host),true)
 else
  Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKREQ,user^.nick,host),true);
 srv.login_start:=GetTickCount;
 linking:=true;
 srv.Connect;
end;

procedure Handler_ServerDisconnect;
var
 srv: TServer;
begin
 tmp_pos:=920;
 if not isLogged then exit;
 if not CheckLevel('',napUserAdmin) then exit;
 if not CheckParams(1) then exit;
 srv:=FindServer(gcmd.cmd);
 tmp_pos:=921;
 if srv=nil then
 begin
   Error(GetLangT(LNG_NOSUCHSERVER),true);
   exit;
 end;
 if (srv.connected<>conConnected) or (srv.hub<>nil) then
 begin
   Error(GetLangT(LNG_CANTDELINK,srv.host),true);
   exit;
 end;
 tmp_pos:=922;
 if not CheckLag(srv) then
 begin // sending disconnect message
   WriteAllServersEx(srv,MSG_SRV_SHUTDOWN,'',user^.nick);
   srv.Flush;
 end;
 DisconnectServer(srv,true,false,'Handler_ServerDisconnect');
 Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_DELINKREQ,srv.host,user^.nick),true);
end;

procedure Handler_KillServer;
var
 srv: TServer;
 i: Integer;
begin
 tmp_pos:=1259;
 if not isLogged then exit;
 if not CheckLevel('',napUserElite) then exit;
 if not CheckParams(1) then exit;
 srv:=FindServer(gcmd.cmd);
 if srv=nil then
 begin
   Error(GetLangT(LNG_NOSUCHSERVER),true);
   exit;
 end;
 tmp_pos:=1260;
 if (srv.connected<>conConnected) or (srv.hub<>nil) then
 begin
   Error(GetLangT(LNG_CANTKILL,srv.host),true);
   exit;
 end;
 tmp_pos:=1261;
 DisconnectServer(srv,true,false,'Handler_KillServer');
 Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_KILLSERVER,user^.nick,srv.host),true);
end;

procedure Handler_RemoveServer;
var
 srv: TServer;
 i: Integer;
begin
 tmp_pos:=930;
 if not isLogged then exit;
 if not CheckLevel('',napUserElite) then exit;
 if not CheckParams(1) then exit;
 srv:=FindServer(gcmd.cmd);
 if srv=nil then
 begin
   Error(GetLangT(LNG_NOSUCHSERVER),true);
   exit;
 end;
 tmp_pos:=931;
 if srv.connected<>conNotConnected then
 begin
   Error(GetLangT(LNG_CANTREMOVE,srv.host),true);
   exit;
 end;
 for i:=db_servers.count-1 downto 0 do
  if db_servers.Items[i]=srv then
  begin
    Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_REMOVESERVER,user^.nick,srv.host),true);
    db_servers.Delete(i);
    srv.Free;
    exit;
  end;
 tmp_pos:=932;
 Error(GetLangT(LNG_NOSUCHSERVER),true);
end;

procedure DisconnectServer(srv: TServer; inform_servers, do_wallop: Boolean; sender: String);
var
 i,j: Integer;
 srv2: TServer;
 user2: POnlineUser;
begin
 tmp_pos:=933;
 if srv=nil then exit;
 if srv.connected=conNotConnected then
 begin
   srv.ResetData;
   exit;
 end;
 tmp_pos:=934;
 if srv.logged then
  if srv.hub=nil then
   WriteAllServers(MSG_SRV_DISCONNECTED,'',srv.host,GetServerLink(srv));
 if db_servers<>nil then
 for i:=0 to db_servers.count-1 do
 begin
   srv2:=db_servers.Items[i];
   if srv2.hub=srv then
   begin
    DisconnectServer(srv2,false,false,'req-'+sender);
    Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_DELINKHUB,srv2.host,srv.host),true);
   end;
 end;
 tmp_pos:=935;
 srv.ResetData;
 srv.login_start:=GetTickCount;
 if srv.thread<>nil then
 try
  srv.thread.Terminate;
  srv.thread:=nil;
  except
 end;
 tmp_pos:=936;
 if srv.socket<>INVALID_SOCKET then
  TCPSocket_Free(srv.socket);
 if srv.out_list<>nil then
 try
  FreeCmdList(srv.out_list);
  srv.out_list:=nil;
  except
 end;
 tmp_pos:=937;
 if srv.out_buf<>nil then
 try
  FreeCmdList(srv.out_buf);
  srv.out_buf:=nil;
  except
 end;
 tmp_pos:=938;
 for j:=0 to MAX_INDEX do
 for i:=db_online.list[j].Count-1 downto 0 do
 try
   user2:=db_online.list[j].Items[i];
   if user2^.server=srv then
     KickUser(user2,'');
   if (i mod 10)=0 then CheckSync;
  except
 end;
 tmp_pos:=939;
 CountStats;
 if do_wallop then Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_DELINK,srv.host,sender),true);
end;

procedure Handler_SetLastInv;
var
 s: PNapCmdEx;
 i: Integer;
begin
 if not CheckParams(1) then exit;
 local:=FindLocalUser(hlist.Strings[0]);
 if local=nil then exit;
 for i:=db_invitations.count-1 downto 0 do
 begin
   s:=db_invitations.Items[i];
   if s^.data=local.nick then
    db_invitations.Delete(i)
   else
    if (GetTickCount-s^.id)>EXPIRE_INVITATION then
     db_invitations.Delete(i);
 end;
 db_invitations.AddCmd(GetTickCount,NextParam(gcmd.cmd),local.nick);
end;

procedure Handler_ForwardAllServers;
var
 srv,srv2,srv3: TServer;
 i,j: Integer;
 str: String;
 user: POnlineUser;
begin
 tmp_pos:=940;
 if not CheckParams(2) then exit;
 srv:=FindServer(StrToIntDef(hlist.Strings[1],0));
 if srv=nil then exit; // error
 if not srv.logged then exit; // error
 tmp_pos:=941;
 srv2:=GetServerLink(srv);
 if srv2<>server then exit; // error
 if (srv2<>nil) and (srv.logged=false) then exit; // error
 tmp_pos:=942;
 gcmd.id:=StrToIntDef(hlist.Strings[0],0);
 if gcmd.id=0 then exit;
 if search_noforward_requests then
 if gcmd.id=MSG_CLIENT_SEARCH then
 try
  tmp_pos:=943;
  if CheckLag(server) then // won't be able to return search results
   if hlist.count>2 then
   begin // close search
     tmp_pos:=944;
     str:=hlist.Strings[2]; // user
     user:=db_online.FindUser(str);
     tmp_pos:=945;
     if user<>nil then
     if user^.server<>nil then
     begin
       j:=CountLinkedServers(server);
       for i:=1 to j do
        user^.server.Exec(MSG_SRV_SEARCH_END,user^.nick);
     end;
     tmp_pos:=946;
     exit;
   end;
   tmp_pos:=947;
  except
   on E:Exception do
    DebugLog('Exception in Handler_ForwardAllServers (pos='+IntToStr(tmp_pos)+') : '+E.Message);
 end;
 tmp_pos:=948;
 srv3:=GetServerLink(server);
 tmp_pos:=949;
 if srv3<>nil then
 for i:=0 to db_servers.count-1 do
 begin
   srv2:=db_servers.Items[i];
   if srv2.logged and (srv2.hub=nil) then
    if srv2<>srv3 then
     srv2.Exec(MSG_SRV_FORWARDALL,gcmd.cmd);
 end;
 gcmd.cmd:=NextParam(gcmd.cmd,2);
 ProcessServerCommand(srv);
end;

procedure CountStats;
var
 i: Integer;
 srv: TServer;
 num_users,num_files, srv_num, num_max: Integer;
 num_bytes: Int64;
begin
 num_users:=local_users;
 num_files:=local_files;
 num_bytes:=local_bytes;
 num_max:=max_users;
 srv_num:=0;
 tmp_pos:=950;
 if db_servers<>nil then
 for i:=0 to db_servers.Count-1 do
 begin
   tmp_pos:=951;
   srv:=db_servers.Items[i];
   tmp_pos:=952;
   if srv.logged then
   begin
     inc(num_users,srv.num_users);
     inc(num_files,srv.num_files);
     inc(num_bytes,srv.num_bytes);
     inc(num_max,srv.max_users);
     inc(srv_num);
   end;
 end;
 tmp_pos:=953;
 total_users:=num_users;
 total_files:=num_files;
 total_bytes:=num_bytes;
 total_users_limit:=num_max;
 num_servers:=srv_num;
 if total_users_max<total_users then total_users_max:=total_users;
 if total_files_max<total_files then total_files_max:=total_files;
 if total_bytes_max<total_bytes then total_bytes_max:=total_bytes;
end;

procedure Handler_ServerStats;
var
 a,b,c,d: Int64;
begin
 tmp_pos:=960;
 if not CheckParams(4) then exit;
 if server=nil then exit;
 a:=StrToInt64Def(hlist.Strings[0],server.num_users);
 b:=StrToInt64Def(hlist.Strings[1],server.num_files);
 c:=StrToInt64Def(hlist.Strings[2],server.num_bytes);
 d:=StrToInt64Def(hlist.Strings[3],server.max_users);
 tmp_pos:=961;
 if (a<0) or (b<0) or (c<0) or (d<0) then exit; // something weird
 server.num_users:=a;
 server.num_files:=b;
 server.num_bytes:=c;
 server.max_users:=d;
 tmp_pos:=962;
 CountStats;
end;

procedure Handler_SrvRelay;
var
 i,id,src,dst: Integer;
 srv, srv2: TServer;
begin
 tmp_pos:=970;
 SplitString(gcmd.cmd,hlist);
 if hlist.Count<3 then exit; // internal error
 dst:=StrToIntDef(hlist.Strings[0],0);
 src:=StrToIntDef(hlist.Strings[1],0);
 tmp_pos:=971;
 if (dst=0) or (src=0) then exit; // internal error
 id:=StrToIntDef(hlist.Strings[2],0);
 gcmd.cmd:=NextParam(gcmd.cmd,3);
 tmp_pos:=972;
 if dst=myserverhandle then
 begin
   // message for this server
   try
     srv:=nil;
     tmp_pos:=973;
     for i:=0 to db_servers.Count-1 do
     begin
       srv2:=db_servers.Items[i];
       if srv2.server_handle=src then
         srv:=srv2;
     end;
     tmp_pos:=974;
     if srv=nil then exit;
     if srv.connected<>conConnected then exit;
     tmp_pos:=975;
     gcmd.id:=id;
     ProcessServerCommand(srv);
    except
     on E:Exception do
      DebugLog('Exception in Handler_SrvRelay (pos='+IntToStr(tmp_pos)+') : '+E.Message);
   end;
   exit;
 end;
 tmp_pos:=976;
 for i:=0 to db_servers.Count-1 do
 begin
   srv2:=db_servers.Items[i];
   tmp_pos:=977;
   if srv2.logged then
   if srv2.server_handle=dst then
   begin
     tmp_pos:=978;
     if search_noforward_results then
      if id=MSG_SRV_SEARCH_RESULT then // to avoid too much traffic
       if CheckLag(GetServerLink(srv2)) then
        exit;
     tmp_pos:=979;
     if browse_noforward_results then
      if id=MSG_CLIENT_RELAY then // do not return browse result
       if FirstParam(gcmd.cmd)='212' then
        if CheckLag(GetServerLink(srv2)) then
         exit;
     tmp_pos:=980;
     srv2.Relay(id,gcmd.cmd,dst,src);
     exit;
   end;
 end;
end;

procedure Handler_SrvRemoteDisconnect;
var
 srv: TServer;
begin
 tmp_pos:=981;
 srv:=FindServer(gcmd.cmd);
 if srv=nil then exit;
 tmp_pos:=982;
 if srv.connected=conConnected then
  DisconnectServer(srv,false,true,'Handler_SrvRemoteDisconnect from '+server.host);
end;

procedure Handler_ServerSyncChannel;
var
 ch: TChannel;
 overwrite: Boolean;
 st: TChannelState;
 i: Integer;
begin
 tmp_pos:=990;
 SplitString(gcmd.cmd,hlist);
 if hlist.Count<6 then exit;
 overwrite:=hlist.Strings[1]='1';
 st:=[];
 i:=StrToIntDef(hlist.Strings[5],0);
 if (i and 1)>0 then st:=st+[chRegistered];
 if (i and 2)>0 then st:=st+[chPrivate];
 if (i and 4)>0 then st:=st+[chModerated];
 if (i and 8)>0 then st:=st+[chTopic];
 ch:=FindChannel(hlist.Strings[0]);
 tmp_pos:=991;
 if ch=nil then
 begin // new channel
   tmp_pos:=992;
   ch:=TChannel.Create(hlist.Strings[0]);
   ch.topic:=hlist.Strings[2];
   ch.limit:=StrToIntDef(hlist.Strings[3],ch.limit);
   ch.level:=Str2Level(hlist.Strings[4]);
   ch.state:=st;
   tmp_pos:=993;
   db_channels.Add(ch);
   WriteAllServers(gcmd.id,'',gcmd.cmd,server);
   exit;
 end;
 tmp_pos:=994;
 if not overwrite then exit; // remote server should change its channel props, not this one
 ch.SetTopic(hlist.Strings[2]);
 ch.limit:=StrToIntDef(hlist.Strings[3],ch.limit);
 ch.level:=Str2Level(hlist.Strings[4]);
 ch.state:=st;
end;

procedure Handler_ServerChannelVoice;
var
 user: POnlineUser;
 ch: TChannel;
 forward_all: Boolean;
 voice,voice2: Boolean;
 srv: TServer;
begin
 tmp_pos:=995;
 SplitString(gcmd.cmd,hlist);
 if hlist.Count<5 then exit;
 voice:=hlist.Strings[3]='1';
 forward_all:=hlist.Strings[4]='1';
 ch:=FindChannel(hlist.Strings[0]);
 tmp_pos:=996;
 if ch=nil then exit;
 if not (chModerated in ch.state) then exit;
 user:=db_online.FindUser(hlist.Strings[1]);
 tmp_pos:=997;
 if user=nil then exit;
 if ch.FindUser(user)=-1 then exit;
 voice2:=StrHash_FindString(ch.voices,user^.nick,true);
 tmp_pos:=998;
 if voice=voice2 then exit;
 if not voice then
 begin // can speak here, but can't on linked server
   if forward_all then
    WriteAllServersEx(server,MSG_SRV_VOICE,'',ch.channel+' '+user^.nick+' '+IntToStr(myserverhandle)+' 1 1');
   exit;
 end;
 tmp_pos:=999;
 // can speak on linked server, but can't speak here
 StrHash_AddEx(ch.voices,user^.nick);
 tmp_pos:=1000;
 if user^.server=nil then
 begin
   srv:=FindServer(StrToIntDef(hlist.Strings[2],0));
   Exec(user,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_VOICE6,GetServerName(srv),ch.channel));
   ch.Wallop(GetLangT(LNG_VOICE5,GetServerName(srv),user^.nick));
 end;
end;

procedure Handler_ServerChannelOp;
var
 user,user2: POnlineUser;
 ch: TChannel;
 forward_all: Boolean;
 op: Boolean;
 srv: TServer;
 i: Integer;
begin
 tmp_pos:=1001;
 SplitString(gcmd.cmd,hlist);
 if hlist.Count<5 then exit;
 op:=hlist.Strings[3]='1';
 forward_all:=hlist.Strings[4]='1';
 ch:=FindChannel(hlist.Strings[0]);
 tmp_pos:=1002;
 if ch=nil then exit;
 if not (chModerated in ch.state) then exit;
 user:=db_online.FindUser(hlist.Strings[1]);
 if user=nil then exit;
 tmp_pos:=1003;
 if ch.FindUser(user)=-1 then exit;
 if ch.Operator(user)=op then exit;
 tmp_pos:=1004;
 if not op then
 begin // can moderate here, but can't on linked server
   if forward_all then
    WriteAllServers(MSG_SRV_OP,'',ch.channel+' '+user^.nick+' '+IntToStr(myserverhandle)+' 1 0');
   exit;
 end;
 tmp_pos:=1005;
 // can speak on linked server, but can't speak here
 StrHash_AddEx(ch.ops,AnsiLowerCase(user^.nick));
 srv:=FindServer(StrToIntDef(hlist.Strings[2],0));
 if user^.server=nil then
   Exec(user,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_CHANNELOPERATOR,GetServerName(srv),ch.channel));
 tmp_pos:=1006;
 for i:=0 to ch.users.count-1 do
 begin
   user2:=ch.users.Items[i];
   if (user2^.server=nil) and (user2<>user) then
    Exec(user2,MSG_SERVER_PUBLIC,ch.channel+' Server '+GetLangT(LNG_CHANNELOPERATOR2,GetServerName(srv),user^.nick,ch.channel));
 end;
end;

procedure Handler_ServerSyncServer;
var
 srv,srv2: TServer;
 i: Integer;
begin
 tmp_pos:=1010;
 SplitString(gcmd.cmd,hlist);
 if hlist.count<8 then exit;
 hlist.Strings[0]:=AnsiLowerCase(hlist.Strings[0]);
 // <server> <port> <version> <handle> <console> <parent_handle> <incoming:1|0>
 tmp_pos:=1011;
 srv:=FindServer(hlist.Strings[0]);
 srv2:=FindServer(StrToIntDef(hlist.Strings[5],0));
 tmp_pos:=1012;
 if srv2=nil then
 begin
   Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_INVLINKHANDLE,hlist.Strings[0],hlist.Strings[5]),true);
   exit;
 end;
 if srv=nil then
 begin
   srv:=TServer.Create;
   srv.host:=hlist.Strings[0];
   db_servers.Add(srv);
 end;
 tmp_pos:=1013;
 i:=StrToIntDef(hlist.Strings[3],0);
 srv.server_handle:=0;
 if (FindServer(i)<>nil) or (i=0) then
 begin
   Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKINVHANDLE4,hlist.Strings[0]),true);
   exit;
 end;
 tmp_pos:=1014;
 srv.ResetData;
 srv.port:=StrToIntDef(hlist.Strings[1],srv.port);
 srv.version:=hlist.Strings[2];
 srv.server_handle:=i;
 srv.console:=hlist.Strings[4];
 srv.hub:=srv2;
 srv.incoming:=hlist.Strings[6]='1';
 srv.reg_user:=AnsiLowerCase(hlist.Strings[7]);
 srv.logged:=true;
 srv.connected:=conConnected;
 tmp_pos:=1015;
 Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKSRVLOGGED3,srv.host,srv2.host),true);
end;

procedure SyncRegisteredUser(srv: TServer; reg: PRegisteredUser; write_all: Boolean);
var
 str: String;
 list: TStringList;
begin
 tmp_pos:=1020;
 if reg=nil then exit;
 if (not write_all) and (srv=nil) then exit; // possible internal error
 list:=CreateStringList;
 list.Add(reg^.nick);
 list.Add(reg^.password);
 list.Add(IntToStr(Ord(reg^.level)));
 list.Add(IntToStr(reg^.downloads));
 list.Add(IntToStr(reg^.uploads));
 list.Add(IntToStr(reg^.last_ip));
 list.Add(IntToStr(reg^.last_seen));
 list.Add(IntToStr(UserState2Int(reg^.state)));
 tmp_pos:=1021;
 str:=JoinString(list);
 FreeStringList(list);
 tmp_pos:=1022;
 if write_all then
 begin
   if srv=nil then WriteAllServers(MSG_SRV_SYNCREGISTERED,'',str) // send to everyone
   else WriteAllServersEx(srv,MSG_SRV_SYNCREGISTERED,'',str); // send to srv and all linked to it
 end else srv.Exec(MSG_SRV_SYNCREGISTERED,str); // send to srv only
end;

procedure Handler_ClearServerRegistrations;
var
 i: Integer;
begin
 for i:=0 to MAX_INDEX do
  db_registered.list[i].Clear;
end;

procedure Handler_SyncServerRegistrations;
var
 reg: TRegisteredUser;
begin
 SplitString(gcmd.cmd,hlist);
 if hlist.count<8 then exit;
 reg.nick:=hlist.Strings[0];
 if db_registered.FindUser(reg.nick)<>nil then db_registered.Delete(reg.nick);
 reg.password:=hlist.Strings[1];
 reg.level:=Str2Level(hlist.Strings[2]);
 reg.downloads:=StrToIntDef(hlist.Strings[3],0);
 reg.uploads:=StrToIntDef(hlist.Strings[4],0);
 reg.last_ip:=StrToInt64Def(hlist.Strings[5],0);
 reg.last_seen:=StrToIntDef(hlist.Strings[6],0);
 reg.state:=Int2UserState(StrToIntDef(hlist.Strings[7],0),false);
 db_registered.Add(reg);
end;

procedure Handler_SyncRegistered;
var
 reg: PRegisteredUser;
 r: TRegisteredUser;
 user: POnlineUser;
 loc: TLocalUser;
begin
 tmp_pos:=1025;
 SplitString(gcmd.cmd,hlist);
 if hlist.count<8 then exit;
 r.nick:=hlist.Strings[0];
 r.password:=hlist.strings[1];
 r.level:=Str2Level(hlist.Strings[2]);
 r.downloads:=StrToIntDef(hlist.Strings[3],0);
 r.uploads:=StrToIntDef(hlist.Strings[4],0);
 r.last_ip:=StrToInt64Def(hlist.Strings[5],0);
 r.last_seen:=StrToIntDef(hlist.Strings[6],0);
 r.state:=Int2UserState(StrToIntDef(hlist.Strings[7],0),false);
 tmp_pos:=1026;
 reg:=db_registered.FindUser(r.nick);
 if reg=nil then
 begin
   tmp_pos:=1027;
   if (r.level<>napUserUser) or (userMuzzled in r.state) or accept_remote_users then
    db_registered.Add(r);
 end
 else
 begin
  tmp_pos:=1028;
  if reg^.password<>r.password then
  begin // accounts don't match - kick oldest one
    tmp_pos:=1029;
    if r.last_seen<reg^.last_seen then
    begin // kick remote one
      tmp_pos:=1030;
      SyncRegisteredUser(nil,reg,true);
      exit;
    end else if r.last_seen>reg^.last_seen then
    begin // kick local
      tmp_pos:=1031;
      db_registered.Delete(r.nick);
      db_registered.Add(r);
      tmp_pos:=1032;
      reg:=db_registered.FindUser(r.nick);
      user:=db_online.FindUser(r.nick);
      tmp_pos:=1033;
      if (user<>nil) and (user^.server=nil) then
      if user^.level<>napUserConsole then
      begin
       tmp_pos:=1034;
       loc:=FindLocalUser(user);
       if loc<>nil then
       begin
         tmp_pos:=1035;
         loc.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_KICKMSG2,server.host));
//         if user^.level<napUserModerator then
//          AddReconnector(decode_ip(loc.ip));
         DisconnectUser(loc,'','','Handler_SyncRegistered',false);
       end;
       tmp_pos:=1036;
       if reg<>nil then
        SyncRegisteredUser(nil,reg,true);
      end;
    end;
    exit;
  end
  else
  begin // passwords match. same user
    tmp_pos:=1037;
    if r.last_seen>reg^.last_seen then
    begin // update record
      tmp_pos:=1038;
      db_registered.Delete(r.nick);
      db_registered.Add(r);
      reg:=db_registered.FindUser(r.nick);
    end else if r.last_seen<reg^.last_seen then
    begin // update remote record
      tmp_pos:=1039;
      SyncRegisteredUser(nil,reg,true);
      exit;
    end;
  end;
 end;
 tmp_pos:=1040;
 user:=db_online.FindUser(r.nick);
 if user=nil then exit;
 if user^.server<>nil then exit;
 loc:=FindLocalUser(user);
 tmp_pos:=1041;
 if loc=nil then exit;
 if loc.data^.password<>r.password then
 begin
   if loc<>cons then
   begin
    tmp_pos:=1042;
    loc.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_KICKMSG2,server.host));
    if user^.level<napUserModerator then
     AddReconnector(decode_ip(loc.ip));
    DisconnectUser(loc,'','','Handler_SyncRegistered2',false);
   end;
   exit;
 end;
 tmp_pos:=1043;
 if loc.level<r.level then
 begin // updating level
   tmp_pos:=1044;
   loc.data^.level:=napUserUser;
   loc.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_LEVEL,GetServerName(server),Level2Str(r.level),IntToStr(Ord(r.level))));
   Wallop(MSG_SERVER_NOSUCH,wallopLevel,GetLangT(LNG_LEVEL1,GetServerName(server),loc.nick,Level2Str(r.level),IntToStr(Ord(r.level))),false);
   loc.data^.level:=r.level;
 end;
 tmp_pos:=1045;
 if (userMuzzled in r.state)<>(userMuzzled in loc.data^.state) then
 begin
   if userMuzzled in r.state then loc.data^.state:=loc.data^.state+[userMuzzled]
   else loc.data^.state:=loc.data^.state-[userMuzzled];
 end;
 tmp_pos:=1046;
 CompleteSyncUser(nil,loc.data);
end;

procedure Handler_SyncUser(public_message: Boolean);
var
 user2: POnlineUser;
 usr: TOnlineUser;
 srv2: TServer;
 st: TUserState;
 i: Integer;
 l: TLocalUser;
 reg: PRegisteredUser;
 str1: String;
 b: PBan;
begin
 tmp_pos:=1050; // extensive debug in this handler
 SplitString(gcmd.cmd,hlist);
 tmp_pos:=1051;
 if hlist.count<17 then exit; // invalid arguments
 tmp_pos:=1052;
 srv2:=FindServer(StrToIntDef(hlist.Strings[14],0));
 if srv2=nil then exit;
 tmp_pos:=1053;
 user2:=db_online.FindUser(hlist.Strings[0]);
 st:=[];
 i:=StrToIntDef(hlist.Strings[15],0);
 tmp_pos:=1054;
 if (i and 1)<>0 then st:=st+[userMuzzled];
 if (i and 2)<>0 then st:=st+[userCloaked];
 tmp_pos:=1055;
 if user2<>nil then
 begin
   tmp_pos:=1056;
   if user2^.server<>srv2 then
   begin // user already exists
     tmp_pos:=1057;
     if user2^.server=nil then
     begin
       tmp_pos:=1058;
       l:=FindLocalUser(user2);
       if l=nil then exit; // weird error
       tmp_pos:=1059;
       l.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_KICKMSG2,server.host));
//       if user2^.level<napUserModerator then
//        AddReconnector(decode_ip(l.ip));
       DisconnectUser(l,'',GetLangT(LNG_SERVERGHOST,user2^.nick,user2^.software),'Handler_SyncUser',false);
     end
     else
     begin
       tmp_pos:=1060;
       WriteAllServers(MSG_SRV_USEROFFLINE,user2^.nick,''); // kick user on all servers
       KickUser(user2,'');
     end;
     exit;
   end;
   tmp_pos:=1061;
   with user2^ do
   begin
     tmp_pos:=1062;
     password:=hlist.Strings[1];
     software:=hlist.Strings[2];
     level:=Str2Level(hlist.Strings[3]);
     ip:=StrToInt64Def(hlist.Strings[4],0);
     dataport:=StrToIntDef(hlist.Strings[5],0);
     total_up:=StrToIntDef(hlist.Strings[6],0);
     total_down:=StrToIntDef(hlist.Strings[7],0);
     uploads:=StrToIntDef(hlist.Strings[8],0);
     downloads:=StrToIntDef(hlist.Strings[9],0);
     max_up:=StrToIntDef(hlist.Strings[10],-1);
     queue:=StrToIntDef(hlist.Strings[11],-1);
     speed:=Str2Speed(hlist.Strings[12]);
     shared:=StrToIntDef(hlist.Strings[13],0);
     server:=srv2;
     state:=state-[userMuzzled,userCloaked]+st;
     last_seen:=StrToInt64Def(hlist.Strings[16],0);
   end;
   tmp_pos:=1063;
 end
 else
 begin
   tmp_pos:=1064;
   with usr do
   begin
     nick:=hlist.Strings[0];
     password:=hlist.Strings[1];
     software:=hlist.Strings[2];
     level:=Str2Level(hlist.Strings[3]);
     ip:=StrToInt64Def(hlist.Strings[4],0);
     dataport:=StrToIntDef(hlist.Strings[5],0);
     total_up:=StrToIntDef(hlist.Strings[6],0);
     total_down:=StrToIntDef(hlist.Strings[7],0);
     uploads:=StrToIntDef(hlist.Strings[8],0);
     downloads:=StrToIntDef(hlist.Strings[9],0);
     max_up:=StrToIntDef(hlist.Strings[10],-1);
     queue:=StrToIntDef(hlist.Strings[11],-1);
     speed:=Str2Speed(hlist.Strings[12]);
     shared:=StrToIntDef(hlist.Strings[13],0);
     server:=srv2;
     state:=st;
     last_seen:=StrToInt64Def(hlist.Strings[16],0);
   end;
   tmp_pos:=1065;
   if usr.level<napUserModerator then
   if db_bans.Banned(usr.nick,decode_ip(usr.ip),b) then
   if b<>nil then
   begin // banned user
     tmp_pos:=1066;
     WriteAllServers(MSG_SRV_USEROFFLINE,usr.nick,''); // kick user on all servers
     WriteAllServers(MSG_SRV_REMOTEBANKICK,'',JoinBan(b^.user,b^.ip)+' '+AddStr(b^.admin)+' '+IntToStr(b^.time)+' '+IntToStr(b^.expires)+' '+b^.reason);
     exit;
   end;
   tmp_pos:=1067;
   db_online.Add(usr);
   tmp_pos:=1068;
   for i:=0 to db_local.count-1 do
   begin
     l:=db_local.Items[i];
     tmp_pos:=1069;
     str1:=StrHash_FindStringEx(l.hotlist,usr.nick,true);
     tmp_pos:=1071;
     if str1<>'' then
      l.Exec(MSG_SERVER_USER_SIGNON,str1+' '+IntToStr(Ord(usr.speed)));
   end;
   tmp_pos:=1072;
   // checking registered users
   reg:=db_registered.FindUser(usr.nick);
   tmp_pos:=1073;
   if reg<>nil then
    if (usr.password<>reg^.password) or (usr.level<>reg^.level) then
     SyncRegisteredUser(usr.server,reg,false);
 end;
 tmp_pos:=1074;
 if not public_message then
  WriteAllServers(gcmd.id,'',gcmd.cmd,server);
end;

procedure Handler_UpdateUser;
var
 user: POnlineUser;
begin
 tmp_pos:=1080;
 SplitString(gcmd.cmd,hlist);
 if hlist.count<9 then exit;
 tmp_pos:=1081;
 user:=db_online.FindUser(hlist.Strings[0]);
 if user=nil then exit;
 tmp_pos:=1082;
 user^.total_up:=StrToIntDef(hlist.Strings[1],user^.total_up);
 user^.total_down:=StrToIntDef(hlist.Strings[2],user^.total_down);
 user^.uploads:=StrToIntDef(hlist.Strings[3],user^.uploads);
 user^.downloads:=StrToIntDef(hlist.Strings[4],user^.downloads);
 user^.max_up:=StrToIntDef(hlist.Strings[5],user^.max_up);
 user^.queue:=StrToIntDef(hlist.Strings[6],user^.queue);
 user^.speed:=Str2Speed(hlist.Strings[7]);
 user^.shared:=StrToIntDef(hlist.Strings[8],user^.shared);
end;

procedure Handler_RemoteBanEx;
begin
 tmp_pos:=1083;
 SplitString(gcmd.cmd,hlist);
 tmp_pos:=1084;
 if hlist.Count<5 then exit;
 BanUser(hlist.Strings[0],hlist.Strings[1],StrToIntDef(hlist.Strings[2],0),hlist.Strings[3],false);
end;

procedure Handler_RemoteBan;
var
 b: TBan;
begin
 tmp_pos:=1085;
 SplitString(gcmd.cmd,hlist);
 tmp_pos:=1086;
 if hlist.Count<4 then exit;
 SplitBan(hlist.Strings[0],b.user,b.ip);
 if db_bans.FindRec(b.user,b.ip)<>-1 then exit;
 b.admin:=hlist.Strings[1];
 b.time:=StrToIntDef(hlist.Strings[2],0);
 tmp_pos:=1087;
 if b.time=0 then exit;
 b.expires:=StrToIntDef(hlist.Strings[3],0);
 if b.expires<>0 then
  if (b.expires<GetTickCountT) then exit; // expired
 tmp_pos:=1088;
 b.reason:=NextParam(gcmd.cmd,4);
 tmp_pos:=1089;
 db_bans.Add(b);
end;

procedure Handler_ClearServerBans;
begin
 db_bans.Clear;
end;

procedure Handler_SyncServerBan;
var
 b: TBan;
begin
 SplitString(gcmd.cmd,hlist);
 if hlist.count<4 then exit;
 SplitBan(hlist.Strings[0],b.user,b.ip);
 if db_bans.FindRec(b.user,b.ip)<>-1 then exit;
 b.admin:=hlist.Strings[1];
 b.time:=StrToIntDef(hlist.Strings[2],0);
 b.expires:=StrToIntDef(hlist.Strings[3],0);
 b.reason:=NextParam(gcmd.cmd,4);
 db_bans.Add(b);
end;

procedure Handler_RemoteUserKick;
var
 user2: POnlineUser;
 l: TLocalUser;
begin
 tmp_pos:=1090;
 user2:=db_online.FindUser(gcmd.cmd);
 if user2=nil then exit;
 tmp_pos:=1091;
 if user2^.server=nil then
 begin
  tmp_pos:=1092;
  l:=FindLocalUser(user2);
  if l=nil then exit;
  tmp_pos:=1093;
  l.Exec(MSG_SERVER_NOSUCH,GetLangT(LNG_KICKMSG2,server.host));
  if user2^.level<napUserModerator then
   AddReconnector(decode_ip(l.ip));
  DisconnectUser(l,'',GetLangT(LNG_SERVERGHOST,user2^.nick,user2^.software),'Handler_SyncUser',false)
 end
 else KickUser(user2,'');
end;

procedure SyncServers(srv,srv2: TServer);
var
 i: Integer;
 srv3: TServer;
begin
 tmp_pos:=1100;
 WriteAllServersEx(srv,MSG_SRV_SYNCSRV,'',srv2.host+' '+IntToStr(srv2.port)+' '+AddStr(srv2.version)+' '+IntToStr(srv2.server_handle)+' '+AddStr(srv2.console)+' '+IntToStr(GetServerHandle(srv2.hub))+' '+IntToStr(Ord(srv2.incoming))+' '+AddStr(srv2.reg_user));
 tmp_pos:=1101;
 for i:=0 to db_servers.count-1 do
 begin
   srv3:=db_servers.Items[i];
   if srv3.logged then
    if srv3.hub=srv2 then
     SyncServers(srv,srv3);
 end;
end;

procedure CompleteSyncUser(srv: TServer; user: POnlineUser);
var
 str: String;
 list: TStringList;
 i: Integer;
begin
 tmp_pos:=1102;
 list:=CreateStringList;
 list.Add(user^.nick);
 list.Add(user^.password);
 list.Add(user^.software);
 list.Add(IntToStr(Ord(user^.level)));
 list.Add(IntToStr(user^.ip));
 list.Add(IntToStr(user^.dataport));
 list.Add(IntToStr(user^.total_up));
 list.Add(IntToStr(user^.total_down));
 list.Add(IntToStr(user^.uploads));
 list.Add(IntToStr(user^.downloads));
 list.Add(IntToStr(user^.max_up));
 list.Add(IntToStr(user^.queue));
 list.Add(IntToStr(Ord(user^.speed)));
 list.Add(IntToStr(user^.shared));
 list.Add(IntToStr(GetServerHandle(user^.server)));
 i:=0;
 if userMuzzled in user^.state then inc(i,1);
 if userCloaked in user^.state then inc(i,2);
 list.Add(IntToStr(i));
 list.Add(IntToStr(user^.last_seen));
 tmp_pos:=1103;
 str:=JoinString(list);
 if srv<>nil then srv.Exec(MSG_SRV_SYNCUSER,str)
 else WriteAllServers(MSG_SRV_PUBLICSYNCUSER,'',str);
 tmp_pos:=1104;
 FreeStringList(list);
end;

procedure UpdateUser(user: POnlineUser; ignored: TServer=nil);
var
 str: String;
 list: TStringList;
begin
 tmp_pos:=1105;
 list:=CreateStringList;
 list.Add(user^.nick);
 list.Add(IntToStr(user^.total_up));
 list.Add(IntToStr(user^.total_down));
 list.Add(IntToStr(user^.uploads));
 list.Add(IntToStr(user^.downloads));
 list.Add(IntToStr(user^.max_up));
 list.Add(IntToStr(user^.queue));
 list.Add(IntToStr(Ord(user^.speed)));
 list.Add(IntToStr(user^.shared));
 tmp_pos:=1106;
 str:=JoinString(list);
 FreeStringList(list);
 tmp_pos:=1107;
 WriteAllServers(MSG_SRV_UPDATEUSER,'',str,ignored);
end;

procedure CompleteSyncServer(srv: TServer;n: Integer);
var
 ch: TChannel;
 i,j,k,num: Integer;
 str: String;
 srv2: TServer;
 user2: POnlineUser;
 local2: TLocalUser;
 ban: PBan;
 reg: PRegisteredUser;
 list: TStringList;
begin
 tmp_pos:=1110;
 linking:=true;
 // sync all linked servers
 WriteAllServers(MSG_SRV_SYNCSRV,'',srv.host+' '+IntToStr(srv.port)+' '+AddStr(srv.version)+' '+IntToStr(srv.server_handle)+' '+AddStr(srv.console)+' '+IntToStr(myserverhandle)+' '+IntToStr(Ord(srv.incoming))+' '+AddStr(srv.reg_user),srv);
 srv.lag:=true;
 srv.login_start:=GetTickCount;
 for i:=0 to db_servers.count-1 do
 begin
   tmp_pos:=1111;
   srv2:=db_servers.Items[i];
   if srv2<>srv then
    if srv2.logged then
     if srv2.hub=nil then
      SyncServers(srv,srv2);
 end;
 tmp_pos:=1112;
 k:=0;
 CheckSync;
 srv.Flush;
 tmp_pos:=1113;
 if srv.connected<>conConnected then exit;
 // sync all bans
 if hub_syncban then
 if srv.incoming then
 begin
  WriteAllServersEx(srv,MSG_SRV_SERVERBANCLEAR,'','');
  for i:=0 to db_bans.Count-1 do
  begin
    ban:=db_bans.Items[i];
    str:='';
    str:=JoinBan(ban^.user,ban^.ip)+' '+AddStr(ban^.admin)+' '+IntToStr(ban^.time)+' '+IntToStr(ban^.expires)+' '+ban^.reason;
    WriteAllServersEx(srv,MSG_SRV_SERVERBANSYNC,'',str);
    if (i mod 20)=0 then CheckSync;
  end;
 end;
 if hub_syncreg then
 if srv.incoming then
 begin
   WriteAllServersEx(srv,MSG_SRV_REGISTEREDCLEAR,'','');
   list:=CreateStringList;
   for i:=0 to MAX_INDEX do
    for j:=0 to db_registered.list[i].count-1 do
    begin
      reg:=db_registered.list[i].Items[j];
      list.Clear;
      list.Add(reg^.nick);
      list.Add(reg^.password);
      list.Add(IntToStr(Ord(reg^.level)));
      list.Add(IntToStr(reg^.downloads));
      list.Add(IntToStr(reg^.uploads));
      list.Add(IntToStr(reg^.last_ip));
      list.Add(IntToStr(reg^.last_seen));
      list.Add(IntToStr(UserState2Int(reg^.state)));
      str:=JoinString(list);
      WriteAllServersEx(srv,MSG_SRV_REGISTEREDSYNC,'',str);
      if (j mod 5)=0 then CheckSync;
    end;
   FreeStringList(list);
 end;
 // sync all users
 num:=0;
 for j:=0 to MAX_INDEX do
 for i:=0 to db_online.list[j].Count-1 do
 begin
   if (i mod 5)=0 then CheckSync;
   tmp_pos:=1114;
   user2:=db_online.list[j].Items[i];
   CompleteSyncUser(srv,user2);
   tmp_pos:=1115;
   if user2^.server=nil then
   begin
     local2:=FindLocalUser(user2);
     tmp_pos:=1116;
     if local2<>nil then
      if locNeedsUpdate in local2.localstate then
      begin
       UpdateUser(user2,srv);
       local2.localstate:=local2.localstate-[locNeedsUpdate];
      end;
   end;
   tmp_pos:=1117;
   inc(num);
   if (num div 10)=0 then CheckSync;
   if (num div 100)=0 then
   begin
     tmp_pos:=1118;
     srv.Flush;
     if srv.connected<>conConnected then exit;
   end;
 end;
 tmp_pos:=1119;
 CheckSync;
 srv.Flush;
 if srv.connected<>conConnected then exit;
 // sync all channels
 tmp_pos:=1120;
 if db_channels<>nil then
  for i:=0 to db_channels.count-1 do
  begin
    if (i mod 10)=0 then CheckSync;
    tmp_pos:=1121;
    ch:=db_channels.Items[i];
    j:=0;
    if chRegistered in ch.state then inc(j,1);
    if chPrivate in ch.state then inc(j,2);
    if chModerated in ch.state then inc(j,4);
    if chTopic in ch.state then inc(j,8);
    str:=ch.channel+' '+IntToStr(n)+' '+AddStr(ch.topic)+' '+IntToStr(ch.limit)+' '+
      IntToStr(Ord(ch.level))+' '+IntToStr(j);
    tmp_pos:=1122;
    srv.Exec(MSG_SRV_SYNCCH,str);
    for j:=0 to ch.users.count-1 do
    begin
      tmp_pos:=1123;
      user2:=ch.users.Items[j];
      WriteAllServersEx(srv,MSG_CLIENT_JOIN,user2^.nick,ch.channel);
      tmp_pos:=1124;
      if user2^.level<napUserModerator then
      begin
        if ch.Operator(user2) then
          WriteAllServersEx(srv,MSG_SRV_OP,'',ch.channel+' '+user2^.nick+' '+IntToStr(myserverhandle)+' 1 1')
        else if (chModerated in ch.state) and StrHash_FindString(ch.voices,user2^.nick,true) then
          srv.Exec(MSG_SRV_VOICE,ch.channel+' '+user2^.nick+' '+IntToStr(myserverhandle)+' 1 1');
      end;
      tmp_pos:=1125;
      inc(k);
      if (k div 10)=0 then CheckSync;
    end;
  end;
 tmp_pos:=1126;
 srv.Flush;
 if srv.connected<>conConnected then exit;
 tmp_pos:=1127;
 WriteAllServers(MSG_SERVER_STATS,'',IntToStr(local_users)+' '+IntToStr(local_files)+' '+IntToStr(local_bytes)+' '+IntToStr(max_users));
 srv.lag:=true;
end;

procedure Handler_LinkServer;
var
 r_reg, r_ip, r_host, r_version, r_console, r_port: String;
 r_handle, i: Integer;
 srv: TServer;
 s: PNapCmdEx;
 sin: TSockAddrIn;
begin // appears after server authentication
 tmp_pos:=1130;
 if query<>queryNormal then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if (local=nil) or (local.data<>nil) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if not (locSwapBytes in local.localstate) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if local.searchespm<>999 then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=1131;
 sin:=TCPSocket_GetRemoteSin(local.socket);
 r_ip:=decode_ip(sin.sin_addr.S_addr);
 hlist.Clear;
 for i:=db_invitations.count-1 downto 0 do
 begin
   s:=db_invitations.Items[i];
   if s^.data=r_ip then
   begin
     if hlist.count=0 then
      SplitString(s^.cmd,hlist);
   end;
 end;
 if hlist.count<9 then
 begin
   DebugLog('Possible Error in Handler_LinkServer: hlist.count = '+IntToStr(hlist.count));
   exit; // internal error or command not found in database
 end;
 tmp_pos:=1132;
 // hlist: <host> <port> <version> <net_build> <handle> <console>
 r_host:=AnsiLowerCase(hlist.Strings[0]);
 r_port:=hlist.Strings[1];
 r_version:=hlist.Strings[2];
 r_handle:=StrToIntDef(hlist.Strings[4],0);
 r_console:=hlist.Strings[5];
 r_reg:=hlist.Strings[6];
 srv:=FindServer(r_host);
 tmp_pos:=1133;
 if srv=nil then
 begin
   tmp_pos:=1134;
   srv:=TServer.Create;
   db_servers.Add(srv);
   srv.host:=r_host;
 end
 else
 begin
   tmp_pos:=1135;
   if srv.connected<>conNotConnected then
   begin
     DisconnectUser(local,'','','Handler_LinkServer',true);
     exit;
   end;
 end;
 tmp_pos:=1136;
 srv.port:=StrToIntDef(r_port,8888);
 srv.hub:=nil;
 srv.connected:=conConnected;
 srv.socket:=local.socket;
 if not sockets_servers_default then
 begin
   TCPSocket_SetSizeRecvBuffer(srv.socket,sockets_servers_recv);
   TCPSocket_SetSizeSendBuffer(srv.socket,sockets_servers_send);
 end;
 tmp_pos:=1137;
 local.socket:=INVALID_SOCKET;
 DisconnectUser(local,'','','Handler_LinkServer',true);
 srv.logged:=true;
 srv.incoming:=true;
 srv.version:=r_version;
 srv.console:=r_console;
 srv.num_users:=0;
 srv.num_files:=0;
 srv.max_users:=0;
 srv.num_bytes:=0;
 srv.server_handle:=r_handle;
 srv.reg_user:=AnsiLowerCase(r_reg);
 tmp_pos:=1138;
 srv.Exec(MSG_SRV_LOGIN_ACK,AddStr(SLAVANAP_FULL)+' '+IntToStr(myserverhandle)+' '+cons.nick+' '+AddStr(cons_reg_user));
 srv.Compile;
 srv.Flush;
 tmp_pos:=1139;
 if srv.connected<>conConnected then exit;
 srv.logged:=true;
 CompleteSyncServer(srv,1);
end;

procedure Handler_ServerCheckPass;
begin
 server.Exec(MSG_SRV_CHECKPASS2,StrMD5(gcmd.cmd+server.mypassword));
end;

procedure Handler_ServerLoginError;
begin
 Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKLOGINERR,server.host,gcmd.cmd),true);
 DisconnectServer(server,false,false,'Handler_ServerLoginError');
end;

procedure Handler_ServerLoginAck;
var
 user2: POnlineUser;
begin
 tmp_pos:=1140;
 SplitString(gcmd.cmd,hlist);
 if hlist.count<4 then exit;
 tmp_pos:=1141;
 server.logged:=true;
 server.version:=hlist.Strings[0];
 server.server_handle:=StrToIntDef(hlist.Strings[1],0);
 server.console:=hlist.Strings[2];
 server.reg_user:=AnsiLowerCase(hlist.Strings[3]);
 user2:=db_online.FindUser(server.console);
 tmp_pos:=1142;
 if user2<>nil then
 begin
   if user2^.level=napUserConsole then
   begin
     tmp_pos:=1143;
     DisconnectServer(server,false,false,'Handler_ServerLoginAck');
     Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKINVCONSOLE,server.host,user2^.nick),true);
     exit;
   end
   else KickUser(user2,'');
 end;
 tmp_pos:=1144;
 Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKSRVLOGGED,server.host),true);
 CompleteSyncServer(server,0);
end;

procedure Handler_ServerCheckPass2;
var
 r_ip, str: String;
 srv: TServer;
 s: PNapCmdEx;
 sin: TSockAddrIn;
 i: Integer;
begin
 tmp_pos:=1150;
 if query<>queryNormal then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if (local=nil) or (local.data<>nil) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if not (locSwapBytes in local.localstate) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if local.searchespm<>999 then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=1151;
 sin:=TCPSocket_GetRemoteSin(local.socket);
 r_ip:=decode_ip(sin.sin_addr.S_addr);
 hlist.Clear;
 for i:=db_invitations.count-1 downto 0 do
 begin
   s:=db_invitations.Items[i];
   if s^.data=r_ip then
   begin
     if hlist.count=0 then
      SplitString(s^.cmd,hlist);
   end;
 end;
 if hlist.count<6 then
 begin
   DebugLog('Possible Error in Handler_ServerCheckPass2: hlist.count = '+IntToStr(hlist.count));
   exit; // internal error or command not found in database
 end;
 str:=AnsiLowerCase(hlist.Strings[0]);
 srv:=FindServer(str);
 if srv=nil then exit; // check pass cannot be executed with unknown servers
 tmp_pos:=1152;
 str:=StrMD5(IntToStr(local.last_search_time)+srv.remotepassword);
 if str<>gcmd.cmd then
 begin
   tmp_pos:=1153;
   LoginError(GetLangT(LNG_LINKINVPASS));
   Wallop(MSG_SERVER_ERROR,wallopServer,GetLangT(LNG_LINKINVPASS2,srv.host),true);
   exit;
 end;
 Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKSRVLOGGED2,srv.host),true);
 server:=srv;
 tmp_pos:=1154;
 Handler_LinkServer;
end;

procedure Handler_ServerLogin;
var
 r_host, r_version, r_console, r_port, r_net, r_allhandles, r_allconsole, r_reg: String;
 r_handle, i, j, k: Integer;
 srv, srv2: TServer;
 b: Boolean;
 r_ip: String;
 sin: TSockAddrIn;
 s: PNapCmdEx;
 usr: POnlineUser;
begin
 tmp_pos:=1160; // extensive debug
 r_host:='<unknown>';
 r_version:='<unknown>';
 r_port:='8888';
 r_net:='0';
 r_ip:=decode_ip(TCPSocket_GetRemoteSin(local.socket).sin_addr.S_addr);
 tmp_pos:=1161;
 // format: <host> <port> <version> <net_build> <handle> <console>
 if query<>queryNormal then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=1162;
 if (local=nil) or (local.data<>nil) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=1163;
 if not (locSwapBytes in local.localstate) then
 begin
   PermissionDenied('',true);
   exit;
 end;
 tmp_pos:=1164;
 SplitString(gcmd.cmd,hlist);
 if hlist.count>5 then r_net:=hlist.Strings[3];
 tmp_pos:=1165;
 if r_net<>NET_BUILD then
 begin
   if hlist.count>0 then r_host:=AnsiLowerCase(hlist.Strings[0]);
   if hlist.Count>1 then r_port:=hlist.Strings[1];
   if hlist.count>2 then r_version:=hlist.Strings[2];
   tmp_pos:=1166;
   LoginError(GetLangT(LNG_LINKBADVERSION,SLAVANAP_FULL));
   Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKBADVERSION2,r_host,r_ip,r_version),true);
   exit;
 end;
 tmp_pos:=1167;
 // format: <host> <port> <version> <net_build> <handle> <console>
 r_host:=AnsiLowerCase(hlist.Strings[0]);
 r_port:=hlist.Strings[1];
 r_version:=hlist.Strings[2];
 r_net:=hlist.Strings[3];
 r_handle:=StrToIntDef(hlist.Strings[4],0);
 r_console:=hlist.Strings[5];
 r_reg:=hlist.Strings[6];
 r_allhandles:=hlist.Strings[7];
 r_allconsole:=hlist.Strings[8];
 tmp_pos:=1168;
 if allow_link=linkNone then // linking disabled
 begin
   LoginError(GetLangT(LNG_LINKNOLINK));
   Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKNOLINK2,r_host,r_ip),true);
   exit;
 end;
 if allow_link=linkCustom then
 begin
   SplitString(allowed_servers,hlst);
   if GetIndex(hlst,r_host,true)=-1 then
   begin
     LoginError(GetLangT(LNG_LINKNOLIST1));
     Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKNOLIST3,r_host,r_ip),true);
     exit;
   end;
 end;
 tmp_pos:=1169;
 srv:=FindServer(r_host);
 tmp_pos:=1170;
 if srv=nil then
 if allow_link=linkList then // unknown server
 begin
   tmp_pos:=1171;
   LoginError(GetLangT(LNG_LINKNOLIST));
   Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKNOLIST2,r_host,r_ip),true);
   exit;
 end;
 tmp_pos:=1172;
 if (srv<>nil) and srv.logged then // already logged
 begin
   tmp_pos:=1173;
   LoginError(GetLangT(LNG_LINKLOGGED));
   Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKLOGGED2,r_host,r_ip),true);
   exit;
 end;
 tmp_pos:=1174;
 if r_handle<1 then // invalid handle
 begin
   tmp_pos:=1175;
   LoginError(GetLangT(LNG_LINKINVHANDLE));
   Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKINVHANDLE2,r_host,r_ip),true);
   exit;
 end;
 SplitString(r_allhandles,hlst);
 for i:=0 to hlst.count-1 do
 begin
   j:=StrToIntDef(hlst.Strings[i],0);
   if j=myserverhandle then
   begin
     LoginError(GetLangT(LNG_LINKINVHANDLE3,hlst.Strings[i],servername_t));
     Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKINVHANDLE2,r_host,r_ip),true);
     exit;
   end;
   for k:=0 to db_servers.count-1 do
   begin
     srv2:=db_servers.Items[k];
     if srv2.logged then
      if srv2.server_handle=j then
      begin
        LoginError(GetLangT(LNG_LINKINVHANDLE3,hlst.Strings[i],srv2.host));
        Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKINVHANDLE2,r_host,r_ip),true);
        exit;
      end;
   end;
 end;
 SplitString(r_allconsole,hlst);
 for i:=0 to hlst.count-1 do
 begin
   usr:=db_online.FindUser(hlst.Strings[i]);
   if usr<>nil then
   begin
     if usr^.level=napUserConsole then
     begin
       LoginError(GetLangT(LNG_LINKINVCONSOLE2,usr^.nick));
       Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKINVCONSOLE3,r_host,r_ip),true);
       exit;
     end;
     KickUser(usr,'');
   end;
 end;
 tmp_pos:=1176;
 srv2:=FindServer(r_handle);
 tmp_pos:=1177;
 if (srv2<>nil) and (srv2.connected<>conNotConnected) then // handle already used
 begin
   tmp_pos:=1178;
   LoginError(GetLangT(LNG_LINKINVHANDLE3,r_handle,srv2.host));
   Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKINVHANDLE2,r_host,r_ip),true);
   exit;
 end;
 tmp_pos:=1179;
 if srv<>nil then
 if (srv.connected=conConnecting) or ((srv.connected=conConnected) and (srv.logged=false)) then
 try // already connecting
   LoginError(GetLangT(LNG_LINKLOGGING));
   Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKLOGGING2,r_host,r_ip),true);
   DisconnectServer(srv,false,false,'Handler_ServerLogin');
   exit;
  except
   exit;
 end;
 tmp_pos:=1180;
 sin:=TCPSocket_GetRemoteSin(local.socket);
 r_ip:=decode_ip(sin.sin_addr.S_addr);
 for i:=db_invitations.count-1 downto 0 do
 begin
   s:=db_invitations.Items[i];
   if s^.data=r_ip then
    db_invitations.Delete(i)
   else if (GetTickCount-s^.id)>EXPIRE_INVITATION then
    db_invitations.Delete(i);
 end;
 db_invitations.AddCmd(GetTickCount,gcmd.cmd,r_ip);
 local.searchespm:=999;
 tmp_pos:=1181;
 if (srv=nil) or (srv.authentication=authResolve) then
 begin // authentication via resolving host name
   tmp_pos:=1182;
   hlist.Clear;
   ResolveNameToIP(r_host,hlist);
   b:=false;
   tmp_pos:=1183;
   for i:=0 to hlist.count-1 do
    if hlist.Strings[i]=r_ip then b:=true;
   tmp_pos:=1184;
   if not b then
   begin // invalid IP
     tmp_pos:=1185;
     LoginError(GetLangT(LNG_LINKINVIP));
     Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKINVIP2,r_host,r_ip),true);
     exit;
   end;
   tmp_pos:=1186;
   local.last_search_time:=0;
 end else
 begin // authentication via password
   tmp_pos:=1187;
   local.last_search_time:=Random(65535);
   local.Exec(MSG_SRV_CHECKPASS,IntToStr(local.last_search_time));
   exit;
 end;
 tmp_pos:=1188;
 Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_LINKSRVLOGGED2,srv.host),true);
 tmp_pos:=1189;
 server:=srv;
 Handler_LinkServer;
end;

procedure Handler_RemoteWallop;
var
 i,j: Integer;
begin
 SplitString(gcmd.cmd,hlist);
 if hlist.count<3 then exit;
 i:=StrToIntDef(hlist.strings[0],0);
 if i<1 then exit;
 j:=StrToIntDef(hlist.Strings[1],-1);
 if j=-1 then exit;
 Wallop(i,TWallopType(j),NextParam(gcmd.cmd,2),true);
end;

procedure Handler_ServerShutDown;
begin
 if server.logged then
 begin
   if gcmd.cmd='' then
    Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_DELINKREQ,server.host,server.console),true)
   else
    Wallop(MSG_SERVER_NOSUCH,wallopServer,GetLangT(LNG_DELINKREQ,server.host,gcmd.cmd),true);
   DisconnectServer(server,true,false,'Handler_ServerShutDown');
 end;
end;

procedure Handler_PingAll;
var
 srv2: TServer;
 i: Integer;
 str: String;
begin
 if query=queryServer then
 begin
   if not CheckParams(2) then exit;
   i:=StrToIntDef(hlist.Strings[0],0);
   if i=myserverhandle then
   begin
     i:=StrToIntDef(hlist.Strings[1],0);
     if i=0 then exit;
     i:=GetTickCount-i;
     if i<0 then exit;
     Wallop(MSG_SERVER_NOSUCH,wallopPing,'Pong from server '+server.host+' ['+IntToStr(i)+' millisecs]',true);
     exit;
   end;
   if i=server.server_handle then
    server.Exec(gcmd.id,gcmd.cmd);
   exit;
 end;
 if not CheckLevel('',napUserModerator) then exit;
 if num_servers<1 then
 begin
   Error('ping all servers failed: no linked servers');
   exit;
 end;
 Wallop(MSG_SERVER_NOSUCH,wallopPing,'Pinging all peer servers...',true);
 str:=IntToStr(myserverhandle)+' '+IntToStr(GetTickCount);
 for i:=0 to db_servers.count-1 do
 begin
   srv2:=db_servers.Items[i];
   if srv2.logged then
    srv2.Exec(gcmd.id,gcmd.cmd);
 end;
end;

procedure Handler_ServerPing;
var
 srv: TServer;
begin
 if query=queryRemoteUser then
  Exec(user,gcmd.id,gcmd.cmd)
 else
 begin
  if not CheckParams(1) then exit;
  if AnsiLowerCase(hlist.Strings[0])=AnsiLowerCase(servername_t) then
  begin
    Exec(user,gcmd.id,gcmd.cmd);
    exit;
  end;
  srv:=FindServer(hlist.Strings[0]);
  if srv=nil then
  begin
   if isDigit(hlist.Strings[0]) then
     Exec(user,gcmd.id,gcmd.cmd)
   else
     Error('server ping failed: no such server',true);
  end
  else
    srv.Exec(gcmd.id,user^.nick+' '+gcmd.cmd);
 end;
end;

procedure Handler_Decompress;
var
 i: Integer;
 buf: String;
 srv: TServer;
begin
 tmp_pos:=1190;
 srv:=server;
 i:=-1;
 try
  buf:=ZDecompressStr(gcmd.cmd);
  CheckSync;
  except
   on E:Exception do
   begin
    DebugLog('Exception in decompressing data : '+E.Message);
    exit;
   end;
 end;
 tmp_pos:=1191;
 try
   while Length(buf)>3 do
   begin
     tmp_pos:=1192;
     i:=Ord(buf[1])*256+Ord(buf[2]);
     gcmd.id:=Ord(buf[3])*256+Ord(buf[4]);
     tmp_pos:=1193;
     if i>(Length(buf)-4) then
     begin
       tmp_pos:=1194;
       DebugLog('Handler_Decompress : invalid command length');
       compressed:=false;
       tmp_pos:=1195;
       SetLength(buf,0);
       exit;
     end;
     tmp_pos:=1196;
     SetLength(gcmd.cmd,i);
     tmp_pos:=1197;
     if i>0 then Move(buf[5],gcmd.cmd[1],i);
     Move(buf[i+5],buf[1],Length(buf)-i-4);
     tmp_pos:=1198;
     SetLength(buf,Length(buf)-i-4);
     try
       compressed:=true;
       tmp_pos:=1199;
       ProcessServerCommand(srv);
       tmp_pos:=1203;
       compressed:=false;
       except
        on E:Exception do
         DebugLog('Exception in Handler_Decompress (pos='+IntToStr(tmp_pos)+') : '+E.Message);
     end;
     tmp_pos:=1200;
   end;
   tmp_pos:=1201;
   compressed:=false;
   SetLength(buf,0);
   tmp_pos:=1202;
 except
   on E:Exception do
    DebugLog('Exception in Handler_Decompress (2) posm='+IntToStr(tmp_pos)+' i='+IntToStr(i)+' bufsize='+IntToStr(Length(buf))+' : '+E.Message);
 end;
end;

function ProcessCommand(usr: TLocalUser; q: TQuery=queryNormal): Boolean;
var
 str1: String;
begin
 Result:=true;
 tmp_pos:=1;
 if not running then exit;
 if q<>queryRemoteUser then
 begin
   if usr=nil then exit;
   local:=usr;
   if locWriteOnly in local.localstate then
   begin
     Result:=false;
     exit;
   end;
   if local.last_seen=0 then
   begin
     Result:=false;
     exit;
   end;
   user:=usr.data;
 end;
 tmp_pos:=2;
 query:=q;
 try
  if log_commands then
  if query=queryNormal then
  begin
    str1:=gcmd.cmd;
    if (gcmd.id=2) or (gcmd.id=6) then
    begin
      SplitString(str1,hlist);
      if hlist.count>1 then
      begin
       hlist.Strings[1]:='*****';
       str1:=JoinString(hlist);
      end; 
    end;
    str1:='Received command ['+IntToStr(gcmd.id)+'] "'+str1+'" (';
    if user<>nil then str1:=str1+user^.nick+', '+user^.software+', '+decode_ip(local.ip)+')'
    else if local<>nil then str1:=str1+decode_ip(local.ip)+')'
    else str1:=str1+'unknown)';
    Log(0,str1,true);
  end;
  tmp_pos:=3;
  case gcmd.id of
   MSG_CLIENT_LOGIN                   : Handler_Login; // 2 - login attempt
   MSG_CLIENT_VERSION_CHECK           : Handler_Echo; // 4 - version check
   MSG_CLIENT_LOGIN_REGISTER          : Handler_LoginRegister; // 6 - register attempt
   MSG_CLIENT_REGISTER                : Handler_CheckNick; // 7 - check nick
   MSG_CLIENT_CHECK_PASS              : Handler_PassCheck;   // 11 - check password
   MSG_CLIENT_ADD_FILE                : Handler_Share('',false); // 100 - share file
   MSG_CLIENT_REMOVE_FILE             : Handler_Unshare(gcmd.cmd); // 102 - unshare file
   MSG_CLIENT_UNSHARE_ALL             : Handler_Unshare;     // 110 - unshare all
   MSG_CLIENT_SEARCH                  : Handler_Search;      // 200 - search request
   MSG_CLIENT_DOWNLOAD                : Handler_Download;    // 203 - download request
   MSG_CLIENT_PRIVMSG                 : Handler_PrivateMessage; // 205 - private message
   MSG_CLIENT_ADD_HOTLIST,
   MSG_CLIENT_ADD_HOTLIST_SEQ         : Handler_HotList; // 207,208 - add to hotlist
   MSG_CLIENT_BROWSE                  : Handler_Browse; // 211 - browse files
   MSG_SERVER_STATS                   : Handler_Stats; // 214 - server stats
   MSG_CLIENT_RESUME_REQUEST          : Handler_Resume; // 215 - resume search
   MSG_CLIENT_DOWNLOAD_START..MSG_CLIENT_UPLOAD_END: Handler_Transfer; // 218..221 - start/end download/upload
   MSG_CLIENT_REMOVE_HOTLIST          : Handler_HotList; // 303 - remove from hot list
   MSG_CLIENT_IGNORE_LIST             : Handler_IgnoreList;  // 320 - ignore list
   MSG_CLIENT_IGNORE_USER             : Handler_IgnoreList;  // 322 - ignore user
   MSG_CLIENT_UNIGNORE_USER           : Handler_IgnoreList;  // 323 - unignore user
   MSG_CLIENT_CLEAR_IGNORE	      : Handler_IgnoreList;  // 326 - clear ignore list
   MSG_CLIENT_JOIN                    : Handler_JoinChannel; // 400 - join channel
   MSG_CLIENT_PART                    : Handler_PartChannel; // 401 - part channel
   MSG_CLIENT_PUBLIC, MSG_SERVER_PUBLIC: Handler_Public; // 402,403 - public message
   MSG_SERVER_TOPIC                   : Handler_ChannelTopic; // 410 - change/request channel topic
   MSG_CLIENT_CHANNEL_BAN_LIST        : Handler_ChanBanList; // 420 - list bans for channel
   MSG_CLIENT_CHANNEL_BAN             : Handler_ChanBan; // 422 - ban user in channel
   MSG_CLIENT_CHANNEL_UNBAN           : Handler_ChanUnban; // 423 - unban user in channel
   MSG_CLIENT_CHANNEL_CLEAR_BANS      : Handler_ChanBanClear; // 424 - clear channel bans
   MSG_CLIENT_CHANNEL_INVITE          : Handler_ChannelInvite; // 430 - invite user to channel
   MSG_CLIENT_CHANNEL_INVITE_DECLINE  : Handler_ChannelDeclineInvite; // 432 - invitation declined
   MSG_CLIENT_DOWNLOAD_FIREWALL       : Handler_DownloadFirewall; // 500 - download thru firewall
   MSG_CLIENT_USERSPEED               : Handler_GetData; // 600 - get user's speed
   MSG_CLIENT_WHOIS                   : Handler_Whois; // 603 - whois request
   MSG_CLIENT_SETUSERLEVEL            : Handler_SetUserLevel; // 606 - change user level
   MSG_CLIENT_UPLOAD_OK               : Handler_Upload; // 608 - upload accepted
   MSG_SERVER_UPLOAD_FAILED           : Handler_Upload; // 609 - upload failed (used by AudioGnome)
   MSG_CLIENT_KILL                    : Handler_Kill; // 610 - kill user
   MSG_CLIENT_NUKE                    : Handler_Nuke; // 611 - nuke user
   MSG_CLIENT_BAN                     : Handler_Ban; // 612 - ban user
   MSG_CLIENT_ALTER_PORT              : Handler_AlterPort; // 613 - alter port
   MSG_CLIENT_UNBAN                   : Handler_Unban; // 614 - unban user
   MSG_CLIENT_BANLIST                 : Handler_Banlist; // 615 - list bans
   MSG_CLIENT_LIST_CHANNELS           : Handler_ListChannels; // 617 - list channels
   MSG_CLIENT_LIMIT                   : Handler_Queue; // 619 - queue limit
   MSG_CLIENT_MOTD                    : if (GetTickCount-usr.last_seen)>30000 then Handler_Motd; // 621 - show motd
   MSG_CLIENT_MUZZLE                  : Handler_Muzzle; // 622 - muzzle user
   MSG_CLIENT_UNMUZZLE		      : Handler_Unmuzzle; // 623 - unmuzzle user
   MSG_CLIENT_ALTER_SPEED             : Handler_AlterSpeed; // 625 - alter speed
   MSG_CLIENT_DATA_PORT_ERROR         : Handler_Relay; // 626 - data port error
   MSG_CLIENT_WALLOP                  : Handler_Wallop; // 627 - wallop
   MSG_CLIENT_ANNOUNCE                : Handler_Announce; // 628 - global message
   MSG_CLIENT_BROWSE_DIRECT           : Handler_DirectBrowse; // 640 - direct browse request
   MSG_SERVER_BROWSE_DIRECT_OK        : Handler_DirectBrowseOK; // 641 - directo browse accepted
   MSG_CLIENT_CLOAK                   : Handler_Cloak; // 652 - cloak
   MSG_CLIENT_CHANGE_SPEED            : Handler_SetSpeed; // 700 - change speed
   MSG_CLIENT_CHANGE_PASS             : Handler_SetPass; // 701 - change password
   MSG_CLIENT_CHANGE_DATA_PORT        : Handler_SetDataPort; // 703 - change data port
   MSG_CLIENT_PING_SERVER             : Handler_ServerPing; // 750 - ping server
   MSG_CLIENT_PING                    : Handler_Relay2; // 751 - user ping
   MSG_CLIENT_PONG                    : Handler_Relay; // 752 - user pong
   MSG_CLIENT_ALTER_PASS              : Handler_AlterPass; // 753 - change password
   MSG_CLIENT_SERVER_RECONFIG         : Handler_Restart; // 800 - reconfig
   MSG_CLIENT_SERVER_VERSION          : Handler_ServerVersion; // 801 - server version
   MSG_CLIENT_SERVER_CONFIG           : Handler_SetConfig; // 810 - change server config
   MSG_CLIENT_CLEAR_CHANNEL           : Handler_ClearChannel; // 820 - clear channel
   MSG_CLIENT_REDIRECT                : Handler_Redirect; // 821 - redirect user to another server
   MSG_CLIENT_CYCLE                   : Handler_Redirect; // 822 - redirect user to metaserver
   MSG_CLIENT_SET_CHAN_LEVEL          : Handler_ChannelLevel; // 823 - set channels level
   MSG_CLIENT_EMOTE                   : Handler_Emote; // 824 - emote
   MSG_CLIENT_CHANNEL_LIMIT           : Handler_ChannelLimit; // 826 - channel limit
   MSG_CLIENT_FULL_CHANNEL_LIST       : Handler_ListAllChannels; // 827 - list all channels
   MSG_CLIENT_KICK                    : Handler_Kick; // 829 - kick user from channel
   MSG_CLIENT_NAMES_LIST              : Handler_ChannelUsersList;// 830 - list users in channel
   MSG_CLIENT_GLOBAL_USER_LIST        : Handler_UserList; // 831 - list all users
   MSG_CLIENT_ADD_DIRECTORY           : Handler_ShareDir; // 870 - share lots of files
   MSG_SRV_LOGIN                      : Handler_ServerLogin; // 8000 - server login
   MSG_SRV_CHECKPASS2                 : Handler_ServerCheckPass2; // 8006 - server authentication reply
//   MSG_CLIENT_RELAY                   : Handler_RelayMessage; // 8100 - relay message to another user
//   MSG_CLIENT_PRELAY                  : Handler_RelayAll; // 8101 - relay message to all users
   MSG_CLIENT_RESTART                 : Handler_Restart; // 8104 - restart server
   MSG_CLIENT_BLOCK                   : Handler_Block; // 8105 - block files
   MSG_CLIENT_UNBLOCK                 : Handler_Block; // 8106 - unblock files
   MSG_CLIENT_BLOCKLIST               : Handler_Block; // 8107 - list blocks
   MSG_CLIENT_MUZZLEINV               : Handler_MuzzleInv; // 8108 - invert muzzle
   MSG_CLIENT_GETCONSOLE              : Handler_GetConsole; // 8109 - get console users
   MSG_CLIENT_CHANNEL_BANIP           : Handler_ChanBan; // 8111 - ban IP in channel
   MSG_CLIENT_SETTRANSFERS            : Handler_SetTransfers; // 8112 - set transfers
   MSG_CLIENT_GETTRANSFERS            : Handler_GetTransfers; // 8113 - get transfers
   MSG_CLIENT_ADDCHANNEL              : Handler_AddChannel; // 8114 - add new registered channel
   MSG_CLIENT_FRIENDS                 : Handler_Friends; // 8115 - add/remove/list friends
   MSG_CLIENT_BANEX                   : Handler_BanEx; // 8116 - ban user
   MSG_CLIENT_CHANGEBAN               : Handler_ChangeBan; // 8117 - change ban
   MSG_CLIENT_CHANNEL_OPEMOTE         : Handler_ChannelOpEmote; // 8118 - op emote
   MSG_CLIENT_CONNECT                 : Handler_ServerConnect(nil,false); // 10100 - connect server
   MSG_CLIENT_DISCONNECT              : Handler_ServerDisconnect; // 10101 - disconnect server
   MSG_CLIENT_KILL_SERVER             : Handler_KillServer;       // 10110 - kill server
   MSG_CLIENT_REMOVE_SERVER           : Handler_RemoveServer; // 10111 - remove server
   MSG_CLIENT_LINKS                   : Handler_ServerLinks; // 10112 - show linked servers
   MSG_CLIENT_USAGE_STATS             : Handler_UsageStats; // 10115 - server stats
   MSG_CLIENT_VERSION_STATS           : Handler_SoftwareStats; // 10118 - version stats
   MSG_CLIENT_WHICH_SERVER            : Handler_WhichServer; // 10119 - show which server client is on
   MSG_CLIENT_PING_ALL_SERVERS        : Handler_PingAll; // 10120 - ping all servers
   MSG_CLIENT_WHO_WAS                 : Handler_WhoWas; // 10121 - who was
   MSG_CLIENT_HISTOGRAM               : Exec(user,MSG_SERVER_HISTOGRAM,'0 0 0 0 0'); // 10123
   MSG_CLIENT_REGISTER_USER           : Handler_AdminRegister; // 10200 - register user
   MSG_CLIENT_USER_MODE               : Handler_UserMode; // 10203 - set user mode
   MSG_CLIENT_OP                      : Handler_ChannelOp; // 10204 - set channel operator
   MSG_CLIENT_DEOP                    : Handler_ChannelDeop; // 10205 - remove channel operator
   MSG_CLIENT_DROP_CHANNEL            : Handler_DropChannel; // 10206 - drop channel
   MSG_CLIENT_CHANNEL_WALLOP          : Handler_ChannelWallop; // 10208 - send message to all channel ops+
   MSG_CLIENT_CHANNEL_MODE            : Handler_ChannelMode; // 10209 - change channel mode
   MSG_CLIENT_CHANNEL_INVITE_OPENNAP  : Handler_ChannelInvite; // 10210 - invite user to channel
   MSG_CLIENT_CHANNEL_VOICE           : Handler_ChannelVoice; // 10211 - give voice to speak in channel
   MSG_CLIENT_CHANNEL_UNVOICE         : Handler_ChannelUnvoice; // 10212 - remove voice
   MSG_CLIENT_SHARE_FILE              : Handler_ShareFile;   // 10300 - share non-mp3 file
   MSG_CLIENT_DENGON_READ             : Handler_DengonRead;  // 10500 - read all messages
   MSG_CLIENT_DENGON_READNEW          : Handler_DengonReadNew; // 10501 - read new messages
   MSG_CLIENT_DENGON_WRITE            : Handler_DengonWrite; // 10502 - leave a message
   MSG_CLIENT_DENGON_DELETE           : Handler_DengonDelete; //10503 - delete a message
   MSG_CLIENT_DENGON_CLEAR            : Handler_DengonClear;  //10504 - delete all messages

//     MSG_CLIENT_OPENNAPSERVER      : Handler_OpenNapLink; // 10010 - opennap server tries to link

   14,15,300,431,624,702,920,931,932,19999: begin end; // ignore command
  end;
  tmp_pos:=4;
  if local<>nil then local.Flush;
  CheckSync;
  except
   on E:Exception do
   begin
    DebugLog('Exception in ProcessCommand (id='+IntToStr(gcmd.id)+',cmd="'+gcmd.cmd+'",query='+IntToStr(Ord(q))+',pos='+IntToStr(tmp_pos)+') : '+E.Message);
    Result:=false;
   end;
 end;
// tmp_local:=nil; // to avoid possible access violation
end;

procedure ProcessRemoteUserCommand;
begin
 tmp_pos:=5;
 if not CheckParams(1) then exit;
 user:=db_online.FindUser(hlist.Strings[0]);
 tmp_pos:=6;
 if user=nil then exit;
 local:=FindLocalUser(user);
 tmp_pos:=7;
 gcmd.cmd:=NextParamEx(gcmd.cmd);
 ProcessCommand(local,queryRemoteUser);
end;

procedure ProcessServerCommand(srv: TServer);
var
 str1: String;
begin
 tmp_pos:=8;
 if srv=nil then exit;
 if not running then exit;
 server:=srv;
 user:=nil;
 local:=nil;
// tmp_local:=nil;
 query:=queryServer;
 tmp_pos:=9;
 try
  if log_servercommands then
  begin
    if gcmd.id<>MSG_SRV_COMPRESSED then
    begin
      if compressed then
       str1:='Received compressed server command ['+IntToStr(gcmd.id)+'] "'+gcmd.cmd+'" ('+server.host+')'
      else
       str1:='Received server command ['+IntToStr(gcmd.id)+'] "'+gcmd.cmd+'" ('+server.host+')';
      Log(0,str1,true);
    end else Log(0,'Received compressed data ('+server.host+')',true);
  end;
  tmp_pos:=10;
  if gcmd.id<>MSG_SRV_COMPRESSED then inc(num_processed);
  CheckSync;
  case gcmd.id of
   MSG_SERVER_ERROR                   : Handler_ServerLoginError; // 0 - server login error
   MSG_SERVER_STATS                   : Handler_ServerStats; // 214 - server stats
   MSG_SRV_LOGIN_ACK                  : Handler_ServerLoginAck; // 8001 - login ack
   MSG_SRV_SETLASTINV                 : Handler_SetLastInv; // 8002 - set "last_inv" variable
   MSG_SRV_FORWARDALL                 : Handler_ForwardAllServers; // 8003 - forward message to all linked servers
   MSG_SRV_DISCONNECTED               : Handler_SrvRemoteDisconnect; // 8004 - remote server disconnected
   MSG_SRV_CHECKPASS                  : Handler_ServerCheckPass; // 8005 - server authentication
   MSG_SRV_RELAY                      : Handler_SrvRelay; // 8007 - relay message to other server thru hub
   MSG_SRV_SYNCCH                     : Handler_ServerSyncChannel; // 8008 - channel sync
   MSG_SRV_VOICE                      : Handler_ServerChannelVoice; // 8009 - voice user in channel
   MSG_SRV_OP                         : Handler_ServerChannelOp; // 8010 - op user in channel (done by server)
   MSG_SRV_SYNCSRV                    : Handler_ServerSyncServer; // 8011 - sync linked server
   MSG_SRV_SYNCUSER                   : Handler_SyncUser(false); // 8012 - sync user
   MSG_SRV_PUBLICSYNCUSER             : Handler_SyncUser(true); // 8013 - sync user (sent to all servers)
   MSG_SRV_USEROFFLINE                : Handler_RemoteUserKick; // 8014 - kick remote user
   MSG_SRV_WALLOP                     : Handler_RemoteWallop; // 8015 - do wallop
   MSG_SRV_COMPRESSED                 : Handler_Decompress; // 8016 - compressed data
   MSG_SRV_UPDATEUSER                 : Handler_UpdateUser; // 8017 - update user data
   MSG_SRV_SEARCH_RESULT              : Handler_RemoteSearchResult; // 8018 - remote search result
   MSG_SRV_SEARCH_END                 : Handler_RemoteSearchEnd; // 8019 - end remote search
   MSG_SRV_SYNCREGISTERED             : Handler_SyncRegistered; // 8020 - sync registered user
   MSG_SRV_REMOTEBANKICK              : Handler_RemoteBan; // 8021 - kicking banned user
   MSG_SRV_SERVERBAN                  : Handler_RemoteBanEx; // 8022 - ban user
   MSG_SRV_SERVERBANCLEAR             : Handler_ClearServerBans; // 8023 - sync bans
   MSG_SRV_SERVERBANSYNC              : Handler_SyncServerBan; // 8024 - sync bans
   MSG_SRV_REGISTEREDCLEAR            : Handler_ClearServerRegistrations; // 8025 - sync registered
   MSG_SRV_REGISTEREDSYNC             : Handler_SyncServerRegistrations; // 8026 - sync registered
   MSG_SRV_SHUTDOWN                   : Handler_ServerShutDown; // 8027 - server shut down
   MSG_SRV_FLOODER                    : Handler_Flooder; // 8028 - informing about flooder
   MSG_CLIENT_RELAY                   : Handler_RelayMessage; // 8100 - relay message to another user
   MSG_CLIENT_PING_ALL_SERVERS        : Handler_PingAll; // 10120 - ping all servers
   else ProcessRemoteUserCommand;
  end;
  tmp_pos:=11;
  CheckSync;
  except
   on E:Exception do
    if gcmd.id<>MSG_SRV_COMPRESSED then
     DebugLog('Exception in ProcessServerCommand (id='+IntToStr(gcmd.id)+',cmd="'+gcmd.cmd+'",pos='+IntToStr(tmp_pos)+') : '+E.Message)
    else
     DebugLog('Exception in ProcessServerCommand (id='+IntToStr(gcmd.id)+',pos='+IntToStr(tmp_pos)+' - compressed data) : '+E.Message)
 end;
end;


initialization
begin
  hlist:=TStringList.Create;
  hlst:=TStringList.Create;
  compressed:=false;
  tmp_pos:=0; // last = 1261
end;

finalization
begin
  hlist.Free;
  hlst.Free;
end;
end.

