{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: languages

 Form for selecting language

*********************************************************}
unit languages;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  IniFiles, ComCtrls, ExtCtrls, StdCtrls, Classes;

type
  TSlavaNapLanguage = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    ksoOfficePanel1: TPanel;
    btn_ok: TButton;
    btn_cancel: TButton;
    list: TListView;
    procedure FormShow(Sender: TObject);
    procedure btn_cancelClick(Sender: TObject);
    procedure btn_okClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    modal: Boolean;
    procedure CreateParams(Var params: TCreateParams);override;
    procedure SetFont(form: TForm);
  end;

var
  SlavaNapLanguage: TSlavaNapLanguage;

implementation

uses mainform, vars, stypes, lang, settings, form;

{$R *.DFM}

procedure TSlavaNapLanguage.CreateParams(Var params: TCreateParams);
begin
  inherited CreateParams( params );
   params.ExStyle := params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapLanguage.FormShow(Sender: TObject);
var
 i: Integer;
 item: TListItem;
 rec: TSearchRec;
 str, fname, lang, comments, ver: String;
 ini: TIniFile;
begin
 SlavaNapLanguage.SetFont(Self);
 btn_cancel.Visible:=not modal;
 if language='' then language:='english';
 with list do
 begin
   Items.BeginUpdate;
   Items.Clear;
   i:=FindFirst(ApplicationDir+'*.lng',faAnyFile,rec);
   while i=0 do
   begin
     if (rec.attr and faDirectory)=0 then
      if rec.name<>'.' then
       if rec.name<>'..' then
       begin
         str:=AnsiLowerCase(ExtractFileName(rec.name));
         str:=Copy(str,1,Length(str)-4);
         fname:=str;
         lang:='';
         comments:='';
         ver:='';
         try
          ini:=TIniFile.Create(ApplicationDir+fname+'.lng');
          lang:=ini.ReadString('Version','Language','');
          comments:=ini.ReadString('Version','Comments','');
          ver:=ini.ReadString('Version','Version','');
          ini.Free;
          except
         end;
         if fname<>'' then
          if lang<>'' then
           if comments<>'' then
           begin
            item:=Items.Add;
            item.Caption:=lang;
            item.SubItems.Add(fname+'.lng');
            item.SubItems.Add(ver);
            item.SubItems.Add(comments);
            item.SubItems.Add(fname);
            if fname=language then
             item.Selected:=true;
           end;
       end;
     i:=FindNext(rec);
   end;
   FindClose(rec);
   Items.EndUpdate;
 end;
end;

procedure TSlavaNapLanguage.btn_cancelClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapLanguage.btn_okClick(Sender: TObject);
begin
 if list.Selected<>nil then
  language:=list.Selected.SubItems[3];
 Close;
 if btn_cancel.Visible and running then
 begin
  LoadLanguage(language);
  SetFont(SlavaNapWindow);
  SetFont(SlavaNapSettings);
  SetFont(Self);
  SlavaNapWindow.ChangeInterface;
  SlavaNapSettings.ChangeInterface;
 end;
end;

procedure TSlavaNapLanguage.SetFont(form: TForm);
var
  str: String;
  ini: TIniFile;
  cl: TColor;
begin
  if form=nil then exit;
  if form<>SlavaNapMain then
  begin
    form.Font:=SlavaNapMain.Font;
    exit;
  end;
  ini:=TIniFile.Create(ApplicationDir+'config');
  with form do
  begin
    str:=ini.ReadString('Interface','BiDiMode','bdLeftToRight');
    if str='bdRightToLeftReadingOnly'  then BiDiMode:=bdRightToLeftReadingOnly
    else if str='bdRightToLeftNoAlign' then BiDiMode:=bdRightToLeftNoAlign
    else if str='bdRightToLeft'        then BiDiMode:=bdRightToLeft
    else BiDiMode:=bdLeftToRight;
    Font.Charset:=ini.ReadInteger('Interface','FontCharset',DEFAULT_CHARSET);
    cl:=StringToColor(ini.ReadString('Interface','FontColor','clWindowText'));
    if cl<>0 then Font.Color:=cl;
    Font.Height:=ini.ReadInteger('Interface','FontHeight',-11);
    Font.Name:=ini.ReadString('Interface','FontName','MS Sans Serif');
    str:=ini.ReadString('Interface','FontPitch','fpDefault');
    if str='fpVariable'   then Font.Pitch:=fpVariable
    else if str='fpFixed' then Font.Pitch:=fpFixed
    else Font.Pitch:=fpDefault;
    Font.Size:=ini.ReadInteger('Interface','FontSize',9);
    Font.Style:=[];
  end;
  ini.Free;
end;

end.
