{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: constants

 All constants are here

*********************************************************}
unit constants;

interface

{$I defines.pas}

const
 // main
 SLAVANAP_TITLE               = 'SlavaNap';
 SLAVANAP_VERSION             = '2.4.1';
 SLAVANAP_BUILD               = '108';
 SLAVANAP_BUILD_DATE          = '24 January 2003';
 SLAVANAP_SHUUSEI             = '47';
 SLAVANAP_SHUUSEI_DATE        = '22 March 2003';
 SLAVANAP_VERSION_SHORT       = SLAVANAP_TITLE+' '+SLAVANAP_VERSION;
 SLAVANAP_FULL                = SLAVANAP_TITLE+' '+SLAVANAP_VERSION+
                                ' (build '+SLAVANAP_BUILD+
                                ' shuusei '+SLAVANAP_SHUUSEI+
                                ' - '+SLAVANAP_SHUUSEI_DATE+')';
 SLAVANAP_BUILD_TEXT          = 'Build '+SLAVANAP_BUILD+' ('+SLAVANAP_BUILD_DATE+')';
 NET_BUILD                    = '19';
 // limits
 MAX_USER_NAME                = 19;
 MIN_USER_NAME                = 1;
 MAX_CHANNEL_NAME             = 32;
 max_software                 = 32;
 max_software_index           = 1000;
 max_custom_block             = 31;
 def_channel_limit            = 100;
 def_ban_timeout              = (31*24*60*60);
 max_announcement             = 63;
 MAX_LOGINIM                  = 63;
 // sockets
 MAX_LISTEN_SOCKET            = 7; // maximum listen sockets
 MAX_LISTEN_TRAPSOCKET        = 7; // maximum listen trapsockets
 DEF_LISTEN_PORT              = 8888; //3456; // default port for listening
 DEF_LISTEN_PORTS             = '3456 8888';
 RECV_BUF_SIZE_MIN            = 128;
 RECV_BUF_SIZE_DEF            = 256;
 RECV_BUF_SIZE_MAX            = 8192;
 RECV_BUF_SIZE_SERVER         = 4096;
 MAX_SERVER_COMMAND           = 4092;
 MAX_SERVER_COMMANDS          = 32;
 MAX_COMMANDS_PER_CYCLE       = 10; // max received commands from one user
 MAX_COMMANDS_PER_CYCLE2      = 2; // max received commands from one user when server is linking
 MAX_FLUSH_INDEX              = 4;
 MAX_SEND_DELAY               = 600000;
 MAX_LOGIN_TIMEOUT            = 60000;
 SERVER_LOGIN_DELAY           = 1500;
 SERVER_MAX_RECEIVE_RECURSE   = 10;
 SERVER_SYNCH_TIMEOUT         = 60000; // timeout for sync operations
 // timeouts
 LASTSEARCH_TIMEOUT           = 15000; // timeout for remote search
 LASTBROWSE_TIMEOUT           = 15000; // timeout for remote browse
 MIN_SERVER_LAG               = 2000; // minimum server lag. if timeout is larger, search and browse results are not returned
 BANDWIDTH_TIMEOUT            = 10000;
 BANDWIDTH_CYCLE              = 20;
 OUTPUT_CHECK_DELAY           = 10000; // check sockets every 10 seconds
 CONSOLE_SYNC                 = 300;
 // other
 CONSOLE_PASS                 = 'console_user';
 CONSOLE_PASS_OFFLINE         = 'remote_console';
 CONSOLE_SOFT                 = 'SlavaNap Console';
 null_md5                     = '00000000000000000000000000000000';
 KiloByte                     = Int64(1024);
 MegaByte                     = Int64(1048576);
 GigaByte                     = Int64(1073741824);
 FileSizeLimit                = Int64(10737418240);
 blocked_bantime              = 86400; // 1 day
 POSSIBLE_LEAK                = 10485760; // 10Mb
 EXPIRE_INVITATION            = 3600000;
 WINMX_DETECT_TIME            = 300000; // 5 min.
 // users list
 USERS_INDEX_INC              = 47;//46;
 USERS_NAME_ARRAY             = 2209;//2116;
 USERS_IP_ARRAY               = 1024;
 // sharing
 MAX_FILE_KEYWORDS            = 12; // max keywords per file
 KEYWORD_LEN_MAX              = 24; // maximum length of keyword
 KEYWORD_LEN_MIN              = 2; // minimum length of keyword. should be '2' or more
 KEYWORD_MAX_SEARCH           = 8; // maximum keywords in search query
 MAX_KEYWORD_ITEMS            = 8000; // limit of items in one keyword. all items exceeding this limit won't be skipped - this limit makes sence only if keyword was selected as base keyword for search
 KEYWORDS_FIRST               = '!&0123456789@abcdefghijklmnopqrstuvwxyz'; // list of characters that can be first item of keyword
 KEYWORDS_FIRST_COUNT         = 40;//# of KEYWORDS_FIRST+1(for 2byte char)// 39; // number of items in KEYWORDS_FIRST list
 KEYWORDS_SEPARATORS          = #$00#$01#$02#$03#$04#$05#$06#$07#$08#$09#$0A#$0B#$0C#$0D#$0E#$0F+
                                #$10#$11#$12#$13#$14#$15#$16#$17#$18#$19#$1A#$1B#$1C#$1D#$1E#$1F+
                                #$20'"'#39'()*+,-./:;<=>?[\]_`'; // list of whitespaces. keyword ends as soon as any of these characters is found.
                                                                 // this list and KEYWORDS_FIRST list CANNOT contain any same character
 KEYWORDS_SEPARATORS_COUNT    = 54; // number of items in KEYWORDS_SEPARATORS
 KEYWORDS_NOINDEX             = -1; // unknown index in keywords list
 MIN_FILE_NAME                = 5; // minimum filename allowed to share (including directory and extension) - constant used internally. don't make it less than '5'
 KATAKANA                     = '               '+
                                '           '+
                                '          '+
                                '                    '+
                                '    ݳ  '; //SpJ^Ji̕R[hɔpJ^Jiׂf[^
 EISUUJI                      = '0123456789       ABCDEFGHIJKLMNOPQRSTUVWXYZ       '+
                                'abcdefghijklmnopqrstuvwxyz'; //Spp̕R[hɔppׂf[^
 HIRAGANA_D                   = '';//ɂȂЂ炪Ȃ2oCg
 HIRAGANA_H                   = '';//ɂȂЂ炪(ς҂Ղ؂)2oCg
 // types of items in db_ips
 IP_MASK                      = 1;
 IP_RESOLVE                   = 2;
 IP_IP                        = 3;
// internal messages for sync_reply_list
 MSG_SR_LOG                   = 1;
 MSG_SR_CONSOLELOG            = 2;
 MSG_SR_RESTART               = 3;
 MSG_SR_CONSOLEREPLY          = 4;
 // internal messages for cmd_list
 MSG_CMD_SAVEDATA             = 20001;
 MSG_CMD_LISTREGISTERED       = 20002;
 MSG_CMD_REFRESHTYPES         = 20003;
 MSG_CMD_LISTUSERS            = 20004;
 MSG_CMD_SETNAPIGATORPASS     = 20005;
 MSG_CMD_LISTSERVERS          = 20006;
 MSG_CMD_LISTCHANNELS         = 20007;
 MSG_CMD_LISTBANS             = 20008;
 MSG_CMD_LISTHOTLIST          = 20009;
 MSG_CMD_CHANNELPROPS         = 20012;
 MSG_CMD_RELOADCHMOTD         = 20013;
 MSG_CMD_WALLOP               = 20014;
 MSG_CMD_REFRESHLISTS         = 20015;
 MSG_CMD_ADDSERVER            = 20016;
 MSG_CMD_SERVERPROPS          = 20017;
 MSG_CMD_UPDATESERVERPROPS    = 20018;
 MSG_CMD_RESETLOG             = 20019;
 MSG_CMD_SETCOMPRESS          = 20020;
 MSG_CMD_SETSTARTUP           = 20021;
 MSG_CMD_MOTDCHANGE           = 20022;
 MSG_CMD_GETMODE              = 20023;
 MSG_CMD_SAVESHARED           = 20024;
 MSG_CMD_SETDAGSTAPASS        = 20025;
 // system
 MAX_RECURSE                  = 7;
 // software
 softNapster                  = 0;
 softAudioGnome               = 1;
 softWinMXNormal              = 2;
 softGnomePlus                = 3;
 softAmster                   = 4;
 softFileNavigator            = 5;
 softCQEX                     = 6;
 softSunshineUN               = 7;
 softTekNap                   = 8;
 softNap                      = 9;
 softMacNap                   = 10;
 softMP3Rage                  = 11;
 softXNap                     = 12;
 softSpotlight                = 13;
 softNFS                      = 14;
 softDMNapster                = 15;
 softKNapster                 = 16;
 softLopster                  = 17;
 softRapigator                = 18;
 softSwaptor                  = 19;
 softDagsta                   = 20;
 softFloodster                = 21;
 softDrumbeat                 = 22;
 softWinMXHidden              = 23;
 softMlDonkey                 = 24;
 softNapigator                = 25;
 softOpennap                  = 26;
 softNap08                    = 27;
 softWinMXJap                 = 28;
 softUnknown                  = 29;
 // users list items
 UL_LEVEL                     = 0;
 UL_SHARED                    = 1;
 UL_SIZE                      = 2;
 UL_AVERAGE                   = 3;
 UL_SOFT                      = 4;
 UL_SPEED                     = 5;
 UL_IP                        = 6;
 UL_PORT                      = 7;
 UL_TIME                      = 8;
 UL_UP                        = 9;
 UL_DOWN                      = 10;
 UL_TRANSFERS                 = 11;
 UL_TUP                       = 12;
 UL_TDOWN                     = 13;
 UL_TTRANSFERS                = 14;
 UL_SERVER                    = 15;
 UL_ULREQUESTS                = 16;
 UL_DLREQUESTS                = 17;
 UL_SEARCHREQS                = 18;
 UL_BLOCKFILES                = 19;
 UL_STATUS                    = 20;

MSG_SERVER_ERROR		= 0;
MSG_CLIENT_LOGIN		= 2;
MSG_SERVER_EMAIL		= 3;
MSG_CLIENT_VERSION_CHECK	= 4;
MSG_CLIENT_LOGIN_REGISTER	= 6;
MSG_CLIENT_REGISTER		= 7;
MSG_SERVER_REGISTER_OK		= 8;
MSG_SERVER_REGISTER_FAIL	= 9;
MSG_SERVER_BAD_NICK		= 10;
MSG_CLIENT_CHECK_PASS		= 11;
MSG_SERVER_PASS_OK		= 12;
MSG_SERVER_ECHO			= 13;
MSG_CLIENT_REGISTRATION_INFO	= 14;
MSG_CLIENT_REGISTRATION_NEW     = 15;
MSG_CLIENT_ADD_FILE		= 100;
MSG_CLIENT_REMOVE_FILE		= 102;
MSG_CLIENT_UNSHARE_ALL		= 110;
MSG_CLIENT_SEARCH		= 200;
MSG_SERVER_SEARCH_RESULT	= 201;
MSG_SERVER_SEARCH_END		= 202;
MSG_CLIENT_DOWNLOAD		= 203;
MSG_SERVER_FILE_READY		= 204;
MSG_CLIENT_PRIVMSG		= 205;
MSG_SERVER_PRIVMSG		= 205;
MSG_SERVER_SEND_ERROR		= 206;
MSG_CLIENT_ADD_HOTLIST		= 207;
MSG_CLIENT_ADD_HOTLIST_SEQ	= 208;
MSG_SERVER_USER_SIGNON		= 209;
MSG_SERVER_USER_SIGNOFF		= 210;
MSG_CLIENT_BROWSE		= 211;
MSG_SERVER_BROWSE_RESPONSE	= 212;
MSG_SERVER_BROWSE_END		= 213;
MSG_SERVER_STATS		= 214;
MSG_CLIENT_RESUME_REQUEST	= 215;
MSG_SERVER_RESUME_MATCH		= 216;
MSG_SERVER_RESUME_MATCH_END	= 217;
MSG_CLIENT_DOWNLOAD_START	= 218;
MSG_CLIENT_DOWNLOAD_END		= 219;
MSG_CLIENT_UPLOAD_START		= 220;
MSG_CLIENT_UPLOAD_END		= 221;
MSG_CLIENT_CHECK_PORT		= 300;
MSG_SERVER_HOTLIST_ACK		= 301;
MSG_SERVER_HOTLIST_ERROR	= 302;
MSG_CLIENT_REMOVE_HOTLIST	= 303;
MSG_SERVER_DISCONNECTING	= 316;
MSG_CLIENT_IGNORE_LIST		= 320;
MSG_SERVER_IGNORE_ENTRY		= 321;
MSG_CLIENT_IGNORE_USER		= 322;
MSG_CLIENT_UNIGNORE_USER	= 323;
MSG_SERVER_NOT_IGNORED		= 324;
MSG_SERVER_ALREADY_IGNORED	= 325;
MSG_CLIENT_CLEAR_IGNORE		= 326;
MSG_CLIENT_JOIN			= 400;
MSG_CLIENT_PART		       	= 401;
MSG_CLIENT_PUBLIC		= 402;
MSG_SERVER_PUBLIC		= 403;
MSG_SERVER_NOSUCH		= 404;
MSG_SERVER_JOIN_ACK		= 405;
MSG_SERVER_JOIN			= 406;
MSG_SERVER_PART			= 407;
MSG_SERVER_CHANNEL_USER_LIST	= 408;
MSG_SERVER_CHANNEL_USER_LIST_END        = 409;
MSG_SERVER_TOPIC		= 410;
MSG_CLIENT_CHANNEL_BAN_LIST	= 420;
MSG_SERVER_CHANNEL_BAN_LIST	= 421;
MSG_CLIENT_CHANNEL_BAN		= 422;
MSG_CLIENT_CHANNEL_UNBAN	= 423;
MSG_CLIENT_CHANNEL_CLEAR_BANS	= 424;
MSG_CLIENT_CHANNEL_INVITE       = 430;
MSG_CLIENT_CHANNEL_INVITE_ACCEPT        = 431;
MSG_CLIENT_CHANNEL_INVITE_DECLINE       = 432;
MSG_CLIENT_DOWNLOAD_FIREWALL	= 500;
MSG_SERVER_UPLOAD_FIREWALL	= 501;
MSG_CLIENT_USERSPEED		= 600;
MSG_SERVER_USER_SPEED		= 601;
MSG_CLIENT_WHOIS		= 603;
MSG_SERVER_WHOIS_RESPONSE	= 604;
MSG_SERVER_WHOWAS		= 605;
MSG_CLIENT_SETUSERLEVEL		= 606;
MSG_SERVER_UPLOAD_REQUEST	= 607;
MSG_CLIENT_UPLOAD_OK		= 608;
MSG_SERVER_UPLOAD_FAILED        = 609;
MSG_CLIENT_KILL			= 610;
MSG_CLIENT_NUKE			= 611;
MSG_CLIENT_BAN			= 612;
MSG_CLIENT_ALTER_PORT		= 613;
MSG_CLIENT_UNBAN		= 614;
MSG_CLIENT_BANLIST		= 615;
MSG_SERVER_IP_BANLIST		= 616;
MSG_CLIENT_LIST_CHANNELS	= 617;
MSG_SERVER_CHANNEL_LIST_END	= 617;
MSG_SERVER_CHANNEL_LIST		= 618;
MSG_CLIENT_LIMIT		= 619;
MSG_SERVER_LIMIT		= 620;
MSG_CLIENT_MOTD			= 621;
MSG_SERVER_MOTD			= 621;
MSG_CLIENT_MUZZLE		= 622;
MSG_CLIENT_UNMUZZLE		= 623;
MSG_CLIENT_UNNUKE		= 624;
MSG_CLIENT_ALTER_SPEED		= 625;
MSG_CLIENT_DATA_PORT_ERROR	= 626;
MSG_SERVER_DATA_PORT_ERROR	= 626;
MSG_CLIENT_WALLOP		= 627;
MSG_SERVER_WALLOP		= 627;
MSG_CLIENT_ANNOUNCE		= 628;
MSG_SERVER_ANNOUNCE		= 628;
MSG_SERVER_NICK_BANLIST		= 629;
MSG_CLIENT_BROWSE_DIRECT	= 640;
MSG_SERVER_BROWSE_DIRECT_OK	= 641;
MSG_SERVER_BROWSE_DIRECT_ERR	= 642;
MSG_CLIENT_CLOAK		= 652;
MSG_CLIENT_CHANGE_SPEED		= 700;
MSG_CLIENT_CHANGE_PASS		= 701;
MSG_CLIENT_CHANGE_EMAIL		= 702;
MSG_CLIENT_CHANGE_DATA_PORT	= 703;
MSG_SERVER_GHOST		= 748;
MSG_CLIENT_PING_SERVER		= 750;
MSG_CLIENT_PING			= 751;
MSG_SERVER_PING			= 751;
MSG_CLIENT_PONG			= 752;
MSG_SERVER_PONG			= 752;
MSG_CLIENT_ALTER_PASS		= 753;
MSG_CLIENT_SERVER_RECONFIG	= 800;
MSG_CLIENT_SERVER_VERSION	= 801;
MSG_CLIENT_SERVER_CONFIG	= 810;
MSG_CLIENT_CLEAR_CHANNEL	= 820;
MSG_CLIENT_REDIRECT		= 821;
MSG_CLIENT_CYCLE		= 822;
MSG_CLIENT_SET_CHAN_LEVEL	= 823;
MSG_CLIENT_EMOTE		= 824;
MSG_SERVER_EMOTE                = 824;
MSG_SERVER_NAMES_LIST		= 825;
MSG_CLIENT_CHANNEL_LIMIT	= 826;
MSG_CLIENT_FULL_CHANNEL_LIST	= 827;
MSG_SERVER_FULL_CHANNEL_INFO	= 828;
MSG_CLIENT_KICK			= 829;
MSG_SERVER_NAMES_LIST_END	= 830;
MSG_CLIENT_NAMES_LIST		= 830;
MSG_CLIENT_GLOBAL_USER_LIST	= 831;
MSG_SERVER_GLOBAL_USER_LIST	= 832;
MSG_CLIENT_ADD_DIRECTORY	= 870;
MSG_CLIENT_BEFORELOGIN          = 920;
MSG_SERVER_BLOCKMD5             = 931;
MSG_CLIENT_NEWSHARE             = 932;

// Supported OpenNap messages
MSG_CLIENT_OPENNAPSERVER        = 10010;
MSG_CLIENT_OPENNAPSERVERACK     = 10011;
MSG_SERVER_TIME_CHECK		= 10023;
MSG_CLIENT_CONNECT		= 10100;
MSG_CLIENT_DISCONNECT		= 10101;
MSG_CLIENT_KILL_SERVER		= 10110;
MSG_CLIENT_REMOVE_SERVER	= 10111;
MSG_CLIENT_LINKS		= 10112;
MSG_CLIENT_USAGE_STATS		= 10115; //	/* server usage stats */
MSG_CLIENT_VERSION_STATS	= 10118; //	/* client version stats */
MSG_CLIENT_WHICH_SERVER         = 10119;
MSG_CLIENT_PING_ALL_SERVERS	= 10120;
MSG_CLIENT_WHO_WAS		= 10121;
MSG_CLIENT_HISTOGRAM		= 10123;
MSG_SERVER_HISTOGRAM		= 10124;
MSG_CLIENT_REGISTER_USER        = 10200;
MSG_CLIENT_USER_MODE		= 10203; //	/* set a user mode */
MSG_SERVER_USER_MODE		= 10203;
MSG_CLIENT_OP			= 10204;
MSG_CLIENT_DEOP			= 10205;
MSG_CLIENT_DROP_CHANNEL		= 10207;
MSG_CLIENT_CHANNEL_WALLOP	= 10208;
MSG_CLIENT_CHANNEL_MODE		= 10209;
MSG_CLIENT_CHANNEL_INVITE_OPENNAP = 10210;
MSG_CLIENT_CHANNEL_VOICE	= 10211;
MSG_CLIENT_CHANNEL_UNVOICE	= 10212;
MSG_CLIENT_CHANNEL_MUZZLE	= 10213;
MSG_CLIENT_CHANNEL_UNMUZZLE	= 10214;
MSG_CLIENT_SHARE_FILE		= 10300; //	/* generic media type */

// SlavaNap messages
MSG_CLIENT_RELAY                = 8100; // relay message to another user
MSG_CLIENT_PRELAY               = 8101; // relay message to all users (except yourself) - Elite only
MSG_CLIENT_USERLIST             = 8102; // list users
MSG_CLIENT_SETVAR               = 8103; // set variable
MSG_CLIENT_RESTART              = 8104; // restart server
MSG_CLIENT_BLOCK                = 8105; // block files
MSG_CLIENT_UNBLOCK              = 8106; // unblock files
MSG_CLIENT_BLOCKLIST            = 8107; // list blocks
MSG_CLIENT_MUZZLEINV            = 8108; // invert muzzle state
MSG_CLIENT_GETCONSOLE           = 8109; // get console user name
MSG_CLIENT_CHANNEL_BANIP        = 8111; // ban user's IP in channel
MSG_CLIENT_SETTRANSFERS         = 8112; // set transfers
MSG_CLIENT_GETTRANSFERS         = 8113; // get transfers for user
MSG_CLIENT_ADDCHANNEL           = 8114; // create new registered channel
MSG_CLIENT_FRIENDS              = 8115; // add/delete/list friends
MSG_CLIENT_BANEX		        = 8116; // ban user
MSG_CLIENT_CHANGEBAN            = 8117; // change ban
MSG_CLIENT_CHANNEL_OPEMOTE      = 8118; // opemote
MSG_CLIENT_ALIAS                = 8119; // server alias list
MSG_CLIENT_GHOST                = 8120; // kill ghosting nic
MSG_CLIENT_PRIVMSG_ANON         = 8121; // send privmgs from user 'Server'
MSG_CLIENT_ALLOWEDLIST          = 8122; // show admin+ outgoing allowed connections list
MSG_CLIENT_CLIENTBLOCKS         = 8123; // show blocked clients
MSG_CLIENT_UNREGISTER           = 8124; // nuke without kill
MSG_CLIENT_SETSERVERPASSWORDS   = 8125; // set all server passwords
MSG_CLIENT_SHOWSETTING          = 8126; // show remote server variables
MSG_CLIENT_SHOWALLSETTINGS      = 8127; // show one setting on all remote servers
MSG_CLIENT_REBOOT               = 8128; // reboot server pc

// other
MSG_CLIENT_MSGSERV_READALL      = 10500; //read all messages
MSG_CLIENT_MSGSERV_READNEW      = 10501; //read new messages
MSG_CLIENT_MSGSERV_WRITE        = 10502; //leave a message
MSG_CLIENT_MSGSERV_DELETE       = 10503; //delete a message
MSG_CLIENT_MSGSERV_CLEAR        = 10504; //delete all messages

// SlavaNap server-server messages
MSG_SRV_LOGIN                   = 8000;
MSG_SRV_LOGIN_ACK               = 8001;
MSG_SRV_SETLASTINV              = 8002;
MSG_SRV_FORWARDALL              = 8003; // forward message to all linked servers
MSG_SRV_DISCONNECTED            = 8004; // remote server disconnected
MSG_SRV_CHECKPASS               = 8005; // server authentication
MSG_SRV_CHECKPASS2              = 8006; // server authentication reply
MSG_SRV_RELAY                   = 8007; // relay message to other server thru hub
MSG_SRV_SYNCCH                  = 8008; // channel sync
MSG_SRV_VOICE                   = 8009; // voice user in channel (done by server)
MSG_SRV_OP                      = 8010; // op user in channel (done by server)
MSG_SRV_SYNCSRV                 = 8011; // sync linked server
MSG_SRV_SYNCUSER                = 8012; // sync user
MSG_SRV_PUBLICSYNCUSER          = 8013; // sync user (sent to all servers)
MSG_SRV_USEROFFLINE             = 8014; // kick remote user
MSG_SRV_WALLOP                  = 8015; // do wallop
MSG_SRV_COMPRESSED              = 8016; // compressed data
MSG_SRV_UPDATEUSER              = 8017; // update user data
MSG_SRV_SEARCH_RESULT           = 8018; // remote search result
MSG_SRV_SEARCH_END              = 8019; // end remote search
MSG_SRV_SYNCREGISTERED          = 8020; // sync registered user
MSG_SRV_REMOTEBANKICK           = 8021; // kicking banned user
MSG_SRV_SERVERBAN               = 8022; // ban user
MSG_SRV_SERVERBANCLEAR          = 8023; // clear bans
MSG_SRV_SERVERBANSYNC           = 8024; // sync ban
MSG_SRV_REGISTEREDCLEAR         = 8025; // sync regisreations start
MSG_SRV_REGISTEREDSYNC          = 8026; // sync registrations
MSG_SRV_SHUTDOWN                = 8027; // server shutdown
MSG_SRV_FLOODER                 = 8028; // inform about flooder
MSG_SRV_ALIAS                   = 8029; // server alias
MSG_SRV_UPDATEBAN               = 8030; // update banfile with connection attempt info
MSG_SRV_BLOCKLISTCLEAR          = 8031; // clear blocked files list
MSG_SRV_BLOCKLISTSYNC           = 8032; // sync blocked files list
MSG_SRV_REMOTE_VAR_REQUEST      = 8033; // request value of setting for variable on remote server
MSG_SRV_REMOTE_VAR_REPLY        = 8034; // reply to 8033

implementation

end.
