{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: setupform

 Setup window

*********************************************************}
unit setupform;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, inifiles, constants, vars, stypes, Classes;

type
  TSlavaNapSetup = class(TForm)
    pages: TPageControl;
    sh1: TTabSheet;
    sh2: TTabSheet;
    Label1: TLabel;
    btn_Next: TButton;
    btn_Cancel1: TButton;
    btn_Complete: TButton;
    btn_Cancel2: TButton;
    btn_Back: TButton;
    Label3: TLabel;
    edit_ports: TEdit;
    edit_host: TEdit;
    Label4: TLabel;
    edit_admin: TEdit;
    Label5: TLabel;
    Label2: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure btn_Cancel1Click(Sender: TObject);
    procedure btn_CompleteClick(Sender: TObject);
    procedure btn_BackClick(Sender: TObject);
    procedure btn_NextClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure ShowSetup;

implementation

uses mainform;

{$R *.DFM}

procedure ShowSetup;
var
 f: TSlavaNapSetup;
begin
 f:=TSlavaNapSetup.Create(SlavaNapWindow);
 f.ShowModal;
end;

procedure TSlavaNapSetup.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 Action:=caFree;
end;

procedure TSlavaNapSetup.FormCreate(Sender: TObject);
var
 ini: TIniFile;
begin
 pages.ActivePage:=sh1;
 ini:=TIniFile.Create(ApplicationDir+'config');
 ini.WriteString('Server','Version',SLAVANAP_VERSION);
 edit_ports.Text:=ini.ReadString('Server','Ports',DEF_LISTEN_PORTS);
 edit_host.Text:=ini.ReadString('Server','ReportHost','localhost');
 edit_admin.Text:=ini.ReadString('Console','User','Admin');
 ini.Free;
end;

procedure TSlavaNapSetup.btn_NextClick(Sender: TObject);
begin
 pages.ActivePage:=sh2;
end;

procedure TSlavaNapSetup.btn_BackClick(Sender: TObject);
begin
 pages.ActivePage:=sh1;
end;

procedure TSlavaNapSetup.btn_Cancel1Click(Sender: TObject);
begin
 IsSetupFailed := True;
 DeleteFile(ApplicationDir+'config');
 Close;
end;

procedure TSlavaNapSetup.btn_CompleteClick(Sender: TObject);
var
 ini: TIniFile;
begin
 if not check_name(edit_admin.Text,true) then
 begin
   ShowMessage('ǗҖ܂');
   exit;
 end;
 ini:=TIniFile.Create(ApplicationDir+'config');
 ini.WriteString('Server','Version',SLAVANAP_VERSION);
 ini.WriteString('Server','Ports',edit_ports.Text);
 ini.WriteString('Server','ReportHost',edit_host.Text);
 ini.WriteString('Console','User',edit_admin.Text);
 ini.Free;
 IsSetupFailed := False;
 Close;
end;

end.
 