{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: slavamenu

 functions for drawing popup menus

*********************************************************}
unit slavamenu;

interface

{$I defines.pas}

uses
  Windows, SysUtils, Classes, Classes2, Forms, Graphics, Controls, Menus, stypes;

procedure SlavaDrawPopupItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
procedure SlavaMeasurePopupItem(Sender: TObject; ACanvas: TCanvas; var Width, Height: Integer);
procedure SlavaDrawMainMenu(Form: TForm; Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);


implementation

procedure SlavaDrawPopupItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
var
 i,j,k:Integer;
 r,r1:TRect;
 str:String;
 c,c1,c2,c3,bg,txt: TColor;
begin
 c:=$00FFB080;
 c1:=$00804040; // selected rect
 c2:=$00FFA060; // line
 c3:=$0040E0FF; // line selected
 if (Sender as TMenuItem).tag>0 then
 begin
   c:=$008098FF;
   c1:=$00404080; // selected rect
   c2:=$006079FF; // line
   c3:=$0026FF1C; // line selected
 end;
 try
   bg:=GetSysColor(COLOR_MENU);
   txt:=GetSysColor(COLOR_MENUTEXT);
   if Selected then txt:=clBlack;
   with ACanvas do
   begin
     if (Sender as TMenuItem).Default then
      Font.Style:=Font.Style + [fsBold]
     else
      Font.Style:=Font.Style - [fsBold];
    Brush.Color:=bg;
    if Selected then
     if (Sender as TMenuItem).Caption<>'--' then
      Brush.Color:=c;
    Font.Color:=txt;
    if not (Sender as TMenuItem).Enabled then Font.Color:=GetSysColor(COLOR_GRAYTEXT);
    if Selected then
     if (Sender as TMenuItem).Caption<>'--' then
      Font.Color:=CountColor(clBlack,c,5,1);
    r:=ARect;
    if (not Selected) or ((Sender as TMenuItem).Caption='--') then inc(r.Left,18);
    FillRect(r);
    if (not Selected) or ((Sender as TMenuItem).Caption='--') then
    begin
      Brush.Color:=CountColor(bg,c,3,1);
      r:=ARect;
      r.Right:=r.Left+17;
      FillRect(r);
      Pen.Color:=CountColor(bg,c,1,3);
      MoveTo(r.Right,r.Top);
      LineTo(r.Right,r.Bottom+1);
    end
    else
    begin
      Brush.Color:=CountColor(bg,c,1,3);
      r1:=ARect;
      r1.Right:=r1.Left+17;
      FillRect(r1);
      Pen.Color:=CountColor(bg,c,1,5);
      MoveTo(r1.Right,r1.Top);
      LineTo(r1.Right,r1.Bottom+1);
    end;
    if (Sender as TMenuItem).Caption<>'--' then
    begin
     j:=TextHeight('W');
     j:=(ARect.Bottom+ARect.Top-j) div 2;
     str:=ShortCutToText((Sender as TMenuItem).ShortCut);
     i:=TextWidth(str);
     Brush.Style:=bsClear;
     TextOut(ARect.Right-18-i,j,str);
     Brush.Style:=bsSolid;
     if (Sender as TMenuItem).Checked then
     begin
      Pen.Color:=Font.Color;
      for k:=0 to 2 do
      begin
       MoveTo(ARect.Left+5,ARect.Top+7+k);
       LineTo(ARect.Left+7,ARect.Top+9+k);
       LineTo(ARect.Left+12,ARect.Top+4+k);
      end;
     end;
     if (Sender as TMenuItem).RadioItem then
     begin
      Pen.Color:=Font.Color;
      for k:=0 to 4 do
      begin
        MoveTo(ARect.Left+7,ARect.Top+6+k);
        LineTo(ARect.Left+10,ARect.Top+6+k);
      end;
      MoveTo(ARect.Left+6,ARect.Top+7);
      LineTo(ARect.Left+6,ARect.Top+10);
      MoveTo(ARect.Left+10,ARect.Top+7);
      LineTo(ARect.Left+10,ARect.Top+10);
     end;
     if Selected then
      with ACanvas do
      begin
        Pen.Color:=c1;
        MoveTo(ARect.Left,ARect.Bottom-1);
        LineTo(ARect.Left,ARect.Top);
        LineTo(ARect.Right-1,ARect.Top);
        Pen.Color:=c1;
        LineTo(ARect.Right-1,ARect.Bottom-1);
        LineTo(ARect.Left,ARect.Bottom-1);
     end;
    end
    else
    begin
     i:=c2;
     if Selected then
      i:=c3;
     Pen.Color:=CountColor(bg,i,5,1);
     MoveTo(ARect.Left+21,ARect.Top+2);
     LineTo(ARect.Left+23,ARect.Top+2);
     Pen.Color:=CountColor(bg,i,4,2);
     LineTo(ARect.Left+25,ARect.Top+2);
     Pen.Color:=CountColor(bg,i,3,3);
     LineTo(ARect.Left+27,ARect.Top+2);
     Pen.Color:=CountColor(bg,i,2,4);
     LineTo(ARect.Left+29,ARect.Top+2);
     Pen.Color:=CountColor(bg,i,1,5);
     LineTo(ARect.Left+31,ARect.Top+2);
     Pen.Color:=i;
     LineTo(ARect.Right,ARect.Top+2);
    end;
   end;
   j:=ACanvas.TextHeight('W');
   j:=(ARect.Bottom+ARect.Top-j) div 2;
   if (Sender as TMenuItem).Caption<>'--' then
    with ACanvas do
     SlavaDrawText(ACanvas,(Sender as TMenuItem).Caption,Point(Arect.Left+22,j),Font.Color,countcolor(font.color,$00202020,1,1),countcolor(font.color,$00202020,3,2));
  except
 end;
end;

procedure SlavaMeasurePopupItem(Sender: TObject; ACanvas: TCanvas; var Width, Height: Integer);
begin
 try
   with ACanvas do
   begin
    if (Sender as TMenuItem).Caption<>'--' then
    begin
     if (Sender as TMenuItem).Default then
      Font.Style:=Font.Style + [fsBold]
     else
      Font.Style:=Font.Style - [fsBold];
     Width:=TextWidth(GetRealString((Sender as TMenuItem).Caption{+' Ctrl+F4'}))+36;
     Height:=19;
    end
    else
    begin
     Width:=20;
     Height:=5;
    end;
   end;
  except
 end;  
end;

procedure SlavaDrawMainMenu(Form: TForm; Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
var
 i,j:Integer;
 r:TRect;
 p,p1:TPoint;
 c,c1: TColor;
begin
 c:=GetSysColor(COLOR_MENU);
 try
   GetDCOrgEx(ACanvas.Handle,p);
   GetDCOrgEx(Form.Canvas.Handle,p1);
   j:=Form.ClientWidth;
   i:=p1.x-p.x+j;
   with ACanvas do
   begin
    if (Sender as TMenuItem).tag=1 then
    begin
      r:=ARect;
      Brush.Color:=c;
      r.Left:=r.Right;
      r.Right:=i;
      FillRect(r);
    end;
    if not Selected then
    begin
     Brush.Color:=c;
     Font.Color:=clWindowText;
    end
    else
    begin
     Brush.Color:=$00FFB080;
     Font.Color:=clBlack;
    end;
    r:=ARect;
    FillRect(r);
    i:=TextWidth(GetRealString((Sender as TMenuItem).Caption));
    j:=TextHeight('W');
    i:=(ARect.Right+ARect.Left-i) div 2;
    j:=(ARect.Bottom+ARect.Top-j) div 2;
   end;
   if Selected then
    c1:=clBlack
   else
    c1:=GetSysColor(COLOR_MENUTEXT);
   SlavaDrawText(ACanvas,(Sender as TMenuItem).Caption,Point(i,j),c1,c1,c1);
   if Selected then
    with ACanvas do
    begin
      Pen.Color:=$00804040;
      MoveTo(ARect.Left,ARect.Bottom-1);
      LineTo(ARect.Left,ARect.Top);
      LineTo(ARect.Right-1,ARect.Top);
      Pen.Color:=$00804040;
      LineTo(ARect.Right-1,ARect.Bottom-1);
      LineTo(ARect.Left,ARect.Bottom-1);
    end;
    with ACanvas do
    begin
     Pen.Color:=c;
     MoveTo(r.Left-1,r.Top-1);
     LineTo(r.Right,r.Top-1);
    end;
   except
  end;  
end;


end.
