{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: Settings

 Settings window

*********************************************************}
unit Settings;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, StdCtrls, IniFiles, Registry, ShellApi, Buttons, Spin,
  Classes, ActiveX, ShlObj, SlavaStrings, CheckLst, STypes, SpectrumCombo,
  BaseCombo, StringResources;

type
  TSlavaNapSettings = class(TForm)
    Panel1: TPanel;
    Panel5: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Header: TPaintBox;
    Tree: TTreeView;
    Pages: TPageControl;
    Sh_Main: TTabSheet;
    Btn_Change: TButton;
    Btn_Restore: TButton;
    Btn_Close: TButton;
    Lbl_Note: TLabel;
    Lbl_Change: TLabel;
    Label1: TLabel;
    Edit_Main_Ports: TEdit;
    Label3: TLabel;
    Edit_Main_Host: TEdit;
    Label4: TLabel;
    Sh_Users: TTabSheet;
    Cb_Users_Reg_Only: TCheckBox;
    Cb_Users_Reg_Allow: TCheckBox;
    Label5: TLabel;
    Edit_Users_Limit: TSpinEdit;
    Sh_Limits: TTabSheet;
    Label6: TLabel;
    Edit_Limits_Stats: TSpinEdit;
    Label7: TLabel;
    Label8: TLabel;
    Edit_Limits_Hotlist: TSpinEdit;
    Edit_Limits_Ignored: TSpinEdit;
    Label9: TLabel;
    Edit_Users_Clones: TSpinEdit;
    Label12: TLabel;
    Edit_Users_Logintimeout: TSpinEdit;
    Sh_interface: TTabSheet;
    Sh_Log: TTabSheet;
    Cb_Log_Login: TCheckBox;
    Cb_Log_Napigator: TCheckBox;
    Cb_Log_Search: TCheckBox;
    Cb_Log_Transfers: TCheckBox;
    Cb_Log_Users: TCheckBox;
    Cb_Log_Save: TCheckBox;
    Cb_Log_Servers: TCheckBox;
    Sh_Share: TTabSheet;
    Cb_Share_Disable: TCheckBox;
    Cb_Share_Inform: TCheckBox;
    Cb_Share_Nomodem: TCheckBox;
    Label13: TLabel;
    Label14: TLabel;
    Edit_Share_Max: TSpinEdit;
    Edit_Share_MaxTotal: TSpinEdit;
    Label15: TLabel;
    Label16: TLabel;
    Edit_Share_FileName: TSpinEdit;
    Edit_Share_Duration: TSpinEdit;
    Sh_Share_Mp3: TTabSheet;
    Label17: TLabel;
    Edit_Mp3_Ext: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Edit_Mp3_Max: TSpinEdit;
    Edit_Mp3_MaxSize: TSpinEdit;
    Edit_Mp3_MinSize: TSpinEdit;
    Sh_Share_Audio: TTabSheet;
    Label21: TLabel;
    Edit_Audio_Ext: TEdit;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Edit_Audio_MaxSize: TSpinEdit;
    Edit_Audio_MinSize: TSpinEdit;
    Edit_Audio_Max: TSpinEdit;
    Sh_Share_Video: TTabSheet;
    Label25: TLabel;
    Edit_Video_Ext: TEdit;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Edit_Video_MaxSize: TSpinEdit;
    Edit_Video_MinSize: TSpinEdit;
    Edit_Video_Max: TSpinEdit;
    Sh_Share_Images: TTabSheet;
    Label29: TLabel;
    Edit_Images_Ext: TEdit;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Edit_Images_MaxSize: TSpinEdit;
    Edit_Images_MinSize: TSpinEdit;
    Edit_Images_Max: TSpinEdit;
    Sh_Share_Apps: TTabSheet;
    Label33: TLabel;
    Edit_Apps_Ext: TEdit;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Edit_Apps_MaxSize: TSpinEdit;
    Edit_Apps_MinSize: TSpinEdit;
    Edit_Apps_Max: TSpinEdit;
    Sh_Share_Cd: TTabSheet;
    Label37: TLabel;
    Edit_Cd_Ext: TEdit;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Edit_Cd_MaxSize: TSpinEdit;
    Edit_Cd_MinSize: TSpinEdit;
    Edit_Cd_Max: TSpinEdit;
    Sh_Share_Text: TTabSheet;
    Label41: TLabel;
    Edit_Text_Ext: TEdit;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    Edit_Text_MaxSize: TSpinEdit;
    Edit_Text_MinSize: TSpinEdit;
    Edit_Text_Max: TSpinEdit;
    Label45: TLabel;
    Cb_Mp3_320: TCheckBox;
    Cb_Mp3_256: TCheckBox;
    Cb_Mp3_224: TCheckBox;
    Cb_Mp3_192: TCheckBox;
    Cb_Mp3_160: TCheckBox;
    Cb_Mp3_128: TCheckBox;
    Cb_Mp3_112: TCheckBox;
    Cb_Mp3_96: TCheckBox;
    Cb_Mp3_80: TCheckBox;
    Cb_Mp3_64: TCheckBox;
    Cb_Mp3_56: TCheckBox;
    Cb_Mp3_48: TCheckBox;
    Cb_Mp3_40: TCheckBox;
    Cb_Mp3_32: TCheckBox;
    Cb_Mp3_24: TCheckBox;
    Cb_Mp3_0: TCheckBox;
    Label46: TLabel;
    Sh_Napigator: TTabSheet;
    Sh_Search: TTabSheet;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    Edit_Search_DefSearch: TSpinEdit;
    Edit_Search_MaxSearch: TSpinEdit;
    Edit_Search_MaxBrowse: TSpinEdit;
    Edit_Search_Searchespm: TSpinEdit;
    Sh_Levels: TTabSheet;
    Sh_Channels: TTabSheet;
    Cb_Channels_Allowcreate: TCheckBox;
    Label52: TLabel;
    Label53: TLabel;
    Edit_Channels_Max: TSpinEdit;
    Edit_Channels_Max2: TSpinEdit;
    Cb_Channels_Blockcqex: TCheckBox;
    Cb_Interface_Startup: TCheckBox;
    Label54: TLabel;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    Edit_Level_0: TEdit;
    Edit_Level_1: TEdit;
    Edit_Level_2: TEdit;
    Edit_Level_3: TEdit;
    Edit_Level_4: TEdit;
    Btn_Level_default: TButton;
    Label61: TLabel;
    Label62: TLabel;
    Label63: TLabel;
    Label64: TLabel;
    Label65: TLabel;
    Edit_Napigator_Host: TEdit;
    Edit_Napigator_Port: TSpinEdit;
    Edit_Napigator_User: TEdit;
    Btn_Napigator_Password: TButton;
    Cb_Napigator_Enabled: TCheckBox;
    Btn_Napigator_Disconnect: TButton;
    Label66: TLabel;
    Label67: TLabel;
    Edit_Main_ListenIp: TEdit;
    Cb_Log_Serverstats: TCheckBox;
    Sh_Console: TTabSheet;
    Sh_Blocked: TTabSheet;
    Label68: TLabel;
    Cb_Block_Napster: TCheckBox;
    Cb_Block_Audiognome: TCheckBox;
    Cb_Block_Gnomeplus: TCheckBox;
    Cb_Block_Amster: TCheckBox;
    Cb_Block_Filenavigator: TCheckBox;
    Cb_Block_Cqex: TCheckBox;
    Cb_Block_Sunshineun: TCheckBox;
    Cb_Block_Teknap: TCheckBox;
    Cb_Block_Nap: TCheckBox;
    Cb_Block_Macnap: TCheckBox;
    Cb_Block_Mp3rage: TCheckBox;
    Cb_Block_Xnap: TCheckBox;
    Cb_Block_Spotlight: TCheckBox;
    Cb_Block_Nfs: TCheckBox;
    Cb_Block_Dmnapster: TCheckBox;
    Cb_Block_Knapster: TCheckBox;
    Cb_Block_Lopster: TCheckBox;
    Cb_Block_Rapigator: TCheckBox;
    Cb_Block_Swaptor: TCheckBox;
    Cb_Block_Other: TCheckBox;
    Label69: TLabel;
    Label70: TLabel;
    Edit_Console_User: TEdit;
    Edit_Console_Speed: TComboBox;
    Label71: TLabel;
    Label72: TLabel;
    Edit_Search_MaxRemoteBrowse: TSpinEdit;
    Cb_Log_Clearserverstats: TCheckBox;
    Cb_Log_Clearclientstats: TCheckBox;
    Panel_Block_Other: TPanel;
    Label74: TLabel;
    Edit_Block_Sign0: TEdit;
    Edit_Block_Sign1: TEdit;
    Edit_Block_Sign2: TEdit;
    Label75: TLabel;
    Label76: TLabel;
    Edit_Main_Handle: TSpinEdit;
    Lbl_Handle: TLabel;
    Sh_Links: TTabSheet;
    Panel6: TPanel;
    Cb_Link_All: TRadioButton;
    Cb_Link_List: TRadioButton;
    Cb_Link_None: TRadioButton;
    Label77: TLabel;
    Edit_Interface_Cpu: TSpinEdit;
    Label78: TLabel;
    Cb_Search_Disable_Remote: TCheckBox;
    Edit_Search_MaxRemote: TSpinEdit;
    Lbl_Search_MaxRemote: TLabel;
    Cb_Channels_Oldwallop: TCheckBox;
    Label79: TLabel;
    Edit_Users_MaxAccept: TSpinEdit;
    Cb_Interface_Noswitch: TCheckBox;
    Cb_Block_Dagsta: TCheckBox;
    Cb_Users_NoRemote: TCheckBox;
    Sh_Sockets: TTabSheet;
    Cb_Sockets_Users_Def: TCheckBox;
    Edit_Sockets_Users_Send: TSpinEdit;
    Edit_Sockets_Users_Recv: TSpinEdit;
    Cb_Sockets_Servers_Def: TCheckBox;
    Edit_Sockets_Servers_Send: TSpinEdit;
    Edit_Sockets_Servers_Recv: TSpinEdit;
    Lbl_Sockets_Users_Send: TLabel;
    Lbl_Sockets_Users_Recv: TLabel;
    Lbl_Sockets_Servers_Send: TLabel;
    Lbl_Sockets_Servers_Recv: TLabel;
    Label81: TLabel;
    Label82: TLabel;
    Label83: TLabel;
    Edit_Channels_MaxMessage: TSpinEdit;
    Edit_Channels_MaxPrivMessage: TSpinEdit;
    Sh_Report: TTabSheet;
    Sh_Other: TTabSheet;
    Label84: TLabel;
    GroupBox4: TGroupBox;
    Label85: TLabel;
    Cb_Ann_Enable: TCheckBox;
    Label86: TLabel;
    Edit_Ann_Delay: TSpinEdit;
    Edit_Ann_messAges: TMemo;
    Label87: TLabel;
    Label88: TLabel;
    Edit_Ann_User: TEdit;
    GroupBox2: TGroupBox;
    Cb_Report_Old_Enable: TCheckBox;
    Label89: TLabel;
    Edit_Report_Old_Port: TSpinEdit;
    GroupBox3: TGroupBox;
    Cb_Report_New_Enabled: TCheckBox;
    Edit_Report_New_Port: TSpinEdit;
    Cb_Report_New_Hidehub: TCheckBox;
    Label90: TLabel;
    Sh_MinShare: TTabSheet;
    Label91: TLabel;
    Edit_MinShare_MinShare: TSpinEdit;
    Label92: TLabel;
    Label93: TLabel;
    Edit_MinShare_Delay: TSpinEdit;
    Label94: TLabel;
    Cb_MinShare_Ban: TCheckBox;
    Edit_MinShare_Bantime: TSpinEdit;
    Label95: TLabel;
    Edit_MinShare_MinSharesize: TSpinEdit;
    Cb_MinShare_Onlyfull: TCheckBox;
    Cb_MinShare_Banip: TCheckBox;
    Cb_MinShare_Full10: TCheckBox;
    Label73: TLabel;
    Edit_Napigator_Myip: TEdit;
    Cb_Channels_Showops: TCheckBox;
    Sh_Motd: TTabSheet;
    Label96: TLabel;
    Edit_Motd: TMemo;
    Cb_MinShare_Kickchat: TCheckBox;
    Cb_Napigator_Autodisconnect: TCheckBox;
    Label97: TLabel;
    Cb_Link_Hub: TCheckBox;
    Label98: TLabel;
    Cb_MinShare_Wallop: TCheckBox;
    Cb_Block_Floodster: TCheckBox;
    Cb_Users_Redirectcqex: TCheckBox;
    Cb_Link_Syncreg: TCheckBox;
    Cb_Channels_Timestamp: TCheckBox;
    Cb_Channels_Low: TCheckBox;
    Cb_Link_Noautoconnect: TCheckBox;
    Label99: TLabel;
    Label100: TLabel;
    Edit_Limits_MaxDown: TSpinEdit;
    Edit_Limits_MaxUp: TSpinEdit;
    Cb_Limits_Limitservers: TCheckBox;
    Cb_Block_Drumbeat: TCheckBox;
    Label101: TLabel;
    Edit_Share_MaxIndex: TSpinEdit;
    Cb_Channels_Preventshout: TCheckBox;
    Cb_Interface_Chatflash: TCheckBox;
    Edit_Channels_Flood_User: TSpinEdit;
    Edit_Channels_Flood_Same: TSpinEdit;
    Cb_Channels_Flood_Warn: TCheckBox;
    Lbl_Flood1: TLabel;
    Lbl_Flood2: TLabel;
    Sh_Colors: TTabSheet;
    Edit_Color_Bg: TksoSpectrumComboBox;
    Label104: TLabel;
    Label105: TLabel;
    Edit_Color_Text: TksoSpectrumComboBox;
    Label106: TLabel;
    Label107: TLabel;
    Label108: TLabel;
    Label109: TLabel;
    Label110: TLabel;
    Label111: TLabel;
    Label112: TLabel;
    Label113: TLabel;
    Edit_Color_Chat: TksoSpectrumComboBox;
    Edit_Color_Mychat: TksoSpectrumComboBox;
    Edit_Color_Channelchat: TksoSpectrumComboBox;
    Edit_Color_Mychannelchat: TksoSpectrumComboBox;
    Edit_Color_Emote: TksoSpectrumComboBox;
    Edit_Color_Myemote: TksoSpectrumComboBox;
    Edit_Color_Join: TksoSpectrumComboBox;
    Edit_Color_Part: TksoSpectrumComboBox;
    Label114: TLabel;
    Edit_Color_Topic: TksoSpectrumComboBox;
    Label115: TLabel;
    Label116: TLabel;
    Label117: TLabel;
    Label118: TLabel;
    Label119: TLabel;
    Label120: TLabel;
    Label121: TLabel;
    Label122: TLabel;
    Label123: TLabel;
    Label124: TLabel;
    Label125: TLabel;
    Edit_Color_Debug: TksoSpectrumComboBox;
    Edit_Color_Error: TksoSpectrumComboBox;
    Edit_Color_Wallop: TksoSpectrumComboBox;
    Edit_Color_Announce: TksoSpectrumComboBox;
    Edit_Color_Online: TksoSpectrumComboBox;
    Edit_Color_Offline: TksoSpectrumComboBox;
    Edit_Color_Search: TksoSpectrumComboBox;
    Edit_Color_Transfer: TksoSpectrumComboBox;
    Edit_Color_Napigator: TksoSpectrumComboBox;
    Edit_Color_Pong: TksoSpectrumComboBox;
    Edit_Color_Whowas: TksoSpectrumComboBox;
    Btn_Colors_default: TButton;
    Cd: TColorDialog;
    Btn_Color_Ch1: TSpeedButton;
    Btn_Color_Ch2: TSpeedButton;
    Btn_Color_Ch3: TSpeedButton;
    Btn_Color_Ch4: TSpeedButton;
    Btn_Color_Ch5: TSpeedButton;
    Btn_Color_Ch6: TSpeedButton;
    Btn_Color_Ch7: TSpeedButton;
    Btn_Color_Ch8: TSpeedButton;
    Btn_Color_Ch9: TSpeedButton;
    Btn_Color_Ch10: TSpeedButton;
    Btn_Color_Ch11: TSpeedButton;
    Btn_Color_Ch12: TSpeedButton;
    Btn_Color_Ch13: TSpeedButton;
    Btn_Color_Ch14: TSpeedButton;
    Btn_Color_Ch15: TSpeedButton;
    Btn_Color_Ch16: TSpeedButton;
    Btn_Color_Ch17: TSpeedButton;
    Btn_Color_Ch18: TSpeedButton;
    Btn_Color_Ch19: TSpeedButton;
    Btn_Color_Ch20: TSpeedButton;
    Btn_Color_Ch21: TSpeedButton;
    Btn_Color_Ch22: TSpeedButton;
    Label10: TLabel;
    Edit_Limits_Memory: TSpinEdit;
    Label11: TLabel;
    Label2: TLabel;
    Edit_Users_BanMail: TEdit;
    Edit_Napigator_Delay: TSpinEdit;
    Label126: TLabel;
    Edit_Block_Sign3: TEdit;
    Edit_Block_Sign4: TEdit;
    Edit_Block_Sign5: TEdit;
    Panel_Block_Message: TPanel;
    Lbl_Block_Message: TLabel;
    Edit_Block_Message: TEdit;
    Cb_Block_Custommessage: TRadioButton;
    Cb_Block_Defaultmessage: TRadioButton;
    Cb_Block_Nomessage: TRadioButton;
    Cb_Link_Syncban: TCheckBox;
    Label127: TLabel;
    Edit_Main_Remoteadmin: TEdit;
    Cb_Link_List2: TRadioButton;
    Edit_Link_List: TEdit;
    Sh_Links2: TTabSheet;
    Label80: TLabel;
    Cb_Link2_LagNoSearch: TCheckBox;
    Cb_Link2_LagNoSearchReq: TCheckBox;
    Cb_Link2_Lagnobrowse: TCheckBox;
    Cb_Link2_Lagnobrowsereq: TCheckBox;
    Edit_Link_Outgoinglist: TEdit;
    Cb_Link_RestrictOutgoing: TCheckBox;
    Label128: TLabel;
    Edit_Users_Redirecturl: TEdit;
    Cb_Interface_SysTray: TCheckBox;
    Cb_Users_Reconnect: TCheckBox;
    Cb_Channels_Floodenable: TCheckBox;
    Label102: TLabel;
    Edit_Level_5: TEdit;
    Cb_Interface_Chatmini: TCheckBox;
    Cb_Interface_Wallop: TCheckBox;
    Cb_Log_Console: TCheckBox;
    Cb_Log_Dagsta: TCheckBox;
    Sh_Dagsta: TTabSheet;
    Label103: TLabel;
    Edit_Dagsta_Host: TEdit;
    Edit_Dagsta_Port: TSpinEdit;
    Edit_Dagsta_User: TEdit;
    Btn_Dagsta_Password: TButton;
    Label129: TLabel;
    Label130: TLabel;
    Label131: TLabel;
    Label132: TLabel;
    Label133: TLabel;
    Edit_Dagsta_Myip: TEdit;
    Edit_Dagsta_Delay: TSpinEdit;
    Label134: TLabel;
    Cb_Dagsta_Enabled: TCheckBox;
    Btn_Dagsta_Disconnect: TButton;
    Cb_Dagsta_Autodisconnect: TCheckBox;
    Label135: TLabel;
    Label136: TLabel;
    Edit_Color_Dagsta: TksoSpectrumComboBox;
    Edit_Color_Ch23: TSpeedButton;
    Label137: TLabel;
    Edit_Color_Browse: TksoSpectrumComboBox;
    Btn_Color_Ch24: TSpeedButton;
    Label51: TLabel;
    Cb_Share_Checkdup: TCheckBox;
    Cb_Interface_Nocpu: TCheckBox;
    Edit_Main_Alias: TEdit;
    Label138: TLabel;
    Cb_Meta_Enabled: TCheckBox;
    Label139: TLabel;
    Label141: TLabel;
    Edit_Meta_Port: TSpinEdit;
    Sh_Blocked_Winmx: TTabSheet;
    Label140: TLabel;
    Cb_Blockmx_Normal: TCheckBox;
    Cb_Blockmx_Limit: TCheckBox;
    Cb_Blockmx_Detect: TCheckBox;
    Edit_Blockmx_Quota: TSpinEdit;
    Lbl_Blockmx_Percentage: TLabel;
    Label142: TLabel;
    Edit_Blockmx_Bantime: TSpinEdit;
    Label143: TLabel;
    Cb_Log_Browse: TCheckBox;
    List_Napigator_MyPort: TComboBox;
    List_Dagsta_MyPort: TComboBox;
    Cb_Block_Mldonkey: TCheckBox;
    Cb_Block_Napigator: TCheckBox;
    Cb_Block_Nap08: TCheckBox;
    Cb_Block_Opennap: TCheckBox;
    Cb_Blockmx_Jap: TCheckBox;
    Cb_Blockmx_Pong: TCheckBox;
    Sh_Blocks: TTabSheet;
    Cb_Blocks_Allow_Share: TCheckBox;
    Cb_Blocks_Allow_Share_Admins: TCheckBox;
    Cb_Blocks_CheckMods: TCheckBox;
    Label144: TLabel;
    Edit_Cons_Autojoin1: TEdit;
    Label145: TLabel;
    Label146: TLabel;
    Edit_Cons_Autojoin2: TEdit;
    Edit_Cons_Autojoin3: TEdit;
    Label147: TLabel;
    Cb_Link_SyncBlock: TCheckBox;
    Label148: TLabel;
    Cb_Report_Truestats: TCheckBox;
    Cb_Share_FriendAdd: TCheckBox;
    Edit_Share_FriendAdd: TSpinEdit;
    Label149: TLabel;
    Label150: TLabel;
    Cb_Link_MaxServers: TCheckBox;
    Edit_Link_MaxServers: TSpinEdit;
    Label151: TLabel;
    Cb_Interface_Wallopsound: TCheckBox;
    Cb_Interface_Remoteadminok: TCheckBox;
    Label152: TLabel;
    Edit_Interface_Remotepass: TEdit;
    Cb_Blockmx_Ban: TCheckBox;
    Sh_Other2: TTabSheet;
    Gb_SearchBlock: TGroupBox;
    Cb_SearchBlock_ChkFiles: TCheckBox;
    Cb_SearchBlock_ChkSize: TCheckBox;
    Rd_SearchBlock_Hard: TRadioButton;
    Rd_SearchBlock_Normal: TRadioButton;
    Edit_SearchBlock_Files: TSpinEdit;
    Edit_SearchBlock_Size: TSpinEdit;
    Gb_DomBlock: TGroupBox;
    Cb_DomBlock_ChkFiles: TCheckBox;
    Cb_DomBlock_ChkSize: TCheckBox;
    Rd_DomBlock_Hard: TRadioButton;
    Rd_DomBlock_Normal: TRadioButton;
    Edit_DomBlock_Files: TSpinEdit;
    Edit_DomBlock_Size: TSpinEdit;
    Label153: TLabel;
    Label154: TLabel;
    Gb_DLFloodBlock: TGroupBox;
    Rd_DLFloodBlock_Block: TRadioButton;
    Rd_DLFloodBlock_Leech: TRadioButton;
    Rd_DLFloodBlock_Ban: TRadioButton;
    Edit_DLFloodBlock: TSpinEdit;
    Edit_DLFloodBlock_Bantime: TComboBox;
    Gb_WQFloodBlock: TGroupBox;
    Rd_WQFloodBlock_Block: TRadioButton;
    Rd_WQFloodBlock_Leech: TRadioButton;
    Rd_WQFloodBlock_Ban: TRadioButton;
    Edit_WQFloodBlock: TSpinEdit;
    Edit_WQFloodBlock_Bantime: TComboBox;
    Cb_Nocount_Text: TCheckBox;
    Cb_Autoban_Incomplete: TCheckBox;
    Cb_Disable_Fakeext: TCheckBox;
    Edit_Fakeext: TEdit;
    Cb_Enable_TrapPort: TCheckBox;
    Edit_TrapPort: TEdit;
    Cb_Block_TransferPort: TCheckBox;
    Edit_Blocked_TransferPort: TEdit;
    Cb_Share_MatchedFile_Only: TCheckBox;
    Sh_Other3: TTabSheet;
    GroupBox1: TGroupBox;
    Cb_Enable_LoginIM: TCheckBox;
    Label155: TLabel;
    Edit_LoginIMBot: TEdit;
    Edit_LoginIM: TMemo;
    Cb_Channels_Forceenter: TCheckBox;
    Edit_Channels_Forceenter: TEdit;
    Label156: TLabel;
    Cb_Allow_2ByteName: TCheckBox;
    Cb_Check_Loginpass: TCheckBox;
    Edit_Loginpass: TEdit;
    Label157: TLabel;
    Cb_Enable_Msgserv: TCheckBox;
    Cb_Restrict_Hitperuser: TCheckBox;
    Edit_Hitperuser: TSpinEdit;
    Label158: TLabel;
    Rd_Xbutton_Attr: TRadioGroup;
    Label160: TLabel;
    Cb_MinShare_NoBlockAct: TCheckBox;
    Sh_Other4: TTabSheet;
    Cb_Block_Napchan: TCheckBox;
    Cb_Block_Utatane: TCheckBox;
    Cb_Block_2get: TCheckBox;
    Cb_Kill_Idleuser: TCheckBox;
    Cb_Deny_Listall_for_Users: TCheckBox;
    Cb_Block_Weird_XnapFile: TCheckBox;
    Edit_Kill_Idleuser_Time: TSpinEdit;
    Label161: TLabel;
    Label162: TLabel;
    Cb_Suggest_DBrowse: TCheckBox;
    Edit_Log_Folder: TEdit;
    Btn_Log_Folder: TButton;
    Label163: TLabel;
    Label164: TLabel;
    Cb_Block_Regnessem: TCheckBox;
    Label165: TLabel;
    Edit_Max_Resolving_Count: TSpinEdit;
    Cb_Refresh_Servers: TCheckBox;
    Edit_Servreftime: TSpinEdit;
    Label159: TLabel;
    Cb_Refresh_Users: TCheckBox;
    Edit_Usersreftime: TSpinEdit;
    Label166: TLabel;
    Cb_Allow_Rtf_Code: TCheckBox;
    Panel4: TPanel;
    Cb_Enable_Metaserver: TCheckBox;
    Edit_Redirected_List: TCheckListBox;
    Edit_MetaPort: TEdit;
    Label167: TLabel;
    Label168: TLabel;
    Btn_Add_Redirected_Server: TButton;
    Btn_Delete_Redirected_Server: TButton;
    Label169: TLabel;
    Edit_Redirected_Server: TEdit;
    Cb_Disable_Nullip: TCheckBox;
    procedure Panel3Resize(Sender: TObject);
    procedure HeaderPaint(Sender: TObject);
    procedure SetTopText(Str: string);
    procedure Btn_CloseClick(Sender: TObject);
    procedure Btn_RestoreClick(Sender: TObject);
    procedure SetChange(Change: Boolean);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure TreeChange(Sender: TObject; Node: TTreeNode);
    procedure Sh_MainShow(Sender: TObject);
    procedure Sh_UsersShow(Sender: TObject);
    procedure Cb_Users_Reg_OnlyClick(Sender: TObject);
    procedure Sh_LimitsShow(Sender: TObject);
    procedure Sh_InterfaceShow(Sender: TObject);
    procedure Sh_LogShow(Sender: TObject);
    procedure Cb_Log_SaveClick(Sender: TObject);
    procedure Sh_ShareShow(Sender: TObject);
    procedure Sh_Share_Mp3Show(Sender: TObject);
    procedure Sh_Share_AudioShow(Sender: TObject);
    procedure Sh_Share_VideoShow(Sender: TObject);
    procedure Sh_Share_ImagesShow(Sender: TObject);
    procedure Sh_Share_AppsShow(Sender: TObject);
    procedure Sh_Share_CdShow(Sender: TObject);
    procedure Sh_Share_TextShow(Sender: TObject);
    procedure Sh_NapigatorShow(Sender: TObject);
    procedure Sh_SearchShow(Sender: TObject);
    procedure Sh_LevelsShow(Sender: TObject);
    procedure Btn_ChangeClick(Sender: TObject);
    procedure Sh_ChannelsShow(Sender: TObject);
    procedure Btn_Level_DefaultClick(Sender: TObject);
    procedure Btn_Napigator_DisconnectClick(Sender: TObject);
    procedure Btn_Napigator_PasswordClick(Sender: TObject);
    procedure Sh_ConsoleShow(Sender: TObject);
    procedure Sh_BlockedShow(Sender: TObject);
    procedure Cb_Log_ServerstatsClick(Sender: TObject);
    procedure Cb_Block_CustommessageClick(Sender: TObject);
    procedure Sh_LinksShow(Sender: TObject);
    procedure Cb_Search_Disable_RemoteClick(Sender: TObject);
    procedure Sh_SocketsShow(Sender: TObject);
    procedure Cb_Sockets_Users_DefClick(Sender: TObject);
    procedure Cb_Sockets_Servers_DefClick(Sender: TObject);
    procedure Sh_ReportShow(Sender: TObject);
    procedure Sh_OtherShow(Sender: TObject);
    procedure Sh_MinShareShow(Sender: TObject);
    procedure Cb_MinShare_OnlyfullClick(Sender: TObject);
    procedure Sh_MotdShow(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Sh_ColorsShow(Sender: TObject);
    procedure Btn_Colors_DefaultClick(Sender: TObject);
    procedure Btn_Color_ChClick(Sender: TObject);
    procedure Sh_Links2Show(Sender: TObject);
    procedure Cb_Channels_FloodenableClick(Sender: TObject);
    procedure Sh_DagstaShow(Sender: TObject);
    procedure Btn_Dagsta_DisconnectClick(Sender: TObject);
    procedure Label137Click(Sender: TObject);
    procedure Cb_Blockmx_LimitClick(Sender: TObject);
    procedure Sh_Blocked_WinmxShow(Sender: TObject);
    procedure Edit_Main_AliasChange(Sender: TObject);
    procedure Sh_BlocksShow(Sender: TObject);
    procedure Cb_Share_FriendAddClick(Sender: TObject);
    procedure Cb_Link_MaxServersClick(Sender: TObject);
    procedure Cb_Interface_RemoteadminokClick(Sender: TObject);
    procedure Cb_Blockmx_DetectClick(Sender: TObject);
    procedure Cb_Blockmx_BanClick(Sender: TObject);
    procedure Sh_Other2Show(Sender: TObject);
    procedure Cb_SearchBlock_ChkFilesClick(Sender: TObject);
    procedure Cb_SearchBlock_ChkSizeClick(Sender: TObject);
    procedure Cb_DomBlock_ChkFilesClick(Sender: TObject);
    procedure Cb_DomBlock_ChkSizeClick(Sender: TObject);
    procedure Rd_DLFloodBlock_BanClick(Sender: TObject);
    procedure Rd_DLFloodBlock_BlockClick(Sender: TObject);
    procedure Rd_DLFloodBlock_LeechClick(Sender: TObject);
    procedure Rd_WQFloodBlock_BanClick(Sender: TObject);
    procedure Rd_WQFloodBlock_BlockClick(Sender: TObject);
    procedure Rd_WQFloodBlock_LeechClick(Sender: TObject);
    procedure Cb_Disable_FakeextClick(Sender: TObject);
    procedure Cb_Enable_TrapPortClick(Sender: TObject);
    procedure Cb_Block_TransferPortClick(Sender: TObject);
    procedure Sh_Other3Show(Sender: TObject);
    procedure Cb_Channels_ForceenterClick(Sender: TObject);
    procedure Cb_Check_LoginpassClick(Sender: TObject);
    procedure Cb_Restrict_HitperuserClick(Sender: TObject);
    procedure Cb_Refresh_ServersClick(Sender: TObject);
    procedure Cb_MinShare_BanClick(Sender: TObject);
    procedure Sh_Other4Show(Sender: TObject);
    procedure Cb_Kill_IdleuserClick(Sender: TObject);
    procedure Btn_Log_FolderClick(Sender: TObject);
    procedure Cb_Refresh_UsersClick(Sender: TObject);
    procedure Cb_Enable_MetaserverClick(Sender: TObject);
    procedure Btn_Add_Redirected_ServerClick(Sender: TObject);
    procedure Btn_Delete_Redirected_ServerClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    procedure SetBanItems(Control: TComboBox);
    function GetBanID(Control: TComboBox): Integer;
    function GetBanIndex(T: Integer): Integer;
    procedure CMShowingChanged(var Msg: TMessage); Message CM_SHOWINGCHANGED;
  public
    { Public Declarations }
    Top_Text: string;
    procedure ChangeColors;
    procedure ChangeInterface(LoadMode: ConfigLoadMode = lmAll);
  end;

function BrowseCallbackProc(hWnd: HWND; uMsg: UINT;
  lParam, lpData: lParam): Integer stdcall;

var
  SlavaNapSettings: TSlavaNapSettings;
  BrowseInfo: TBrowseInfo;
  Ini: TMemIniFile;

implementation

uses
  Vars, Constants, MainForm, Bans, Handler, Lang, Users, EditDialog,
  Servers, Channels, WinSock, BlckSock, Memory_Manager, Languages;

{$R *.DFM}

const
  DATA_MAIN = Pointer(1);
  DATA_SOCKETS = Pointer(2);
  DATA_USERS = Pointer(3);
  DATA_LIMITS = Pointer(4);
  DATA_SEARCH = Pointer(5);
  DATA_CHANNELS = Pointer(6);
  DATA_LINKS = Pointer(7);
  DATA_NAPIGATOR = Pointer(8);
  DATA_LEVELS = Pointer(9);
  DATA_BLOCKED = Pointer(10);
  DATA_MOTD = Pointer(11);
  DATA_INTERFACE = Pointer(12);
  DATA_CONSOLE = Pointer(13);
  DATA_LOG = Pointer(14);
  DATA_SHARE = Pointer(15);
  DATA_SHARE_MP3 = Pointer(16);
  DATA_SHARE_AUDIO = Pointer(17);
  DATA_SHARE_VIDEO = Pointer(18);
  DATA_SHARE_IMAGES = Pointer(19);
  DATA_SHARE_APP = Pointer(20);
  DATA_SHARE_CD = Pointer(21);
  DATA_SHARE_TEXT = Pointer(22);
  DATA_SHARE_MINSHARE = Pointer(23);
  DATA_OTHER = Pointer(24);
  DATA_REPORT = Pointer(25);
  DATA_COLORS = Pointer(26);
  DATA_LINKS2 = Pointer(27);
  DATA_DAGSTA = Pointer(28);
  DATA_BLOCKEDMX = Pointer(29);
  DATA_BLOCKS = Pointer(30);
  DATA_OTHER2 = Pointer(31);
  DATA_OTHER3 = Pointer(32);
  DATA_OTHER4 = Pointer(33);

procedure TSlavaNapSettings.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.ExStyle := Params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapSettings.Panel3Resize(Sender: TObject);
begin
  Header.Width := Panel3.Width - 16;
end;

procedure TSlavaNapSettings.HeaderPaint(Sender: TObject);
var
  B, B1: TBitmap;
  I, J, W, H, X: Integer;
  C, C1, C2: TColor;
  R: TRect;
begin
  try
    W := Header.Width;
    H := Header.Height;
    R := Rect(0, 0, W, H);
    B := CreateTBitmap;
    B1 := CreateTBitmap;
    try
      B.Width := W;
      B.Height := H;
      B1.Width := W;
      B1.Height := H;
      STypes.GradientFill(B.Canvas.Handle, R, $00C04B94, clBtnFace, 128, False);
      B.Canvas.Pen.Color := clBtnFace;
      B.Canvas.MoveTo(0, 0);
      B.Canvas.LineTo(W - 1, 0);
      B.Canvas.MoveTo(W - 1, H - 1);
      B.Canvas.LineTo(0, H - 1);
      B.Canvas.LineTo(0, H - 2);
      B.Canvas.Pen.Color := CountColor(B.Canvas.Pixels[1, 0], $00C04B94, 1, 1);
      B.Canvas.LineTo(0, 0);
      B.Canvas.Font.Assign(Header.Font);
      B.Canvas.Brush.Style := bsClear;
      B.Canvas.Font.Color := CountColor($00C04B94, clBlack, 1, 1);
      B.Canvas.TextOut(11, 5, Top_Text);
      B1.Canvas.CopyRect(R, B.Canvas, R);
      X := B.Canvas.TextWidth(Top_Text) + 15;
      for I := 2 to X do // Blur (My own, not gaussian)  ;-)
        for J := 2 to H - 3 do
        begin
          C := B1.Canvas.Pixels[I, J];
          C1 := CountColor(B1.Canvas.Pixels[I + 1, J], B1.Canvas.Pixels[I - 1,
            J], 1, 1);
          C2 := CountColor(B1.Canvas.Pixels[I, J + 1], B1.Canvas.Pixels[I, J -
            1], 1, 1);
          C1 := CountColor(C1, C2, 1, 1);
          B.Canvas.Pixels[I, J] := CountColor(C, C1, 1, 4);
        end;
      // Blur borders
      for I := 1 to W - 2 do
      begin
        // Top
        C := B1.Canvas.Pixels[I, 0];
        C1 := CountColor(B1.Canvas.Pixels[I + 1, 1], B1.Canvas.Pixels[I - 1, 1],
          1, 1);
        C2 := CountColor(B1.Canvas.Pixels[I, 2], B1.Canvas.Pixels[I, 0], 1, 1);
        C1 := CountColor(C1, C2, 1, 1);
        B.Canvas.Pixels[I, 1] := CountColor(C, C1, 1, 4);
        // Bottom
        C := B1.Canvas.Pixels[I, H - 1];
        C1 := CountColor(B1.Canvas.Pixels[I + 1, H - 2], B1.Canvas.Pixels[I - 1,
          H - 2], 1, 1);
        C2 := CountColor(B1.Canvas.Pixels[I, H - 3], B1.Canvas.Pixels[I, H - 1],
          1, 1);
        C1 := CountColor(C1, C2, 1, 1);
        B.Canvas.Pixels[I, H - 2] := CountColor(C, C1, 1, 4);
      end;
      B.Canvas.Font.Color := clWhite;
      B.Canvas.TextOut(10, 4, Top_Text);
      Header.Canvas.CopyRect(R, B.Canvas, R);
    except
    end;
    FreeTBitmap(B);
    FreeTBitmap(B1);
  except
  end;
end;

procedure TSlavaNapSettings.SetTopText(Str: string);
begin
  if Top_Text = Str then Exit;
  Top_Text := Str;
  try
    HeaderPaint(Header);
  except
  end;
end;

procedure TSlavaNapSettings.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  Height := Height - 90;
  for I := 0 to Ord(napSpeedT3) do
    Edit_Console_Speed.Items.Add(Speed2Str(TNapSpeed(I)));
  SetBanItems(Edit_DLFloodBlock_Bantime);
  SetBanItems(Edit_WQFloodBlock_Bantime);
  Ini := TMemIniFile.Create(ApplicationDir + 'config');
end;

procedure TSlavaNapSettings.FormShow(Sender: TObject);
var
  T, Item, It1: TTreeNode;
begin
  ChangeInterface(lmInitial);
  Caption := GetLangI(LNG_S_CAPTION);
  Btn_Restore.Caption := GetLangI(LNG_S_BTN_RESTORE);
  Btn_Close.Caption := GetLangI(LNG_S_BTN_CLOSE);
  Lbl_Change.Caption := GetLangI(LNG_S_LBL_NOTE);
  // Pages.ActivePage := Sh_Main;
  // Sh_MainShow(nil);
  ChangeColors;
  Tree.Items.Clear;
  Item := Tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_MAIN));
  Item.Data := DATA_MAIN;
  It1 := Item;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_SOCKETS));
  T.Data := DATA_SOCKETS;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_USERS));
  T.Data := DATA_USERS;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_LIMITS));
  T.Data := DATA_LIMITS;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_SEARCH));
  T.Data := DATA_SEARCH;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_CHANNELS));
  T.Data := DATA_CHANNELS;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_LINKS));
  T.Data := DATA_LINKS;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_LINKS2));
  T.Data := DATA_LINKS2;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_NAPIGATOR));
  T.Data := DATA_NAPIGATOR;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_DAGSTA));
  T.Data := DATA_DAGSTA;
  T := Tree.Items.Addchild(Item, GetLangI(LNG_S_ITEM_LEVELS));
  T.Data := DATA_LEVELS;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_BLOCKED));
  T.Data := DATA_BLOCKED;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_BLOCKEDMX));
  T.Data := DATA_BLOCKEDMX;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_MOTD));
  T.Data := DATA_MOTD;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_BLOCKS));
  T.Data := DATA_BLOCKS;
  Item := Tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_INTERFACE));
  Item.Data := DATA_INTERFACE;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_CONSOLE));
  T.Data := DATA_CONSOLE;
  T := Tree.Items.Addchild(Item, GetLangI(LNG_S_ITEM_COLORS));
  T.Data := DATA_COLORS;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_LOG));
  T.Data := DATA_LOG;
  Item.Expand(True);
  Item := Tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_SHARE));
  Item.Data := DATA_SHARE;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_SHARE_MP3));
  T.Data := DATA_SHARE_MP3;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_SHARE_AUDIO));
  T.Data := DATA_SHARE_AUDIO;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_SHARE_VIDEO));
  T.Data := DATA_SHARE_VIDEO;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_SHARE_IMAGES));
  T.Data := DATA_SHARE_IMAGES;
  T := Tree.Items.Addchild(Item, GetLangI(LNG_S_ITEM_SHARE_APP));
  T.Data := DATA_SHARE_APP;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_SHARE_CD));
  T.Data := DATA_SHARE_CD;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_SHARE_TEXT));
  T.Data := DATA_SHARE_TEXT;
  T := Tree.Items.Addchild(Item, GetLangI(LNG_S_ITEM_MINSHARE));
  T.Data := DATA_SHARE_MINSHARE;
  Item.Expand(True);
  Item := Tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_OTHER));
  Item.Data := DATA_OTHER;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_REPORT));
  T.Data := DATA_REPORT;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_OTHER2));
  T.Data := DATA_OTHER2;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_OTHER3));
  T.Data := DATA_OTHER3;
  T := Tree.Items.AddChild(Item, GetLangI(LNG_S_ITEM_OTHER4));
  T.Data := DATA_OTHER4;
  Item.Expand(True);
  It1.Expand(True); // Expand first Item and Focus it
  Pages.ActivePage := Sh_Main;
  Sh_MainShow(nil);
end;

procedure TSlavaNapSettings.Btn_CloseClick(Sender: TObject);
begin
  Close;
end;

procedure TSlavaNapSettings.Btn_RestoreClick(Sender: TObject);
begin
  if Assigned(Pages.ActivePage.OnShow) then
    Pages.ActivePage.OnShow(nil);
end;

procedure TSlavaNapSettings.SetChange(Change: Boolean);
begin
  if Change then
  begin
    Btn_Change.Caption := GetLangI(LNG_S_BTN_CHANGE);
    Lbl_Note.Caption := GetLangI(LNG_S_LBL_CHANGE);
    Lbl_Change.Visible := False;
  end
  else
  begin
    Btn_Change.Caption := GetLangI(LNG_S_BTN_SAVE);
    ;
    Lbl_Note.Caption := GetLangI(LNG_S_LBL_SAVE);
    ;
    Lbl_Change.Visible := True;
  end;
end;

procedure TSlavaNapSettings.TreeChange(Sender: TObject; Node: TTreeNode);
begin
  if Node = nil then Exit;
  if not Node.Selected then Exit;
  if Node.Data = DATA_MAIN then
    Pages.ActivePage := Sh_Main
  else if Node.Data = DATA_USERS then
    Pages.ActivePage := Sh_Users
  else if Node.Data = DATA_LIMITS then
    Pages.ActivePage := Sh_Limits
  else if Node.Data = DATA_INTERFACE then
    Pages.ActivePage := Sh_interface
  else if Node.Data = DATA_LOG then
    Pages.ActivePage := Sh_Log
  else if Node.Data = DATA_SHARE then
    Pages.ActivePage := Sh_Share
  else if Node.Data = DATA_SHARE_MP3 then
    Pages.ActivePage := Sh_Share_Mp3
  else if Node.Data = DATA_SHARE_AUDIO then
    Pages.ActivePage := Sh_Share_Audio
  else if Node.Data = DATA_SHARE_VIDEO then
    Pages.ActivePage := Sh_Share_Video
  else if Node.Data = DATA_SHARE_IMAGES then
    Pages.ActivePage := Sh_Share_Images
  else if Node.Data = DATA_SHARE_APP then
    Pages.ActivePage := Sh_Share_Apps
  else if Node.Data = DATA_SHARE_CD then
    Pages.ActivePage := Sh_Share_Cd
  else if Node.Data = DATA_SHARE_TEXT then
    Pages.ActivePage := Sh_Share_Text
  else if Node.Data = DATA_NAPIGATOR then
    Pages.ActivePage := Sh_Napigator
  else if Node.Data = DATA_DAGSTA then
    Pages.ActivePage := Sh_Dagsta
  else if Node.Data = DATA_SEARCH then
    Pages.ActivePage := Sh_Search
  else if Node.Data = DATA_LEVELS then
    Pages.ActivePage := Sh_Levels
  else if Node.Data = DATA_CHANNELS then
    Pages.ActivePage := Sh_Channels
  else if Node.Data = DATA_CONSOLE then
    Pages.ActivePage := Sh_Console
  else if Node.Data = DATA_BLOCKED then
    Pages.ActivePage := Sh_Blocked
  else if Node.Data = DATA_BLOCKEDMX then
    Pages.ActivePage := Sh_Blocked_Winmx
  else if Node.Data = DATA_BLOCKS then
    Pages.ActivePage := Sh_Blocks
  else if Node.Data = DATA_LINKS then
    Pages.ActivePage := Sh_Links
  else if Node.Data = DATA_SOCKETS then
    Pages.ActivePage := Sh_Sockets
  else if Node.Data = DATA_OTHER then
    Pages.ActivePage := Sh_Other
  else if Node.Data = DATA_REPORT then
    Pages.ActivePage := Sh_Report
  else if Node.Data = DATA_SHARE_MINSHARE then
    Pages.ActivePage := Sh_MinShare
  else if Node.Data = DATA_MOTD then
    Pages.ActivePage := Sh_Motd
  else if Node.Data = DATA_COLORS then
    Pages.ActivePage := Sh_Colors
  else if Node.Data = DATA_LINKS2 then
    Pages.ActivePage := Sh_Links2
  else if Node.Data = DATA_OTHER2 then
    Pages.ActivePage := Sh_Other2
  else if Node.Data = DATA_OTHER3 then
    Pages.ActivePage := Sh_Other3
  else if Node.Data = DATA_OTHER4 then
    Pages.ActivePage := Sh_Other4;
end;

procedure TSlavaNapSettings.Cb_Users_Reg_OnlyClick(Sender: TObject);
begin
  Cb_Users_Reg_Allow.Visible := Cb_Users_Reg_Only.Checked;
end;

procedure TSlavaNapSettings.Cb_Log_SaveClick(Sender: TObject);
begin
  Cb_Log_Users.Visible := Cb_Log_Save.Checked;
  Cb_Log_Servers.Visible := Cb_Log_Save.Checked;
end;

procedure TSlavaNapSettings.Sh_MainShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_MAIN));
  SetChange(False);
  Lbl_Handle.Caption := Format(RS_Settings_CurrentHandle, [MyServerHandle]);
  Lbl_Handle.Font.Color := clPurple;
  Edit_Main_Remoteadmin.Text := Cons_Reg_User;
  Edit_Main_Ports.Text := Ini.ReadString('Server', 'Ports', DEF_LISTEN_PORTS);
  Edit_Main_Host.Text := Ini.ReadString('Server', 'ReportHost', 'localhost');
  Edit_Main_Handle.Value := Ini.ReadInteger('Server', 'ServerHandle', 0);
  Edit_Main_ListenIp.Text := Ini.ReadString('Server', 'SocketsInterface',
    '0.0.0.0');
  Edit_Main_Alias.Text := Trim(Ini.ReadString('Server', 'Alias', ''));
end;

procedure TSlavaNapSettings.Sh_UsersShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_USERS));
  SetChange(True);
  Cb_Users_Reg_Only.Visible := not Network_Hub;
  Cb_Users_Reg_Only.Checked := Registered_Only;
  Cb_Users_Reg_Allow.Checked := Allow_Register;
  Cb_Users_Reg_Allow.Visible := Cb_Users_Reg_Only.Checked;
  Cb_Users_NoRemote.Checked := not Accept_Remote_Users;
  Edit_Users_Limit.Value := Max_Users;
  Edit_Users_Clones.Value := Max_Clones;
  Edit_Users_Logintimeout.Value := TimeOut_Login div 1000;
  Edit_Users_MaxAccept.Value := Max_Users_Per_Minute;
  Cb_Users_Redirectcqex.Checked := Redirect_Cqex;
  Edit_Users_BanMail.Text := BanMail;
  Edit_Users_Redirecturl.Text := Redirect_Url;
  Cb_Users_Reconnect.Checked := Reconnect_Delay;
end;

procedure TSlavaNapSettings.Sh_LimitsShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_LIMITS));
  SetChange(True);
  Edit_Limits_Stats.Value := Stats_Delay div 1000;
  Edit_Limits_Hotlist.Value := Max_Hotlist;
  Edit_Limits_Ignored.Value := Max_Ignorelist;
  Cb_Limits_Limitservers.Checked := not Bandwidth_Limitservers;
  Edit_Limits_MaxDown.Value := Bandwidth_MaxDown;
  Edit_Limits_MaxUp.Value := Bandwidth_MaxUp;
  if Win98 then
    Edit_Limits_Memory.Value := Memory_Limit div 1048576
  else
    Edit_Limits_Memory.Value := 0;
end;

procedure TSlavaNapSettings.Sh_InterfaceShow(Sender: TObject);
var
  Reg: TRegistry;
  B: Boolean;
  Str: string;
begin
  SetTopText(GetLangI(LNG_S_TEXT_INTERFACE));
  SetChange(True);
  Edit_Interface_Remotepass.Text := Remote_Adminpass;
  Cb_Interface_Remoteadminok.Checked := Remote_Admin_Ok;
  Edit_Interface_Remotepass.Visible := Remote_Admin_Ok;
  Edit_Interface_Cpu.Value := Cpu_Usage;
  Cb_Interface_Nocpu.Checked := Cpu_Disable;
  Cb_Interface_Noswitch.Checked := not Switch_Chat;
  Cb_Interface_Chatflash.Checked := Chat_Flash;
  Cb_Interface_SysTray.Checked := SlavaNapwindow.Tray.Active;
  Cb_Interface_Chatmini.Checked := Chat_Mini;
  Cb_Interface_Wallop.Checked := Wallop_Im;
  Cb_Interface_Wallopsound.Checked := Wallop_Sound;
  Reg := TRegistry.Create;
  B := False;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run', True);
    Str := Reg.ReadString('SlavaNap');
    if Str <> '' then
      B := True;
  except
  end;
  Reg.Free;
  Cb_Interface_Startup.Checked := B;
end;

procedure TSlavaNapSettings.Sh_LogShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_LOG));
  SetChange(True);
  Cb_Log_Login.Checked := Log_Login;
  Cb_Log_Napigator.Checked := Log_Napigator;
  Cb_Log_Dagsta.Checked := Log_Dagsta;
  Cb_Log_Search.Checked := Log_Search;
  Cb_Log_Browse.Checked := Log_Browse;
  Cb_Log_Transfers.Checked := Log_Transfers;
  // Cb_Log_Links.Checked := Log_Links;
  Cb_Log_Save.Checked := Log_To_File;
  Cb_Log_SaveClick(nil);
  Cb_Log_Users.Checked := Log_Commands;
  Cb_Log_Servers.Checked := Log_Servercommands;
  Cb_Log_Serverstats.Checked := Save_Stats;
  Cb_Log_ServerstatsClick(nil);
  Cb_Log_Clearserverstats.Checked := Clear_Serverstats;
  Cb_Log_Clearclientstats.Checked := Clear_Clientstats;
  Cb_Log_Console.Checked := Log_Console_Data;
end;

procedure TSlavaNapSettings.Sh_ShareShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SHARE));
  SetChange(True);
  Edit_Share_FriendAdd.Value := Share_Auto_FriendAdd_Minimum;
  Edit_Share_Max.Value := MaxShare;
  Edit_Share_MaxTotal.Value := MaxShare_Total;
  Edit_Share_FileName.Value := MinFileName;
  Edit_Share_Duration.Value := MinDuration;
  Cb_Share_FriendAdd.Checked := Auto_FriendAdd;
  Label149.Visible := Cb_Share_FriendAdd.Checked;
  Label150.Visible := Cb_Share_FriendAdd.Checked;
  Edit_Share_FriendAdd.Visible := Cb_Share_FriendAdd.Checked;
  Cb_Share_Disable.Checked := not Allow_Share;
  Cb_Share_Inform.Checked := ShareInform;
  Cb_Share_Nomodem.Checked := Share_Nomodem;
  Edit_Share_MaxIndex.Value := MaxShareIndex;
  Cb_Share_Checkdup.Checked := Share_Checkdup;
end;

procedure TSlavaNapSettings.Sh_Share_Mp3Show(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SHARE_MP3));
  SetChange(True);
  Edit_Mp3_Ext.Text := Ext_Mp3;
  Edit_Mp3_Max.Value := MaxShare_Mp3;
  Edit_Mp3_MinSize.Value := MinFileSize_mp3 div 1024;
  Edit_Mp3_MaxSize.Value := MaxFileSize_Mp3 div 1024;
  Cb_Mp3_320.Checked := Share_320;
  Cb_Mp3_256.Checked := Share_256;
  Cb_Mp3_224.Checked := Share_224;
  Cb_Mp3_192.Checked := Share_192;
  Cb_Mp3_160.Checked := Share_160;
  Cb_Mp3_128.Checked := Share_128;
  Cb_Mp3_112.Checked := Share_112;
  Cb_Mp3_96.Checked := Share_96;
  Cb_Mp3_80.Checked := Share_80;
  Cb_Mp3_64.Checked := Share_64;
  Cb_Mp3_56.Checked := Share_56;
  Cb_Mp3_48.Checked := Share_48;
  Cb_Mp3_40.Checked := Share_40;
  Cb_Mp3_32.Checked := Share_32;
  Cb_Mp3_24.Checked := Share_24;
  Cb_Mp3_0.Checked := Share_Unknown;
end;

procedure TSlavaNapSettings.Sh_Share_AudioShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SHARE_AUDIO));
  SetChange(True);
  Edit_Audio_Ext.Text := Ext_Audio;
  Edit_Audio_Max.Value := MaxShare_Audio;
  Edit_Audio_MinSize.Value := MinFileSize_Audio div 1024;
  Edit_Audio_MaxSize.Value := MaxFileSize_Audio div 1024;
end;

procedure TSlavaNapSettings.Sh_Share_VideoShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SHARE_VIDEO));
  SetChange(True);
  Edit_Video_Ext.Text := Ext_Video;
  Edit_Video_Max.Value := MaxShare_Video;
  Edit_Video_MinSize.Value := MinFileSize_Video div 1024;
  Edit_Video_MaxSize.Value := MaxFileSize_Video div 1024;
end;

procedure TSlavaNapSettings.Sh_Share_ImagesShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SHARE_IMAGES));
  SetChange(True);
  Edit_Images_Ext.Text := Ext_Image;
  Edit_Images_Max.Value := MaxShare_Image;
  Edit_Images_MinSize.Value := MinFileSize_Image div 1024;
  Edit_Images_MaxSize.Value := MaxFileSize_Image div 1024;
end;

procedure TSlavaNapSettings.Sh_Share_AppsShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SHARE_APP));
  SetChange(True);
  Edit_Apps_Ext.Text := Ext_App;
  Edit_Apps_Max.Value := MaxShare_App;
  Edit_Apps_MinSize.Value := MinFileSize_App div 1024;
  Edit_Apps_MaxSize.Value := MaxFileSize_App div 1024;
end;

procedure TSlavaNapSettings.Sh_Share_CdShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SHARE_CD));
  SetChange(True);
  Edit_Cd_Ext.Text := Ext_Cd;
  Edit_Cd_Max.Value := MaxShare_Cd;
  Edit_Cd_MinSize.Value := MinFileSize_Cd div 1024;
  Edit_Cd_MaxSize.Value := MaxFileSize_Cd div 1024;
end;

procedure TSlavaNapSettings.Sh_Share_TextShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SHARE_TEXT));
  SetChange(True);
  Edit_Text_Ext.Text := Ext_Text;
  Edit_Text_Max.Value := MaxShare_Text;
  Edit_Text_MinSize.Value := MinFileSize_Text div 1024;
  Edit_Text_MaxSize.Value := MaxFileSize_Text div 1024;
end;

procedure TSlavaNapSettings.Sh_NapigatorShow(Sender: TObject);
var
  I, J: Integer;
begin
  SetTopText(GetLangI(LNG_S_TEXT_NAPIGATOR));
  SetChange(True);
  Edit_Napigator_Host.Text := Napigator_Host;
  Edit_Napigator_Port.Text := Napigator_Port;
  Edit_Napigator_User.Text := Napigator_User;
  Edit_Napigator_Myip.Text := Napigator_Myip;
  Cb_Napigator_Enabled.Checked := Napigator_Enabled;
  Cb_Napigator_Autodisconnect.Checked := Napigator_Autodisconnect;
  Edit_Napigator_Delay.Value := Napigator_Delay div 60000;
  // Setting up List of Ports
  J := 0;
  List_Napigator_MyPort.Items.Clear;
  for I := 0 to MAX_LISTEN_SOCKET do
    if Server_Port[I] <> 0 then
    begin
      List_Napigator_MyPort.Items.Add(IntToStr(Server_Port[I]));
      if Server_Port[I] = Napigator_MyPort then
        J := List_Napigator_MyPort.Items.Count - 1;
    end;
  {if Meta_Enabled then
  begin
   List_Napigator_MyPort.Items.Add(IntToStr(Meta_Port));
   if Meta_Port = Napigator_MyPort then
     J := List_Napigator_MyPort.Items.Count - 1;
  end;}
  if Enable_Metaserver and (Length(MetaPort_List) > 0) then
  begin
    List_Napigator_MyPort.Items.Add(IntToStr(MetaPort_List[0]));
    if MetaPort_List[0] = Napigator_MyPort then
      J := List_Napigator_MyPort.Items.Count - 1;
  end;
  List_Napigator_MyPort.ItemIndex := J;
  List_Napigator_MyPort.DropDownCount := List_Napigator_MyPort.Items.Count;
end;

procedure TSlavaNapSettings.Sh_DagstaShow(Sender: TObject);
var
  I, J: Integer;
begin
  SetTopText(GetLangI(LNG_S_TEXT_DAGSTA));
  SetChange(True);
  Edit_Dagsta_Host.Text := Dagsta_Host;
  Edit_Dagsta_Port.Text := Dagsta_Port;
  Edit_Dagsta_User.Text := Dagsta_User;
  Edit_Dagsta_Myip.Text := Dagsta_Myip;
  Cb_Dagsta_Enabled.Checked := Dagsta_Enabled;
  Cb_Dagsta_Autodisconnect.Checked := Dagsta_Autodisconnect;
  Edit_Dagsta_Delay.Value := Dagsta_Delay div 60000;
  // Setting up List of Ports
  J := 0;
  List_Dagsta_MyPort.Items.Clear;
  for I := 0 to MAX_LISTEN_SOCKET do
    if Server_Port[I] <> 0 then
    begin
      List_Dagsta_MyPort.Items.Add(IntToStr(Server_Port[I]));
      if Server_Port[I] = Dagsta_MyPort then
        J := List_Dagsta_MyPort.Items.Count - 1;
    end;
  {if Meta_Enabled then
  begin
   List_Dagsta_MyPort.Items.Add(IntToStr(Meta_Port));
   if Meta_Port = Dagsta_MyPort then
     J := List_Dagsta_MyPort.Items.Count - 1;
  end;}
  if Enable_Metaserver and (Length(MetaPort_List) > 0) then
  begin
    List_Dagsta_MyPort.Items.Add(IntToStr(MetaPort_List[0]));
    if MetaPort_List[0] = Dagsta_MyPort then
      J := List_Dagsta_MyPort.Items.Count - 1;
  end;
  List_Dagsta_MyPort.ItemIndex := J;
  List_Dagsta_MyPort.DropDownCount := List_Dagsta_MyPort.Items.Count;
end;

procedure TSlavaNapSettings.Sh_SearchShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SEARCH));
  SetChange(True);
  Edit_Search_DefSearch.Value := DefSearchResults;
  Edit_Search_MaxSearch.Value := MaxSearchResults;
  Edit_Search_MaxBrowse.Value := MaxBrowseResults;
  Edit_Search_MaxRemoteBrowse.Value := MaxRemoteBrowse;
  Edit_Search_MaxRemote.Value := MaxRemoteSearchResults;
  Edit_Search_Searchespm.Value := Flood_Max_Searches;
  Cb_Search_Disable_Remote.Checked := DisableRemoteSearch;
  Cb_Search_Disable_RemoteClick(nil);
end;

procedure TSlavaNapSettings.Sh_LevelsShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_LEVELS));
  SetChange(True);
  Edit_Level_0.Text := Levels[0];
  Edit_Level_1.Text := Levels[1];
  Edit_Level_2.Text := Levels[2];
  Edit_Level_3.Text := Levels[3];
  Edit_Level_4.Text := Levels[4];
  Edit_Level_5.Text := Levels[5];
end;

procedure TSlavaNapSettings.Sh_ChannelsShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_CHANNELS));
  SetChange(True);
  Cb_Channels_Allowcreate.Checked := Allow_Create_Channels;
  Edit_Channels_Max.Value := Max_Channels;
  Edit_Channels_Max2.Value := Max_Channels_Total;
  Cb_Channels_Blockcqex.Checked := Block_Cqex_Chat;
  Cb_Channels_Oldwallop.Checked := Old_Opsay;
  Edit_Channels_MaxPrivMessage.Value := Max_Privmsg_Len;
  Edit_Channels_MaxMessage.Value := Max_Channelmsg_Len;
  Cb_Channels_Showops.Checked := Show_Operators;
  Cb_Channels_Preventshout.Checked := Prevent_Shouting;
  Edit_Channels_Flood_User.Value := Flood_Max_User_Message;
  Edit_Channels_Flood_Same.Value := Flood_Max_Same_Message;
  Cb_Channels_Flood_Warn.Checked := Flood_Warning;
  Cb_Channels_Floodenable.Checked := Flood_Enable;
  Cb_Channels_FloodenableClick(nil);
  Cb_Channels_Timestamp.Checked := Ini.ReadBool('Channels', 'TimeStamp', False);
  Cb_Channels_Low.Checked := Ini.ReadBool('Channels', 'LowerCase', False);
end;

procedure TSlavaNapSettings.Sh_ConsoleShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_CONSOLE));
  SetChange(False);
  Edit_Console_User.Text := Ini.ReadString('Console', 'User', 'Admin');
  if Running then
    Edit_Console_Speed.ItemIndex := Ord(Cons.Data^.Speed);
  Edit_Cons_Autojoin1.Text := Ini.ReadString('Console', 'AutoJoinRoom1', '');
  Edit_Cons_Autojoin2.Text := Ini.ReadString('Console', 'AutoJoinRoom2', '');
  Edit_Cons_Autojoin3.Text := Ini.ReadString('Console', 'AutoJoinRoom3', '');
end;

procedure TSlavaNapSettings.Sh_BlockedShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_BLOCKED));
  SetChange(True);
  Cb_Block_Napster.Checked := Blocked_Clients[softNapster];
  Cb_Block_Audiognome.Checked := Blocked_Clients[softAudioGnome];
  Cb_Block_Gnomeplus.Checked := Blocked_Clients[softGnomePlus];
  Cb_Block_Amster.Checked := Blocked_Clients[softAmster];
  Cb_Block_Filenavigator.Checked := Blocked_Clients[softFileNavigator];
  Cb_Block_Cqex.Checked := Blocked_Clients[softCQEX];
  Cb_Block_Sunshineun.Checked := Blocked_Clients[softSunshineUN];
  Cb_Block_Teknap.Checked := Blocked_Clients[softTekNap];
  Cb_Block_Nap.Checked := Blocked_Clients[softNap];
  Cb_Block_Macnap.Checked := Blocked_Clients[softMacNap];
  Cb_Block_Mp3rage.Checked := Blocked_Clients[softMP3Rage];
  Cb_Block_Xnap.Checked := Blocked_Clients[softXNap];
  Cb_Block_Spotlight.Checked := Blocked_Clients[softSpotlight];
  Cb_Block_Nfs.Checked := Blocked_Clients[softNFS];
  Cb_Block_Dmnapster.Checked := Blocked_Clients[softDMNapster];
  Cb_Block_Knapster.Checked := Blocked_Clients[softKNapster];
  Cb_Block_Lopster.Checked := Blocked_Clients[softLopster];
  Cb_Block_Rapigator.Checked := Blocked_Clients[softRapigator];
  Cb_Block_Swaptor.Checked := Blocked_Clients[softSwaptor];
  Cb_Block_Dagsta.Checked := Blocked_Clients[softDagsta];
  Cb_Block_Drumbeat.Checked := Blocked_Clients[softDrumbeat];
  Cb_Block_Floodster.Checked := Blocked_Clients[softFloodster];
  Cb_Block_Mldonkey.Checked := Blocked_Clients[softMlDonkey];
  Cb_Block_Opennap.Checked := Blocked_Clients[softOpennap];
  Cb_Block_Napigator.Checked := Blocked_Clients[softNapigator];
  Cb_Block_Nap08.Checked := Blocked_Clients[softNap08];
  Cb_Block_Other.Checked := Blocked_Clients[softUnknown];
  case Blocked_Messagetype of
    blckCustom: Cb_Block_Custommessage.Checked := True;
    blckNone: Cb_Block_Nomessage.Checked := True;
  else
    Cb_Block_Defaultmessage.Checked := True;
  end;
  Edit_Block_Message.Text := Blocked_Message;
  Edit_Block_Sign0.Text := Blocked_Custom[0];
  Edit_Block_Sign1.Text := Blocked_Custom[1];
  Edit_Block_Sign2.Text := Blocked_Custom[2];
  Edit_Block_Sign3.Text := Blocked_Custom[3];
  Edit_Block_Sign4.Text := Blocked_Custom[4];
  Edit_Block_Sign5.Text := Blocked_Custom[5];
  Cb_Block_CustommessageClick(nil);
end;

procedure TSlavaNapSettings.Sh_LinksShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_LINKS));
  SetChange(True);
  case Allow_Link of
    linkAll: Cb_Link_All.Checked := True;
    linkNone: Cb_Link_None.Checked := True;
    linkCustom: Cb_Link_List2.Checked := True;
  else
    Cb_Link_List.Checked := True;
  end;
  Edit_Link_List.Text := Allowed_Servers;
  Cb_Link_Hub.Checked := Network_Hub;
  Cb_Link_Syncban.Checked := Hub_Syncban;
  Cb_Link_Syncreg.Checked := Hub_Syncreg;
  Cb_Link_SyncBlock.Checked := Hub_SyncBlock;
  Cb_Link_Noautoconnect.Checked := AutoLink_Only1;
  Cb_Link_RestrictOutgoing.Checked := Restrict_Outgoing;
  Edit_Link_Outgoinglist.Text := Outgoing_List;
  {Cb_Meta_Enabled.Checked := Meta_Enabled;
  Edit_Meta_Port.Value := Meta_Port;}
  Cb_Link_MaxServers.Checked := Max_Servers_Enabled;
  Label151.Visible := Max_Servers_Enabled;
  Edit_Link_MaxServers.Visible := Max_Servers_Enabled;
  Edit_Link_MaxServers.Value := Max_Servers;
end;

procedure TSlavaNapSettings.Sh_Links2Show(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_LINKS2));
  SetChange(True);
  Cb_Link2_LagNoSearch.Checked := Search_Noforward_Results;
  Cb_Link2_LagNoSearchReq.Checked := Search_Noforward_Requests;
  Cb_Link2_Lagnobrowse.Checked := Browse_Noforward_Results;
  Cb_Link2_Lagnobrowsereq.Checked := Browse_Noforward_Requests;
end;

procedure TSlavaNapSettings.Sh_SocketsShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_SOCKETS));
  SetChange(True);
  Cb_Sockets_Users_Def.Checked := Sockets_Users_default;
  Edit_Sockets_Users_Send.Value := Sockets_Users_Send;
  Edit_Sockets_Users_Recv.Value := Sockets_Users_Recv;
  Cb_Sockets_Users_DefClick(nil);
  Cb_Sockets_Servers_Def.Checked := Sockets_Servers_default;
  Edit_Sockets_Servers_Send.Value := Sockets_Servers_Send;
  Edit_Sockets_Servers_Recv.Value := Sockets_Servers_Recv;
  Cb_Sockets_Servers_DefClick(nil);
end;

procedure TSlavaNapSettings.Sh_OtherShow(Sender: TObject);
var
  I: Integer;
begin
  SetTopText(GetLangI(LNG_S_TEXT_OTHER));
  SetChange(True);
  Cb_Ann_Enable.Checked := Ann_Enabled;
  Edit_Ann_Delay.Value := Ann_Delay;
  Edit_Ann_User.Text := Ann_User;
  Edit_Ann_Messages.Lines.Clear;
  for I := 0 to Max_Announcement do
    if Ann_Messages[I] <> '' then
      Edit_Ann_Messages.Lines.Add(Ann_Messages[I]);
end;

procedure TSlavaNapSettings.Sh_Other2Show(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_OTHER2));
  SetChange(True);

  Cb_SearchBlock_ChkFiles.Checked := SearchBlock_ChkFiles;
  Cb_SearchBlock_ChkSize.Checked := SearchBlock_ChkSize;
  Edit_SearchBlock_Files.Value := SearchBlock_Files;
  Edit_SearchBlock_Size.Value := SearchBlock_Size div MegaByte;
  Rd_SearchBlock_Hard.Enabled := SearchBlock_ChkFiles and SearchBlock_ChkSize;
  Rd_SearchBlock_Hard.Enabled := SearchBlock_ChkFiles and SearchBlock_ChkSize;
  Rd_SearchBlock_Hard.Checked := SearchBlock_Hard;
  Rd_SearchBlock_Normal.Checked := not SearchBlock_Hard;

  Cb_DomBlock_ChkFiles.Checked := DomBlock_ChkFiles;
  Cb_DomBlock_ChkSize.Checked := DomBlock_ChkSize;
  Edit_DomBlock_Files.Value := DomBlock_Files;
  Edit_DomBlock_Size.Value := DomBlock_Size div MegaByte;
  Rd_DomBlock_Hard.Enabled := DomBlock_ChkFiles and DomBlock_ChkSize;
  Rd_DomBlock_Hard.Enabled := DomBlock_ChkFiles and DomBlock_ChkSize;
  Rd_DomBlock_Hard.Checked := DomBlock_Hard;
  Rd_DomBlock_Normal.Checked := not DomBlock_Hard;

  case DLFloodBlock_Method of
    Block: Rd_DLFloodBlock_Block.Checked := True;
    Leech: Rd_DLFloodBlock_Leech.Checked := True;
    Ban: Rd_DLFloodBlock_Ban.Checked := True;
  end;
  Edit_DLFloodBlock.Value := DLFloodBlock_Count;
  Edit_DLFloodBlock_Bantime.Visible := Rd_DLFloodBlock_Ban.Checked;
  Edit_DLFloodBlock_Bantime.ItemIndex := GetBanIndex(DLFloodBlock_Bantime);

  case WQFloodBlock_Method of
    Block: Rd_WQFloodBlock_Block.Checked := True;
    Leech: Rd_WQFloodBlock_Leech.Checked := True;
    Ban: Rd_WQFloodBlock_Ban.Checked := True;
  end;
  Edit_WQFloodBlock.Value := WQFloodBlock_Count;
  Edit_WQFloodBlock_Bantime.Visible := Rd_WQFloodBlock_Ban.Checked;
  Edit_WQFloodBlock_Bantime.ItemIndex := GetBanIndex(WQFloodBlock_Bantime);

  Cb_Nocount_Text.Checked := Nocount_Text;
  Cb_Autoban_Incomplete.Checked := Autoban_Incomplete;
  Cb_Disable_Fakeext.Checked := Disable_FakeExt;
  Edit_Fakeext.Visible := Cb_Disable_Fakeext.Checked;
  Edit_Fakeext.Text := Fakeext;
  Cb_Enable_TrapPort.Checked := Enable_TrapPort;
  Edit_TrapPort.Text := Ini.ReadString('Other2', 'TrapPort', '8888 8875 7743');
  Cb_Block_TransferPort.Checked := Block_TransferPort;
  Edit_Blocked_TransferPort.Visible := Cb_Block_TransferPort.Checked;
  Edit_Blocked_TransferPort.Text := Blocked_TransferPort;
  Cb_Share_MatchedFile_Only.Checked := Share_MatchedFile_Only;
end;

procedure TSlavaNapSettings.Sh_Other3Show(Sender: TObject);
var
  I: Integer;
begin
  SetTopText(GetLangI(LNG_S_TEXT_OTHER3));
  SetChange(True);
  Cb_Enable_LoginIM.Checked := Enable_LoginIM;
  Edit_LoginIMBot.Text := LoginIMBot;
  Edit_LoginIM.Lines.Clear;
  for I := 0 to MAX_LOGINIM do
    if LoginIM[I] <> '' then
      Edit_LoginIM.Lines.Add(LoginIM[I]);
  Cb_Channels_Forceenter.Checked := Force_Enter;
  Edit_Channels_Forceenter.Text := Force_Enter_Channel;
  Cb_Allow_2ByteName.Checked := Allow_2ByteName;
  Cb_Check_Loginpass.Checked := Check_Loginpass;
  Edit_Loginpass.Text := Loginpass;
  Edit_Loginpass.Visible := Cb_Check_Loginpass.Checked;
  Label157.Visible := Cb_Check_Loginpass.Checked;
  Cb_Enable_Msgserv.Checked := Enable_Msgserv;
  Cb_Restrict_Hitperuser.Checked := Restrict_Hitperuser;
  Edit_Hitperuser.Value := MaxHitPerUser;
  Edit_Hitperuser.Visible := Cb_Restrict_Hitperuser.Checked;
  Label158.Visible := Cb_Restrict_Hitperuser.Checked;
  case B3_Canclose of
    Unknown3: Rd_Xbutton_Attr.ItemIndex := 0;
    True3: Rd_Xbutton_Attr.ItemIndex := 1;
    False3: Rd_Xbutton_Attr.ItemIndex := 2;
  end;
  Cb_MinShare_NoBlockAct.Checked := MinShare_NoBlockAct;
  Cb_Kill_Idleuser.Checked := Kill_Idleuser;
  Edit_Kill_Idleuser_Time.Value := Kill_Idleuser_Time div 60000;
  Label161.Visible := Cb_Kill_Idleuser.Checked;
  Label162.Visible := Cb_Kill_Idleuser.Checked;
  Edit_Kill_Idleuser_Time.Visible := Cb_Kill_Idleuser.Checked;
  Cb_Deny_Listall_for_Users.Checked := not Listall_for_Users;
  Cb_Block_Weird_XnapFile.Checked := Block_Weird_XnapFile;
  Cb_Suggest_DBrowse.Checked := Suggest_DBrowse;
  Cb_Allow_Rtf_Code.Checked := Allow_Rtf_Code;
  Cb_Disable_Nullip.Checked := Disable_Nullip;
end;

procedure TSlavaNapSettings.Sh_Other4Show(Sender: TObject);
var
  I, J: Integer;
  HostPort: string;
  Srv: TServer;
begin
  SetTopText(GetLangI(LNG_S_TEXT_OTHER4));
  SetChange(True);
  Cb_Block_Napchan.Checked := Blocked_Clients[softNapchan];
  Cb_Block_Utatane.Checked := Blocked_Clients[softUtatane];
  Cb_Block_2get.Checked := Blocked_Clients[soft2get];
  Cb_Block_Regnessem.Checked := Blocked_Clients[softRegnessem];
  Edit_Log_Folder.Text := Log_Folder;
  Edit_Max_Resolving_Count.Value := Max_Resolving_Count;

  Cb_Refresh_Users.Checked := SlavaNapWindow.Cb_Users_Refresh.Checked;
  Edit_Usersreftime.Value := SlavaNapWindow.Edit_Users_Refresh.Value;
  Edit_Usersreftime.Visible := Cb_Refresh_Users.Checked;
  Label166.Visible := Cb_Refresh_Users.Checked;
  Cb_Refresh_Servers.Checked := SlavaNapWindow.Cb_Servers_Refresh.Checked;
  Edit_Servreftime.Value := SlavaNapWindow.Edit_Servers_Refresh.Value;
  Edit_Servreftime.Visible := Cb_Refresh_Servers.Checked;
  Label159.Visible := Cb_Refresh_Servers.Checked;

  Cb_Enable_Metaserver.Checked := Enable_Metaserver;
  Edit_MetaPort.Text := MetaPort;
  with Edit_Redirected_List do
  begin
    Clear;
    for I := 0 to Redirected_Servers.Count - 1 do
    begin
      Items.Add(Redirected_Servers.Str(I));
      Checked[I] := Boolean(Redirected_Servers.Id(I));
    end;
    for I := 0 to DB_Servers.Count - 1 do
    begin
      Srv := DB_Servers[I];
      HostPort := LowerCase(Srv.Host) + ':' + IntToStr(Srv.Port);
      if Items.IndexOf(HostPort) = -1 then
      begin
        J := Items.Add(HostPort);
        Checked[J] := True;
      end;
    end;
  end;
  Cb_Enable_MetaserverClick(nil);
end;

procedure TSlavaNapSettings.Sh_ReportShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_REPORT));
  SetChange(True);
  Cb_Report_Old_Enable.Checked := Old_Report_Enabled;
  Edit_Report_Old_Port.Value := Old_Report_Port;
  Cb_Report_New_Enabled.Checked := New_Report_Enabled;
  Edit_Report_New_Port.Value := New_Report_Port;
  Cb_Report_New_Hidehub.Checked := New_Report_Hide_Hub;
  Cb_Report_Truestats.Checked := True_Stats;
end;

procedure TSlavaNapSettings.Sh_MinShareShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_MINSHARE));
  SetChange(True);
  Edit_MinShare_MinShare.Value := MinShare;
  Edit_MinShare_Delay.Value := MinShare_Delay div 60000;
  Cb_MinShare_Ban.Checked := MinShare_Ban;
  Cb_MinShare_Banip.Checked := MinShare_Banip;
  Label160.Visible := Cb_MinShare_Ban.Checked;
  Edit_MinShare_Bantime.Visible := Cb_MinShare_Ban.Checked;
  Edit_MinShare_Bantime.Value := MinShare_Bantime div 60;
  Cb_MinShare_Onlyfull.Checked := MinShare_Fullonly;
  Cb_MinShare_Full10.Checked := MinShare_Only10;
  Edit_MinShare_MinSharesize.Value := MinShare_Size div MegaByte;
  Cb_MinShare_OnlyfullClick(nil);
  Cb_MinShare_Kickchat.Checked := MinShare_Kickchat;
  Cb_MinShare_Wallop.Checked := Wallop_Serverban;
end;

procedure TSlavaNapSettings.Sh_MotdShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_MOTD));
  SetChange(True);
  Edit_Motd.Lines.Clear;
  try
    Edit_Motd.Lines.LoadFromFile(ApplicationDir + 'motd');
  except
  end;
end;

procedure TSlavaNapSettings.Sh_ColorsShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_COLORS));
  SetChange(True);
  Edit_Color_Bg.ColorValue := slBackground;
  Edit_Color_Text.ColorValue := slText;
  Edit_Color_Chat.ColorValue := slChatMessage;
  Edit_Color_Mychat.ColorValue := slChatMyMessage;
  Edit_Color_Channelchat.ColorValue := slChannelMessage;
  Edit_Color_Mychannelchat.ColorValue := slChannelMyMessage;
  Edit_Color_Emote.ColorValue := slChannelEmote;
  Edit_Color_Myemote.ColorValue := slChannelMyEmote;
  Edit_Color_Join.ColorValue := slChannelJoin;
  Edit_Color_Part.ColorValue := slChannelPart;
  Edit_Color_Topic.ColorValue := slTopic;
  Edit_Color_Debug.ColorValue := slDebugData;
  Edit_Color_Error.ColorValue := slError;
  Edit_Color_Wallop.ColorValue := slWallop;
  Edit_Color_announce.ColorValue := slAnnounce;
  Edit_Color_Online.ColorValue := slOnline;
  Edit_Color_Offline.ColorValue := slOffline;
  Edit_Color_Search.ColorValue := slSearch;
  Edit_Color_Browse.ColorValue := slBrowse;
  Edit_Color_Transfer.ColorValue := slTransfer;
  Edit_Color_Napigator.ColorValue := slNapigator;
  Edit_Color_Dagsta.ColorValue := slDagsta;
  Edit_Color_Pong.ColorValue := slPong;
  Edit_Color_Whowas.ColorValue := slWhoWas;
end;

procedure TSlavaNapSettings.Btn_ChangeClick(Sender: TObject);
var
  Reg: TRegistry;
  I: Integer;
  LogFileName: string;
  P: PStringHashItem;
  Ch: TChannel;
  List: TMyStringList;
begin
  if Pages.ActivePage = Sh_Main then
  try
    Listen_Interface := Edit_Main_ListenIp.Text;
    Cons_Reg_User := Edit_Main_Remoteadmin.Text;
    Ini.WriteString('Server', 'Ports', Edit_Main_Ports.Text);
    Ini.WriteString('Server', 'ReportHost', Edit_Main_Host.Text);
    Ini.WriteInteger('Server', 'ServerHandle', Edit_Main_Handle.Value);
    Ini.WriteString('Server', 'SocketsInterface', Listen_Interface);
    if Edit_Main_Alias.Text = ServerName_I then
      Ini.DeleteKey('Server', 'Alias')
    else
      Ini.WriteString('Server', 'Alias', Edit_Main_Alias.Text);
  except
  end
  else if Pages.ActivePage = Sh_Colors then
  try
    slBackground := Edit_Color_Bg.ColorValue;
    slText := Edit_Color_Text.ColorValue;
    slChatMessage := Edit_Color_Chat.ColorValue;
    slChatMyMessage := Edit_Color_Mychat.ColorValue;
    slChannelMessage := Edit_Color_Channelchat.ColorValue;
    slChannelMyMessage := Edit_Color_Mychannelchat.ColorValue;
    slChannelEmote := Edit_Color_Emote.ColorValue;
    slChannelMyEmote := Edit_Color_Myemote.ColorValue;
    slChannelJoin := Edit_Color_Join.ColorValue;
    slChannelPart := Edit_Color_Part.ColorValue;
    slTopic := Edit_Color_Topic.ColorValue;
    slDebugData := Edit_Color_Debug.ColorValue;
    slError := Edit_Color_Error.ColorValue;
    slWallop := Edit_Color_Wallop.ColorValue;
    slAnnounce := Edit_Color_Announce.ColorValue;
    slOnline := Edit_Color_Online.ColorValue;
    slOffline := Edit_Color_Offline.ColorValue;
    slSearch := Edit_Color_Search.ColorValue;
    slBrowse := Edit_Color_Browse.ColorValue;
    slTransfer := Edit_Color_Transfer.ColorValue;
    slNapigator := Edit_Color_Napigator.ColorValue;
    slDagsta := Edit_Color_Dagsta.ColorValue;
    slPong := Edit_Color_Pong.ColorValue;
    slWhoWas := Edit_Color_Whowas.ColorValue;
    ChangeColors;
    if Running then
      SlavaNapWindow.SetColors(True);
  except
  end
  else if Pages.ActivePage = Sh_Users then
  try
    Registered_Only := Cb_Users_Reg_Only.Checked;
    Allow_Register := Cb_Users_Reg_Allow.Checked;
    Max_Users := Edit_Users_Limit.Value;
    Max_Clones := Edit_Users_Clones.Value;
    TimeOut_Login := Int64(Edit_Users_Logintimeout.Value) * 1000;
    Max_Users_Per_Minute := Edit_Users_MaxAccept.Value;
    Accept_Remote_Users := not Cb_Users_NoRemote.Checked;
    Redirect_Cqex := Cb_Users_Redirectcqex.Checked;
    BanMail := Edit_Users_BanMail.Text;
    Redirect_Url := Edit_Users_Redirecturl.Text;
    Reconnect_Delay := Cb_Users_Reconnect.Checked;
  except
  end
  else if Pages.ActivePage = Sh_Limits then
  try
    Stats_Delay := Int64(Edit_Limits_Stats.Value) * 1000;
    Max_Hotlist := Edit_Limits_Hotlist.Value;
    Max_Ignorelist := Edit_Limits_Ignored.Value;
    Bandwidth_MaxDown := Edit_Limits_MaxDown.Value;
    Bandwidth_MaxUp := Edit_Limits_MaxUp.Value;
    Bandwidth_Limitservers := not Cb_Limits_Limitservers.Checked;
    if Win98 then
      Memory_Limit := 1048576 * Int64(Edit_Limits_Memory.Value)
    else
      Memory_Limit := 0;
  except
  end
  else if Pages.ActivePage = Sh_Log then
  try
    Log_Login := Cb_Log_Login.Checked;
    Log_Napigator := Cb_Log_Napigator.Checked;
    Log_Dagsta := Cb_Log_Dagsta.Checked;
    Log_Search := Cb_Log_Search.Checked;
    Log_Browse := Cb_Log_Browse.Checked;
    Log_Transfers := Cb_Log_Transfers.Checked;
    //   Log_Links := Cb_Log_Links.Checked;
    Log_To_File := Cb_Log_Save.Checked;
    Log_Commands := Cb_Log_Users.Checked;
    Log_Servercommands := Cb_Log_Servers.Checked;
    Save_Stats := Cb_Log_Serverstats.Checked;
    Clear_Serverstats := Cb_Log_Clearserverstats.Checked;
    Clear_Clientstats := Cb_Log_Clearclientstats.Checked;
    Log_Console_Data := Cb_Log_Console.Checked;
  except
  end
  else if Pages.ActivePage = Sh_Share then
  try
    MaxShare := Edit_Share_Max.Value;
    MaxShare_Total := Edit_Share_MaxTotal.Value;
    MinFileName := Edit_Share_FileName.Value;
    MinDuration := Edit_Share_Duration.Value;
    Share_Auto_FriendAdd_Minimum := Edit_Share_FriendAdd.Value;
    Auto_FriendAdd := Cb_Share_FriendAdd.Checked;
    Allow_Share := not Cb_Share_Disable.Checked;
    ShareInform := Cb_Share_Inform.Checked;
    Share_Nomodem := Cb_Share_Nomodem.Checked;
    MaxShareIndex := Edit_Share_MaxIndex.Value;
    Share_Checkdup := Cb_Share_Checkdup.Checked;
  except
  end
  else if Pages.ActivePage = Sh_Share_Mp3 then
  try
    Ext_Mp3 := Edit_Mp3_Ext.Text;
    if Running then
      Cmd_List.AddDoublecmd(MSG_CMD_REFRESHTYPES, 0, '', '');
    MaxShare_Mp3 := Edit_Mp3_Max.Value;
    MinFileSize_Mp3 := Int64(Edit_Mp3_MinSize.Value) * 1024;
    MaxFileSize_Mp3 := Int64(Edit_Mp3_MaxSize.Value) * 1024;
    Share_320 := Cb_Mp3_320.Checked;
    Share_256 := Cb_Mp3_256.Checked;
    Share_224 := Cb_Mp3_224.Checked;
    Share_192 := Cb_Mp3_192.Checked;
    Share_160 := Cb_Mp3_160.Checked;
    Share_128 := Cb_Mp3_128.Checked;
    Share_112 := Cb_Mp3_112.Checked;
    Share_96 := Cb_Mp3_96.Checked;
    Share_80 := Cb_Mp3_80.Checked;
    Share_64 := Cb_Mp3_64.Checked;
    Share_56 := Cb_Mp3_56.Checked;
    Share_48 := Cb_Mp3_48.Checked;
    Share_40 := Cb_Mp3_40.Checked;
    Share_32 := Cb_Mp3_32.Checked;
    Share_24 := Cb_Mp3_24.Checked;
    Share_Unknown := Cb_Mp3_0.Checked;
  except
  end
  else if Pages.ActivePage = Sh_Share_Audio then
  try
    Ext_Audio := Edit_Audio_Ext.Text;
    if Running then
      Cmd_List.AddDoublecmd(MSG_CMD_REFRESHTYPES, 0, '', '');
    MaxShare_Audio := Edit_Audio_Max.Value;
    MinFileSize_Audio := Int64(Edit_Audio_MinSize.Value) * 1024;
    MaxFileSize_Audio := Int64(Edit_Audio_MaxSize.Value) * 1024;
  except
  end
  else if Pages.ActivePage = Sh_Share_Video then
  try
    Ext_Video := Edit_Video_Ext.Text;
    if Running then
      Cmd_List.AddDoublecmd(MSG_CMD_REFRESHTYPES, 0, '', '');
    MaxShare_Video := Edit_Video_Max.Value;
    MinFileSize_Video := Int64(Edit_Video_MinSize.Value) * 1024;
    MaxFileSize_Video := Int64(Edit_Video_MaxSize.Value) * 1024;
  except
  end
  else if Pages.ActivePage = Sh_Share_Images then
  try
    Ext_Image := Edit_Images_Ext.Text;
    if Running then
      Cmd_List.AddDoublecmd(MSG_CMD_REFRESHTYPES, 0, '', '');
    MaxShare_Image := Edit_Images_Max.Value;
    MinFileSize_Image := Int64(Edit_Images_MinSize.Value) * 1024;
    MaxFileSize_Image := Int64(Edit_Images_MaxSize.Value) * 1024;
  except
  end
  else if Pages.ActivePage = Sh_Share_Apps then
  try
    Ext_App := Edit_Apps_Ext.Text;
    if Running then
      Cmd_List.AddDoublecmd(MSG_CMD_REFRESHTYPES, 0, '', '');
    MaxShare_App := Edit_Apps_Max.Value;
    MinFileSize_App := Int64(Edit_Apps_MinSize.Value) * 1024;
    MaxFileSize_App := Int64(Edit_Apps_MaxSize.Value) * 1024;
  except
  end
  else if Pages.ActivePage = Sh_Share_Cd then
  try
    Ext_Cd := Edit_Cd_Ext.Text;
    if Running then
      Cmd_List.AddDoublecmd(MSG_CMD_REFRESHTYPES, 0, '', '');
    MaxShare_Cd := Edit_Cd_Max.Value;
    MinFileSize_Cd := Int64(Edit_Cd_MinSize.Value) * 1024;
    MaxFileSize_Cd := Int64(Edit_Cd_MaxSize.Value) * 1024;
  except
  end
  else if Pages.ActivePage = Sh_Share_Text then
  try
    Ext_Text := Edit_Text_Ext.Text;
    if Running then
      Cmd_List.AddDoublecmd(MSG_CMD_REFRESHTYPES, 0, '', '');
    MaxShare_Text := Edit_Text_Max.Value;
    MinFileSize_Text := Int64(Edit_Text_MinSize.Value) * 1024;
    MaxFileSize_Text := Int64(Edit_Text_MaxSize.Value) * 1024;
  except
  end
  else if Pages.ActivePage = Sh_Search then
  try
    DefSearchResults := Edit_Search_DefSearch.Value;
    MaxSearchResults := Edit_Search_MaxSearch.Value;
    MaxBrowseResults := Edit_Search_MaxBrowse.Value;
    MaxRemoteBrowse := Edit_Search_MaxRemoteBrowse.Value;
    Flood_Max_Searches := Edit_Search_Searchespm.Value;
    DisableRemoteSearch := Cb_Search_Disable_Remote.Checked;
    MaxRemoteSearchResults := Edit_Search_MaxRemote.Value;
  except
  end
  else if Pages.ActivePage = Sh_Channels then
  try
    Allow_Create_Channels := Cb_Channels_Allowcreate.Checked;
    Max_Channels := Edit_Channels_Max.Value;
    Max_Channels_Total := Edit_Channels_Max2.Value;
    Block_Cqex_Chat := Cb_Channels_Blockcqex.Checked;
    Old_Opsay := Cb_Channels_Oldwallop.Checked;
    Channels_Timestamp := Cb_Channels_Timestamp.Checked;
    Max_Privmsg_Len := Edit_Channels_MaxPrivMessage.Value;
    Max_Channelmsg_Len := Edit_Channels_MaxMessage.Value;
    Show_Operators := Cb_Channels_Showops.Checked;
    Prevent_Shouting := Cb_Channels_Preventshout.Checked;
    Flood_Enable := Cb_Channels_Floodenable.Checked;
    Flood_Max_User_Message := Edit_Channels_Flood_User.Value;
    Flood_Max_Same_Message := Edit_Channels_Flood_Same.Value;
    Flood_Warning := Cb_Channels_Flood_Warn.Checked;
    Ini.WriteBool('Channels', 'TimeStamp', Cb_Channels_Timestamp.Checked);
    Ini.WriteBool('Channels', 'LowerCase', Cb_Channels_Low.Checked);
  except
  end
  else if Pages.ActivePage = Sh_interface then
  try
    Remote_Admin_Ok := Cb_Interface_Remoteadminok.Checked;
    Remote_Adminpass := Edit_Interface_Remotepass.Text;
    Cpu_Usage := Edit_Interface_Cpu.Value;
    Cpu_Disable := Cb_Interface_Nocpu.Checked;
    Switch_Chat := not Cb_Interface_Noswitch.Checked;
    Chat_Flash := Cb_Interface_Chatflash.Checked;
    Chat_Mini := Cb_Interface_Chatmini.Checked;
    Wallop_Im := Cb_Interface_Wallop.Checked;
    Wallop_Sound := Cb_Interface_Wallopsound.Checked;
    if Cb_Interface_SysTray.Checked <> SlavaNapwindow.Tray.Active then
    begin
      SlavaNapWindow.Tray.Active := Cb_Interface_SysTray.Checked;
      if not SlavaNapWindow.Visible then
        SlavaNapWindow.Show;
    end;
    Reg := TRegistry.Create;
    try
      Reg.RootKey := HKEY_LOCAL_MACHINE;
      Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run', True);
      if Cb_Interface_Startup.Checked then
        Reg.WriteString('SlavaNap', Application.ExeName + ' -hide')
      else
        Reg.DeleteValue('SlavaNap');
    except
    end;
    Reg.Free;
  except
  end
  else if Pages.ActivePage = Sh_Levels then
  try
    Levels[0] := Edit_Level_0.Text;
    Levels[1] := Edit_Level_1.Text;
    Levels[2] := Edit_Level_2.Text;
    Levels[3] := Edit_Level_3.Text;
    Levels[4] := Edit_Level_4.Text;
    Levels[5] := Edit_Level_5.Text;
  except
  end
  else if Pages.ActivePage = Sh_Napigator then
  try
    Napigator_Host := Edit_Napigator_Host.Text;
    Napigator_Port := Edit_Napigator_Port.Text;
    Napigator_User := Edit_Napigator_User.Text;
    if List_Napigator_MyPort.ItemIndex <> -1 then
      Napigator_MyPort :=
        StrToIntDef(List_Napigator_MyPort.Items.Strings[List_Napigator_MyPort.ItemIndex], Napigator_MyPort);
    Napigator_Enabled := Cb_Napigator_Enabled.Checked;
    Napigator_Myip := Trim(Edit_Napigator_Myip.Text);
    Napigator_Autodisconnect := Cb_Napigator_Autodisconnect.Checked;
    Napigator_Delay := Edit_Napigator_Delay.Value * 60000;
  except
  end
  else if Pages.ActivePage = Sh_Dagsta then
  try
    Dagsta_Host := Edit_Dagsta_Host.Text;
    Dagsta_Port := Edit_Dagsta_Port.Text;
    Dagsta_User := Edit_Dagsta_User.Text;
    if List_Dagsta_MyPort.ItemIndex <> -1 then
      Dagsta_MyPort :=
        StrToIntDef(List_Dagsta_MyPort.Items.Strings[List_Dagsta_MyPort.ItemIndex], Dagsta_MyPort);
    Dagsta_Enabled := Cb_Dagsta_Enabled.Checked;
    Dagsta_Myip := Trim(Edit_Dagsta_Myip.Text);
    Dagsta_Autodisconnect := Cb_Dagsta_Autodisconnect.Checked;
    Dagsta_Delay := Edit_Dagsta_Delay.Value * 60000;
  except
  end
  else if Pages.ActivePage = Sh_Blocked then
  try
    Blocked_Clients[softNapster] := Cb_Block_Napster.Checked;
    Blocked_Clients[softAudioGnome] := Cb_Block_Audiognome.Checked;
    Blocked_Clients[softGnomePlus] := Cb_Block_Gnomeplus.Checked;
    Blocked_Clients[softAmster] := Cb_Block_Amster.Checked;
    Blocked_Clients[softFileNavigator] := Cb_Block_Filenavigator.Checked;
    Blocked_Clients[softCQEX] := Cb_Block_Cqex.Checked;
    Blocked_Clients[softSunshineUN] := Cb_Block_Sunshineun.Checked;
    Blocked_Clients[softTekNap] := Cb_Block_Teknap.Checked;
    Blocked_Clients[softNap] := Cb_Block_Nap.Checked;
    Blocked_Clients[softMacNap] := Cb_Block_Macnap.Checked;
    Blocked_Clients[softMP3Rage] := Cb_Block_Mp3rage.Checked;
    Blocked_Clients[softXNap] := Cb_Block_Xnap.Checked;
    Blocked_Clients[softSpotlight] := Cb_Block_Spotlight.Checked;
    Blocked_Clients[softNFS] := Cb_Block_Nfs.Checked;
    Blocked_Clients[softDMNapster] := Cb_Block_Dmnapster.Checked;
    Blocked_Clients[softKNapster] := Cb_Block_Knapster.Checked;
    Blocked_Clients[softLopster] := Cb_Block_Lopster.Checked;
    Blocked_Clients[softRapigator] := Cb_Block_Rapigator.Checked;
    Blocked_Clients[softSwaptor] := Cb_Block_Swaptor.Checked;
    Blocked_Clients[softDagsta] := Cb_Block_Dagsta.Checked;
    Blocked_Clients[softDrumbeat] := Cb_Block_Drumbeat.Checked;
    Blocked_Clients[softFloodster] := Cb_Block_Floodster.Checked;
    Blocked_Clients[softMlDonkey] := Cb_Block_Mldonkey.Checked;
    Blocked_Clients[softOpennap] := Cb_Block_Opennap.Checked;
    Blocked_Clients[softNapigator] := Cb_Block_Napigator.Checked;
    Blocked_Clients[softNap08] := Cb_Block_Nap08.Checked;
    Blocked_Clients[softUnknown] := Cb_Block_Other.Checked;
    Blocked_Message := Edit_Block_Message.Text;
    Blocked_Custom[0] := AnsiLowerCase(Edit_Block_Sign0.Text);
    Blocked_Custom[1] := AnsiLowerCase(Edit_Block_Sign1.Text);
    Blocked_Custom[2] := AnsiLowerCase(Edit_Block_Sign2.Text);
    Blocked_Custom[3] := AnsiLowerCase(Edit_Block_Sign3.Text);
    Blocked_Custom[4] := AnsiLowerCase(Edit_Block_Sign4.Text);
    Blocked_Custom[5] := AnsiLowerCase(Edit_Block_Sign5.Text);
    if Cb_Block_Custommessage.Checked then
      Blocked_Messagetype := blckCustom
    else if Cb_Block_Nomessage.Checked then
      Blocked_Messagetype := blckNone
    else
      Blocked_Messagetype := blckDefault;
  except
  end
  else if Pages.ActivePage = Sh_Blocked_Winmx then
  try
    Blocked_Clients[softWinMXNormal] := Cb_Blockmx_Normal.Checked;
    Blocked_Clients[softWinMXJap] := Cb_Blockmx_Jap.Checked;
    Blocked_Clients[softWinMXHidden] := Cb_Blockmx_Detect.Checked;
    Ban_FakeMX := Cb_Blockmx_Ban.Checked;
    Mx_Ban := Edit_Blockmx_Bantime.Value * 3600;
    Mx_UsePing := Cb_Blockmx_Pong.Checked;
    Limit_Mx := Cb_Blockmx_Limit.Checked;
    Quota_Mx := Edit_Blockmx_Quota.Value;
  except
  end
  else if Pages.ActivePage = Sh_Blocks then
  try
    Block_AllowShare := Cb_Blocks_Allow_Share.Checked;
    Block_AllowShare_Admins := Cb_Blocks_Allow_Share_Admins.Checked;
    Block_CheckMods := Cb_Blocks_CheckMods.Checked;
  except
  end
  else if Pages.ActivePage = Sh_Console then
  try
    if not Check_Name(Edit_Console_User.Text, True) then
    begin
      ShowMessage(RS_Settings_InvalidUserName);
      Exit;
    end;
    Ini.WriteString('Console', 'User', Edit_Console_User.Text);
    Ini.WriteString('Console', 'AutoJoinRoom1', Edit_Cons_Autojoin1.Text);
    Ini.WriteString('Console', 'AutoJoinRoom2', Edit_Cons_Autojoin2.Text);
    Ini.WriteString('Console', 'AutoJoinRoom3', Edit_Cons_Autojoin3.Text);
    if Running then
      if Ord(Cons.Data^.Speed) <> Edit_Console_Speed.ItemIndex then
        Cmd_List.AddDoubleCmd(MSG_CLIENT_CHANGE_SPEED, 0,
          IntToStr(Edit_Console_Speed.ItemIndex), '');
  except
  end
  else if Pages.ActivePage = Sh_Links then
  try
    if Cb_Link_All.Checked then
      Allow_Link := linkAll
    else if Cb_Link_None.Checked then
      Allow_Link := linkNone
    else if Cb_Link_List2.Checked then
      Allow_Link := linkCustom
    else
      Allow_Link := linkList;
    Allowed_Servers := LowerCase(Edit_Link_List.Text);
    Network_Hub := Cb_Link_Hub.Checked;
    if Network_Hub then
      Registered_Only := False;
    Hub_Syncreg := Cb_Link_Syncreg.Checked;
    Hub_Syncban := Cb_Link_Syncban.Checked;
    Hub_SyncBlock := Cb_Link_SyncBlock.Checked;
    AutoLink_Only1 := Cb_Link_Noautoconnect.Checked;
    Restrict_Outgoing := Cb_Link_RestrictOutgoing.Checked;
    Outgoing_List := LowerCase(Edit_Link_Outgoinglist.Text);
    {Meta_Enabled := Cb_Meta_Enabled.Checked;
    Meta_Port := Edit_Meta_Port.Value;}
    Max_Servers_Enabled := Cb_Link_MaxServers.Checked;
    Max_Servers := Edit_Link_MaxServers.Value;
  except
  end
  else if Pages.ActivePage = Sh_Links2 then
  try
    Search_Noforward_Results := Cb_Link2_LagNoSearch.Checked;
    Search_Noforward_Requests := Cb_Link2_LagNoSearchReq.Checked;
    Browse_Noforward_Results := Cb_Link2_Lagnobrowse.Checked;
    Browse_Noforward_Requests := Cb_Link2_Lagnobrowsereq.Checked;
  except
  end
  else if Pages.ActivePage = Sh_Sockets then
  try
    Sockets_Users_default := Cb_Sockets_Users_Def.Checked;
    Sockets_Users_Send := Edit_Sockets_Users_Send.Value;
    Sockets_Users_Recv := Edit_Sockets_Users_Recv.Value;
    Sockets_Servers_default := Cb_Sockets_Servers_Def.Checked;
    Sockets_Servers_Send := Edit_Sockets_Servers_Send.Value;
    Sockets_Servers_Recv := Edit_Sockets_Servers_Recv.Value;
  except
  end
  else if Pages.ActivePage = Sh_Other then
  try
    Ann_Enabled := Cb_Ann_Enable.Checked;
    Ann_Delay := Edit_Ann_Delay.Value;
    Ann_User := Edit_Ann_User.Text;
    for I := 0 to Max_Announcement do
      Ann_Messages[I] := '';
    for I := 0 to Edit_Ann_Messages.Lines.Count - 1 do
      if Trim(Edit_Ann_Messages.Lines.Strings[I]) <> '' then
        Ann_Messages[I] := Trim(Edit_Ann_Messages.Lines.Strings[I]);
  except
  end
  else if Pages.ActivePage = Sh_Report then
  try
    Old_Report_Enabled := Cb_Report_Old_Enable.Checked;
    Old_Report_Port := Edit_Report_Old_Port.Value;
    New_Report_Enabled := Cb_Report_New_Enabled.Checked;
    New_Report_Port := Edit_Report_New_Port.Value;
    New_Report_Hide_Hub := Cb_Report_New_Hidehub.Checked;
    True_Stats := Cb_Report_Truestats.Checked;
  except
  end
  else if Pages.ActivePage = Sh_MinShare then
  try
    MinShare := Edit_MinShare_MinShare.Value;
    MinShare_Delay := Int64(Edit_MinShare_Delay.Value) * 60000;
    MinShare_Ban := Cb_MinShare_Ban.Checked;
    MinShare_Banip := Cb_MinShare_Banip.Checked;
    MinShare_Bantime := Edit_MinShare_Bantime.Value * 60;
    MinShare_Fullonly := Cb_MinShare_Onlyfull.Checked;
    MinShare_Size := Int64(Edit_MinShare_MinSharesize.Value) * MegaByte;
    MinShare_Only10 := Cb_MinShare_Full10.Checked;
    MinShare_Kickchat := Cb_MinShare_Kickchat.Checked;
    Wallop_Serverban := Cb_MinShare_Wallop.Checked;
  except
  end
  else if Pages.ActivePage = Sh_Motd then
  try
    Edit_Motd.Lines.SaveToFile(ApplicationDir + 'motd');
    if Running then
      Cmd_List.AddDoubleCmd(MSG_CMD_MOTDCHANGE, 0, '', '');
  except
  end
  else if Pages.ActivePage = Sh_Other2 then
  try
    SearchBlock_ChkFiles := Cb_SearchBlock_ChkFiles.Checked;
    SearchBlock_ChkSize := Cb_SearchBlock_ChkSize.Checked;
    SearchBlock_Files := Edit_SearchBlock_Files.Value;
    SearchBlock_Size := Edit_SearchBlock_Size.Value * MegaByte;
    SearchBlock_Hard := Rd_SearchBlock_Hard.Checked;

    DomBlock_ChkFiles := Cb_DomBlock_ChkFiles.Checked;
    DomBlock_ChkSize := Cb_DomBlock_ChkSize.Checked;
    DomBlock_Files := Edit_DomBlock_Files.Value;
    DomBlock_Size := Edit_DomBlock_Size.Value * MegaByte;
    DomBlock_Hard := Rd_DomBlock_Hard.Checked;

    if Rd_DLFloodBlock_Leech.Checked then
      DLFloodBlock_Method := Leech
    else if Rd_DLFloodBlock_Ban.Checked then
      DLFloodBlock_Method := Ban
    else
      DLFloodBlock_Method := Block;
    DLFloodBlock_Count := Edit_DLFloodBlock.Value;
    DLFloodBlock_Bantime := GetBanID(Edit_DLFloodBlock_Bantime);

    if Rd_WQFloodBlock_Leech.Checked then
      WQFloodBlock_Method := Leech
    else if Rd_WQFloodBlock_Ban.Checked then
      WQFloodBlock_Method := Ban
    else
      WQFloodBlock_Method := Block;
    WQFloodBlock_Count := Edit_WQFloodBlock.Value;
    WQFloodBlock_Bantime := GetBanID(Edit_WQFloodBlock_Bantime);

    Nocount_Text := Cb_Nocount_Text.Checked;
    Autoban_Incomplete := Cb_Autoban_Incomplete.Checked;
    Disable_FakeExt := Cb_Disable_Fakeext.Checked;
    Fakeext := Edit_Fakeext.Text;
    Enable_TrapPort := Cb_Enable_TrapPort.Checked;
    Ini.WriteString('Other2', 'TrapPort', Edit_TrapPort.Text);
    Block_TransferPort := Cb_Block_TransferPort.Checked;
    Blocked_TransferPort := Edit_Blocked_TransferPort.Text;
    SplitString(Blocked_TransferPort, Blocked_TransferPort_List);

    Share_MatchedFile_Only := Cb_Share_MatchedFile_Only.Checked;
  except
  end
  else if Pages.ActivePage = Sh_Other3 then
  try
    Enable_LoginIM := Cb_Enable_LoginIM.Checked;
    LoginIMBot := Edit_LoginIMBot.Text;
    for I := 0 to Max_LoginIM do
      LoginIM[I] := '';
    for I := 0 to Edit_LoginIM.Lines.Count - 1 do
      if Trim(Edit_LoginIM.Lines.Strings[I]) <> '' then
        LoginIM[I] := Trim(Edit_LoginIM.Lines.Strings[I]);
    Force_Enter := Cb_Channels_Forceenter.Checked;
    Force_Enter_Channel := Edit_Channels_Forceenter.Text;
    SplitString(Force_Enter_Channel, Force_Enter_Channel_List);
    if Force_Enter then
    begin
      P := Force_Enter_Channel_List.First;
      while P <> nil do
      begin
        if FindChannel(P^.Data) = nil then
        begin
          Ch := TChannel.Create(P^.Data);
          Include(Ch.State, chRegistered);
          DB_Channels.Add(Ch);
        end;
        P := P^.Next;
      end;
    end;
    Allow_2ByteName := Cb_Allow_2ByteName.Checked;
    Check_Loginpass := Cb_Check_Loginpass.Checked;
    Loginpass := Edit_Loginpass.Text;
    Enable_Msgserv := Cb_Enable_Msgserv.Checked;
    Restrict_Hitperuser := Cb_Restrict_Hitperuser.Checked;
    MaxHitPerUser := Edit_Hitperuser.Value;
    case Rd_Xbutton_Attr.ItemIndex of
      0: B3_Canclose := Unknown3;
      1: B3_Canclose := True3;
      2: B3_Canclose := False3;
    end;
    MinShare_NoBlockAct := Cb_MinShare_NoBlockAct.Checked;
    Kill_Idleuser := Cb_Kill_Idleuser.Checked;
    Kill_Idleuser_Time := Edit_Kill_Idleuser_Time.Value * 60000;
    Listall_for_Users := not Cb_Deny_Listall_for_Users.Checked;
    Block_Weird_XnapFile := Cb_Block_Weird_XnapFile.Checked;
    Suggest_DBrowse := Cb_Suggest_DBrowse.Checked;
    Allow_Rtf_Code := Cb_Allow_Rtf_Code.Checked;
    Disable_Nullip := Cb_Disable_Nullip.Checked;
  except
  end
  else if Pages.ActivePage = Sh_Other4 then
  try
    Blocked_Clients[softNapchan] := Cb_Block_Napchan.Checked;
    Blocked_Clients[softUtatane] := Cb_Block_Utatane.Checked;
    Blocked_Clients[soft2get] := Cb_Block_2get.Checked;
    Blocked_Clients[softRegnessem] := Cb_Block_Regnessem.Checked;
    if Log_Folder <> Edit_Log_Folder.Text then
    begin
      Log_File.Free;
      ShortDateFormat := 'yyyymmdd';
      // LogFileName := ApplicationDir + 'server-' + DateToStr(Now) + '.log';
      LogFileName := Edit_Log_Folder.Text + 'server-' + DateToStr(Now) + '.log';
      ShortDateFormat := 'yyyy/mm/dd';
      if not FileExists(LogFileName) then
      try
        Log_File := TFileStream.Create(LogFileName, fmCreate);
        Log_File.Free;
      except
      end;
      try
        Log_File := TFileStream.Create(LogFileName, fmOpenWrite or
          fmShareDenyWrite);
        Log_File.Seek(0, soFromEnd);
      except
        Log_File := nil;
        LogStartup('Settings::Btn_ChangeClick: Cannot open "' + LogFileName +
          '" !!!');
        DebugLog('Error: Cannot open File ' + LogFileName);
      end;
    end;
    Log_Folder := Edit_Log_Folder.Text;
    Max_Resolving_Count := Edit_Max_Resolving_Count.Value;
    with SlavaNapWindow do
    begin
      Cb_Users_Refresh.Checked := Cb_Refresh_Users.Checked;
      Edit_Users_Refresh.Value := Edit_Usersreftime.Value;
      Cb_Servers_Refresh.Checked := Cb_Refresh_Servers.Checked;
      Edit_Servers_Refresh.Value := Edit_Servreftime.Value;
    end;
    Enable_Metaserver := Cb_Enable_Metaserver.Checked;
    MetaPort := Edit_MetaPort.Text;
    List := TMyStringList.Create;
    SplitString(MetaPort, List);
    SetLength(MetaPort_List, List.Count);
    for I := 0 to List.Count - 1 do
      MetaPort_List[I] := StrToIntDef(List[I], -1);
    List.Free;
    Redirected_Server := '';
    Redirected_Server_Chk := '';
    Redirected_Servers.Clear;
    with Edit_Redirected_List do
      for I := 0 to Count - 1 do
      begin
        Redirected_Server := Redirected_Server + Items.Strings[I] + ' ';
        Redirected_Server_Chk := Redirected_Server_Chk +
          IntToStr(Integer(Checked[I])) + ' ';
        Redirected_Servers.AddCmd(Integer(Checked[I]), Items.Strings[I]);
      end;
  except
  end;
  Ini.UpdateFile;
  Btn_RestoreClick(nil);
end;

procedure TSlavaNapSettings.Btn_Level_DefaultClick(Sender: TObject);
begin
  Edit_Level_0.Text := 'Leech';
  Edit_Level_1.Text := 'User';
  Edit_Level_2.Text := 'Moderator';
  Edit_Level_3.Text := 'Admin';
  Edit_Level_4.Text := 'Elite';
  Edit_Level_5.Text := 'Console';
  Btn_ChangeClick(nil);
end;

procedure TSlavaNapSettings.Btn_Napigator_DisconnectClick(Sender: TObject);
begin
  if not Running then Exit;
  if Napigator_Socket <> INVALID_SOCKET then
  begin
    DoCloseSocket(Napigator_Socket);
    Napigator_Socket := INVALID_SOCKET;
  end;
end;

procedure TSlavaNapSettings.Btn_Napigator_PasswordClick(Sender: TObject);
begin
  if Sender = Btn_Napigator_Password then
    SlavaNapEdit.Ask(SE_NAPIGATORPASS)
  else
    SlavaNapEdit.Ask(SE_DAGSTAPASS);
end;

procedure TSlavaNapSettings.Cb_Log_ServerstatsClick(Sender: TObject);
begin
  Cb_Log_Clearserverstats.Visible := Cb_Log_Serverstats.Checked;
end;

procedure TSlavaNapSettings.Cb_Block_CustommessageClick(Sender: TObject);
begin
  Lbl_Block_Message.Visible := Cb_Block_Custommessage.Checked;
  Edit_Block_Message.Visible := Cb_Block_Custommessage.Checked;
end;

procedure TSlavaNapSettings.Cb_Search_Disable_RemoteClick(Sender: TObject);
begin
  Lbl_Search_MaxRemote.Visible := not Cb_Search_Disable_Remote.Checked;
  Edit_Search_MaxRemote.Visible := not Cb_Search_Disable_Remote.Checked;
end;

procedure TSlavaNapSettings.Cb_Sockets_Users_DefClick(Sender: TObject);
begin
  Edit_Sockets_Users_Send.Visible := not Cb_Sockets_Users_Def.Checked;
  Edit_Sockets_Users_Recv.Visible := not Cb_Sockets_Users_Def.Checked;
  Lbl_Sockets_Users_Send.Visible := not Cb_Sockets_Users_Def.Checked;
  Lbl_Sockets_Users_Recv.Visible := not Cb_Sockets_Users_Def.Checked;
end;

procedure TSlavaNapSettings.Cb_Sockets_Servers_DefClick(Sender: TObject);
begin
  Edit_Sockets_Servers_Send.Visible := not Cb_Sockets_Servers_Def.Checked;
  Edit_Sockets_Servers_Recv.Visible := not Cb_Sockets_Servers_Def.Checked;
  Lbl_Sockets_Servers_Send.Visible := not Cb_Sockets_Servers_Def.Checked;
  Lbl_Sockets_Servers_Recv.Visible := not Cb_Sockets_Servers_Def.Checked;
end;

procedure TSlavaNapSettings.Cb_MinShare_OnlyfullClick(Sender: TObject);
begin
  Cb_MinShare_Full10.Visible := Cb_MinShare_Onlyfull.Checked;
end;

procedure TSlavaNapSettings.ChangeColors;
begin
  Tree.Color := slBackground;
  Tree.Font.Color := slText;
end;

procedure TSlavaNapSettings.Btn_Colors_DefaultClick(Sender: TObject);
begin
  slBackground := $FFFFFF;
  slText := 0;
  slError := $0000FF;
  slWallop := $A06000;
  slAnnounce := $A00060;
  slWhowas := $600060;
  slPong := $600060;
  slOffline := $603000;
  slOnline := $A06000;
  slDebugData := $000060;
  slNapigator := $006000;
  slDagsta := $008000;
  slSearch := $A000A0;
  slBrowse := $E000E0;
  slTransfer := $600060;
  slTopic := $B00060;
  slChannelMessage := 0;
  slChannelMyMessage := $404040;
  slChannelEmote := $606000;
  slChannelMyEmote := $808000;
  slChannelJoin := $A06000;
  slChannelPart := $603000;
  slChatMessage := $A00000;
  slChatMyMessage := 0;
  ChangeColors;
  if Running then
    SlavaNapWindow.SetColors(True);
  Btn_RestoreClick(nil);
end;

procedure TSlavaNapSettings.Btn_Color_ChClick(Sender: TObject);
var
  I: Integer;
  C: TColor;
begin
  if not (Sender Is TSpeedButton) then Exit;
  I := (Sender as TSpeedButton).Tag;
  if I = 0 then Exit;
  Cd.Tag := I;
  case I of
    1: C := Edit_Color_Bg.ColorValue;
    2: C := Edit_Color_Chat.ColorValue;
    3: C := Edit_Color_Mychat.ColorValue;
    4: C := Edit_Color_Channelchat.ColorValue;
    5: C := Edit_Color_Mychannelchat.ColorValue;
    6: C := Edit_Color_Emote.ColorValue;
    7: C := Edit_Color_Myemote.ColorValue;
    8: C := Edit_Color_Join.ColorValue;
    9: C := Edit_Color_Part.ColorValue;
    10: C := Edit_Color_Topic.ColorValue;
    11: C := Edit_Color_Debug.ColorValue;
    12: C := Edit_Color_Text.ColorValue;
    13: C := Edit_Color_Error.ColorValue;
    14: C := Edit_Color_Wallop.ColorValue;
    15: C := Edit_Color_Announce.ColorValue;
    16: C := Edit_Color_Online.ColorValue;
    17: C := Edit_Color_Offline.ColorValue;
    18: C := Edit_Color_Search.ColorValue;
    19: C := Edit_Color_Transfer.ColorValue;
    20: C := Edit_Color_Napigator.ColorValue;
    21: C := Edit_Color_Pong.ColorValue;
    22: C := Edit_Color_Whowas.ColorValue;
    23: C := Edit_Color_Dagsta.ColorValue;
    24: C := Edit_Color_Browse.ColorValue;
  else
    Exit;
  end;
  Cd.Color := C;
  if not Cd.Execute then Exit;
  C := Cd.Color;
  case cd.Tag of
    1: Edit_Color_Bg.ColorValue := C;
    2: Edit_Color_Chat.ColorValue := C;
    3: Edit_Color_Mychat.ColorValue := C;
    4: Edit_Color_Channelchat.ColorValue := C;
    5: Edit_Color_Mychannelchat.ColorValue := C;
    6: Edit_Color_Emote.ColorValue := C;
    7: Edit_Color_Myemote.ColorValue := C;
    8: Edit_Color_Join.ColorValue := C;
    9: Edit_Color_Part.ColorValue := C;
    10: Edit_Color_Topic.ColorValue := C;
    11: Edit_Color_Debug.ColorValue := C;
    12: Edit_Color_Text.ColorValue := C;
    13: Edit_Color_Error.ColorValue := C;
    14: Edit_Color_Wallop.ColorValue := C;
    15: Edit_Color_Announce.ColorValue := C;
    16: Edit_Color_Online.ColorValue := C;
    17: Edit_Color_Offline.ColorValue := C;
    18: Edit_Color_Search.ColorValue := C;
    19: Edit_Color_Transfer.ColorValue := C;
    20: Edit_Color_Napigator.ColorValue := C;
    21: Edit_Color_Pong.ColorValue := C;
    22: Edit_Color_Whowas.ColorValue := C;
    23: Edit_Color_Dagsta.ColorValue := C;
    24: Edit_Color_Browse.ColorValue := C;
  else
    Exit;
  end;
end;

procedure TSlavaNapSettings.Cb_Channels_FloodenableClick(Sender: TObject);
begin
  Lbl_Flood1.Visible := Cb_Channels_Floodenable.Checked;
  Lbl_Flood2.Visible := Cb_Channels_Floodenable.Checked;
  Edit_Channels_Flood_User.Visible := Cb_Channels_Floodenable.Checked;
  Edit_Channels_Flood_Same.Visible := Cb_Channels_Floodenable.Checked;
  Cb_Channels_Flood_Warn.Visible := Cb_Channels_Floodenable.Checked;
end;

procedure TSlavaNapSettings.Btn_Dagsta_DisconnectClick(Sender: TObject);
begin
  if not Running then Exit;
  if Dagsta_Socket <> INVALID_SOCKET then
  begin
    DoCloseSocket(Dagsta_Socket);
    Dagsta_Socket := INVALID_SOCKET;
  end;
end;

procedure TSlavaNapSettings.Label137Click(Sender: TObject);
begin
  ShellExecute(Handle, PChar('open'), PChar('http://www.dagsta.com/?register'),
    nil, nil, SW_ShowNormal);
end;

procedure TSlavaNapSettings.Cb_Blockmx_LimitClick(Sender: TObject);
begin
  Lbl_Blockmx_Percentage.Visible := Cb_Blockmx_Limit.Checked;
  Edit_Blockmx_Quota.Visible := Cb_Blockmx_Limit.Checked;
end;

procedure TSlavaNapSettings.Sh_Blocked_WinmxShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_BLOCKED));
  SetChange(True);
  Cb_Blockmx_Normal.Checked := Blocked_Clients[softWinMXNormal];
  Cb_Blockmx_Jap.Checked := Blocked_Clients[softWinMXJap];
  Cb_Blockmx_Detect.Checked := Blocked_Clients[softWinMXHidden];
  Cb_Blockmx_Ban.Visible := Blocked_Clients[softWinMXHidden];
  // Cb_Blockmx_Pong.Visible := Blocked_Clients[softWinMXHidden];
  Label142.Visible := Ban_FakeMX;
  Cb_Blockmx_Ban.Checked := Ban_FakeMX;
  Edit_Blockmx_Bantime.Visible := Ban_FakeMX;
  Edit_Blockmx_Bantime.Value := Mx_Ban div 3600;
  Cb_Blockmx_Limit.Checked := Limit_Mx;
  Edit_Blockmx_Quota.Value := Quota_Mx;
  Cb_Blockmx_Pong.Checked := Mx_UsePing;
  Cb_Blockmx_LimitClick(nil);
end;

procedure TSlavaNapSettings.Edit_Main_AliasChange(Sender: TObject);
var
  I: Integer;
  Str: string;
begin
  Str := Edit_Main_Alias.Text;
  if Length(Str) > 0 then
    for I := 0 to Edit_Main_Alias.GetTextLen do
      if Str[I] = ' ' then
        Str[I] := '_';
  Edit_Main_Alias.Text := Str;
end;

procedure TSlavaNapSettings.Sh_BlocksShow(Sender: TObject);
begin
  SetTopText(GetLangI(LNG_S_TEXT_BLOCKS));
  SetChange(True);
  Cb_Blocks_Allow_Share.Checked := Block_AllowShare;
  Cb_Blocks_Allow_Share_Admins.Checked := Block_AllowShare_Admins;
  Cb_Blocks_CheckMods.Checked := Block_CheckMods;
end;

procedure TSlavaNapSettings.Cb_Share_FriendAddClick(Sender: TObject);
begin
  Edit_Share_FriendAdd.Visible := Cb_Share_FriendAdd.Checked;
  Label149.Visible := Cb_Share_FriendAdd.Checked;
  Label150.Visible := Cb_Share_FriendAdd.Checked;
end;

procedure TSlavaNapSettings.Cb_Link_MaxServersClick(Sender: TObject);
begin
  Label151.Visible := Cb_Link_MaxServers.Checked;
  Edit_Link_MaxServers.Visible := Cb_Link_MaxServers.Checked;
end;

procedure TSlavaNapSettings.Cb_Interface_RemoteadminokClick(
  Sender: TObject);
begin
  Edit_Interface_Remotepass.Visible := Cb_Interface_Remoteadminok.Checked;
end;

procedure TSlavaNapSettings.Cb_Blockmx_DetectClick(Sender: TObject);
begin
  Label142.Visible := Cb_Blockmx_Detect.Checked and Cb_Blockmx_Ban.Checked;
  Cb_Blockmx_Ban.Visible := Cb_Blockmx_Detect.Checked;
  Edit_Blockmx_Bantime.Visible := Cb_Blockmx_Detect.Checked and
    Cb_Blockmx_Ban.Checked;
  // Cb_Blockmx_Pong.Visible := Cb_Blockmx_Detect.Checked;
end;

procedure TSlavaNapSettings.Cb_Blockmx_BanClick(Sender: TObject);
begin
  Label142.Visible := Cb_Blockmx_Ban.Checked;
  Edit_Blockmx_Bantime.Visible := Cb_Blockmx_Ban.Checked;
end;

procedure TSlavaNapSettings.Cb_SearchBlock_ChkFilesClick(Sender: TObject);
begin
  Edit_SearchBlock_Files.Enabled := Cb_SearchBlock_ChkFiles.Checked;
  Rd_SearchBlock_Hard.Enabled := Cb_SearchBlock_ChkFiles.Checked and
    Cb_SearchBlock_ChkSize.Checked;
  Rd_SearchBlock_Normal.Enabled := Cb_SearchBlock_ChkFiles.Checked and
    Cb_SearchBlock_ChkSize.Checked;
end;

procedure TSlavaNapSettings.Cb_SearchBlock_ChkSizeClick(Sender: TObject);
begin
  Edit_SearchBlock_Size.Enabled := Cb_SearchBlock_ChkSize.Checked;
  Rd_SearchBlock_Hard.Enabled := Cb_SearchBlock_ChkFiles.Checked and
    Cb_SearchBlock_ChkSize.Checked;
  Rd_SearchBlock_Normal.Enabled := Cb_SearchBlock_ChkFiles.Checked and
    Cb_SearchBlock_ChkSize.Checked;
end;

procedure TSlavaNapSettings.Cb_DomBlock_ChkFilesClick(Sender: TObject);
begin
  Edit_DomBlock_Files.Enabled := Cb_DomBlock_ChkFiles.Checked;
  Rd_DomBlock_Hard.Enabled := Cb_DomBlock_ChkFiles.Checked and
    Cb_DomBlock_ChkSize.Checked;
  Rd_DomBlock_Normal.Enabled := Cb_DomBlock_ChkFiles.Checked and
    Cb_DomBlock_ChkSize.Checked;
end;

procedure TSlavaNapSettings.Cb_DomBlock_ChkSizeClick(Sender: TObject);
begin
  Edit_DomBlock_Size.Enabled := Cb_DomBlock_ChkSize.Checked;
  Rd_DomBlock_Hard.Enabled := Cb_DomBlock_ChkFiles.Checked and
    Cb_DomBlock_ChkSize.Checked;
  Rd_DomBlock_Normal.Enabled := Cb_DomBlock_ChkFiles.Checked and
    Cb_DomBlock_ChkSize.Checked;
end;

procedure TSlavaNapSettings.Rd_DLFloodBlock_BanClick(Sender: TObject);
begin
  Edit_DLFloodBlock_Bantime.Visible := True;
end;

procedure TSlavaNapSettings.Rd_DLFloodBlock_BlockClick(Sender: TObject);
begin
  Edit_DLFloodBlock_Bantime.Visible := False;
end;

procedure TSlavaNapSettings.Rd_DLFloodBlock_LeechClick(Sender: TObject);
begin
  Edit_DLFloodBlock_Bantime.Visible := False;
end;

procedure TSlavaNapSettings.Rd_WQFloodBlock_BanClick(Sender: TObject);
begin
  Edit_WQFloodBlock_Bantime.Visible := True;
end;

procedure TSlavaNapSettings.Rd_WQFloodBlock_BlockClick(Sender: TObject);
begin
  Edit_WQFloodBlock_Bantime.Visible := False;
end;

procedure TSlavaNapSettings.Rd_WQFloodBlock_LeechClick(Sender: TObject);
begin
  Edit_WQFloodBlock_Bantime.Visible := False;
end;

procedure TSlavaNapSettings.SetBanItems(Control: TComboBox);
begin
  Control.Items.Clear;
  Control.Items.Add(GetLangI(LNG_BANS_TIME60));
  Control.Items.Add(GetLangI(LNG_BANS_TIME300));
  Control.Items.Add(GetLangI(LNG_BANS_TIME600));
  Control.Items.Add(GetLangI(LNG_BANS_TIME1800));
  Control.Items.Add(GetLangI(LNG_BANS_TIME3600));
  Control.Items.Add(GetLangI(LNG_BANS_TIME10800));
  Control.Items.Add(GetLangI(LNG_BANS_TIME43200));
  Control.Items.Add(GetLangI(LNG_BANS_TIME86400));
  Control.Items.Add(GetLangI(LNG_BANS_TIME259200));
  Control.Items.Add(GetLangI(LNG_BANS_TIME604800));
  Control.Items.Add(GetLangI(LNG_BANS_TIME1209600));
  Control.Items.Add(GetLangI(LNG_BANS_TIME2678400));
  Control.ItemIndex := Control.Items.Count - 1;
  Control.Items.Add(GetLangI(LNG_BANS_TIME5184000));
  Control.Items.Add(GetLangI(LNG_BANS_TIME7776000));
  Control.Items.Add(GetLangI(LNG_BANS_TIME31536000));
  Control.Items.Add(RS_BanTimeForever);
  Control.DropDownCount := Control.Items.Count;
end;

function TSlavaNapSettings.GetBanID(Control: TComboBox): Integer;
var
  T: Integer;
begin
  case control.ItemIndex of
    0: T := 60;
    1: T := 300;
    2: T := 600;
    3: T := 1800;
    4: T := 3600;
    5: T := 10800;
    6: T := 43200;
    7: T := 86400;
    8: T := 259200;
    9: T := 604800;
    10: T := 1209600;
    11: T := 2678400;
    12: T := 5184000;
    13: T := 7776000;
    14: T := 31536000;
    15: T := 0;
  else
    T := Def_Ban_Timeout;
  end;
  Result := T;
end;

function TSlavaNapSettings.GetBanIndex(T: Integer): Integer;
var
  Itemindex: Integer;
begin
  case T of
    60: Itemindex := 0;
    300: Itemindex := 1;
    600: Itemindex := 2;
    1800: Itemindex := 3;
    3600: Itemindex := 4;
    10800: Itemindex := 5;
    43200: Itemindex := 6;
    86400: Itemindex := 7;
    259200: Itemindex := 8;
    604800: Itemindex := 9;
    1209600: Itemindex := 10;
    2678400: Itemindex := 11;
    5184000: Itemindex := 12;
    7776000: Itemindex := 13;
    31536000: Itemindex := 14;
    0: Itemindex := 15;
  else
    Itemindex := 7; // 1
  end;
  Result := Itemindex;
end;

procedure TSlavaNapSettings.Cb_Disable_FakeextClick(Sender: TObject);
begin
  Edit_Fakeext.Visible := Cb_Disable_Fakeext.Checked;
end;

procedure TSlavaNapSettings.Cb_Enable_TrapPortClick(Sender: TObject);
begin
  Edit_TrapPort.Visible := Cb_Enable_TrapPort.Checked;
end;

procedure TSlavaNapSettings.Cb_Block_TransferPortClick(Sender: TObject);
begin
  Edit_Blocked_TransferPort.Visible := Cb_Block_TransferPort.Checked;
end;

procedure TSlavaNapSettings.Cb_Channels_ForceenterClick(Sender: TObject);
begin
  Label156.Visible := Cb_Channels_Forceenter.Checked;
  Edit_Channels_Forceenter.Visible := Cb_Channels_Forceenter.Checked;
end;

procedure TSlavaNapSettings.Cb_Check_LoginpassClick(Sender: TObject);
begin
  Edit_Loginpass.Visible := Cb_Check_Loginpass.Checked;
  Label157.Visible := Cb_Check_Loginpass.Checked;
end;

procedure TSlavaNapSettings.Cb_Restrict_HitperuserClick(
  Sender: TObject);
begin
  Edit_Hitperuser.Visible := Cb_Restrict_Hitperuser.Checked;
  Label158.Visible := Cb_Restrict_Hitperuser.Checked;
end;

procedure TSlavaNapSettings.Cb_Refresh_ServersClick(Sender: TObject);
begin
  Edit_Servreftime.Visible := Cb_Refresh_Servers.Checked;
  Label159.Visible := Cb_Refresh_Servers.Checked;
end;

procedure TSlavaNapSettings.Cb_Refresh_UsersClick(Sender: TObject);
begin
  Edit_Usersreftime.Visible := Cb_Refresh_Users.Checked;
  Label166.Visible := Cb_Refresh_Users.Checked;
end;

procedure TSlavaNapSettings.Cb_MinShare_BanClick(Sender: TObject);
begin
  Label160.Visible := Cb_MinShare_Ban.Checked;
  Edit_MinShare_Bantime.Visible := Cb_MinShare_Ban.Checked;
end;

procedure TSlavaNapSettings.ChangeInterface(LoadMode: ConfigLoadMode = lmAll);
begin
  if LoadMode <> lmRest then
  begin
    SetFont(Self.Font);
    SetFont(Tree.Font);
    SetFont(Header.Font, 10);
    SetFont(Lbl_Change.Font, 10);
    SetFont(Lbl_Note.Font, 9);
    SetFont(Label55.Font);
    SetFont(Lbl_Handle.Font);
    SetFont(Label137.Font);
    // Sh_Main
    Label1.Caption := GetLangI(LNG_S_SHMAIN_LABEL1);
    Label3.Caption := GetLangI(LNG_S_SHMAIN_LABEL3);
    Label4.Caption := GetLangI(LNG_S_SHMAIN_LABEL4);
    Label66.Caption := GetLangI(LNG_S_SHMAIN_LABEL66);
    Label67.Caption := GetLangI(LNG_S_SHMAIN_LABEL67);
    Label75.Caption := GetLangI(LNG_S_SHMAIN_LABEL75);
    Label76.Caption := GetLangI(LNG_S_SHMAIN_LABEL76);
    Lbl_Handle.Caption := GetLangI(LNG_S_SHMAIN_LBL_HANDLE);
    Label127.Caption := GetLangI(LNG_S_SHMAIN_LABEL127);
    Label138.Caption := GetLangI(LNG_S_SHMAIN_LABEL138);
    if LoadMode = lmInitial then Exit;
  end;
  // Sh_Users
  Label5.Caption := GetLangI(LNG_S_SHUSERS_LABEL5);
  Label9.Caption := GetLangI(LNG_S_SHUSERS_LABEL9);
  Label12.Caption := GetLangI(LNG_S_SHUSERS_LABEL12);
  Label79.Caption := GetLangI(LNG_S_SHUSERS_LABEL79);
  Label2.Caption := GetLangI(LNG_S_SHUSERS_LABEL2);
  Label128.Caption := GetLangI(LNG_S_SHUSERS_LABEL128);
  Cb_Users_Reg_Only.Caption := GetLangI(LNG_S_SHUSERS_CB_USERS_REG_ONLY);
  Cb_Users_Reg_Allow.Caption := GetLangI(LNG_S_SHUSERS_CB_USERS_REG_ALLOW);
  Cb_Users_NoRemote.Caption := GetLangI(LNG_S_SHUSERS_CB_USERS_NOREMOTE);
  Cb_Users_Redirectcqex.Caption :=
    GetLangI(LNG_S_SHUSERS_CB_USERS_REDIRECTCQEX);
  Cb_Users_Reconnect.Caption := GetLangI(LNG_S_SHUSERS_CB_USERS_RECONNECT);
  // Sh_Limits
  Label6.Caption := GetLangI(LNG_S_SHLIMITS_LABEL6);
  Label7.Caption := GetLangI(LNG_S_SHLIMITS_LABEL7);
  Label8.Caption := GetLangI(LNG_S_SHLIMITS_LABEL8);
  Label99.Caption := GetLangI(LNG_S_SHLIMITS_LABEL99);
  Label100.Caption := GetLangI(LNG_S_SHLIMITS_LABEL100);
  Label10.Caption := GetLangI(LNG_S_SHLIMITS_LABEL10);
  Label11.Caption := GetLangI(LNG_S_SHLIMITS_LABEL11);
  Cb_Limits_Limitservers.Caption :=
    GetLangI(LNG_S_SHLIMITS_CB_LIMITS_LIMITSERVERS);
  // Sh_interface
  Label77.Caption := GetLangI(LNG_S_SHINTERFACE_LABEL77);
  Label78.Caption := GetLangI(LNG_S_SHINTERFACE_LABEL78);
  Label152.Caption := GetLangI(LNG_S_SHINTERFACE_LABEL152);
  Cb_Interface_Startup.Caption :=
    GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_STARTUP);
  Cb_Interface_Noswitch.Caption :=
    GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_NOSWITCH);
  Cb_Interface_Chatflash.Caption :=
    GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_CHATFLASH);
  Cb_Interface_SysTray.Caption :=
    GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_SYSTRAY);
  Cb_Interface_Chatmini.Caption :=
    GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_CHATMINI);
  Cb_Interface_Wallop.Caption :=
    GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_WALLOP);
  Cb_Interface_Nocpu.Caption := GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_NOCPU);
  Cb_Interface_Wallopsound.Caption :=
    GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_WALLOPSOUND);
  Cb_Interface_Remoteadminok.Caption :=
    GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_REMOTEADMINOK);
  // Sh_Log
  Cb_Log_Login.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_LOGIN);
  Cb_Log_Napigator.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_NAPIGATOR);
  Cb_Log_Search.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_SEARCH);
  Cb_Log_Transfers.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_TRANSFERS);
  Cb_Log_Users.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_USERS);
  Cb_Log_Save.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_SAVE);
  Cb_Log_Servers.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_SERVERS);
  Cb_Log_Serverstats.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_SERVERSTATS);
  Cb_Log_Clearserverstats.Caption :=
    GetLangI(LNG_S_SHLOG_CB_LOG_CLEARSERVERSTATS);
  Cb_Log_Clearclientstats.Caption :=
    GetLangI(LNG_S_SHLOG_CB_LOG_CLEARCLIENTSTATS);
  Cb_Log_Console.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_CONSOLE);
  Cb_Log_Dagsta.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_DAGSTA);
  Cb_Log_Browse.Caption := GetLangI(LNG_S_SHLOG_CB_LOG_BROWSE);
  // Sh_Share
  Label13.Caption := GetLangI(LNG_S_SHSHARE_LABEL13);
  Label14.Caption := GetLangI(LNG_S_SHSHARE_LABEL14);
  Label15.Caption := GetLangI(LNG_S_SHSHARE_LABEL15);
  Label16.Caption := GetLangI(LNG_S_SHSHARE_LABEL16);
  Label101.Caption := GetLangI(LNG_S_SHSHARE_LABEL101);
  Label149.Caption := GetLangI(LNG_S_SHSHARE_LABEL149);
  Label150.Caption := GetLangI(LNG_S_SHSHARE_LABEL150);
  Cb_Share_Disable.Caption := GetLangI(LNG_S_SHSHARE_CB_SHARE_DISABLE);
  Cb_Share_Inform.Caption := GetLangI(LNG_S_SHSHARE_CB_SHARE_INFORM);
  Cb_Share_Nomodem.Caption := GetLangI(LNG_S_SHSHARE_CB_SHARE_NOMODEM);
  Cb_Share_Checkdup.Caption := GetLangI(LNG_S_SHSHARE_CB_SHARE_CHECKDUP);
  Cb_Share_FriendAdd.Caption := GetLangI(LNG_S_SHSHARE_CB_SHARE_FRIENDADD);
  // Sh_Share_Mp3
  Label17.Caption := GetLangI(LNG_S_SHSHAREMP3_LABEL17);
  Label18.Caption := GetLangI(LNG_S_SHSHAREMP3_LABEL18);
  Label19.Caption := GetLangI(LNG_S_SHSHAREMP3_LABEL19);
  Label20.Caption := GetLangI(LNG_S_SHSHAREMP3_LABEL20);
  Label45.Caption := GetLangI(LNG_S_SHSHAREMP3_LABEL45);
  Label46.Caption := GetLangI(LNG_S_SHSHAREMP3_LABEL46);
  Cb_Mp3_320.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_320);
  Cb_Mp3_256.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_256);
  Cb_Mp3_224.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_224);
  Cb_Mp3_192.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_192);
  Cb_Mp3_160.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_160);
  Cb_Mp3_128.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_128);
  Cb_Mp3_112.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_112);
  Cb_Mp3_96.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_96);
  Cb_Mp3_80.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_80);
  Cb_Mp3_64.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_64);
  Cb_Mp3_56.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_56);
  Cb_Mp3_48.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_48);
  Cb_Mp3_40.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_40);
  Cb_Mp3_32.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_32);
  Cb_Mp3_24.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_24);
  Cb_Mp3_0.Caption := GetLangI(LNG_S_SHSHAREMP3_CB_MP3_0);
  // Sh_Share_Audio
  Label21.Caption := GetLangI(LNG_S_SHSHAREAUDIO_LABEL21);
  Label22.Caption := GetLangI(LNG_S_SHSHAREAUDIO_LABEL22);
  Label23.Caption := GetLangI(LNG_S_SHSHAREAUDIO_LABEL23);
  Label24.Caption := GetLangI(LNG_S_SHSHAREAUDIO_LABEL24);
  // Sh_Share_Video
  Label25.Caption := GetLangI(LNG_S_SHSHAREVIDEO_LABEL25);
  Label26.Caption := GetLangI(LNG_S_SHSHAREVIDEO_LABEL26);
  Label27.Caption := GetLangI(LNG_S_SHSHAREVIDEO_LABEL27);
  Label28.Caption := GetLangI(LNG_S_SHSHAREVIDEO_LABEL28);
  // Sh_Share_Images
  Label29.Caption := GetLangI(LNG_S_SHSHAREIMAGES_LABEL29);
  Label30.Caption := GetLangI(LNG_S_SHSHAREIMAGES_LABEL30);
  Label31.Caption := GetLangI(LNG_S_SHSHAREIMAGES_LABEL31);
  Label32.Caption := GetLangI(LNG_S_SHSHAREIMAGES_LABEL32);
  // Sh_Share_Apps
  Label33.Caption := GetLangI(LNG_S_SHSHAREAPPS_LABEL33);
  Label34.Caption := GetLangI(LNG_S_SHSHAREAPPS_LABEL34);
  Label35.Caption := GetLangI(LNG_S_SHSHAREAPPS_LABEL35);
  Label36.Caption := GetLangI(LNG_S_SHSHAREAPPS_LABEL36);
  // Sh_Share_Cd
  Label37.Caption := GetLangI(LNG_S_SHSHARECD_LABEL37);
  Label38.Caption := GetLangI(LNG_S_SHSHARECD_LABEL38);
  Label39.Caption := GetLangI(LNG_S_SHSHARECD_LABEL39);
  Label40.Caption := GetLangI(LNG_S_SHSHARECD_LABEL40);
  // Sh_Share_Text
  Label41.Caption := GetLangI(LNG_S_SHSHARETEXT_LABEL41);
  Label42.Caption := GetLangI(LNG_S_SHSHARETEXT_LABEL42);
  Label43.Caption := GetLangI(LNG_S_SHSHARETEXT_LABEL43);
  Label44.Caption := GetLangI(LNG_S_SHSHARETEXT_LABEL44);
  // Sh_Napigator
  Label61.Caption := GetLangI(LNG_S_SHNAPIGATOR_LABEL61);
  Label62.Caption := GetLangI(LNG_S_SHNAPIGATOR_LABEL62);
  Label63.Caption := GetLangI(LNG_S_SHNAPIGATOR_LABEL63);
  Label64.Caption := GetLangI(LNG_S_SHNAPIGATOR_LABEL64);
  Label65.Caption := GetLangI(LNG_S_SHNAPIGATOR_LABEL65);
  Label73.Caption := GetLangI(LNG_S_SHNAPIGATOR_LABEL73);
  Label97.Caption := GetLangI(LNG_S_SHNAPIGATOR_LABEL97);
  Label126.Caption := GetLangI(LNG_S_SHNAPIGATOR_LABEL126);
  Btn_Napigator_Password.Caption :=
    GetLangI(LNG_S_SHNAPIGATOR_BTN_NAPIGATOR_PASSWORD);
  Cb_Napigator_Enabled.Caption :=
    GetLangI(LNG_S_SHNAPIGATOR_CB_NAPIGATOR_ENABLED);
  Btn_Napigator_Disconnect.Caption :=
    GetLangI(LNG_S_SHNAPIGATOR_BTN_NAPIGATOR_DISCONNECT);
  Cb_Napigator_Autodisconnect.Caption :=
    GetLangI(LNG_S_SHNAPIGATOR_CB_NAPIGATOR_AUTODISCONNECT);
  // Sh_Search
  Label47.Caption := GetLangI(LNG_S_SHSEARCH_LABEL47);
  Label48.Caption := GetLangI(LNG_S_SHSEARCH_LABEL48);
  Label49.Caption := GetLangI(LNG_S_SHSEARCH_LABEL49);
  Label50.Caption := GetLangI(LNG_S_SHSEARCH_LABEL50);
  Label72.Caption := GetLangI(LNG_S_SHSEARCH_LABEL72);
  Lbl_Search_MaxRemote.Caption := GetLangI(LNG_S_SHSEARCH_LBL_SEARCH_MAXREMOTE);
  Cb_Search_Disable_Remote.Caption :=
    GetLangI(LNG_S_SHSEARCH_CB_SEARCH_DISABLE_REMOTE);
  // Sh_Levels
  Label54.Caption := GetLangI(LNG_S_SHLEVELS_LABEL54);
  Label55.Caption := GetLangI(LNG_S_SHLEVELS_LABEL55);
  Label56.Caption := GetLangI(LNG_S_SHLEVELS_LABEL56);
  Label57.Caption := GetLangI(LNG_S_SHLEVELS_LABEL57);
  Label58.Caption := GetLangI(LNG_S_SHLEVELS_LABEL58);
  Label59.Caption := GetLangI(LNG_S_SHLEVELS_LABEL59);
  Label60.Caption := GetLangI(LNG_S_SHLEVELS_LABEL60);
  Label102.Caption := GetLangI(LNG_S_SHLEVELS_LABEL102);
  Btn_Level_default.Caption := GetLangI(LNG_S_SHLEVELS_BTN_LEVEL_DEFAULT);
  // Sh_Channels
  Label52.Caption := GetLangI(LNG_S_SHCHANNELS_LABEL52);
  Label53.Caption := GetLangI(LNG_S_SHCHANNELS_LABEL53);
  Label82.Caption := GetLangI(LNG_S_SHCHANNELS_LABEL82);
  Label83.Caption := GetLangI(LNG_S_SHCHANNELS_LABEL83);
  Lbl_Flood1.Caption := GetLangI(LNG_S_SHCHANNELS_LBL_FLOOD1);
  Lbl_Flood2.Caption := GetLangI(LNG_S_SHCHANNELS_LBL_FLOOD2);
  Cb_Channels_Allowcreate.Caption :=
    GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_ALLOWCREATE);
  Cb_Channels_Blockcqex.Caption :=
    GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_BLOCKCQEX);
  Cb_Channels_Oldwallop.Caption :=
    GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_OLDWALLOP);
  Cb_Channels_Showops.Caption := GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_SHOWOPS);
  Cb_Channels_Timestamp.Caption :=
    GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_TIMESTAMP);
  Cb_Channels_Low.Caption := GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_LOW);
  Cb_Channels_Preventshout.Caption :=
    GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_PREVENTSHOUT);
  Cb_Channels_Flood_Warn.Caption :=
    GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_FLOOD_WARN);
  Cb_Channels_Floodenable.Caption :=
    GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_FLOODENABLE);
  // Sh_Console
  Label69.Caption := GetLangI(LNG_S_SHCONSOLE_LABEL69);
  Label70.Caption := GetLangI(LNG_S_SHCONSOLE_LABEL70);
  Label71.Caption := GetLangI(LNG_S_SHCONSOLE_LABEL71);
  Label144.Caption := GetLangI(LNG_S_SHCONSOLE_LABEL144);
  Label145.Caption := GetLangI(LNG_S_SHCONSOLE_LABEL145);
  Label146.Caption := GetLangI(LNG_S_SHCONSOLE_LABEL146);
  Label147.Caption := GetLangI(LNG_S_SHCONSOLE_LABEL147);
  // Sh_Blocked
  Label68.Caption := GetLangI(LNG_S_SHBLOCKED_LABEL68);
  Cb_Block_Napster.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NAPSTER);
  Cb_Block_Audiognome.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_AUDIOGNOME);
  Cb_Block_Gnomeplus.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_GNOMEPLUS);
  Cb_Block_Amster.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_AMSTER);
  Cb_Block_Filenavigator.Caption :=
    GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_FILENAVIGATOR);
  Cb_Block_Cqex.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_CQEX);
  Cb_Block_Sunshineun.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_SUNSHINEUN);
  Cb_Block_Teknap.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_TEKNAP);
  Cb_Block_Nap.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NAP);
  Cb_Block_Macnap.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_MACNAP);
  Cb_Block_Mp3rage.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_MP3RAGE);
  Cb_Block_Xnap.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_XNAP);
  Cb_Block_Spotlight.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_SPOTLIGHT);
  Cb_Block_Nfs.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NFS);
  Cb_Block_Dmnapster.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_DMNAPSTER);
  Cb_Block_Knapster.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_KNAPSTER);
  Cb_Block_Lopster.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_LOPSTER);
  Cb_Block_Rapigator.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_RAPIGATOR);
  Cb_Block_Swaptor.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_SWAPTOR);
  Cb_Block_Other.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_OTHER);
  Label74.Caption := GetLangI(LNG_S_SHBLOCKED_LABEL74);
  Cb_Block_Dagsta.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_DAGSTA);
  Cb_Block_Floodster.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_FLOODSTER);
  Cb_Block_Drumbeat.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_DRUMBEAT);
  Cb_Block_Custommessage.Caption :=
    GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_CUSTOMMESSAGE);
  Cb_Block_Defaultmessage.Caption :=
    GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_DEFAULTMESSAGE);
  Cb_Block_Nomessage.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NOMESSAGE);
  Lbl_Block_Message.Caption := GetLangI(LNG_S_SHBLOCKED_LBL_BLOCK_MESSAGE);
  Cb_Block_Mldonkey.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_MLDONKEY);
  Cb_Block_Napigator.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NAPIGATOR);
  Cb_Block_Nap08.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NAP08);
  Cb_Block_Opennap.Caption := GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_OPENNAP);
  // Sh_Links
  Label98.Caption := GetLangI(LNG_S_SHLINKS_LABEL98);
  Label139.Caption := GetLangI(LNG_S_SHLINKS_LABEL139);
  Label141.Caption := GetLangI(LNG_S_SHLINKS_LABEL141);
  Label151.Caption := GetLangI(LNG_S_SHLINKS_LABEL151);
  Cb_Link_All.Caption := GetLangI(LNG_S_SHLINKS_CB_LINK_ALL);
  Cb_Link_List.Caption := GetLangI(LNG_S_SHLINKS_CB_LINK_LIST);
  Cb_Link_List2.Caption := GetLangI(LNG_S_SHLINKS_CB_LINK_LIST2);
  Cb_Link_None.Caption := GetLangI(LNG_S_SHLINKS_CB_LINK_NONE);
  Cb_Link_Hub.Caption := GetLangI(LNG_S_SHLINKS_CB_LINK_HUB);
  Cb_Link_Syncreg.Caption := GetLangI(LNG_S_SHLINKS_CB_LINK_SYNCREG);
  Cb_Link_Noautoconnect.Caption :=
    GetLangI(LNG_S_SHLINKS_CB_LINK_NOAUTOCONNECT);
  Cb_Link_Syncban.Caption := GetLangI(LNG_S_SHLINKS_CB_LINK_SYNCBAN);
  Cb_Link_RestrictOutgoing.Caption :=
    GetLangI(LNG_S_SHLINKS_CB_LINK_RESTRICTOUTGOING);
  Cb_Meta_Enabled.Caption := GetLangI(LNG_S_SHLINKS_CB_META_ENABLED);
  Cb_Link_SyncBlock.Caption := GetLangI(LNG_S_SHLINKS_CB_LINK_SYNCBLOCK);
  Cb_Link_MaxServers.Caption := GetLangI(LNG_S_SHLINKS_CB_LINK_MAXSERVERS);
  // Sh_Sockets
  Lbl_Sockets_Users_Send.Caption :=
    GetLangI(LNG_S_SHSOCKETS_LBL_SOCKETS_USERS_SEND);
  Lbl_Sockets_Users_Recv.Caption :=
    GetLangI(LNG_S_SHSOCKETS_LBL_SOCKETS_USERS_RECV);
  Lbl_Sockets_Servers_Send.Caption :=
    GetLangI(LNG_S_SHSOCKETS_LBL_SOCKETS_SERVERS_SEND);
  Lbl_Sockets_Servers_Recv.Caption :=
    GetLangI(LNG_S_SHSOCKETS_LBL_SOCKETS_SERVERS_RECV);
  Label81.Caption := GetLangI(LNG_S_SHSOCKETS_LABEL81);
  Cb_Sockets_Users_Def.Caption :=
    GetLangI(LNG_S_SHSOCKETS_CB_SOCKETS_USERS_DEF);
  Cb_Sockets_Servers_Def.Caption :=
    GetLangI(LNG_S_SHSOCKETS_CB_SOCKETS_SERVERS_DEF);
  // Sh_Report
  Label148.Caption := GetLangI(LNG_S_SHREPORT_LABEL148);
  Cb_Report_Old_Enable.Caption := GetLangI(LNG_S_SHREPORT_CB_REPORT_OLD_ENABLE);
  Label89.Caption := GetLangI(LNG_S_SHREPORT_LABEL89);
  Cb_Report_New_Enabled.Caption :=
    GetLangI(LNG_S_SHREPORT_CB_REPORT_NEW_ENABLED);
  Cb_Report_New_Hidehub.Caption :=
    GetLangI(LNG_S_SHREPORT_CB_REPORT_NEW_HIDEHUB);
  Label90.Caption := GetLangI(LNG_S_SHREPORT_LABEL90);
  Cb_Report_Truestats.Caption := GetLangI(LNG_S_SHREPORT_CB_REPORT_TRUESTATS);
  GroupBox2.Caption := GetLangI(LNG_S_SHREPORT_GROUPBOX2);
  GroupBox3.Caption := GetLangI(LNG_S_SHREPORT_GROUPBOX3);
  // Sh_Other
  Label84.Caption := GetLangI(LNG_S_SHOTHER_LABEL84);
  Cb_Ann_Enable.Caption := GetLangI(LNG_S_SHOTHER_CB_ANN_ENABLE);
  Label85.Caption := GetLangI(LNG_S_SHOTHER_LABEL85);
  Label86.Caption := GetLangI(LNG_S_SHOTHER_LABEL86);
  Label87.Caption := GetLangI(LNG_S_SHOTHER_LABEL87);
  Label88.Caption := GetLangI(LNG_S_SHOTHER_LABEL88);
  GroupBox4.Caption := GetLangI(LNG_S_SHOTHER_GROUPBOX4);
  // Sh_MinShare
  Label91.Caption := GetLangI(LNG_S_SHMINSHARE_LABEL91);
  Label92.Caption := GetLangI(LNG_S_SHMINSHARE_LABEL92);
  Label93.Caption := GetLangI(LNG_S_SHMINSHARE_LABEL93);
  Label94.Caption := GetLangI(LNG_S_SHMINSHARE_LABEL94);
  Label95.Caption := GetLangI(LNG_S_SHMINSHARE_LABEL95);
  Label160.Caption := GetLangI(LNG_S_SHMINSHARE_LABEL160);
  Cb_MinShare_Ban.Caption := GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_BAN);
  Cb_MinShare_Onlyfull.Caption :=
    GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_ONLYFULL);
  Cb_MinShare_Banip.Caption := GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_BANIP);
  Cb_MinShare_Full10.Caption := GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_FULL10);
  Cb_MinShare_Kickchat.Caption :=
    GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_KICKCHAT);
  Cb_MinShare_Wallop.Caption := GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_WALLOP);
  // Sh_Motd
  Label96.Caption := GetLangI(LNG_S_SHMOTD_LABEL96);
  // Sh_Colors
  Label104.Caption := GetLangI(LNG_S_SHCOLORS_LABEL104);
  Label105.Caption := GetLangI(LNG_S_SHCOLORS_LABEL105);
  Label106.Caption := GetLangI(LNG_S_SHCOLORS_LABEL106);
  Label107.Caption := GetLangI(LNG_S_SHCOLORS_LABEL107);
  Label108.Caption := GetLangI(LNG_S_SHCOLORS_LABEL108);
  Label109.Caption := GetLangI(LNG_S_SHCOLORS_LABEL109);
  Label110.Caption := GetLangI(LNG_S_SHCOLORS_LABEL110);
  Label111.Caption := GetLangI(LNG_S_SHCOLORS_LABEL111);
  Label112.Caption := GetLangI(LNG_S_SHCOLORS_LABEL112);
  Label113.Caption := GetLangI(LNG_S_SHCOLORS_LABEL113);
  Label114.Caption := GetLangI(LNG_S_SHCOLORS_LABEL114);
  Label115.Caption := GetLangI(LNG_S_SHCOLORS_LABEL115);
  Label116.Caption := GetLangI(LNG_S_SHCOLORS_LABEL116);
  Label117.Caption := GetLangI(LNG_S_SHCOLORS_LABEL117);
  Label118.Caption := GetLangI(LNG_S_SHCOLORS_LABEL118);
  Label119.Caption := GetLangI(LNG_S_SHCOLORS_LABEL119);
  Label120.Caption := GetLangI(LNG_S_SHCOLORS_LABEL120);
  Label121.Caption := GetLangI(LNG_S_SHCOLORS_LABEL121);
  Label122.Caption := GetLangI(LNG_S_SHCOLORS_LABEL122);
  Label123.Caption := GetLangI(LNG_S_SHCOLORS_LABEL123);
  Label124.Caption := GetLangI(LNG_S_SHCOLORS_LABEL124);
  Label125.Caption := GetLangI(LNG_S_SHCOLORS_LABEL125);
  Label136.Caption := GetLangI(LNG_S_SHCOLORS_LABEL136);
  Label51.Caption := GetLangI(LNG_S_SHCOLORS_LABEL51);
  Btn_Colors_default.Caption := GetLangI(LNG_S_SHCOLORS_BTN_COLORS_DEFAULT);
  // Sh_Links2
  Label80.Caption := GetLangI(LNG_S_SHLINKS2_LABEL80);
  Cb_Link2_LagNoSearch.Caption := GetLangI(LNG_S_SHLINKS2_CB_LINK2_LAGNOSEARCH);
  Cb_Link2_LagNoSearchReq.Caption :=
    GetLangI(LNG_S_SHLINKS2_CB_LINK2_LAGNOSEARCHREQ);
  Cb_Link2_Lagnobrowse.Caption := GetLangI(LNG_S_SHLINKS2_CB_LINK2_LAGNOBROWSE);
  Cb_Link2_Lagnobrowsereq.Caption :=
    GetLangI(LNG_S_SHLINKS2_CB_LINK2_LAGNOBROWSEREQ);
  // Sh_Dagsta
  Label103.Caption := GetLangI(LNG_S_SHDAGSTA_LABEL103);
  Label129.Caption := GetLangI(LNG_S_SHDAGSTA_LABEL129);
  Label130.Caption := GetLangI(LNG_S_SHDAGSTA_LABEL130);
  Label131.Caption := GetLangI(LNG_S_SHDAGSTA_LABEL131);
  Label132.Caption := GetLangI(LNG_S_SHDAGSTA_LABEL132);
  Label133.Caption := GetLangI(LNG_S_SHDAGSTA_LABEL133);
  Label134.Caption := GetLangI(LNG_S_SHDAGSTA_LABEL134);
  Label135.Caption := GetLangI(LNG_S_SHDAGSTA_LABEL135);
  Label137.Caption := GetLangI(LNG_S_SHDAGSTA_LABEL137);
  Btn_Dagsta_Password.Caption := GetLangI(LNG_S_SHDAGSTA_BTN_DAGSTA_PASSWORD);
  Cb_Dagsta_Enabled.Caption := GetLangI(LNG_S_SHDAGSTA_CB_DAGSTA_ENABLED);
  Btn_Dagsta_Disconnect.Caption :=
    GetLangI(LNG_S_SHDAGSTA_BTN_DAGSTA_DISCONNECT);
  Cb_Dagsta_Autodisconnect.Caption :=
    GetLangI(LNG_S_SHDAGSTA_CB_DAGSTA_AUTODISCONNECT);
  // Sh_Blockedwinmx
  Lbl_Blockmx_Percentage.Caption :=
    GetLangI(LNG_S_SHBLOCKEDWINMX_LBL_BLOCKMX_PERCENTAGE);
  Label140.Caption := GetLangI(LNG_S_SHBLOCKEDWINMX_LABEL140);
  Label142.Caption := GetLangI(LNG_S_SHBLOCKEDWINMX_LABEL142);
  Label143.Caption := GetLangI(LNG_S_SHBLOCKEDWINMX_LABEL143);
  Cb_Blockmx_Normal.Caption := GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_NORMAL);
  Cb_Blockmx_Limit.Caption := GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_LIMIT);
  Cb_Blockmx_Detect.Caption := GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_DETECT);
  Cb_Blockmx_Jap.Caption := GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_JAP);
  Cb_Blockmx_Pong.Caption := GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_PONG);
  Cb_Blockmx_Ban.Caption := GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_BAN);
  // Sh_Blocks
  Cb_Blocks_Allow_Share.Caption :=
    GetLangI(LNG_S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE);
  Cb_Blocks_Allow_Share_Admins.Caption :=
    GetLangI(LNG_S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE_ADMINS);
  Cb_Blocks_CheckMods.Caption := GetLangI(LNG_S_SHBLOCKS_CB_BLOCKS_CHECKMODS);
  // Sh_Other2
  Label153.Caption := GetLangI(LNG_S_SHOTHER2_LABEL153);
  Label154.Caption := GetLangI(LNG_S_SHOTHER2_LABEL154);
  Gb_SearchBlock.Caption := GetLangI(LNG_S_SHOTHER2_GB_SEARCHBLOCK);
  Cb_SearchBlock_ChkFiles.Caption :=
    GetLangI(LNG_S_SHOTHER2_CB_SEARCHBLOCK_CHKFILES);
  Cb_SearchBlock_ChkSize.Caption :=
    GetLangI(LNG_S_SHOTHER2_CB_SEARCHBLOCK_CHKSIZE);
  Rd_SearchBlock_Hard.Caption := GetLangI(LNG_S_SHOTHER2_RD_SEARCHBLOCK_HARD);
  Rd_SearchBlock_Normal.Caption :=
    GetLangI(LNG_S_SHOTHER2_RD_SEARCHBLOCK_NORMAL);
  Gb_DomBlock.Caption := GetLangI(LNG_S_SHOTHER2_GB_DOMBLOCK);
  Cb_DomBlock_ChkFiles.Caption := GetLangI(LNG_S_SHOTHER2_CB_DOMBLOCK_CHKFILES);
  Cb_DomBlock_ChkSize.Caption := GetLangI(LNG_S_SHOTHER2_CB_DOMBLOCK_CHKSIZE);
  Rd_DomBlock_Hard.Caption := GetLangI(LNG_S_SHOTHER2_RD_DOMBLOCK_HARD);
  Rd_DomBlock_Normal.Caption := GetLangI(LNG_S_SHOTHER2_RD_DOMBLOCK_NORMAL);
  Gb_DLFloodBlock.Caption := GetLangI(LNG_S_SHOTHER2_GB_DLFLOODBLOCK);
  Rd_DLFloodBlock_Block.Caption := GetLangI(LNG_S_SHOTHER2_RD_DLFLOODBLOCK_BAN);
  Rd_DLFloodBlock_Leech.Caption :=
    GetLangI(LNG_S_SHOTHER2_RD_DLFLOODBLOCK_BLOCK);
  Rd_DLFloodBlock_Ban.Caption := GetLangI(LNG_S_SHOTHER2_RD_DLFLOODBLOCK_LEECH);
  Gb_WQFloodBlock.Caption := GetLangI(LNG_S_SHOTHER2_GB_WQFLOODBLOCK);
  Rd_WQFloodBlock_Block.Caption := GetLangI(LNG_S_SHOTHER2_RD_WQFLOODBLOCK_BAN);
  Rd_WQFloodBlock_Leech.Caption :=
    GetLangI(LNG_S_SHOTHER2_RD_WQFLOODBLOCK_BLOCK);
  Rd_WQFloodBlock_Ban.Caption := GetLangI(LNG_S_SHOTHER2_RD_WQFLOODBLOCK_LEECH);
  Cb_Nocount_Text.Caption := GetLangI(LNG_S_SHOTHER2_CB_NOCOUNT_TEXT);
  Cb_Autoban_Incomplete.Caption :=
    GetLangI(LNG_S_SHOTHER2_CB_AUTOBAN_INCOMPLETE);
  Cb_Disable_Fakeext.Caption := GetLangI(LNG_S_SHOTHER2_CB_DISABLE_FAKEEXT);
  Cb_Enable_TrapPort.Caption := GetLangI(LNG_S_SHOTHER2_CB_ENABLE_TRAPPORT);
  Cb_Block_TransferPort.Caption :=
    GetLangI(LNG_S_SHOTHER2_CB_BLOCK_TRANSFERPORT);
  Cb_Share_MatchedFile_Only.Caption :=
    GetLangI(LNG_S_SHOTHER2_CB_SHARE_MATCHEDFILE_ONLY);
  // Sh_Other3
  Label156.Caption := GetLangI(LNG_S_SHOTHER3_LABEL156);
  Label157.Caption := GetLangI(LNG_S_SHOTHER3_LABEL157);
  Label158.Caption := GetLangI(LNG_S_SHOTHER3_LABEL158);
  GroupBox1.Caption := GetLangI(LNG_S_SHOTHER3_GROUPBOX1);
  Label155.Caption := GetLangI(LNG_S_SHOTHER3_CB_ENABLE_LOGINIM);
  Cb_Enable_LoginIM.Caption := GetLangI(LNG_S_SHOTHER3_LABEL155);
  Cb_Channels_Forceenter.Caption :=
    GetLangI(LNG_S_SHOTHER3_CB_CHANNELS_FORCEENTER);
  Cb_Allow_2ByteName.Caption := GetLangI(LNG_S_SHOTHER3_CB_ALLOW_2BYTENAME);
  Cb_Check_Loginpass.Caption := GetLangI(LNG_S_SHOTHER3_CB_CHECK_LOGINPASS);
  Cb_Enable_Msgserv.Caption := GetLangI(LNG_S_SHOTHER3_CB_ENABLE_MSGSERV);
  Cb_Restrict_Hitperuser.Caption :=
    GetLangI(LNG_S_SHOTHER3_CB_RESTRICT_HITPERUSER);
  Rd_Xbutton_Attr.Caption := GetLangI(LNG_S_SHOTHER3_RD_XBUTTON_ATTR);
  Rd_Xbutton_Attr.Items[0] := GetLangI(LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS1);
  Rd_Xbutton_Attr.Items[1] := GetLangI(LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS2);
  Rd_Xbutton_Attr.Items[2] := GetLangI(LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS3);
  Cb_Kill_Idleuser.Caption := GetLangI(LNG_S_SHOTHER3_CB_KILL_IDLEUSER);
  Label161.Caption := GetLangI(LNG_S_SHOTHER3_LABEL161);
  Label162.Caption := GetLangI(LNG_S_SHOTHER3_LABEL162);
  Cb_MinShare_NoBlockAct.Caption :=
    GetLangI(LNG_S_SHOTHER3_CB_MINSHARE_NOBLOCKACT);
  Cb_Deny_Listall_for_Users.Caption :=
    GetLangI(LNG_S_SHOTHER3_CB_DENY_LISTALL_FOR_USERS);
  Cb_Block_Weird_XnapFile.Caption :=
    GetLangI(LNG_S_SHOTHER3_CB_BLOCK_WEIRD_XNAPFILE);
  Cb_Suggest_DBrowse.Caption := GetLangI(LNG_S_SHOTHER3_CB_SUGGEST_DBROWSE);
  Cb_Allow_Rtf_Code.Caption := GetLangI(LNG_S_SHOTHER3_CB_ALLOW_RTF_CODE);
  Cb_Disable_Nullip.Caption := GetLangI(LNG_S_SHOTHER3_CB_DISABLE_NULLIP);
  // Sh_Other4
  Label164.Caption := GetLangI(LNG_S_SHOTHER4_LABEL164);
  Cb_Block_Napchan.Caption := GetLangI(LNG_S_SHOTHER4_CB_BLOCK_NAPCHAN);
  Cb_Block_Utatane.Caption := GetLangI(LNG_S_SHOTHER4_CB_BLOCK_UTATANE);
  Cb_Block_2get.Caption := GetLangI(LNG_S_SHOTHER4_CB_BLOCK_2GET);
  Cb_Block_Regnessem.Caption := GetLangI(LNG_S_SHOTHER4_CB_BLOCK_REGNESSEM);
  Label163.Caption := GetLangI(LNG_S_SHOTHER4_LABEL163);
  Label165.Caption := GetLangI(LNG_S_SHOTHER4_LABEL165);
  Cb_Refresh_Users.Caption := GetLangI(LNG_S_SHOTHER4_CB_REFRESH_USERS);
  Label166.Caption := GetLangI(LNG_S_SHOTHER4_LABEL166);
  Cb_Refresh_Servers.Caption := GetLangI(LNG_S_SHOTHER4_CB_REFRESH_SERVERS);
  Label159.Caption := GetLangI(LNG_S_SHOTHER4_LABEL159);
  Cb_Enable_Metaserver.Caption := GetLangI(LNG_S_SHOTHER4_CB_ENABLE_METASERVER);
  Btn_Add_Redirected_Server.Caption :=
    GetLangI(LNG_S_SHOTHER4_BTN_ADD_REDIRECTED_CAPTION);
  Btn_Delete_Redirected_Server.Caption :=
    GetLangI(LNG_S_SHOTHER4_BTN_DELETE_REDIRECTED_CAPTION);
  Label167.Caption := GetLangI(LNG_S_SHOTHER4_LABEL167);
  Label168.Caption := GetLangI(LNG_S_SHOTHER4_LABEL168);
  Label169.Caption := GetLangI(LNG_S_SHOTHER4_LABEL169);
end;

procedure TSlavaNapSettings.Cb_Kill_IdleuserClick(Sender: TObject);
begin
  Label161.Visible := Cb_Kill_Idleuser.Checked;
  Label162.Visible := Cb_Kill_Idleuser.Checked;
  Edit_Kill_Idleuser_Time.Visible := Cb_Kill_Idleuser.Checked;
end;

procedure TSlavaNapSettings.Btn_Log_FolderClick(Sender: TObject);
var
  Memory: IMalloc;
  Buffer: PChar;
  Ret, Root: PItemIDList;
begin
  SHGetMalloc(Memory);
  Buffer := Memory.Alloc(MAX_PATH);
  SHGetSpecialFolderLocation(SlavaNapSettings.Handle, CSIDL_DRIVES, Root);
  with BrowseInfo do
  begin
    hwndOwner := SlavaNapSettings.Handle;
    pidlRoot := Root;
    ulFlags := BIF_STATUSTEXT;
    lpszTitle := PChar(RS_Settings_SetLogFolder);
    pszDisplayName := Buffer;
    Lpfn := BrowseCallbackProc;
  end;
  Ret := SHBrowseForFolder(BrowseInfo);
  if SHGetPathFromIDList(Ret, Buffer) then
    Edit_Log_Folder.Text := Buffer;
  if Edit_Log_Folder.Text[Length(Edit_Log_Folder.Text)] <> '\' then
    Edit_Log_Folder.Text := Buffer + '\';
  Memory.Free(Ret);
  Memory.Free(Root);
  Memory.Free(Buffer);
end;

function BrowseCallbackProc(hWnd: HWND; uMsg: UINT;
  lParam, lpData: LPARAM): Integer;
var
  Path: array[0..65536] of Char;
begin
  if BrowseInfo.ulFlags = BIF_STATUSTEXT then
  begin
    if uMsg = BFFM_SELCHANGED then
    begin
      SHGetPathFromIDList(PItemIDList(lParam), Path);
      SendMessage(hWnd, BFFM_SETSTATUSTEXT, 0, LongInt(string(Path)));
    end;
  end;
  Result := 0;
end;

procedure TSlavaNapSettings.Cb_Enable_MetaserverClick(Sender: TObject);
begin
  Panel4.Visible := Cb_Enable_Metaserver.Checked;
  if Cb_Enable_Metaserver.Checked then
  begin
    Label169.Width := 128;
    Label169.Caption := GetLangI(LNG_S_SHOTHER4_LABEL169);
  end
  else
  begin
    Label169.Width := 320;
    Label169.Caption := GetLangI(LNG_S_SHOTHER4_LABEL169_2);
  end;
end;

procedure TSlavaNapSettings.Btn_Add_Redirected_ServerClick(
  Sender: TObject);
var
  I: Integer;
  Host: string;
begin
  Host := Trim(LowerCase(Edit_Redirected_Server.Text));
  if Host = '' then Exit;
  I := Pos(':', Host);
  if I = 0 then
    Host := Host + ':8888'
  else if StrToIntDef(Copy(Host, I + 1, MaxInt), 0) <= 0 then Exit;
  with Edit_Redirected_List do
  begin
    if Items.IndexOf(Host) <> -1 then Exit;
    I := Items.Add(Host);
    Checked[I] := True;
    Selected[I] := True;
  end;
  Edit_Redirected_Server.Clear;
end;

procedure TSlavaNapSettings.Btn_Delete_Redirected_ServerClick(
  Sender: TObject);
begin
  with Edit_Redirected_List do
  begin
    DeleteSelected;
    if Count > 0 then
      Selected[0] := True;
  end;
end;

procedure TSlavaNapSettings.FormDestroy(Sender: TObject);
begin
  Ini.Free;
end;

procedure TSlavaNapSettings.CMShowingChanged(var Msg: TMessage);
begin
  inherited;
  if Visible and Running then
  begin
    Update;
    ChangeInterface(lmRest);
  end;
end;

end.
