package Sledge::Plugin::Download;
# $Id: Download.pm,v 1.3 2003/02/14 07:36:51 miyagawa Exp $
#
# Tatsuhiko Miyagawa <miyagawa@edge.co.jp>
# Livin' On The EDGE, Limited.
#

use strict;
use vars qw($VERSION);
$VERSION = 0.02;

use vars qw(@ISA @EXPORT);

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(download);

sub download {
    my($self, $filename, $content) = @_;
    my $type = _dispatch_type($self, $filename);
    $self->r->header_out('Content-Disposition' => $type->{disposition});
    $self->r->content_type($type->{type});

    if (defined $content) {
	$self->r->header_out('Content-Length' => length $content);
	$self->r->send_http_header;
	$self->r->print($content);
    }
    else {
	$self->r->send_http_header;
    }
    $self->finished(1);		# may be early, but no problem
}

sub _dispatch_type {
    my($self, $filename) = @_;
    my $ua = $self->r->header_in('User-Agent');
    my $name = _convert($filename);

    if ($ua !~ /Mac/ && $ua =~ /MSIE/) {
	my($ver) = $ua =~ /MSIE ([\d\.]+)/;
	if ($ver < 5) {
	    return {
		disposition => "inline; filename=$name",
		type => "application/download; name=$name",
	    };
	}
	else {
	    return {
		disposition => "attachment; filename=$name",
		type => "application/download; name=$name",
	    };
	}
    }
    else {
	return {
	    disposition => "attachment; filename=$name",
	    type => "application/octet-stream; name=$name",
	};
    }
}

sub _convert {
    my $name = shift;
    return $name if $name =~ /^[\x00-\x7f]+$/; # ascii

    require Jcode;
    return Jcode->new($name)->sjis;
}

1;

__END__

=head1 NAME

Sledge::Plugin::Download - HTTP file download enhancemnet

=head1 SYNOPSIS

  package Your::Pages;
  use Sledge::Plugin::Download;

  sub dispatch_foo {
      my $self = shift;
      $self->download('foo.csv');
      while (my $line = <$fh>) {
          $self->r->print($line);
      }
  }

  # or, if your filesize is small
  sub dispatch_foo {
      my $self = shift;
      my $output = $self->read_content;
      $self->download("ۤۤ.txt", $output);
  }

=head1 DESCRIPTIO

Sledge::Plugin::Download ϡեɥФݤΡ
֥饦ˤХб뤿Υץ饰Ǥ

=head1 METHODS

Υץ饰useȡPages饹 C<download()> ᥽åɤɲä
ޤΥ᥽åɤϡե̾ˤȤꡢHTTPɤ򳫻
إåϤޤ

եȤŸƤʤˤϡȤ
ѿɤߤǤ C<download()> 2ϤС
Content-Length: νϡȤΥȥץåȤ֤˼¹Ԥޤ

ե̾˥ޥХʸѤ Shift_JIS ǥ󥳡ǥ
졢UNIX饤ȤǤʸȯǽޤ

=head1 AUTHOR

Tatsuhiko Miyagawa <miyagawa@edge.co.jp> with Sledge development team.

=head1 SEE ALSO

L<Jcode>

=cut
