#!/bin/bash
set -e
cd -- "$(dirname -- "${BASH_SOURCE[0]}")"

readonly USE_STATIC=1
readonly USE_STRIP=1
readonly USE_MTUNE=corei7

ARGUMENTS="$@"
if [[ -z "${ARGUMENTS}" ]]; then
  ARGUMENTS="32 64"
fi

PLATFORM="$(uname -s)"
unset SUFFIX
if [[ "${PLATFORM}" == MINGW* || "${PLATFORM}" == CYGWIN* ]]; then
  SUFFIX=".exe"
fi

MAKE=make
if [[ "${PLATFORM}" == *BSD || "${PLATFORM}" == DragonFly || "${PLATFORM}" == SunOS ]]; then
  MAKE=g${MAKE}
fi

function mk_slunk() {
  printf "\033[1;36m\n[ Build ${2} ]\033[0m\n\n"
  ${MAKE} -B CPU=${1} MARCH=${3} MTUNE=${USE_MTUNE} STATIC=${USE_STATIC} STRIP=${USE_STRIP}
  cp -f "frontend/bin/slunkcrypt${SUFFIX}" "out/slunkcrypt-${2}${SUFFIX}"
}

mkdir -p "out"
rm -f "out/slunkcrypt-*"
${MAKE} clean

for cpu in ${ARGUMENTS}; do
  case "${cpu}" in
    32)
      mk_slunk "${cpu}" x86 pentium2
      ;;
    64)
      mk_slunk "${cpu}" x64 x86-64
      ;;
    *)
      printf "Skipping unknown argument: \"${cpu}\"\n"
      ;;
  esac
done

printf "\033[1;32m\nBuild completed successfully.\033[0m\n\n"
