#!/bin/bash
# sudo apt install crossbuild-essential-i386
# sudo apt install crossbuild-essential-arm64
set -e
cd -- "$(dirname -- "${BASH_SOURCE[0]}")"

function mk_musl() {
	local outdir="/usr/local/musl/${1}-linux-gnu"
	local build="musl-build-${1}"
	rm -rf "${build}" && mkdir -p "${build}"
	tar -xvf "musl-latest.tar.gz" --strip-components=1 -C "${build}"
	pushd "${build}"
	if [ -z "${2}" ]; then
		./configure --prefix="${outdir}"
	else
		./configure --host="${2}" --prefix="${outdir}"
	fi
	make
	sudo rm -rf "${outdir}"
	sudo make install
	popd
}

if [ "$(gcc -dumpmachine)" != "x86_64-linux-gnu" ]; then
	echo "This script is supposed to run on the native \"x86_64-linux-gnu\" platform !!!"
	exit 1
fi

curl -vkf -o "musl-latest.tar.gz" "https://musl.libc.org/releases/musl-latest.tar.gz"

mk_musl x86_64
mk_musl i686 i686-linux-gnu
mk_musl aarch64 aarch64-linux-gnu
