﻿/******************************************************************************/
/* SlunkCrypt, by LoRd_MuldeR <MuldeR2@GMX.de>                                */
/* This work has been released under the CC0 1.0 Universal license!           */
/******************************************************************************/

using System;
using com.muldersoft.slunkcrypt.gui.utils.cpu;

namespace com.muldersoft.slunkcrypt.gui.process
{
    struct CPUFeatures
    {
        public readonly bool x64;
        public readonly bool hasSSE2;
        public readonly bool hasAVX2;

        private static readonly Lazy<CPUFeatures> cpuFeatures = new Lazy<CPUFeatures>(DetectFeatures);

        public static CPUFeatures Features
        {
            get { return cpuFeatures.Value; }
        }

        public CPUFeatures(bool x64, bool sse2, bool avx2)
        {
            this.x64 = x64;
            this.hasSSE2 = sse2;
            this.hasAVX2 = avx2;
        }

        private static CPUFeatures DetectFeatures()
        {
            try
            {
                return new CPUFeatures(
                    CPU.Architecture.Equals(CPUArchitecture.CPU_ARCH_X64),
                    CPU.Capabilities.HasFlag(CPUCapabilities.CPU_SSE2),
                    CPU.Capabilities.HasFlag(CPUCapabilities.CPU_AVX2));
            }
            catch
            {
                return new CPUFeatures(false, false, false); /*fallback*/
            }
        }
    }
}
