﻿/******************************************************************************/
/* SlunkCrypt, by LoRd_MuldeR <MuldeR2@GMX.de>                                */
/* This work has been released under the CC0 1.0 Universal license!           */
/******************************************************************************/

using System;
using System.Reflection;

namespace com.muldersoft.slunkcrypt.gui.utils
{
    static class VersionInfo
    {
        private static readonly Lazy<Version> m_version = new Lazy<Version>(GetAssemblyVersion);
        private static readonly Lazy<string> m_versionStr = new Lazy<string>(InitVersionString);

        // =============================================================================
        // Properties
        // =============================================================================

        public static Version Version
        {
            get { return m_version.Value; }
        }

        public static string VersionStr
        {
            get { return m_versionStr.Value; }
        }

        // =============================================================================
        // Internal methods
        // =============================================================================

        private static Version GetAssemblyVersion()
        {
            try
            {
                return Assembly.GetExecutingAssembly().GetName().Version;
            }
            catch
            {
                return new Version();
            }
        }

        private static string InitVersionString()
        {
            try
            {
                DateTime buildDate = new DateTime(2000, 1, 1).Add(new TimeSpan(TimeSpan.TicksPerDay * Version.Build + TimeSpan.TicksPerSecond * 2 * Version.Revision));
                return String.Format("Version {0:D}.{1:D}, built on {2}", Version.Major, Version.Minor, buildDate.ToString("yyyy-MM-dd"));
            }
            catch
            {
                return "Unknown version";
            }
        }
    }
}
