/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.action;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.component.FontSelectorDialog;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.StyledEditorKit;
import smart_gs.spread_selection.FontUtil;

public class SetFontFamilyAction
extends StyledEditorKit.FontFamilyAction {
    protected String name;
    protected GSHTMLEditor parentEkit;
    protected FontUtil fontUtilFamily;
    protected FontUtil fontUtilFace;
    protected AtomicBoolean stop = new AtomicBoolean(false);

    public SetFontFamilyAction(GSHTMLEditor ekit, String actionName) {
        super(actionName, "");
        this.name = actionName;
        this.parentEkit = ekit;
        this.fontUtilFamily = new FontUtil(this.parentEkit, "font-family");
        this.fontUtilFace = new FontUtil(this.parentEkit, "face");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int end;
        if (this.stop.get()) {
            return;
        }
        int start = this.parentEkit.getGSHTMLEditorTextPane().getSelectionStart();
        if (start == (end = this.parentEkit.getGSHTMLEditorTextPane().getSelectionEnd())) {
            return;
        }
        if (this.name.equals("[EKITFONTSELECTOR]")) {
            if (this.parentEkit.getFontNameFromSelector() == null) {
                if (this.fontUtilFamily.check(start, end)) {
                    while (this.fontUtilFamily.check(start, end)) {
                        this.fontUtilFamily.releasMakup();
                    }
                    return;
                }
                if (this.fontUtilFace.check(start, end)) {
                    while (this.fontUtilFace.check(start, end)) {
                        this.fontUtilFace.releasMakup();
                    }
                    return;
                }
            } else {
                StyledEditorKit.FontFamilyAction newFontFamilyAction = new StyledEditorKit.FontFamilyAction("fontFamilyAction", this.parentEkit.getFontNameFromSelector());
                newFontFamilyAction.actionPerformed(ae);
            }
        } else {
            FontSelectorDialog fsdInput = new FontSelectorDialog(this.parentEkit.getFrame(), "Select Font*", true, "face", this.parentEkit.getTextPane().getSelectedText());
            String newFace = fsdInput.getFontName();
            if (newFace != null) {
                StyledEditorKit.FontFamilyAction newFontFamilyAction = new StyledEditorKit.FontFamilyAction("fontFamilyAction", newFace);
                newFontFamilyAction.actionPerformed(ae);
            }
        }
    }

    public String getFontType(int start, int end) {
        String valueStr = this.fontUtilFamily.selectValue(start, end);
        if (valueStr != null) {
            return valueStr;
        }
        valueStr = this.fontUtilFace.selectValue(start, end);
        if (valueStr != null) {
            return valueStr;
        }
        return null;
    }

    public void stop() {
        this.stop.set(true);
    }

    public void start() {
        this.stop.set(false);
    }
}

