/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class FontSelectorDialog
extends JDialog
implements ItemListener {
    private Vector vcFontnames = null;
    private final JComboBox jcmbFontlist;
    private String fontName = new String();
    private JOptionPane jOptionPane;
    private final JTextPane jtpFontPreview;
    private String defaultText;

    public FontSelectorDialog(Frame parent, String title, boolean bModal, String attribName, String demoText) {
        super(parent, title, bModal);
        this.defaultText = demoText != null && demoText.length() > 0 ? (demoText.length() > 24 ? demoText.substring(0, 24) : demoText) : "aAbBcCdDeEfFgGhH,.0123";
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.vcFontnames = new Vector(fonts.length - 5);
        for (int i = 0; i < fonts.length; ++i) {
            if (fonts[i].equals("Dialog") || fonts[i].equals("DialogInput") || fonts[i].equals("Monospaced") || fonts[i].equals("SansSerif") || fonts[i].equals("Serif")) continue;
            this.vcFontnames.add(fonts[i]);
        }
        this.jcmbFontlist = new JComboBox(this.vcFontnames);
        this.jcmbFontlist.addItemListener(this);
        this.jtpFontPreview = new JTextPane();
        HTMLEditorKit kitFontPreview = new HTMLEditorKit();
        HTMLDocument docFontPreview = (HTMLDocument)kitFontPreview.createDefaultDocument();
        this.jtpFontPreview.setEditorKit(kitFontPreview);
        this.jtpFontPreview.setDocument(docFontPreview);
        this.jtpFontPreview.setMargin(new Insets(4, 4, 4, 4));
        this.jtpFontPreview.setBounds(0, 0, 120, 18);
        this.jtpFontPreview.setText(this.getFontSampleString(this.defaultText));
        Object[] panelContents = new Object[]{attribName, this.jcmbFontlist, "Font Sample*", this.jtpFontPreview};
        final Object[] buttonLabels = new Object[]{"Accept*", "Cancel*"};
        this.jOptionPane = new JOptionPane(panelContents, 3, 2, null, buttonLabels, buttonLabels[0]);
        this.setContentPane(this.jOptionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                FontSelectorDialog.this.jOptionPane.setValue(new Integer(-1));
            }
        });
        this.jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (FontSelectorDialog.this.isVisible() && e.getSource() == FontSelectorDialog.this.jOptionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = FontSelectorDialog.this.jOptionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    FontSelectorDialog.this.jOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (value.equals(buttonLabels[0])) {
                        FontSelectorDialog.this.fontName = (String)FontSelectorDialog.this.jcmbFontlist.getSelectedItem();
                        FontSelectorDialog.this.setVisible(false);
                    } else {
                        FontSelectorDialog.this.fontName = null;
                        FontSelectorDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            this.jtpFontPreview.setText(this.getFontSampleString(this.defaultText));
        }
    }

    public FontSelectorDialog(Frame parent, String title, boolean bModal, String attribName) {
        this(parent, title, bModal, attribName, "");
    }

    public String getFontName() {
        return this.fontName;
    }

    private String getFontSampleString(String demoText) {
        return "<HTML><BODY><FONT FACE=\"" + this.jcmbFontlist.getSelectedItem() + '\"' + ">" + demoText + "</FONT></BODY></HTML>";
    }
}

