/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.dictionary.image;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import smart_gs.dictionary.Dictionary;
import smart_gs.dictionary.DictionaryRegion;
import smart_gs.dictionary.DictionaryXML;
import smart_gs.dictionary.image.SearchDictionaryResult;
import smart_gs.image_search.ImageSearchFilter;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Region;

public class ImageSearchFilterImpl
implements ImageSearchFilter {
    protected HashMap<String, ArrayList<FilterData>> urlMap = new HashMap();

    public void init() {
        DictionaryXML dictionaryXML = DictionaryXML.getInstance();
        TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
        for (String word : dictionaryMap.keySet()) {
            Dictionary dictionary = dictionaryMap.get(word);
            ArrayList<DictionaryRegion> dictionaryRegions = dictionary.getDictionaryRegionList();
            for (int i = 0; i < dictionaryRegions.size(); ++i) {
                FilterData filterData;
                ArrayList<Object> dictionaryRegionList;
                DictionaryRegion dictionaryRegion = dictionaryRegions.get(i);
                if (this.urlMap.containsKey(dictionaryRegion.getRegion().getBaseURI())) {
                    dictionaryRegionList = this.urlMap.get(dictionaryRegion.getRegion().getBaseURI());
                    filterData = new FilterData();
                    filterData.setWord(word);
                    filterData.setDictionaryRegion(dictionaryRegion);
                    dictionaryRegionList.add(filterData);
                    continue;
                }
                dictionaryRegionList = new ArrayList();
                filterData = new FilterData();
                filterData.setWord(word);
                filterData.setDictionaryRegion(dictionaryRegion);
                dictionaryRegionList.add(filterData);
                this.urlMap.put(dictionaryRegion.getRegion().getBaseURI(), dictionaryRegionList);
            }
        }
    }

    @Override
    public SearchResult filter(SearchResult searchResult) {
        try {
            String uri = searchResult.getBaseURI();
            if (this.urlMap.containsKey(uri)) {
                ArrayList<FilterData> dictionaryRegions = this.urlMap.get(uri);
                for (int i = 0; i < dictionaryRegions.size(); ++i) {
                    FilterData filterData = dictionaryRegions.get(i);
                    DictionaryRegion dictionaryRegion = filterData.getDictionaryRegion();
                    Region region = dictionaryRegion.getRegion();
                    Rectangle rectangle = region.getRectangle();
                    boolean match = this.contains(searchResult.getRectangle(), region.getRectangle());
                    if (!match) continue;
                    SearchDictionaryResult searchDictionaryResult = new SearchDictionaryResult(searchResult.getSpread(), rectangle, searchResult.getScore(), searchResult.getRank(), searchResult.getLineIndex());
                    searchDictionaryResult.setWord(filterData.getWord());
                    return searchDictionaryResult;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean contains(Rectangle a, Rectangle b) {
        return true;
    }

    class FilterData {
        protected String word;
        protected DictionaryRegion dictionaryRegion;

        FilterData() {
        }

        public DictionaryRegion getDictionaryRegion() {
            return this.dictionaryRegion;
        }

        public void setDictionaryRegion(DictionaryRegion dictionaryRegion) {
            this.dictionaryRegion = dictionaryRegion;
        }

        public String getWord() {
            return this.word;
        }

        public void setWord(String word) {
            this.word = word;
        }
    }
}

