/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorDefaultMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.LineSegEditorToolBar;
import smart_gs.util.Intersection2D;

public class LineSegEditorCutMode
implements LineSegEditorMode {
    private static LineSegEditorCutMode singleton = new LineSegEditorCutMode();
    private Point2D start = null;
    private Point2D end = null;
    private ExLine2D cutLine;
    private List<LineSegmentForEdit> selectedLineSingletonList;
    private List<LineSegmentForEdit> originalLines;
    private int selectedLineSegIndex;
    private LineSegEditor editor;
    private LineSegEditorToolBar toolbar;

    private LineSegEditorCutMode() {
    }

    public static LineSegEditorCutMode getInstance() {
        return singleton;
    }

    @Override
    public void mousePressed(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
        if (e.getButton() != 1) {
            this.cancel();
            return;
        }
        if (this.start == null) {
            this.start = e.getPoint();
            return;
        }
        this.end = e.getPoint();
    }

    @Override
    public void mouseClicked(GSMouseEvent e, LineSegEditorCanvas canvas) {
        if (e.getButton() != 1) {
            this.cancel();
            return;
        }
        this.setCursor(canvas);
        if (e.getClickCount() == 2) {
            this.cutLine = new ExLine2D(this.start, this.end);
            this.start = null;
            this.end = null;
            this.LineSegEditorCutModePostProcess(this.cutLine, canvas);
        }
    }

    private void LineSegEditorCutModePostProcess(ExLine2D cutLine, LineSegEditorCanvas canvas) {
        int i;
        Point2D firstCutPoint = null;
        int firstCutSegmentIndex = 0;
        Point2D secondCutPoint = null;
        int secondCutSegmentIndex = 0;
        List<Point2D> points = this.selectedLineSingletonList.get(0).getPoints();
        int size = points.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Line2D.Double tmpLine = new Line2D.Double(points.get(i2), points.get((i2 + 1) % size));
            boolean intsects = this.cutLine.intersectsLine(tmpLine);
            if (!intsects) continue;
            if (firstCutPoint == null) {
                firstCutSegmentIndex = i2;
                firstCutPoint = Intersection2D.getIntersection(cutLine, tmpLine);
                if (firstCutPoint != null) continue;
                JOptionPane.showMessageDialog(null, "Failed to compute the first crossing point for " + i2 + "-th segment. Try again!");
                return;
            }
            if (secondCutPoint == null) {
                secondCutSegmentIndex = i2;
                secondCutPoint = Intersection2D.getIntersection(cutLine, tmpLine);
                if (firstCutPoint != null) continue;
                JOptionPane.showMessageDialog(null, "Failed to compute the second crossing point for " + i2 + "-th segment. Try again!");
                return;
            }
            JOptionPane.showMessageDialog(null, "Too many crossings. Try again!");
            return;
        }
        if (firstCutPoint == null || secondCutPoint == null) {
            System.out.println("Reset");
            return;
        }
        ArrayList<Point2D> firstPoints = new ArrayList<Point2D>();
        ArrayList<Point2D> secondPoints = new ArrayList<Point2D>();
        for (i = 0; i <= firstCutSegmentIndex; ++i) {
            firstPoints.add(points.get(i));
        }
        firstPoints.add(firstCutPoint);
        firstPoints.add(secondCutPoint);
        for (i = secondCutSegmentIndex + 1; i < size; ++i) {
            firstPoints.add(points.get(i));
        }
        secondPoints.add(firstCutPoint);
        for (i = firstCutSegmentIndex + 1; i <= secondCutSegmentIndex; ++i) {
            secondPoints.add(points.get(i));
        }
        secondPoints.add(secondCutPoint);
        if (firstPoints.size() == 0 || secondPoints.size() == 0) {
            JOptionPane.showMessageDialog(null, "Illegal cut line. Try again!");
            return;
        }
        this.originalLines.remove(this.selectedLineSegIndex);
        this.originalLines.add(this.selectedLineSegIndex, new LineSegmentForEdit(secondPoints));
        this.originalLines.add(this.selectedLineSegIndex, new LineSegmentForEdit(firstPoints));
        this.editor.setLinesForEdit(this.originalLines);
        LineSegEditorDefaultMode mode = LineSegEditorDefaultMode.getInstance();
        this.editor.setMode(mode);
        this.toolbar.initializeButtonGroup();
        this.editor.rewriteLineSegIndexes();
        this.editor.repaint();
        this.editor.getLineSegEditorCanvas().getLineSegEditorImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseMoved(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
        this.end = e.getPoint();
        this.setCursor(canvas);
    }

    @Override
    public void paint(Graphics g, LineSegEditorCanvas canvas) {
        if (this.start == null || this.end == null) {
            return;
        }
        double ratio = canvas.getLineSegEditorImageLabel().getRatio();
        double gapX = canvas.getLineSegEditorImageLabel().getGapWidth();
        double gapY = canvas.getLineSegEditorImageLabel().getGapHeight();
        new LineView(new ExLine2D(this.start, this.end)).enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
        this.setCursor(canvas);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void mouseDragged(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
    }

    @Override
    public void mouseEntered(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
    }

    @Override
    public void mouseExited(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
    }

    @Override
    public void mouseReleased(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
    }

    public void setCursor(LineSegEditorCanvas canvas) {
        canvas.getLineSegEditorImageLabel().setCursor(new Cursor(1));
    }

    public void giveSelectedLine(List<LineSegmentForEdit> selectedLineSingletonList) {
        this.selectedLineSingletonList = selectedLineSingletonList;
    }

    public void giveOriginalLines(List<LineSegmentForEdit> originalLines) {
        this.originalLines = originalLines;
    }

    public void giveSelectedLineSegIndex(int index) {
        this.selectedLineSegIndex = index;
    }

    public void giveLineSegEditor(LineSegEditor editor) {
        this.editor = editor;
    }

    public void giveLineSegEditorToolBar(LineSegEditorToolBar toolbar) {
        this.toolbar = toolbar;
    }
}

