/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.state;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.drawing_mode.AnchorMode;
import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorDrawMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.LineSegEditorState;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;

public class LineSegEditorDefaultState
implements LineSegEditorState {
    private LineSegEditorMode mode;
    private Cursor cursor;
    private LineSegEditorCanvas canvas;

    public LineSegEditorDefaultState() {
        this.mode = LineSegEditorDrawMode.getInstance();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public LineSegEditorDefaultState(LineSegEditorCanvas canvas) {
        this.canvas = canvas;
        this.mode = LineSegEditorDrawMode.getInstance();
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void setMode(LineSegEditorMode mode) {
        ImageLabel imageLabel = WorkspaceWindow.getInstance().getSpreadCanvas().getImageLabel();
        this.mode.cancel();
        this.mode = mode;
        imageLabel.setCursor(this.cursor);
    }

    @Override
    public void mouseClicked(GSMouseEvent e, LineSegEditorCanvas canvas) {
        if (e.getButton() == 1) {
            if (WorkspaceWindow.getInstance().onlyOneOfAltCtrlShiftIsPressed()) {
                if (WorkspaceWindow.getInstance().isAlt()) {
                    this.rightButtonClickAction(e);
                } else if (WorkspaceWindow.getInstance().isCtrl()) {
                    this.setMode(LineSegEditorDrawMode.getInstance());
                }
            } else {
                this.mode.mouseClicked(e, canvas);
            }
        } else if (e.getButton() == 3) {
            this.rightButtonClickAction(e);
        } else {
            this.mode.mouseClicked(e, canvas);
        }
    }

    private void rightButtonClickAction(GSMouseEvent e) {
    }

    @Override
    public void mouseDragged(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.mode.mouseDragged(e, canvas);
    }

    @Override
    public void mouseEntered(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.mode.mouseEntered(e, canvas);
    }

    @Override
    public void mouseExited(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.mode.mouseExited(e, canvas);
    }

    @Override
    public void mouseMoved(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.mode.mouseMoved(e, canvas);
    }

    @Override
    public void mousePressed(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.mode.mousePressed(e, canvas);
    }

    @Override
    public void mouseReleased(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.mode.mouseReleased(e, canvas);
    }

    @Override
    public void paint(Graphics g, LineSegEditorCanvas canvas) {
        this.mode.paint(g, canvas);
    }

    @Override
    public LineSegEditorMode getMode() {
        return this.mode;
    }

    @Override
    public int getType() {
        return 0;
    }

    public void changeCursorTo(Mode mode) {
        Point hotSpot = new Point(0, 0);
        Toolkit kit = Toolkit.getDefaultToolkit();
        if (mode instanceof DefaultDrawingMode) {
            this.setCursor(new Cursor(0));
        } else if (mode instanceof RectangleMode) {
            this.setCursor(new Cursor(1));
        } else if (mode instanceof PolygonMode) {
            this.setCursor(new Cursor(1));
        } else if (mode instanceof AnchorMode) {
            Image img = new ImageIcon("./icons/anchor_cursor.png").getImage();
            String name = "anchor_cursor";
            this.setCursor(kit.createCustomCursor(img, hotSpot, name));
        } else if (mode instanceof BookmarkMode) {
            ImageIcon imageIcon = new ImageIcon("./icons/bookmark.png");
            Image img = imageIcon.getImage();
            hotSpot = new Point(10, 30);
            String name = "bookmark_cursor";
            this.setCursor(kit.createCustomCursor(img, hotSpot, name));
        } else if (mode instanceof EraserMode) {
            Image img = new ImageIcon("./icons/eraser.png").getImage();
            String name = "eraser_cursor";
            this.setCursor(kit.createCustomCursor(img, new Point(5, 5), name));
        } else if (mode instanceof MemoPadMode) {
            Image img = new ImageIcon("./icons/memopad_cursor.png").getImage();
            String name = "memopad_cursor";
            this.setCursor(kit.createCustomCursor(img, hotSpot, name));
        } else if (mode instanceof MarkerMode) {
            Image img = new ImageIcon("./icons/marker_cursor.png").getImage();
            String name = "marker_cursor";
            this.setCursor(kit.createCustomCursor(img, hotSpot, name));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }
}

