/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.state;

import java.awt.Graphics;
import java.awt.Point;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.LineSegEditorRightClickMenu;
import smart_gs.drawing_tool.action.MemoPadTextAction;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.LineSegEditorState;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.LineSegment;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class LineSegEditorUniSelectedState
implements LineSegEditorState {
    private static LineSegEditorUniSelectedState singleton = new LineSegEditorUniSelectedState();
    private boolean markupMovable = false;
    private Point start;
    private Point end;
    private LineSegment selectedLineSeg;
    private boolean createArrowPointMode = false;
    private boolean deleteArrowPointMode = false;
    private boolean moveArrowPointMode = false;

    private LineSegEditorUniSelectedState() {
    }

    public static LineSegEditorUniSelectedState getInstance() {
        return singleton;
    }

    @Override
    public void mouseClicked(GSMouseEvent e, LineSegEditorCanvas canvas) {
        if (this.selectedLineSeg == null) {
            return;
        }
        View view = this.selectedLineSeg.getView();
        if (e.getButton() == 3) {
            this.rightButtonClickAction(e, canvas);
        } else if (e.getButton() == 1) {
            if (e.getClickCount() == 2 && view.getType() == 5 && view.contains(e.getPoint2D())) {
                new MemoPadTextAction(this.selectedLineSeg).actionPerformed(e);
            } else if (WorkspaceWindow.getInstance().onlyOneOfAltCtrlShiftIsPressed()) {
                if (WorkspaceWindow.getInstance().isAlt()) {
                    this.rightButtonClickAction(e, canvas);
                } else if (WorkspaceWindow.getInstance().isCtrl()) {
                    DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
                    new ImageToolBarSetModeByMouseEvent().setMode(e, ImageToolBar.modeNone);
                }
            }
        }
    }

    private void rightButtonClickAction(GSMouseEvent e, LineSegEditorCanvas canvas) {
        LineSegEditorRightClickMenu menu = new LineSegEditorRightClickMenu(this.selectedLineSeg, canvas, this);
        menu.show(e.getComponent(), e.getOriginalPoint().x, e.getOriginalPoint().y);
        GlobalViewPanel.getInstance().repaint();
    }

    @Override
    public void mouseDragged(GSMouseEvent e, LineSegEditorCanvas canvas) {
    }

    @Override
    public void mouseEntered(GSMouseEvent e, LineSegEditorCanvas canvas) {
        canvas.repaint();
    }

    @Override
    public void mouseExited(GSMouseEvent e, LineSegEditorCanvas canvas) {
    }

    @Override
    public void mouseMoved(GSMouseEvent e, LineSegEditorCanvas canvas) {
    }

    @Override
    public void mousePressed(GSMouseEvent e, LineSegEditorCanvas canvas) {
    }

    @Override
    public void mouseReleased(GSMouseEvent e, LineSegEditorCanvas canvas) {
    }

    @Override
    public void paint(Graphics g, LineSegEditorCanvas canvas) {
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public LineSegEditorMode getMode() {
        return null;
    }

    @Override
    public void setMode(LineSegEditorMode mode) {
    }
}

