/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.state;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.RightClickMenu;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.action.MemoPadTextAction;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.MultiSelectedState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.region.MemoPadRegion;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class UniSelectedState
implements State {
    private static UniSelectedState singleton = new UniSelectedState();
    private boolean markupMovable = false;
    private Point start;
    private Point end;
    private Region selectedRegion;
    private boolean selectedRegionMoving;
    private boolean createArrowPointMode = false;
    private boolean deleteArrowPointMode = false;
    private boolean moveArrowPointMode = false;

    private UniSelectedState() {
    }

    public static UniSelectedState getInstance() {
        return singleton;
    }

    public boolean getMarkupMovability() {
        return this.markupMovable;
    }

    public void setMarkupMovability(boolean b) {
        this.markupMovable = b;
    }

    @Override
    public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.selectedRegion == null) {
            return;
        }
        boolean ctrlPressed = WorkspaceWindow.getInstance().isCtrl();
        boolean altPressed = WorkspaceWindow.getInstance().isAlt();
        boolean shiftPressed = WorkspaceWindow.getInstance().isShift();
        int clickCount = e.getClickCount();
        int button = e.getButton();
        View view = this.selectedRegion.getView();
        if (button == 3) {
            this.rightButtonClickAction(e, canvas, shiftPressed);
        } else if (button == 1) {
            if (clickCount == 2 && view.getType() == 5 && view.contains(e.getPoint2D())) {
                new MemoPadTextAction(this.selectedRegion).actionPerformed(e);
            } else if (WorkspaceWindow.getInstance().isAlt() && !WorkspaceWindow.getInstance().isCtrl()) {
                this.rightButtonClickAction(e, canvas, WorkspaceWindow.getInstance().isShift());
            } else if (WorkspaceWindow.getInstance().isCtrl()) {
                DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
                new ImageToolBarSetModeByMouseEvent().setMode(e, ImageToolBar.modeNone);
            }
        }
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    private void rightButtonClickAction(GSMouseEvent e, SpreadCanvas canvas, boolean isShift) {
        boolean isTemporary = this.selectedRegion.isTemporary();
        if (isTemporary && isShift) {
            new DeleteRegionAction(this.selectedRegion, this).execute();
        } else {
            RightClickMenu menu = new RightClickMenu(this.selectedRegion, canvas, this, isTemporary);
            menu.show(e.getComponent(), e.getOriginalPoint().x, e.getOriginalPoint().y);
            GlobalViewPanel.getInstance().repaint();
        }
    }

    @Override
    public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
        double xx;
        Point point = e.getPoint();
        double x = ((Point2D)point).getX();
        double y = ((Point2D)point).getY();
        double w = canvas.getImageLabel().getImageWidth();
        double h = canvas.getImageLabel().getImageHeight();
        double d = x <= 2.0 ? 2.0 : (xx = x >= w - 2.0 ? w - 2.0 : x);
        double yy = y <= 2.0 ? 2.0 : (y >= h - 2.0 ? h - 2.0 : y);
        Point2D.Double d2 = new Point2D.Double(xx, yy);
        if (this.selectedRegion != null) {
            View view = this.selectedRegion.getView();
            if (view.isResizable()) {
                this.selectedRegionMoving = true;
                view.resize(d2);
                WorkspaceWindow.setUpdated(true);
            } else if (view.getType() == 5 && this.moveArrowPointMode) {
                int index = ((MemoPadView)view).getIndexOfMovingArrow();
                ((MemoPadView)view).arrowMoveBy(index, d2);
                WorkspaceWindow.setUpdated(true);
            } else {
                this.end = new Point((int)xx, (int)yy);
                if (this.markupMovable && !this.selectedRegion.getView().isProtected() || this.selectedRegion.getView().getType() == 5 && !this.selectedRegion.getView().isProtected() || this.selectedRegion.getView().getType() == 6 && !this.selectedRegion.getView().isProtected() || this.selectedRegion.getView().getType() == 7 && !this.selectedRegion.getView().isProtected()) {
                    Point2D.Double p = new Point2D.Double(this.end.x - this.start.x, this.end.y - this.start.y);
                    this.selectedRegionMoving = true;
                    this.selectedRegion.getView().moveBy(p);
                    WorkspaceWindow.setUpdated(true);
                }
                this.start = this.end;
            }
        }
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseExited(GSMouseEvent e, SpreadCanvas canvas) {
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        boolean buttonThree;
        this.start = e.getPoint();
        if (this.createArrowPointMode) {
            MemoPadView view = (MemoPadView)this.selectedRegion.getView();
            view.addArrow(view.arrowTo(e.getPoint2D()));
            this.createArrowPointMode = false;
            WorkspaceWindow.setUpdated(true);
            return;
        }
        if (this.deleteArrowPointMode) {
            MemoPadView view = (MemoPadView)this.selectedRegion.getView();
            view.deleteArrow(e.getPoint());
            this.deleteArrowPointMode = false;
            ((MemoPadRegion)this.selectedRegion).setDeleteArrowPointMode(false);
            return;
        }
        boolean contains = false;
        boolean contains_in_arrow_head = false;
        int length = canvas.getCurrentSpread().getRegions().size();
        int indexR = -1;
        int indexA = -1;
        for (int i = length - 1; i >= 0; --i) {
            View view = canvas.getCurrentSpread().getRegions().get(i).getView();
            if (view.contains(e.getPoint())) {
                contains = true;
                indexR = i;
                break;
            }
            if (view.getType() != 5) continue;
            if (((MemoPadView)view).containsInArrowHead(e.getPoint())) {
                contains_in_arrow_head = true;
                indexA = i;
                break;
            }
            if (!((MemoPadView)view).containsInArrow(e.getPoint())) continue;
            contains = true;
            indexR = i;
            break;
        }
        boolean regionIsSelected = this.selectedRegion != null;
        boolean buttonOne = e.getButton() == 1;
        boolean bl = buttonThree = e.getButton() == 3;
        if (buttonOne) {
            if (contains && WorkspaceWindow.getInstance().isAlt() && e.isControlDown()) {
                if (regionIsSelected) {
                    this.selectedRegion.getView().setIsSelected(false);
                    ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
                    GlobalViewPanel.getInstance().setSelectedElement(null);
                    GlobalViewPanel.getInstance().repaint();
                    this.selectedRegion = null;
                    DefaultState state = DefaultState.getInstance();
                    ImageLabel.setState(state);
                    state.mousePressed(e, canvas);
                    return;
                }
                DefaultState state = DefaultState.getInstance();
                ImageLabel.setState(state);
                state.mousePressed(e, canvas);
            } else if (regionIsSelected && contains && e.isControlDown() && e.isShiftDown()) {
                MultiSelectedState state = MultiSelectedState.getInstance();
                ImageLabel.setState(state);
                state.addSelectedRegion(this.selectedRegion);
                state.addSelectedRegion(canvas.getRegion(e.getPoint()));
            } else if (buttonOne && contains && e.isShiftDown()) {
                if (regionIsSelected) {
                    this.selectedRegion.getView().setIsSelected(false);
                    ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
                    GlobalViewPanel.getInstance().setSelectedElement(null);
                    GlobalViewPanel.getInstance().repaint();
                }
                this.selectedRegion = canvas.getAnotherRegion(e.getPoint());
                this.selectedRegion.getView().setIsSelected(true);
                ReasoningWebFrame.getInstance().getElementsPanel().setElement(this.selectedRegion);
                GlobalViewPanel.getInstance().setSelectedElement(this.selectedRegion);
                GlobalViewPanel.getInstance().repaint();
            } else if (contains) {
                if (regionIsSelected) {
                    this.selectedRegion.getView().setIsSelected(false);
                    ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
                    GlobalViewPanel.getInstance().setSelectedElement(null);
                    GlobalViewPanel.getInstance().repaint();
                }
                this.selectedRegion = canvas.getRegionByIndex(indexR);
                this.selectedRegion.getView().setIsSelected(true);
                if (DefaultState.getInstance().getMode() == EraserMode.getInstance()) {
                    EraserMode.getInstance().mousePressed(e, canvas);
                    return;
                }
                if (this.getSelectedRegion().getView().getType() == 5) {
                    MemoPadView mview = (MemoPadView)this.selectedRegion.getView();
                    ImageLabel imageLabel = WorkspaceWindow.getInstance().getSpreadCanvas().getImageLabel();
                    double ratio = imageLabel.getRatio();
                    double gapX = imageLabel.getGapWidth();
                    double gapY = imageLabel.getGapHeight();
                    if (mview.containsInCorner(e.getPoint())) {
                        mview.setResizeMode(true);
                    }
                    ReasoningWebFrame.getInstance().getElementsPanel().setElement(this.selectedRegion);
                    GlobalViewPanel.getInstance().setSelectedElement(this.selectedRegion);
                    GlobalViewPanel.getInstance().repaint();
                }
            } else if (contains_in_arrow_head) {
                if (regionIsSelected) {
                    this.selectedRegion.getView().setIsSelected(false);
                    ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
                    GlobalViewPanel.getInstance().setSelectedElement(null);
                    GlobalViewPanel.getInstance().repaint();
                }
                this.setMoveArrowPointMode(true);
                this.selectedRegion = canvas.getRegionByIndex(indexA);
                MemoPadView mview = (MemoPadView)this.selectedRegion.getView();
                mview.setIsSelected(true);
                mview.setIndexOfMovingArrow(e.getPoint2D());
            } else if (regionIsSelected) {
                this.selectedRegion.getView().setIsSelected(false);
                ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
                GlobalViewPanel.getInstance().setSelectedElement(null);
                GlobalViewPanel.getInstance().repaint();
                this.selectedRegion = null;
                DefaultState state = DefaultState.getInstance();
                ImageLabel.setState(state);
                state.mousePressed(e, canvas);
            } else {
                this.selectedRegion = null;
                DefaultState state = DefaultState.getInstance();
                ImageLabel.setState(state);
            }
        } else if (buttonThree) {
            if (contains) {
                if (regionIsSelected) {
                    this.selectedRegion.getView().setIsSelected(false);
                    ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
                    GlobalViewPanel.getInstance().setSelectedElement(null);
                    GlobalViewPanel.getInstance().repaint();
                }
                this.selectedRegion = canvas.getRegionByIndex(indexR);
                this.selectedRegion.getView().setIsSelected(true);
            } else if (contains_in_arrow_head) {
                if (regionIsSelected) {
                    this.selectedRegion.getView().setIsSelected(false);
                    ReasoningWebFrame.getInstance().getElementsPanel().setElement(null);
                    GlobalViewPanel.getInstance().setSelectedElement(null);
                    GlobalViewPanel.getInstance().repaint();
                }
                this.selectedRegion = canvas.getRegionByIndex(indexA);
                this.setMoveArrowPointMode(true);
                MemoPadView mview = (MemoPadView)this.selectedRegion.getView();
                mview.setIsSelected(true);
                mview.setIndexOfMovingArrow(e.getPoint2D());
            }
        }
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
        View view;
        this.selectedRegionMoving = true;
        if (this.selectedRegion != null && (view = this.selectedRegion.getView()).getType() == 5) {
            if (((MemoPadView)view).isResizable()) {
                ((MemoPadView)view).setResizeMode(false);
            } else if (((MemoPadView)view).getIndexOfMovingArrow() >= 0) {
                ((MemoPadView)view).setIndexOfMovingArrow(-1);
                this.moveArrowPointMode = false;
            }
        }
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
    }

    public Region getSelectedRegion() {
        return this.selectedRegion;
    }

    public boolean isSelectedRegionMoving() {
        return this.selectedRegionMoving;
    }

    public void setCreateArrowPointMode(boolean b) {
        this.createArrowPointMode = b;
    }

    public void setDeleteArrowPointMode(boolean b) {
        this.deleteArrowPointMode = b;
        if (this.getSelectedRegion().getView().getType() == 5) {
            ((MemoPadRegion)this.getSelectedRegion()).setDeleteArrowPointMode(b);
        }
    }

    public void setMoveArrowPointMode(boolean b) {
        this.moveArrowPointMode = b;
    }

    public void setSelectedRegion(Region region) {
        this.selectedRegion = region;
    }

    @Override
    public int getType() {
        return 1;
    }
}

