/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.util.Enumeration;
import java.util.Hashtable;

public class PageIndexTable {
    private static PageIndexTable singleton = new PageIndexTable();
    private Hashtable<Integer, Integer> table = new Hashtable();

    public static PageIndexTable getInstance() {
        return singleton;
    }

    private PageIndexTable() {
    }

    public void setIndex(int systemIndex, int userIndex) {
        this.table.put(systemIndex, userIndex);
    }

    public int getSystemIndex(int userIndex) {
        if (this.table.containsValue(userIndex)) {
            Enumeration<Integer> keys = this.table.keys();
            while (keys.hasMoreElements()) {
                int systemIndex = keys.nextElement();
                if (this.table.get(systemIndex) != userIndex) continue;
                return systemIndex;
            }
        }
        return -1;
    }

    public int getUserIndex(int systemIndex) {
        if (this.table.containsKey(systemIndex)) {
            return this.table.get(systemIndex);
        }
        return -1;
    }
}

