/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import smart_gs.logical.GSResource;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.toolbar.action.NewCompactEditorAction;
import smart_gs.swingui.toolbar.action.NewEditorAction;
import smart_gs.swingui.tree.action.AddSpreadDirectoryAction;
import smart_gs.swingui.tree.action.AddSpreadsAction;
import smart_gs.swingui.tree.action.DeleteSelectedSpreadTreeItemsAction;
import smart_gs.swingui.tree.action.ImportImagesAction;
import smart_gs.swingui.tree.action.MakeSpreadDirectoryAction;
import smart_gs.swingui.tree.action.SortSelectedSpreadTreeItemsByNameAction;

public class SpreadSelectPopupMenu
extends JPopupMenu {
    private JMenuItem setSheetNameItem;
    private JMenuItem showSheetItem;

    public SpreadSelectPopupMenu(SpreadTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        int size = paths.length;
        if (size == 0) {
            JOptionPane.showMessageDialog(null, "Select items in ImageTree");
        } else if (size == 1) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            GSResource selectedItem = (GSResource)selectedNode.getUserObject();
            if (selectedItem instanceof SpreadDirectory) {
                SpreadDirectory spreadDirectory = (SpreadDirectory)selectedItem;
                JMenuItem copyAndAddItem = new JMenuItem("Import Images");
                copyAndAddItem.addActionListener(new ImportImagesAction(selectedNode, tree));
                this.add(copyAndAddItem);
                JMenuItem makeDirectory = new JMenuItem("Make New Directory");
                makeDirectory.addActionListener(new MakeSpreadDirectoryAction(selectedNode, tree));
                this.add(makeDirectory);
                JMenuItem deleteItem = new JMenuItem("Delete Selected Directory");
                deleteItem.addActionListener(new DeleteSelectedSpreadTreeItemsAction(tree));
                this.add(deleteItem);
                JMenu imageFolderOperationMenu = new JMenu("Image Folder Operations:");
                this.add(imageFolderOperationMenu);
                JMenuItem addItem = new JMenuItem("Add Images to ImageTree");
                addItem.addActionListener(new AddSpreadsAction(spreadDirectory.getFile(), tree, spreadDirectory));
                imageFolderOperationMenu.add(addItem);
                JMenuItem addDirectory = new JMenuItem("Add Directory and Ancestors to ImageTree");
                addDirectory.addActionListener(new AddSpreadDirectoryAction(spreadDirectory.getFile(), spreadDirectory));
                imageFolderOperationMenu.add(addDirectory);
            } else {
                JMenuItem deleteItem = new JMenuItem("Delete Image");
                deleteItem.addActionListener(new DeleteSelectedSpreadTreeItemsAction(tree));
                this.add(deleteItem);
                JMenuItem openItemInEditor = new JMenuItem("Open in Editor");
                openItemInEditor.addActionListener(new NewEditorAction());
                this.add(openItemInEditor);
                JMenuItem openItemInCompactEditor = new JMenuItem("Open in Compact Editor");
                openItemInCompactEditor.addActionListener(new NewCompactEditorAction());
                this.add(openItemInCompactEditor);
            }
        } else {
            JMenuItem deleteItem = new JMenuItem("Delete Selected Items");
            deleteItem.addActionListener(new DeleteSelectedSpreadTreeItemsAction(tree));
            this.add(deleteItem);
            JMenuItem sortItemByName = new JMenuItem("Sort Selected Items by Name");
            sortItemByName.addActionListener(new SortSelectedSpreadTreeItemsByNameAction(tree));
            this.add(sortItemByName);
        }
    }
}

