/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class MoveTreeToolBar
extends JToolBar
implements ActionListener {
    protected JButton prev = new JButton(new ImageIcon("./icons/prev_page.png"));
    protected JButton next;
    protected int historycounter = 0;
    protected int pathCount = 0;
    private AbstractGSWindow parent;

    public MoveTreeToolBar(AbstractGSWindow parent) {
        this.prev.setEnabled(false);
        this.prev.addActionListener(this);
        this.prev.setActionCommand("prev");
        this.prev.setToolTipText("Previous page (Alt + UP)");
        this.prev.setMnemonic(38);
        this.add(this.prev);
        this.next = new JButton(new ImageIcon("./icons/next_page.png"));
        this.next.setEnabled(false);
        this.next.addActionListener(this);
        this.next.setActionCommand("next");
        this.next.setToolTipText("Next page (Alt + DOWN)");
        this.next.setMnemonic(40);
        this.add(this.next);
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Spread spread;
        int scale = this.parent.getSpreadCanvas().imageLabel.scale;
        ImageLabel.Show lineSegment = this.parent.getSpreadCanvas().imageLabel.getLineSegShowingMode();
        if (e.getActionCommand().equals("next")) {
            Spread spread2 = WorkspaceWindow.getInstance().getSpreadInTree(this.pathCount + 1);
            if (spread2 != null) {
                if (!(this.parent instanceof GSEditor)) {
                    WorkspaceWindow workspaceWindow = WorkspaceWindow.getInstance();
                    workspaceWindow.setSpread(spread2);
                    workspaceWindow.setImageSearch(spread2.toString());
                    workspaceWindow.getSpreadCanvas().imageLabel.setScale(scale);
                    workspaceWindow.getHistoryToolBar().setHistoryCanvasScale(scale);
                    workspaceWindow.getSpreadCanvas().imageLabel.setLineSegShowingMode(lineSegment);
                    workspaceWindow.getSpreadCanvas().imageLabel.showImage();
                } else {
                    GSEditor editor = (GSEditor)this.parent;
                    editor.setSpread(spread2);
                    editor.getSpreadCanvas().imageLabel.setScale(scale);
                    editor.getSpreadCanvas().imageLabel.setLineSegShowingMode(lineSegment);
                    editor.getSpreadCanvas().imageLabel.showImage();
                    editor.updateMoveToolBar();
                }
            }
        } else if (e.getActionCommand().equals("prev") && (spread = WorkspaceWindow.getInstance().getSpreadInTree(this.pathCount - 1)) != null) {
            if (!(this.parent instanceof GSEditor)) {
                WorkspaceWindow workspaceWindow = WorkspaceWindow.getInstance();
                workspaceWindow.setSpread(spread);
                workspaceWindow.setImageSearch(spread.toString());
                workspaceWindow.getSpreadCanvas().imageLabel.setScale(scale);
                workspaceWindow.getHistoryToolBar().setHistoryCanvasScale(scale);
                workspaceWindow.getSpreadCanvas().imageLabel.setLineSegShowingMode(lineSegment);
                workspaceWindow.getSpreadCanvas().imageLabel.showImage();
            } else {
                GSEditor editor = (GSEditor)this.parent;
                editor.setSpread(spread);
                editor.getSpreadCanvas().imageLabel.setScale(scale);
                editor.getSpreadCanvas().imageLabel.setLineSegShowingMode(lineSegment);
                editor.getSpreadCanvas().imageLabel.showImage();
                editor.updateMoveToolBar();
            }
        }
    }

    public void setPathCount(int pathCount) {
        this.pathCount = pathCount;
        Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
        if (spread != null) {
            this.next.setEnabled(true);
        } else {
            this.next.setEnabled(false);
        }
        spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
        if (spread != null) {
            this.prev.setEnabled(true);
        } else {
            this.prev.setEnabled(false);
        }
    }
}

