/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.text_search;

import com.hexidec.ekit.component.ExtendedHTMLEditorKit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.Spread;
import smart_gs.logical.UsersNoteTree;
import smart_gs.text_search.logical.SearchResult;
import smart_gs.text_search.swingui.TextToShow;
import sml_editor.swingui.GSHTMLEditorTextPane;

public class TextSearchEngine {
    private static TextSearchEngine singleton = new TextSearchEngine();
    private String queryText;
    private List<Spread> spreadsToSearch;
    private int documentType;
    private List<SearchResult> results;
    private SmartDocument document;
    private boolean isCaseSensitive;
    private boolean isRegularExpressions;

    public static TextSearchEngine getInstance() {
        return singleton;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public void setRegularExpressions(boolean regularExpressions) {
        this.isRegularExpressions = regularExpressions;
    }

    public void setSearchScope(List<Spread> spreadsToSearch) {
        this.spreadsToSearch = spreadsToSearch;
    }

    public void setDocumentType(int documentType) {
        this.documentType = documentType;
    }

    public void execute() {
        this.results = new ArrayList<SearchResult>();
        switch (this.documentType) {
            case 5: {
                ArrayList arrList1 = (ArrayList)UsersNoteTree.getInstance().getUsersNotes();
                Iterator it1 = arrList1.iterator();
                while (it1.hasNext()) {
                    this.addResults(this.queryText, (SmartDocument)it1.next(), this.isCaseSensitive, this.isRegularExpressions);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.spreadsToSearch.size(); ++i) {
                    this.document = this.spreadsToSearch.get(i).getFirstIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.spreadsToSearch.size(); ++i) {
                    this.document = this.spreadsToSearch.get(i).getFirstIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.spreadsToSearch.size(); ++i) {
                    this.document = this.spreadsToSearch.get(i).getSecondIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.spreadsToSearch.size(); ++i) {
                    this.document = this.spreadsToSearch.get(i).getFirstIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                    this.document = this.spreadsToSearch.get(i).getThirdIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                    this.document = this.spreadsToSearch.get(i).getSecondIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                }
                ArrayList arrList2 = (ArrayList)UsersNoteTree.getInstance().getUsersNotes();
                Iterator it2 = arrList2.iterator();
                while (it2.hasNext()) {
                    this.addResults(this.queryText, (SmartDocument)it2.next(), this.isCaseSensitive, this.isRegularExpressions);
                }
                break;
            }
        }
    }

    private void addResults(String queryText, SmartDocument document, boolean isCaseSensitive, boolean isRegularExpressions) {
        block9: {
            String documentURI = document.getURI();
            String source = document.getSource();
            GSHTMLEditorTextPane tempTextPane = new GSHTMLEditorTextPane(null, null);
            ExtendedHTMLEditorKit htmlKit = new ExtendedHTMLEditorKit();
            tempTextPane.setEditorKit(htmlKit);
            source = source.replaceAll(" ", "&nbsp;");
            tempTextPane.setText(source);
            Document baseDocument = tempTextPane.getDocument();
            try {
                String plainText = baseDocument.getText(0, baseDocument.getLength());
                String ccQuery = this.convertCase(queryText, isCaseSensitive);
                String ccText = this.convertCase(plainText, isCaseSensitive);
                int lengthOfQuery = queryText.length();
                int i = 0;
                if (ccText == null) {
                    return;
                }
                if (isRegularExpressions) {
                    try {
                        Pattern p = Pattern.compile(ccQuery);
                        Matcher m = p.matcher(ccText);
                        while (m.find()) {
                            int indexOfResult = m.start();
                            String resultStr = m.group();
                            SearchResult result = new SearchResult();
                            result.setResult(resultStr, documentURI, indexOfResult);
                            TextToShow textToShow = this.textToShow(indexOfResult, resultStr.length(), plainText);
                            result.setTextToShow(textToShow);
                            this.results.add(result);
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block9;
                    }
                }
                if (ccText.indexOf(ccQuery) == -1) break block9;
                while (true) {
                    int indexOfResult;
                    if ((indexOfResult = ccText.indexOf(ccQuery, i)) == -1) {
                        i = 0;
                        break;
                    }
                    SearchResult result = new SearchResult();
                    result.setResult(queryText, documentURI, indexOfResult);
                    TextToShow textToShow = this.textToShow(indexOfResult, lengthOfQuery, plainText);
                    result.setTextToShow(textToShow);
                    this.results.add(result);
                    i = indexOfResult + ccQuery.length();
                }
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private String convertCase(String source, boolean isCaseSensitive) {
        if (source == null) {
            return null;
        }
        if (isCaseSensitive) {
            return source;
        }
        return source.toLowerCase();
    }

    private TextToShow textToShow(int index, int lengthOfQuery, String text) {
        String textToShow = text.substring(index, index + lengthOfQuery);
        int num = 10;
        int length = text.length();
        String pre = index + 1 <= 10 ? (index == 0 ? "" : text.substring(0, index)) : "..." + text.substring(index - 10, index);
        String query = text.substring(index, index + lengthOfQuery);
        String fol = length - index - lengthOfQuery <= 10 ? (length - index - lengthOfQuery == 0 ? "" : text.substring(index + lengthOfQuery)) : text.substring(index + lengthOfQuery, index + lengthOfQuery + 10) + "...";
        textToShow = pre + query + fol;
        return new TextToShow(textToShow, pre.length(), lengthOfQuery);
    }

    public List<SearchResult> getResults() {
        return this.results;
    }
}

