/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import smart_gs.logical.LineSegment;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;

public class SegfoToLineConverter {
    private Spread spread;
    String file_name;

    public SegfoToLineConverter(Spread spread) {
        this.spread = spread;
        this.file_name = spread.getFileName();
    }

    public List<LineSegment> getLines(File file) {
        return this.getLines(file, this.file_name);
    }

    public List<LineSegment> getLines(File file, String file_name) {
        int i;
        int i2;
        String secondLineString;
        String firstLineString;
        ArrayList<LineSegment> lines = new ArrayList<LineSegment>();
        StringBuffer bodyBufStr = new StringBuffer();
        try {
            String tmp_str;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            firstLineString = br.readLine();
            if (firstLineString == null) {
                System.out.println("Someting wrong to read the first line of the file: " + file);
                return null;
            }
            secondLineString = br.readLine();
            if (secondLineString == null) {
                System.out.println("Someting wrong to read the second line of the file: " + file);
                return null;
            }
            while ((tmp_str = br.readLine()) != null) {
                bodyBufStr.append(tmp_str);
                bodyBufStr.append('\t');
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Something wrong to read the file: " + file);
            return null;
        }
        int start = firstLineString.indexOf(file_name);
        for (i2 = 0; i2 < start; ++i2) {
            if (Character.isWhitespace(firstLineString.indexOf(i2))) continue;
            System.out.println(String.format("1st line \"%s\" does not match the spread file name: \"%s\"", firstLineString, file_name));
            return null;
        }
        for (i2 = start + file_name.length(); i2 < firstLineString.length(); ++i2) {
            if (Character.isWhitespace(firstLineString.indexOf(i2))) continue;
            System.out.println(String.format("1st line \"%s\" does not match the spread file name: \"%s\"", firstLineString, file_name));
            return null;
        }
        String directionInString = new String();
        directionInString = Preference.getInstance().getTextType() == 0 ? "Horizontal" : "Vertical";
        start = secondLineString.indexOf(directionInString);
        for (i = 0; i < start; ++i) {
            if (Character.isWhitespace(secondLineString.indexOf(i))) continue;
            System.out.println(String.format("2nd line \"%s\" of  \"%s\" does not match the current mode \"%s\"", secondLineString, file_name, directionInString));
            return null;
        }
        for (i = start + directionInString.length(); i < secondLineString.length(); ++i) {
            if (Character.isWhitespace(secondLineString.indexOf(i))) continue;
            System.out.println(String.format("2nd line \"%s\" of  \"%s\" does not match the current mode \"%s\"", secondLineString, file_name, directionInString));
            return null;
        }
        String file_contents = bodyBufStr.toString();
        String[] tokenArray = file_contents.split("[\\x20\\u0009\\u000D]+");
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int i3 = 0; i3 < tokenArray.length; ++i3) {
            if (tokenArray[i3].isEmpty()) {
                ++i3;
            }
            try {
                int tmpInt = Integer.parseInt(tokenArray[i3]);
                intList.add(tmpInt);
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println(String.format("%d-th element %d of  \"%s\" cannot be parsed as an integer", i3, file_name, tokenArray[i3]));
                return null;
            }
        }
        if ((Integer)intList.get(intList.size() - 1) != -99999) {
            System.out.println(String.format("The last token should be -99999, but is %d in  \"%s\" ", intList.get(intList.size()), file_name));
        }
        intList.remove(intList.size() - 1);
        ArrayList<Point2D> tmpPointsList = new ArrayList<Point2D>();
        int size = intList.size();
        int index = 0;
        for (int i4 = 0; i4 < size; ++i4) {
            int tmpIntX = (Integer)intList.get(i4);
            if (tmpIntX == -1) {
                if (tmpPointsList.isEmpty()) {
                    System.out.println(String.format("The line ends with %d-th element -1 is empty", i4));
                    return null;
                }
                lines.add(new LineSegment(this.spread, tmpPointsList, index));
                ++index;
                tmpPointsList = new ArrayList();
                continue;
            }
            if (tmpIntX < 0) {
                System.out.println(String.format("%d-th integer %d (x-axis) in the body is negative ", i4, tmpIntX));
            }
            if (++i4 >= size) {
                System.out.println(String.format("The data did not end with -1", new Object[0]));
                return null;
            }
            int tmpIntY = (Integer)intList.get(i4);
            if (tmpIntY < 0) {
                System.out.println(String.format("%d-th integer (y-axis) %d in the body is negative ", i4, tmpIntX));
            }
            tmpPointsList.add(new Point2D.Double(tmpIntX, tmpIntY));
        }
        return lines;
    }

    public List<LineSegmentForEdit> getLinesForEdit(File file) {
        return this.getLinesForEdit(file, this.file_name);
    }

    public List<LineSegmentForEdit> getLinesForEdit(File file, String file_name) {
        int i;
        int i2;
        String secondLineString;
        String firstLineString;
        ArrayList<LineSegmentForEdit> lines = new ArrayList<LineSegmentForEdit>();
        StringBuffer bodyBufStr = new StringBuffer();
        try {
            String tmp_str;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            firstLineString = br.readLine();
            if (firstLineString == null) {
                System.out.println("Someting wrong to read the first line of the file: " + file);
                return null;
            }
            secondLineString = br.readLine();
            if (secondLineString == null) {
                System.out.println("Someting wrong to read the second line of the file: " + file);
                return null;
            }
            while ((tmp_str = br.readLine()) != null) {
                bodyBufStr.append(tmp_str);
                bodyBufStr.append('\t');
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Something wrong to read the file: " + file);
            return null;
        }
        int start = firstLineString.indexOf(file_name);
        for (i2 = 0; i2 < start; ++i2) {
            if (Character.isWhitespace(firstLineString.indexOf(i2))) continue;
            System.out.println(String.format("1st line \"%s\" does not match the spread file name: \"%s\"", firstLineString, file_name));
            return null;
        }
        for (i2 = start + file_name.length(); i2 < firstLineString.length(); ++i2) {
            if (Character.isWhitespace(firstLineString.indexOf(i2))) continue;
            System.out.println(String.format("1st line \"%s\" does not match the spread file name: \"%s\"", firstLineString, file_name));
            return null;
        }
        String directionInString = new String();
        directionInString = Preference.getInstance().getTextType() == 0 ? "Horizontal" : "Vertical";
        start = secondLineString.indexOf(directionInString);
        for (i = 0; i < start; ++i) {
            if (Character.isWhitespace(secondLineString.indexOf(i))) continue;
            System.out.println(String.format("2nd line \"%s\" does not match the current mode \"%s\"", secondLineString, directionInString));
            return null;
        }
        for (i = start + directionInString.length(); i < secondLineString.length(); ++i) {
            if (Character.isWhitespace(secondLineString.indexOf(i))) continue;
            System.out.println(String.format("2nd line \"%s\" does not match the current mode \"%s\"", secondLineString, directionInString));
            return null;
        }
        String file_contents = bodyBufStr.toString();
        String[] tokenArray = file_contents.split("[\\x20\\u0009\\u000D]+");
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int i3 = 0; i3 < tokenArray.length; ++i3) {
            if (tokenArray[i3].isEmpty()) {
                ++i3;
            }
            try {
                int tmpInt = Integer.parseInt(tokenArray[i3]);
                intList.add(tmpInt);
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println(String.format("%d-th element %d cannot be parsed as an integer", i3, tokenArray[i3]));
                return null;
            }
        }
        if ((Integer)intList.get(intList.size() - 1) != -99999) {
            System.out.println(String.format("The last token should be -99999, but is %d", intList.get(intList.size())));
        }
        intList.remove(intList.size() - 1);
        ArrayList<Point2D> tmpPointsList = new ArrayList<Point2D>();
        int size = intList.size();
        for (int i4 = 0; i4 < size; ++i4) {
            int tmpIntX = (Integer)intList.get(i4);
            if (tmpIntX == -1) {
                if (tmpPointsList.isEmpty()) {
                    System.out.println(String.format("The line ends with %d-th element -1 is empty", i4));
                    return null;
                }
                lines.add(new LineSegmentForEdit(tmpPointsList));
                tmpPointsList = new ArrayList();
                continue;
            }
            if (tmpIntX < 0) {
                System.out.println(String.format("%d-th integer %d (x-axis) in the body is negative ", i4, tmpIntX));
            }
            if (++i4 >= size) {
                System.out.println(String.format("The data did not end with -1", new Object[0]));
                return null;
            }
            int tmpIntY = (Integer)intList.get(i4);
            if (tmpIntY < 0) {
                System.out.println(String.format("%d-th integer (y-axis) %d in the body is negative ", i4, tmpIntX));
            }
            tmpPointsList.add(new Point2D.Double(tmpIntX, tmpIntY));
        }
        return lines;
    }
}

