/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.swingui;

import com.hexidec.ekit.PasteListener;
import com.hexidec.ekit.UnicodeDecode;
import com.hexidec.ekit.action.RedoAction;
import com.hexidec.ekit.action.UndoAction;
import com.hexidec.ekit.component.ExtendedHTMLDocument;
import com.hexidec.ekit.component.ExtendedHTMLEditorKit;
import com.hexidec.ekit.component.HTMLUtilities;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.Keymap;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sml_editor.swingui.EditorMouseListener;

public class GSHTMLEditorTextPane
extends JTextPane
implements MouseListener,
FocusListener,
CaretListener {
    private static int n = 0;
    private DocumentListener docListener;
    private EditorMouseListener mouseListener;
    private PasteListener pasteListener;
    private int count = 0;
    private List<String> tagNames;
    private String emphasizeId;
    public static int DEFAULT_FONT_SIZE = 20;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected static String DUMMY_CHAR = "\u0001";
    protected static String DUMMY_CHAR_HTML = "&#1;";

    public GSHTMLEditorTextPane(UndoAction undoAction, RedoAction redoAction) {
        this.setContentType("text/html");
        this.undoAction = undoAction;
        this.redoAction = redoAction;
        this.tagNames = this.createTagList();
        Style defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontSize(defStyle, DEFAULT_FONT_SIZE);
        this.setFont(new Font("default", 0, 20));
        this.updateText();
        this.addFocusListener(this);
        this.addCaretListener(this);
    }

    private void checkTagName(Element element) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            String tagName = elem.getNodeName();
            if (!tagName.equals("br")) {
                this.addTagList(tagName);
            }
            this.checkTagName(elem);
        }
    }

    @Override
    public void setText(String t) {
        t = t.replaceAll(DUMMY_CHAR_HTML, "");
        super.setText(t + DUMMY_CHAR);
    }

    @Override
    public String getText() {
        String rtn = super.getText();
        return rtn.replaceAll(DUMMY_CHAR_HTML, "");
    }

    @Override
    public String getSelectedText() {
        int p1;
        String src = null;
        Caret caret = this.getCaret();
        int p0 = Math.min(caret.getDot(), caret.getMark());
        if (p0 != (p1 = Math.max(caret.getDot(), caret.getMark()))) {
            String body;
            src = body = HTMLUtilities.getBodyText(super.getText());
            src = src.replaceAll(" ", "");
            src = src.replaceAll("\r", "");
            src = src.replaceAll("\n", "");
            src = src.replaceAll("\r\n", "");
            src = src.replaceAll("\\</p\\>", "\n");
            src = src.replaceAll("\\<br\\>", "\n");
            Pattern pattern = Pattern.compile("<.+?>", 32);
            Matcher matcher = pattern.matcher(src);
            src = matcher.replaceAll("");
            src = src.replaceAll("&amp;", "&");
            src = src.replaceAll("&quot;", "\"");
            src = src.replaceAll("&gt;", "<");
            src = src.replaceAll("&lt;", ">");
            src = src.replaceAll("&#160;", " ");
            src = src.replaceAll(DUMMY_CHAR_HTML, "");
            src = UnicodeDecode.decode(src);
            src = src.substring(Math.max(0, p0 - 1), Math.min(src.length(), p1 - 1));
        }
        return src;
    }

    public List<String> createTagList() {
        ArrayList<String> tagNames = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("tags.txt"));
            while ((line = reader.readLine()) != null) {
                tagNames.add(line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tagNames;
    }

    public void addTagList(String tagname) {
        if (!this.tagNames.contains(tagname)) {
            this.tagNames.add(tagname);
        }
    }

    public List getTagNames() {
        return this.tagNames;
    }

    public void updateText() {
    }

    public void emphasize(String id) {
        this.emphasizeId = id;
    }

    private Node getNode(Node node, int index) {
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() == 3) {
                this.count += n.getNodeValue().length();
                if (this.count >= index) {
                    this.count = 0;
                    return n;
                }
            } else if (n.getNodeName().equals("br")) {
                ++this.count;
            }
            if ((n = this.getNode(n, index)) == null) continue;
            return n;
        }
        return null;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        try {
            String body;
            ExtendedHTMLDocument htmlDoc = (ExtendedHTMLDocument)this.getDocument();
            if (e.getDot() == htmlDoc.getLength() && htmlDoc.getLength() > 1 && (body = HTMLUtilities.getBodyText(super.getText())).endsWith(DUMMY_CHAR_HTML + "\n")) {
                if (e.getDot() == e.getMark()) {
                    this.setCaretPosition(htmlDoc.getLength() - 1);
                } else {
                    this.moveCaretPosition(htmlDoc.getLength() - 1);
                    new DelayCaret(e.getMark(), htmlDoc.getLength() - 1).start();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setDocumentListener(DocumentListener docListener) {
        this.getStyledDocument().removeDocumentListener(this.docListener);
        this.docListener = docListener;
        this.getStyledDocument().addDocumentListener(this.docListener);
    }

    public void setMouseListener(EditorMouseListener mouseListener) {
        this.removeMouseListener(this.mouseListener);
        this.mouseListener = mouseListener;
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.validate();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.emphasizeId = null;
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        Keymap km = this.getKeymap();
        KeyStroke ksctrlz = KeyStroke.getKeyStroke(90, 2);
        km.addActionForKeyStroke(ksctrlz, this.undoAction);
        KeyStroke ksctrly = KeyStroke.getKeyStroke(89, 2);
        km.addActionForKeyStroke(ksctrly, this.redoAction);
        KeyStroke ksctrlv = KeyStroke.getKeyStroke(86, 2);
        km.addActionForKeyStroke(ksctrlv, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GSHTMLEditorTextPane.this.paste(true);
            }
        });
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void setPasteListener(PasteListener pasteListener) {
        this.pasteListener = pasteListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paste(boolean allowHtml) {
        Clipboard clp = this.getToolkit().getSystemClipboard();
        Transferable data = clp.getContents(this);
        try {
            this.pasteListener.stopDocumentListener();
            if (data.isDataFlavorSupported(new DataFlavor("text/html;class=java.lang.String")) && allowHtml) {
                boolean isFirst = this.getCaretPosition() <= 1;
                ExtendedHTMLEditorKit kit = (ExtendedHTMLEditorKit)this.getEditorKit();
                kit.setReadWithoutHeader(true);
                super.paste();
                kit.setReadWithoutHeader(false);
                int pos = this.getCaretPosition();
                this.setText(HTMLUtilities.getBodyText(super.getText()));
                if (isFirst) {
                    this.setCaretPosition(pos - 1);
                } else {
                    this.setCaretPosition(pos - 2);
                }
            } else {
                boolean isFirst = this.getCaretPosition() <= 1;
                this.pasteListener.paste();
                int pos = this.getCaretPosition();
                this.setText(HTMLUtilities.getBodyText(super.getText()));
                if (isFirst && pos + 1 == this.getDocument().getLength() - 1) {
                    this.setCaretPosition(pos + 1);
                } else {
                    this.setCaretPosition(pos);
                }
            }
            this.pasteListener.learn();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.pasteListener.startDocumentListener();
        }
    }

    @Override
    public void copy() {
        super.copy();
    }

    public class DelayCaret
    extends Thread {
        int pos = 0;
        int mark = 0;

        public DelayCaret(int mark, int pos) {
            this.mark = mark;
            this.pos = pos;
        }

        @Override
        public void run() {
            GSHTMLEditorTextPane.this.setCaretPosition(this.mark);
            GSHTMLEditorTextPane.this.moveCaretPosition(this.pos);
        }
    }
}

