/*
 * Decompiled with CFR 0.152.
 */
package webdav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.webdav.lib.Lock;
import webdav.PropFindInfo;
import webdav.WebDavDownLoadEvent;
import webdav.WebDavProcessor;
import webdav.WebDavUploadLoadEvent;
import webdav.table.PropFindModel;
import webdav.table.PropFindRenderer;
import webdav.table.PropFindSort;

public class WebDavViewTableFactory {
    private final PropFindModel model = new PropFindModel();
    private final JTable table;
    protected WebDavProcessor webDavProcessor;
    protected WebDavDownLoadEvent webDavDownLoadEvent;
    protected WebDavUploadLoadEvent webDavUploadLoadEvent;
    protected Stack<String> stack = new Stack();
    protected String owner = "user";
    protected JTextField filenameField;
    protected int mode;
    protected String lockToken;
    public static final int INITIALIZE = 0;
    public static final int DOWNLOAD_DONE = 100;
    public static final int UPLOAD_DONE = 200;
    protected int event = 0;

    public WebDavViewTableFactory(int mode_, PropFindInfo[] propFindInfos, Color backgroundColor) {
        this.mode = mode_;
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, false, false, row, column);
            }
        });
        this.table.setIntercellSpacing(new Dimension());
        this.table.setShowGrid(false);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setMinWidth(0);
        col.setMaxWidth(0);
        col.setResizable(false);
        col = this.table.getColumnModel().getColumn(1);
        col.setCellRenderer(new PropFindRenderer(this.table));
        col.setPreferredWidth(100);
        col = this.table.getColumnModel().getColumn(2);
        col.setPreferredWidth(300);
        InputMap im = this.table.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke stab = KeyStroke.getKeyStroke(9, 1);
        KeyStroke senter = KeyStroke.getKeyStroke(10, 64);
        im.put(tab, im.get(enter));
        im.put(stab, im.get(senter));
        if (propFindInfos != null) {
            for (int i = 0; i < propFindInfos.length; ++i) {
                this.model.addPropFindList(propFindInfos[i]);
            }
        }
        final Color orgColor = this.table.getSelectionBackground();
        final Color tflColor = backgroundColor;
        this.table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                WebDavViewTableFactory.this.table.setSelectionForeground(Color.WHITE);
                WebDavViewTableFactory.this.table.setSelectionBackground(orgColor);
            }

            @Override
            public void focusLost(FocusEvent e) {
                WebDavViewTableFactory.this.table.setSelectionForeground(Color.BLACK);
                WebDavViewTableFactory.this.table.setSelectionBackground(tflColor);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Point pt = me.getPoint();
                int row = WebDavViewTableFactory.this.table.rowAtPoint(pt);
                String name = (String)WebDavViewTableFactory.this.model.getValueAt(row, 1);
                String size = (String)WebDavViewTableFactory.this.model.getValueAt(row, 3);
                if (me.getClickCount() == 2) {
                    if (size.equals("")) {
                        WebDavViewTableFactory.this.model.clear();
                        try {
                            String path_;
                            boolean upflg = false;
                            if (name.equals("..")) {
                                WebDavViewTableFactory.this.stack.pop();
                                name = "";
                                upflg = true;
                            }
                            if ((path_ = WebDavViewTableFactory.this.stack.peek()) == null) {
                                path_ = "";
                            }
                            if (!path_.equals("")) {
                                if (!path_.equals("/")) {
                                    if (!path_.endsWith("/")) {
                                        path_ = path_ + "/";
                                    }
                                } else {
                                    path_ = "";
                                }
                                if (path_.startsWith("/")) {
                                    path_ = path_.substring(1, path_.length());
                                }
                            }
                            PropFindInfo[] propFindInfoChild = WebDavViewTableFactory.this.webDavProcessor.getPropFindInfo(path_ + name, 1);
                            if (WebDavViewTableFactory.this.stack.size() != 1 || !upflg) {
                                PropFindInfo propFindInfo = new PropFindInfo();
                                propFindInfo.setDisplayname("..");
                                propFindInfo.setDirectory(true);
                                WebDavViewTableFactory.this.model.addPropFindList(propFindInfo);
                            }
                            if (propFindInfoChild != null) {
                                propFindInfoChild = new PropFindSort().sort(propFindInfoChild);
                                for (int i = 0; i < propFindInfoChild.length; ++i) {
                                    WebDavViewTableFactory.this.model.addPropFindList(propFindInfoChild[i]);
                                }
                            }
                            if (!upflg) {
                                WebDavViewTableFactory.this.stack.push(path_ + name);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        String path = WebDavViewTableFactory.this.stack.peek();
                        if (WebDavViewTableFactory.this.mode == 0) {
                            WebDavViewTableFactory.this.download(path, name);
                        } else {
                            WebDavViewTableFactory.this.filenameField.setText(name);
                        }
                    }
                } else if (WebDavViewTableFactory.this.mode == 1 && !size.equals("") && WebDavViewTableFactory.this.filenameField != null) {
                    WebDavViewTableFactory.this.filenameField.setText(name);
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (WebDavViewTableFactory.this.mode != 1) {
                    return;
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = WebDavViewTableFactory.this.table.getSelectedRow();
                if (row == -1) {
                    return;
                }
                String name = (String)WebDavViewTableFactory.this.model.getValueAt(row, 1);
                String size = (String)WebDavViewTableFactory.this.model.getValueAt(row, 3);
                if (!size.equals("") && WebDavViewTableFactory.this.filenameField != null) {
                    WebDavViewTableFactory.this.filenameField.setText(name);
                }
            }
        });
        this.stack.push("");
    }

    public boolean download(String path, String name) {
        try {
            boolean unlock = true;
            PropFindInfo[] propFindInfoChild = this.webDavProcessor.getPropFindInfo(path, name, 0);
            ArrayList lockList = propFindInfoChild[0].getLocks();
            boolean readonly = false;
            if (lockList.size() != 0) {
                boolean lockcheck = true;
                if (this.lockToken != null) {
                    for (int i = 0; i < lockList.size(); ++i) {
                        Lock lock = (Lock)lockList.get(i);
                        String lockTokenTemp = lock.getLockToken();
                        if (lockTokenTemp == null || !this.lockToken.equals(lockTokenTemp)) continue;
                        lockcheck = false;
                        break;
                    }
                }
                if (lockcheck) {
                    readonly = true;
                } else {
                    this.webDavProcessor.unlock(path, name, this.lockToken);
                    unlock = false;
                }
            }
            if (JOptionPane.showConfirmDialog(new JFrame(), "Do you download it?") != 0) {
                return false;
            }
            String lockTokenTemp = null;
            if (!this.webDavProcessor.download(path, name, "./temp/gs/")) {
                JOptionPane.showMessageDialog(new JFrame(), "Download failure", "error", 0);
                return false;
            }
            if (this.webDavDownLoadEvent != null) {
                this.webDavDownLoadEvent.setDownload("./temp/gs/" + name, lockTokenTemp);
                this.webDavDownLoadEvent.setDownloadpath(path);
                this.webDavDownLoadEvent.setDownloaname(name);
                this.webDavDownLoadEvent.setStack(this.stack);
                this.webDavDownLoadEvent.setUnlock(unlock);
                this.webDavDownLoadEvent.setReadonly(readonly);
            }
            return true;
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(new JFrame(), "Download failure", "error", 0);
            return true;
        }
    }

    public boolean downlaod() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return false;
        }
        String path = this.stack.peek();
        String name = (String)this.model.getValueAt(row, 1);
        String size = (String)this.model.getValueAt(row, 3);
        if (size.equals("")) {
            return false;
        }
        return this.download(path, name);
    }

    public boolean upload() {
        if (this.webDavUploadLoadEvent == null) {
            return true;
        }
        boolean unlock = true;
        String path = this.stack.peek();
        try {
            if (this.filenameField == null) {
                return true;
            }
            String name = this.filenameField.getText();
            boolean lockcheck = true;
            if (this.filenameField != null) {
                String oldname = this.webDavUploadLoadEvent.getUploadname();
                if (oldname == null) {
                    oldname = "";
                }
                if (oldname.equals(name)) {
                    if (this.webDavUploadLoadEvent.isReadonly()) {
                        JOptionPane.showMessageDialog(new JFrame(), "This file is locked. ", "locked", 0);
                        return false;
                    }
                    PropFindInfo[] propFindInfoChild = this.webDavProcessor.getPropFindInfo(path, name, 0);
                    if (propFindInfoChild != null) {
                        int input;
                        ArrayList lockList = propFindInfoChild[0].getLocks();
                        if (lockList.size() != 0) {
                            if (this.lockToken != null) {
                                for (int i = 0; i < lockList.size(); ++i) {
                                    Lock lock = (Lock)lockList.get(i);
                                    String lockTokenTemp = lock.getLockToken();
                                    if (lockTokenTemp == null || !this.lockToken.equals(lockTokenTemp)) continue;
                                    lockcheck = false;
                                    break;
                                }
                            }
                            if (lockcheck) {
                                JOptionPane.showMessageDialog(new JFrame(), "This file is locked. ", "locked", 0);
                                return false;
                            }
                            unlock = false;
                        }
                        if ((input = JOptionPane.showConfirmDialog(new JFrame(), "Do you overwrite?")) != 0) {
                            return false;
                        }
                    }
                }
            }
            if (name.equals("")) {
                JOptionPane.showMessageDialog(new JFrame(), "Please input the file name.", "error", 0);
                return false;
            }
            File file = this.webDavUploadLoadEvent.getUploadfile();
            String uploadlockToken = null;
            if (!lockcheck) {
                uploadlockToken = this.lockToken;
            }
            if (!this.webDavProcessor.upload(path, name, file, uploadlockToken)) {
                JOptionPane.showMessageDialog(new JFrame(), "Upload failure", "error", 0);
                return false;
            }
            if (this.webDavDownLoadEvent != null) {
                this.webDavDownLoadEvent.setDownload("./temp/gs/" + name, this.lockToken);
                this.webDavDownLoadEvent.setDownloadpath(path);
                this.webDavDownLoadEvent.setDownloaname(name);
                this.webDavDownLoadEvent.setStack(this.stack);
                this.webDavDownLoadEvent.setUnlock(unlock);
                this.webDavDownLoadEvent.setReadonly(false);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(new JFrame(), "Upload failure", "error", 0);
            return false;
        }
        return true;
    }

    public void unlock() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String name = (String)this.model.getValueAt(row, 1);
        String size = (String)this.model.getValueAt(row, 3);
        if (!size.equals("")) {
            try {
                String path = this.stack.peek();
                PropFindInfo[] propFindInfoChild = this.webDavProcessor.getPropFindInfo(path, name, 0);
                ArrayList lockList = propFindInfoChild[0].getLocks();
                if (lockList.size() == 0) {
                    JOptionPane.showMessageDialog(new JFrame(), "This file is not locked. ", "locked", 0);
                    return;
                }
                Lock lock = (Lock)lockList.get(0);
                this.webDavProcessor.unlock(path, name, lock.getLockToken());
                this.model.clear();
                propFindInfoChild = this.webDavProcessor.getPropFindInfo(path, 1);
                if (propFindInfoChild != null) {
                    if (this.stack.size() != 1) {
                        PropFindInfo propFindInfo = new PropFindInfo();
                        propFindInfo.setDisplayname("..");
                        propFindInfo.setDirectory(true);
                        this.model.addPropFindList(propFindInfo);
                    }
                    propFindInfoChild = new PropFindSort().sort(propFindInfoChild);
                    for (int i = 0; i < propFindInfoChild.length; ++i) {
                        this.model.addPropFindList(propFindInfoChild[i]);
                    }
                }
                if (this.webDavUploadLoadEvent != null) {
                    this.webDavUploadLoadEvent.setReadonly(false);
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(new JFrame(), "Unlock failure", "error", 0);
            }
        }
    }

    public void lock() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        String name = (String)this.model.getValueAt(row, 1);
        String size = (String)this.model.getValueAt(row, 3);
        if (!size.equals("")) {
            try {
                String path = this.stack.peek();
                PropFindInfo[] propFindInfoChild = this.webDavProcessor.getPropFindInfo(path, name, 0);
                ArrayList lockList = propFindInfoChild[0].getLocks();
                if (lockList.size() != 0) {
                    JOptionPane.showMessageDialog(new JFrame(), "This file is locked. ", "locked", 0);
                    return;
                }
                String lockTokenTemp = this.webDavProcessor.lock(path, name, this.owner);
                if (lockTokenTemp == null) {
                    JOptionPane.showMessageDialog(new JFrame(), "It failed in the lock.", "locked", 0);
                    return;
                }
                if (this.webDavDownLoadEvent != null) {
                    this.webDavDownLoadEvent.setLockToken(lockTokenTemp);
                }
                this.model.clear();
                propFindInfoChild = this.webDavProcessor.getPropFindInfo(path, 1);
                if (propFindInfoChild != null) {
                    if (this.stack.size() != 1) {
                        PropFindInfo propFindInfo = new PropFindInfo();
                        propFindInfo.setDisplayname("..");
                        propFindInfo.setDirectory(true);
                        this.model.addPropFindList(propFindInfo);
                    }
                    propFindInfoChild = new PropFindSort().sort(propFindInfoChild);
                    for (int i = 0; i < propFindInfoChild.length; ++i) {
                        this.model.addPropFindList(propFindInfoChild[i]);
                    }
                }
                this.webDavDownLoadEvent.setUnlock(false);
                this.webDavDownLoadEvent.setReadonly(true);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(new JFrame(), "Lock failure", "error", 0);
            }
        }
    }

    public void setWebDavProcessor(WebDavProcessor webDavProcessor) {
        this.webDavProcessor = webDavProcessor;
    }

    public JTable getJTable() {
        return this.table;
    }

    public void setWebDavDownLoadEvent(WebDavDownLoadEvent webDavDownLoadEvent) {
        this.webDavDownLoadEvent = webDavDownLoadEvent;
    }

    public void seWebDavUploadLoadEvent(WebDavUploadLoadEvent webDavUploadLoadEvent) {
        this.webDavUploadLoadEvent = webDavUploadLoadEvent;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public JTextField getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(JTextField filenameField) {
        this.filenameField = filenameField;
    }

    public void setLockToken(String lockToken) {
        this.lockToken = lockToken;
    }

    public void setStack(Stack<String> stack) {
        this.stack = stack;
    }
}

