package smart_gs.drawing_tool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class tmpDrawingModeSelectionPopupMenu extends JPopupMenu {

	public tmpDrawingModeSelectionPopupMenu(GSMouseEvent e1) {
		final GSMouseEvent e0 = e1;
		
		JMenuItem none = new JMenuItem("<none>");
		none.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeNone);
			}
		});
		this.add(none);

		JMenuItem rect = new JMenuItem("tmp Rectangle");
		rect.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = RectangleMode.getInstance();
				mode.setTemporary(true);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeTmpRectangle);
			}
		});
		this.add(rect);

		JMenuItem marker = new JMenuItem("tmp Marker");
		marker.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = MarkerMode.getInstance();
				mode.setTemporary(true);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeTmpMarker);
			}
		});
		this.add(marker);

		JMenuItem polygon = new JMenuItem("tmp Polygon");
		polygon.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = PolygonMode.getInstance();
				mode.setTemporary(true);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeTmpPolygon);
			}
		});
		this.add(polygon);

		JMenuItem bookmark = new JMenuItem("tmp Bookmark");
		bookmark.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Mode mode = BookmarkMode.getInstance();
				mode.setTemporary(true);
				DefaultState.getInstance().setMode(mode);
				new ImageToolBarSetModeByMouseEvent().setMode((MouseEvent)e0,ImageToolBar.modeTmpBookmark);
			}
		});
		this.add(bookmark);
	}
}
