/* $Id: SearchResultPanelOfLineMode.java 574 2012-09-12 15:25:48Z shayashi $ */
/*
 * 쐬: 2006/06/21
 *
 */
package smart_gs.image_search.normal.swingui;

import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

import smart_gs.GSConstants;
import smart_gs.image_search.LineImageCropper;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Preference;

/**
 * @author kazuaki kobayashi
 *
 * 
*/
@SuppressWarnings("serial")

class SearchResultPanelOfLineMode extends AbstractSearchResultPanel{
		
	// 20110423 shayashi added queryImage arg.
	SearchResultPanelOfLineMode(SearchResultViewer parent,List<SearchResult> results,Image queryImage){
		super(parent,results,queryImage);
		GridLayout layout;
		if (TextType.isHorizontal()) {
			layout = new GridLayout(SIZE_TO_DISPLAY,1);
		} else {
			layout = new GridLayout(1,SIZE_TO_DISPLAY);
		}
		this.setLayout(layout);
		this.createNextResults(this.count);
		this.nextCount = this.count + 1;
		this.showResult(this.nextResults);
		this.createNextResults(nextCount);
	}	
	protected JLabel createImageLabel(SearchResult result,Image queryImage){	
		LineImageCropper cropper = new LineImageCropper(result);
		BufferedImage bufImage = cropper.crop();	
		bufImage = (BufferedImage) cropper.fillRelative(bufImage);
		ImageIcon icon = new ImageIcon(bufImage);	
		JLabel label = new JLabel();
		label.setIcon(icon);
		label.addMouseListener(new LabelMouseListener(label,result.getSpread(),result.getRectangle()));
		return label;
	}
}
