/* $Id: HighlightAllActionListener.java 515 2012-06-29 10:27:38Z ohura $ */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.swingui.WorkspaceWindow;
import sml_editor.swingui.toolbar.EditorToolBar;

public class HighlightAllActionListener implements ActionListener {

	@Override
	public void actionPerformed(ActionEvent e) {
		EditorToolBar editorToolBar = WorkspaceWindow.getInstance().getGSEditorToolBar();
		String findTerm = editorToolBar.getEditorTextPane().findTerm;
		String replaceTerm = editorToolBar.getEditorTextPane().replaceTerm;
		boolean bCaseSensitive = editorToolBar.getEditorTextPane().bCaseSensitive;
		int iOffset = editorToolBar.getEditorTextPane().iOffset;
		boolean forward = editorToolBar.getEditorTextPane().forward;

		if(findTerm != null) {
			if(editorToolBar.getHighlightAllCheckBox().isSelected()) {
				editorToolBar.getEditorTextPane().highlightOff();
				editorToolBar.getEditorTextPane().findText(findTerm, replaceTerm, bCaseSensitive, iOffset, forward);
				editorToolBar.getEditorTextPane().findAllText(findTerm, bCaseSensitive);
			} else {
				editorToolBar.getEditorTextPane().highlightOff();
				editorToolBar.getEditorTextPane().findText(findTerm, replaceTerm, bCaseSensitive, iOffset, forward);
			}
		}
	}

}
