package smart_gs.util;

import java.util.Arrays;
import java.util.Comparator;

import javax.imageio.ImageIO;


public class GSImageFileUtils {
	private static String description = null;
	private static String supportedFormatNames[] = null;
	
	public static boolean isAcceptable (String string) {
		String formatNames[] = ImageIO.getReaderFormatNames();
		String fileName = string;
		for(int i=0;i<formatNames.length;i++){
			if (fileName.toLowerCase().endsWith("."+formatNames[i].toLowerCase())) {
				return true;
			}
		}
		return false;
	}
	
	public static boolean isSupportedFormat(String fmtName){
		return isAcceptable("." + fmtName);
	}
	
	public static String getDescription() {
		if (description != null) return description;
		String ans = "";
		String formatNames[] = ImageIO.getReaderFormatNames();
		for(int i=0;i<formatNames.length;i++){
			formatNames[i] = formatNames[i].toLowerCase();
		}
		Arrays.sort(formatNames,new StringComparator());
		if (formatNames.length != 0) ans = formatNames[0];
		String lastAns 	= formatNames[0];
		for(int i=1;i<formatNames.length;i++){
			if (!lastAns.equals(formatNames[i])) {
				ans += "," + formatNames[i];
				lastAns = formatNames[i];
			}
		}
		description = ans;
		return ans;
	}
}
